/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.rpa.dao;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.rpa.RpaConstants;
import kd.epm.eb.business.rpa.dao.RpaIntegrationSheetDao;
import kd.epm.eb.business.rpa.entity.RpaIntegrationCell;
import kd.epm.eb.common.utils.GlobalIdUtil;

public class RpaIntegrationCellDao {
    private static final String ENTITY_NAME = "eb_rpa_integration_cell";
    private static final String ALL_FIELD = "id, rpainteid, sheetid, refdata, sequence, modifier, modifytime";

    public static RpaIntegrationCellDao getInstance() {
        return InnerClass.instance;
    }

    private RpaIntegrationCellDao() {
    }

    public DynamicObject[] load(Long rpaIntegrationId) {
        QFilter q1 = new QFilter("rpainteid", "=", (Object)rpaIntegrationId);
        return BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)ALL_FIELD, (QFilter[])new QFilter[]{q1});
    }

    public RpaIntegrationCell load(Long rpaIntegrationId, Long sheetId) {
        QFilter q1 = new QFilter("rpainteid", "=", (Object)rpaIntegrationId);
        QFilter q2 = new QFilter("sheetid", "=", (Object)sheetId);
        DynamicObject[] dynamicObject = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)ALL_FIELD, (QFilter[])new QFilter[]{q1, q2}, (String)"sequence");
        if (dynamicObject.length == 0) {
            return null;
        }
        return this.loadDataToRpaIntegrationCell(dynamicObject);
    }

    public void save(Long rpaIntegrationId, Long sheetId, String refData, boolean hasMapping, String enumFieldConfig) {
        String[] data = this.stringToStringArray(refData, 2000);
        if (data == null) {
            return;
        }
        DynamicObject[] newDynObj = this.dataToDynamicObject(rpaIntegrationId, sheetId, data);
        try (TXHandle tx = TX.required();){
            try {
                this.deleteBySheetIds(Collections.singletonList(sheetId));
                SaveServiceHelper.save((DynamicObject[])newDynObj);
                RpaIntegrationSheetDao.getInstance().updateMappingStatus(sheetId, hasMapping ? RpaConstants.MappingStatus.MAPPING : RpaConstants.MappingStatus.NO_MAPPING);
                RpaIntegrationSheetDao.getInstance().updateEnumFiled(sheetId, enumFieldConfig);
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public void deleteBySheetIds(List<Long> sheetIds) {
        DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("sheetid", "in", sheetIds)});
    }

    public void deleteByRpaIntegration(List<Long> rpaIntegrationIds) {
        DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("rpainteid", "in", rpaIntegrationIds)});
    }

    public void copy(Long oldRpaIntegrationId, Long newRpaIntegrationId, Map<Long, Long> SheetMappingId) {
        DynamicObject[] oldData = this.load(oldRpaIntegrationId);
        DynamicObject[] newData = new DynamicObject[oldData.length];
        if (oldData.length == 0) {
            return;
        }
        Long currUserId = RequestContext.get().getCurrUserId();
        Date now = TimeServiceHelper.now();
        for (int i = 0; i < oldData.length; ++i) {
            DynamicObject newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
            newDynamicObject.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            newDynamicObject.set("rpainteid", (Object)newRpaIntegrationId);
            newDynamicObject.set("sheetid", (Object)SheetMappingId.get(oldData[i].getLong("sheetid")));
            newDynamicObject.set("refdata", (Object)oldData[i].getString("refdata"));
            newDynamicObject.set("sequence", (Object)oldData[i].getInt("sequence"));
            newDynamicObject.set("modifier", (Object)currUserId);
            newDynamicObject.set("modifytime", (Object)now);
            newData[i] = newDynamicObject;
        }
        this.deleteBySheetIds(new ArrayList<Long>(SheetMappingId.values()));
        SaveServiceHelper.save((DynamicObject[])newData);
    }

    private RpaIntegrationCell transToModel(DynamicObject dynamicObject, String data) {
        RpaIntegrationCell model = new RpaIntegrationCell();
        model.setId(dynamicObject.getLong("id"));
        model.setRpaInteId(dynamicObject.getLong("rpainteid.id"));
        model.setSheetId(dynamicObject.getLong("sheetid"));
        model.setRefData(data);
        model.setSequence(dynamicObject.getInt("sequence"));
        model.setModifier(dynamicObject.getLong("modifier.id"));
        model.setModifyTime(dynamicObject.getDate("modifytime"));
        return model;
    }

    private String[] stringToStringArray(String data, int length) {
        if (StringUtils.isBlank((String)data) || length <= 0) {
            return null;
        }
        int n = (data.length() + length - 1) / length;
        String[] split = new String[n];
        for (int i = 0; i < n; ++i) {
            split[i] = i < n - 1 ? data.substring(i * length, (i + 1) * length) : data.substring(i * length);
        }
        return split;
    }

    private DynamicObject[] dataToDynamicObject(Long rpaIntegrationId, Long SheetId, String[] data) {
        Long currUserId = RequestContext.get().getCurrUserId();
        Date now = TimeServiceHelper.now();
        DynamicObject[] dynamicObjects = new DynamicObject[data.length];
        for (int i = 0; i < data.length; ++i) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
            dynamicObject.set("rpainteid", (Object)rpaIntegrationId);
            dynamicObject.set("sheetid", (Object)SheetId);
            dynamicObject.set("refdata", (Object)data[i]);
            dynamicObject.set("sequence", (Object)i);
            dynamicObject.set("modifier", (Object)currUserId);
            dynamicObject.set("modifytime", (Object)now);
            dynamicObjects[i] = dynamicObject;
        }
        return dynamicObjects;
    }

    private RpaIntegrationCell loadDataToRpaIntegrationCell(DynamicObject[] dynamicObjects) {
        StringBuilder data = new StringBuilder();
        for (DynamicObject dynamicObject : dynamicObjects) {
            data.append(dynamicObject.getString("refdata"));
        }
        return this.transToModel(dynamicObjects[0], data.toString());
    }

    private static class InnerClass {
        private static final RpaIntegrationCellDao instance = new RpaIntegrationCellDao();

        private InnerClass() {
        }
    }
}

