/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.rpa.dao;

import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.rpa.RpaConstants;
import kd.epm.eb.business.rpa.dao.RpaEntityRefDao;
import kd.epm.eb.business.rpa.dao.RpaIntegrationAttachmentDao;
import kd.epm.eb.business.rpa.dao.RpaIntegrationSheetDao;
import kd.epm.eb.business.rpa.entity.RpaIntegration;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import org.apache.commons.beanutils.BeanUtils;

public class RpaIntegrationDao {
    private static final Log log = LogFactory.getLog(RpaIntegrationDao.class);
    private static final String ENTITY_NAME = "eb_rpa_integration";
    private static final int MAX_NUMBER_COUNT = 50;

    public static RpaIntegrationDao getInstance() {
        return InnerClass.instance;
    }

    private RpaIntegrationDao() {
    }

    public RpaIntegration load(Long id) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_NAME);
        if (dynamicObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u4e0d\u5b58\u5728\u3002", (String)"RpaIntegrationDao_1", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        return this.transToModel(dynamicObject);
    }

    public DynamicObjectCollection load(Long modelId, List<String> numbers) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and(new QFilter("number", "in", numbers));
        return QueryServiceHelper.query((String)ENTITY_NAME, (String)"id, model, bizmodel, number", (QFilter[])qFilter.toArray());
    }

    public DynamicObjectCollection loadByModel(Long modelId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        return QueryServiceHelper.query((String)ENTITY_NAME, (String)"id,name", (QFilter[])new QFilter[]{qFilter});
    }

    public boolean checkRpaIntegrationExisted(Long id) {
        QFilter q1 = new QFilter("id", "=", (Object)id);
        return QueryServiceHelper.exists((String)ENTITY_NAME, (QFilter[])new QFilter[]{q1});
    }

    public DynamicObjectCollection queryStatus(List<Long> ids) {
        String selectFields = "id, status";
        QFilter qFilter = new QFilter("id", "in", ids);
        return QueryServiceHelper.query((String)ENTITY_NAME, (String)selectFields, (QFilter[])new QFilter[]{qFilter});
    }

    public Long queryBizModel(Long id) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)"bizmodel", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        return dynamicObject.getLong("bizmodel");
    }

    public boolean queryExistedIntegrationByCateId(List<Long> cateIds) {
        return QueryServiceHelper.exists((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("cateid", "in", cateIds)});
    }

    public boolean queryIsZipExport(Long id) {
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        qFilter.and("type", "=", (Object)RpaConstants.ExportType.ZIP.getValue());
        return QueryServiceHelper.exists((String)ENTITY_NAME, (QFilter[])qFilter.toArray());
    }

    public boolean checkNumberExisted(Long id, Long modelId, String number) {
        QFBuilder qb = new QFBuilder();
        qb.add("model", "=", (Object)modelId);
        qb.add("number", "=", (Object)number);
        if (IDUtils.isNotEmptyLong((Long)id).booleanValue()) {
            qb.add(new QFilter("id", "!=", (Object)id));
        }
        return QueryServiceHelper.exists((String)ENTITY_NAME, (QFilter[])qb.toArrays());
    }

    public RpaConstants.Status queryRpaIntegrationStatus(Long id) {
        DynamicObject integration = QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)"status", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (integration == null) {
            return null;
        }
        if (RpaConstants.Status.ENABLE.getValue().equals(integration.getString("status"))) {
            return RpaConstants.Status.ENABLE;
        }
        return RpaConstants.Status.DISABLE;
    }

    public void updateStatus(RpaConstants.Status status, List<Long> pkIds) {
        DynamicObject[] objs;
        long currUserId = RequestContext.get().getCurrUserId();
        Date now = TimeServiceHelper.now();
        for (DynamicObject obj : objs = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)"id,status,modifier,modifytime", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)})) {
            obj.set("status", (Object)status.getValue());
            obj.set("modifier", (Object)currUserId);
            obj.set("modifytime", (Object)now);
        }
        SaveServiceHelper.save((DynamicObject[])objs);
    }

    public void updateCateId(List<Long> pkIds, Long cateId) {
        DynamicObject[] objs;
        long currUserId = RequestContext.get().getCurrUserId();
        Date now = TimeServiceHelper.now();
        for (DynamicObject obj : objs = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)"id,cateid,modifier,modifytime", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)})) {
            obj.set("cateid", (Object)cateId);
            obj.set("modifier", (Object)currUserId);
            obj.set("modifytime", (Object)now);
        }
        SaveServiceHelper.save((DynamicObject[])objs);
    }

    public void delete(List<Long> ids) {
        try (TXHandle tx = TX.required();){
            try {
                RpaIntegrationSheetDao.getInstance().deleteByRpaIntegration(ids);
                RpaEntityRefDao.getInstance().deleteByRpaIntegration(ids);
                DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
        RpaIntegrationAttachmentDao.getInstance().deleteAttachment(ids);
    }

    public void copyRpaIntegration(Long id) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_NAME);
        RpaIntegration oldModel = this.transToModel(dynamicObject);
        RpaIntegration newModel = new RpaIntegration();
        try {
            BeanUtils.copyProperties((Object)newModel, (Object)oldModel);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        HashSet<String> numberSet = new HashSet<String>(16);
        HashSet<String> nameSet = new HashSet<String>(16);
        String filterNumber = oldModel.getNumber().length() > 44 ? oldModel.getNumber().substring(0, 44) : oldModel.getNumber();
        QFilter qfilter = new QFilter("number", "ftlike", (Object)filterNumber);
        try (DataSet allData = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)ENTITY_NAME, (String)"name, number", (QFilter[])new QFilter[]{qfilter}, null);){
            while (allData.hasNext()) {
                Row row = allData.next();
                numberSet.add(row.getString("number"));
                nameSet.add(row.getString("name"));
            }
        }
        RequestContext requestContext = RequestContext.get();
        Date now = TimeServiceHelper.now();
        newModel.setId(0L);
        newModel.setName(this.getCopyName(oldModel.getName(), nameSet));
        newModel.setNumber(this.getCopyName(oldModel.getNumber(), numberSet));
        newModel.setStatus(RpaConstants.Status.DISABLE.getValue());
        newModel.setCreator(requestContext.getCurrUserId());
        newModel.setCreateTime(now);
        newModel.setModifier(requestContext.getCurrUserId());
        newModel.setModifyTime(now);
        DynamicObject newDynObj = this.packageDynamicObject(newModel);
        Long newRpaIntegrationId = newDynObj.getLong("id");
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newDynObj});
                RpaEntityRefDao.getInstance().copy(id, newRpaIntegrationId);
                RpaIntegrationSheetDao.getInstance().copy(id, newRpaIntegrationId);
            }
            catch (Throwable e) {
                tx.markRollback();
                log.error(e.getMessage(), e);
                throw new KDBizException(e.getMessage());
            }
        }
        RpaIntegrationAttachmentDao.getInstance().copyAttachment(id, newRpaIntegrationId);
    }

    private String getCopyName(String name, Set<String> nameSet) {
        String copyName = "";
        for (int i = 0; i < nameSet.size(); ++i) {
            StringBuilder appendName = new StringBuilder("copy");
            StringBuilder preName = new StringBuilder(name);
            if (i > 0) {
                appendName.append(i);
            }
            String string = copyName = name.length() + appendName.length() > 50 ? preName.substring(0, 50 - appendName.length()) + appendName : preName.append((CharSequence)appendName).toString();
            if (nameSet.contains(copyName)) continue;
            return copyName;
        }
        return copyName;
    }

    private RpaIntegration transToModel(DynamicObject dynamicObject) {
        RpaIntegration model = new RpaIntegration();
        model.setId(dynamicObject.getLong("id"));
        model.setCateId(dynamicObject.getDynamicObject("cateid").getLong("id"));
        model.setNumber(dynamicObject.getString("number"));
        model.setName(dynamicObject.getString("name"));
        model.setStatus(dynamicObject.getString("status"));
        model.setModelId(dynamicObject.getDynamicObject("model").getLong("id"));
        model.setBizModelId(dynamicObject.getDynamicObject("bizmodel").getLong("id"));
        model.setDescription(dynamicObject.getString("description"));
        model.setSource(dynamicObject.getInt("source"));
        model.setType(dynamicObject.getString("type"));
        model.setCreator(dynamicObject.getDynamicObject("creator").getLong("id"));
        model.setCreateTime(dynamicObject.getDate("createtime"));
        model.setModifier(dynamicObject.getDynamicObject("modifier").getLong("id"));
        model.setModifyTime(dynamicObject.getDate("modifytime"));
        return model;
    }

    private DynamicObject packageDynamicObject(RpaIntegration model) {
        DynamicObject dynamicObject;
        Long id = model.getId();
        if (IDUtils.isNull((Long)id)) {
            id = GlobalIdUtil.genGlobalLongId();
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
            dynamicObject.set("creator", (Object)model.getCreator());
            dynamicObject.set("createtime", (Object)model.getCreateTime());
            dynamicObject.set("status", (Object)model.getStatus());
        } else {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_NAME);
        }
        dynamicObject.set("id", (Object)id);
        dynamicObject.set("cateid", (Object)model.getCateId());
        dynamicObject.set("number", (Object)model.getNumber());
        dynamicObject.set("name", (Object)model.getName());
        dynamicObject.set("model", (Object)model.getModelId());
        dynamicObject.set("bizmodel", (Object)model.getBizModelId());
        dynamicObject.set("description", (Object)model.getDescription());
        dynamicObject.set("source", (Object)model.getSource());
        dynamicObject.set("type", (Object)model.getType());
        dynamicObject.set("modifier", (Object)model.getModifier());
        dynamicObject.set("modifytime", (Object)model.getModifyTime());
        return dynamicObject;
    }

    private static class InnerClass {
        private static final RpaIntegrationDao instance = new RpaIntegrationDao();

        private InnerClass() {
        }
    }
}

