/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.rpa.dao;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.rpa.RpaConstants;
import kd.epm.eb.business.rpa.dao.RpaIntegrationCellDao;
import kd.epm.eb.business.rpa.entity.RpaIntegrationSheet;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;

public class RpaIntegrationSheetDao {
    private static final String ENTITY_NAME = "eb_rpa_integration_sheet";
    private static final String selectProperties = "id, seqnum, rpainte, sheetname, sheetid, template, isfloat, mappingstatus, effectstatus, modifier, modifytime, name, number, enumfield";

    public static RpaIntegrationSheetDao getInstance() {
        return InnerClass.instance;
    }

    private RpaIntegrationSheetDao() {
    }

    public DynamicObjectCollection query(Long rpaIntegrationId, Set<Long> templateIds) {
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("rpainte", "=", (Object)rpaIntegrationId)).add(new QFilter("mappingstatus", "=", (Object)RpaConstants.MappingStatus.MAPPING.getValue())).add(new QFilter("effectstatus", "=", (Object)RpaConstants.EffectStatus.EFFECTIVE.getValue())).add(new QFilter("template", "in", templateIds));
        return QueryServiceHelper.query((String)ENTITY_NAME, (String)"id,sheetname,template.id,template.name,isfloat, number,enumfield", (QFilter[])builder.toArrays(), (String)"seqnum");
    }

    public List<RpaIntegrationSheet> load(Long rpaIntegrationId) {
        QFilter q1 = new QFilter("rpainte", "=", (Object)rpaIntegrationId);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)selectProperties, (QFilter[])new QFilter[]{q1});
        if (load.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.stream(load).map(this::transToModel).collect(Collectors.toList());
    }

    public DynamicObject loadSingle(Long id) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)ENTITY_NAME);
    }

    public DynamicObjectCollection queryStatus(List<Long> ids) {
        String selectFields = "id, effectstatus";
        QFilter qFilter = new QFilter("id", "in", ids);
        return QueryServiceHelper.query((String)ENTITY_NAME, (String)selectFields, (QFilter[])new QFilter[]{qFilter});
    }

    public DynamicObject[] queryStatusByRpaIntegration(List<Long> rpaIntegrationIds) {
        String selectFields = "id, rpainte, effectstatus";
        QFilter qFilter = new QFilter("rpainte", "in", rpaIntegrationIds);
        return BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)selectFields, (QFilter[])new QFilter[]{qFilter});
    }

    public boolean existedSheetMappingData(Long rpaIntegrationId) {
        QFilter q1 = new QFilter("rpainte", "=", (Object)rpaIntegrationId);
        return QueryServiceHelper.exists((String)ENTITY_NAME, (QFilter[])new QFilter[]{q1});
    }

    public List<Long> getTemplateIds(Long integrationId) {
        QFilter qFilter = new QFilter("rpainte", "=", (Object)integrationId);
        QFilter qFilter1 = new QFilter("effectstatus", "=", (Object)RpaConstants.EffectStatus.EFFECTIVE.getValue());
        DynamicObjectCollection query = QueryServiceHelper.query((String)ENTITY_NAME, (String)"template.id", (QFilter[])new QFilter[]{qFilter, qFilter1});
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            return query.stream().map(dynamicObject -> dynamicObject.getLong("template.id")).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public boolean queryTemplateRef(Long integrationId, List<Long> sheetIds) {
        String sheet = sheetIds.stream().map(Object::toString).collect(Collectors.joining(",", "(", ")"));
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("select t.fentryid from t_eb_rpa_scheme s ").append("inner join t_eb_rpa_scheme_template t on s.fid = t.fid ").append("inner join t_eb_rpa_integration_sht h on s.frpaintegration = h.frpainteid ").append("where t.ftemplate = h.ftemplateid ").append("and h.fid in ").append(sheet).append(" and h.frpainteid = ? ");
        try (DataSet rows = DB.queryDataSet((String)"queryTemplateRef", (DBRoute)DBRoute.of((String)"epm"), (String)sqlBuilder.toString(), (Object[])new Object[]{integrationId});){
            if (rows.hasNext()) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public Map<String, DynamicObject> getNameMapping(Long integrationId) {
        DynamicObjectCollection mappings = QueryServiceHelper.query((String)ENTITY_NAME, (String)"id,sheetname,template,mappingstatus,effectStatus", (QFilter[])new QFilter[]{new QFilter("rpainte", "=", (Object)integrationId)}, (String)"seqnum");
        if (mappings.size() > 0) {
            LinkedHashMap<String, DynamicObject> nameMap = new LinkedHashMap<String, DynamicObject>(mappings.size());
            mappings.forEach(e -> nameMap.put(e.getString("sheetname"), (DynamicObject)e));
            return nameMap;
        }
        return Collections.emptyMap();
    }

    public void updateMappingStatus(Long sheetId, RpaConstants.MappingStatus status) {
        DynamicObject sheetMapping = BusinessDataServiceHelper.loadSingle((Object)sheetId, (String)ENTITY_NAME);
        sheetMapping.set("mappingstatus", (Object)status.getValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sheetMapping});
    }

    public void updateEnumFiled(Long sheetId, String enumFieldConfig) {
        DynamicObject sheetMapping = BusinessDataServiceHelper.loadSingle((Object)sheetId, (String)ENTITY_NAME);
        sheetMapping.set("enumfield", (Object)enumFieldConfig);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sheetMapping});
    }

    public boolean updateEffectStatus(List<Long> sheetIds, RpaConstants.EffectStatus status) {
        DynamicObject[] dos;
        boolean isAllSuccess = true;
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", "in", sheetIds);
        for (DynamicObject dy : dos = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)selectProperties, (QFilter[])qfBuilder.toArray())) {
            if (status.getValue().equals(dy.getString("effectstatus"))) continue;
            if (RpaConstants.EffectStatus.EFFECTIVE == status && RpaConstants.MappingStatus.NO_MAPPING.getValue().equals(dy.getString("mappingstatus"))) {
                isAllSuccess = false;
                continue;
            }
            dy.set("effectstatus", (Object)status.getValue());
            dy.set("modifier", (Object)RequestContext.get().getCurrUserId());
            dy.set("modifytime", (Object)TimeServiceHelper.now());
        }
        this.save(dos);
        return isAllSuccess;
    }

    public void saveMapping(Long integrationId, DynamicObjectCollection mapping) {
        QFilter[] qFilters = new QFilter[]{new QFilter("rpainte", "=", (Object)integrationId)};
        ArrayList<DynamicObject> saveInfos = new ArrayList<DynamicObject>(mapping.size());
        boolean exists = QueryServiceHelper.exists((String)ENTITY_NAME, (QFilter[])qFilters);
        HashSet<Long> tmpIds = new HashSet<Long>(10);
        for (int i = 0; i < mapping.size(); ++i) {
            DynamicObject row = (DynamicObject)mapping.get(i);
            DynamicObject sheetMapping = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
            long id = row.getLong("id");
            if (id > 0L) {
                sheetMapping.set("id", (Object)id);
            } else {
                sheetMapping.set("creator", (Object)RequestContext.get().getCurrUserId());
                sheetMapping.set("createtime", (Object)TimeServiceHelper.now());
                sheetMapping.set("modifier", (Object)RequestContext.get().getCurrUserId());
                sheetMapping.set("modifytime", (Object)TimeServiceHelper.now());
            }
            sheetMapping.set("seqnum", (Object)(i + 1));
            sheetMapping.set("rpainte", (Object)integrationId);
            String sheetName = row.getString("sheetname");
            String[] newSheetName = sheetName.split("\\s+");
            String number = newSheetName.length > 0 ? newSheetName[0] : "";
            String name = newSheetName.length > 1 ? newSheetName[1] : "";
            sheetMapping.set("sheetname", (Object)sheetName);
            sheetMapping.set("number", (Object)number);
            sheetMapping.set("name", (Object)name);
            if (row.get("template") != null) {
                DynamicObject template = (DynamicObject)row.get("template");
                if (tmpIds.contains(template.getLong("id"))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e00\u4e2a\u62a5\u8868\u6a21\u677f\u53ea\u80fd\u6620\u5c04\u4e00\u4e2a\u8868\u683c\uff0c%s\u5b58\u5728\u591a\u6b21\u6620\u5c04\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RpaIntegrationSheetDao_1", (String)"epm-eb-business", (Object[])new Object[0]), template.getString("name")));
                }
                tmpIds.add(template.getLong("id"));
                sheetMapping.set("template", (Object)template);
                sheetMapping.set("mappingstatus", (Object)row.getString("mappingstatus"));
            }
            sheetMapping.set("effectstatus", (Object)row.getString("effectstatus"));
            saveInfos.add(sheetMapping);
        }
        try (TXHandle tx = TX.required();){
            try {
                if (exists) {
                    DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])qFilters);
                }
                SaveServiceHelper.save((DynamicObject[])saveInfos.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public void delete(List<Long> ids) {
        try (TXHandle tx = TX.required();){
            try {
                RpaIntegrationCellDao.getInstance().deleteBySheetIds(ids);
                DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public void save(DynamicObject[] newDyDynamicObjects) {
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])newDyDynamicObjects);
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public void deleteByRpaIntegration(List<Long> rpaIntegrationIds) {
        RpaIntegrationCellDao.getInstance().deleteByRpaIntegration(rpaIntegrationIds);
        DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("rpainte", "in", rpaIntegrationIds)});
    }

    public void copy(Long oldRpaIntegrationId, Long newRpaIntegrationId) {
        Long currUserId = RequestContext.get().getCurrUserId();
        Date now = TimeServiceHelper.now();
        List<RpaIntegrationSheet> load = this.load(oldRpaIntegrationId);
        if (CollectionUtils.isEmpty(load)) {
            return;
        }
        HashMap<Long, Long> sheetMappingIds = new HashMap<Long, Long>(load.size());
        DynamicObject[] newDyDynamicObjects = new DynamicObject[load.size()];
        AtomicInteger row = new AtomicInteger(0);
        load.forEach(data -> {
            RpaIntegrationSheet newModel = new RpaIntegrationSheet();
            try {
                BeanUtils.copyProperties((Object)newModel, (Object)data);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new KDBizException(e.getMessage());
            }
            newModel.setId(null);
            newModel.setRpaInteId(newRpaIntegrationId);
            newModel.setModifier(currUserId);
            newModel.setModifyTime(now);
            DynamicObject newDynamicObject = this.packageDynamicObject(newModel);
            sheetMappingIds.put(data.getId(), newDynamicObject.getLong("id"));
            int i = row.getAndIncrement();
            newDyDynamicObjects[i] = newDynamicObject;
        });
        SaveServiceHelper.save((DynamicObject[])newDyDynamicObjects);
        RpaIntegrationCellDao.getInstance().copy(oldRpaIntegrationId, newRpaIntegrationId, sheetMappingIds);
    }

    private RpaIntegrationSheet transToModel(DynamicObject dynamicObject) {
        RpaIntegrationSheet model = new RpaIntegrationSheet();
        model.setId(dynamicObject.getLong("id"));
        model.setSeqNum(dynamicObject.getInt("seqnum"));
        model.setRpaInteId(dynamicObject.getLong("rpainte.id"));
        model.setSheetName(dynamicObject.getString("sheetname"));
        model.setNumber(dynamicObject.getString("number"));
        model.setName(dynamicObject.getString("name"));
        model.setTemplateId(dynamicObject.getLong("template.id"));
        model.setIsFloat(dynamicObject.getInt("isfloat"));
        model.setEffectStatus(dynamicObject.getString("effectstatus"));
        model.setMappingStatus(dynamicObject.getString("mappingstatus"));
        model.setModifier(dynamicObject.getLong("modifier.id"));
        model.setModifyTime(dynamicObject.getDate("modifytime"));
        model.setEnumField(dynamicObject.getString("enumfield"));
        return model;
    }

    private DynamicObject packageDynamicObject(RpaIntegrationSheet model) {
        DynamicObject dynamicObject;
        Long id = model.getId();
        if (IDUtils.isNull((Long)id)) {
            id = GlobalIdUtil.genGlobalLongId();
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
        } else {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_NAME);
        }
        dynamicObject.set("id", (Object)id);
        dynamicObject.set("seqnum", (Object)model.getSeqNum());
        dynamicObject.set("rpainte", (Object)model.getRpaInteId());
        dynamicObject.set("sheetname", (Object)model.getSheetName());
        dynamicObject.set("number", (Object)model.getNumber());
        dynamicObject.set("name", (Object)model.getName());
        dynamicObject.set("template", (Object)model.getTemplateId());
        dynamicObject.set("isfloat", (Object)model.getIsFloat());
        dynamicObject.set("effectstatus", (Object)model.getEffectStatus());
        dynamicObject.set("mappingstatus", (Object)model.getMappingStatus());
        dynamicObject.set("modifier", (Object)model.getModifier());
        dynamicObject.set("modifytime", (Object)model.getModifyTime());
        dynamicObject.set("enumfield", (Object)model.getEnumField());
        return dynamicObject;
    }

    private static class InnerClass {
        private static final RpaIntegrationSheetDao instance = new RpaIntegrationSheetDao();

        private InnerClass() {
        }
    }
}

