/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.rpa.dao;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.rpa.RpaConstants;
import kd.epm.eb.business.rpa.entity.RpaScheme;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;

public class RpaSchemeDao {
    private static final Log log = LogFactory.getLog(RpaSchemeDao.class);
    private static final String ENTITY_NAME = "eb_rpa_scheme";
    private static final int MAX_NUMBER_COUNT = 50;

    public static RpaSchemeDao getInstance() {
        return InnerClass.instance;
    }

    private RpaSchemeDao() {
    }

    public DynamicObject loadToDyObj(Long id) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)ENTITY_NAME);
    }

    public RpaScheme loadToModel(Long id) {
        DynamicObject dyObj = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)ENTITY_NAME);
        if (dyObj == null) {
            return null;
        }
        return this.transToModel(dyObj);
    }

    public DynamicObjectCollection loadByModel(Long modelId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        return QueryServiceHelper.query((String)ENTITY_NAME, (String)"id,name", (QFilter[])new QFilter[]{qFilter});
    }

    public boolean existsNumber(long modelId, String number) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("number", "=", (Object)number);
        return QueryServiceHelper.exists((String)ENTITY_NAME, (QFilter[])new QFilter[]{qFilter});
    }

    public boolean checkDataBelongToCurrentUser(List<Long> ids, Long currentUserId) {
        QFilter qFilter = new QFilter("id", "in", ids);
        DynamicObjectCollection data = QueryServiceHelper.query((String)ENTITY_NAME, (String)"creater", (QFilter[])new QFilter[]{qFilter});
        return data.stream().allMatch(p -> currentUserId.equals(p.getLong("creater")));
    }

    public DynamicObjectCollection queryStatus(List<Long> ids) {
        String selectFields = "id, status";
        QFilter qFilter = new QFilter("id", "in", ids);
        return QueryServiceHelper.query((String)ENTITY_NAME, (String)selectFields, (QFilter[])new QFilter[]{qFilter});
    }

    public boolean checkRpaIntegrationByRef(List<Long> rpaIntegrationIds, RpaConstants.Status status) {
        QFilter qFilter = new QFilter("rpaintegration", "in", rpaIntegrationIds);
        if (status != null) {
            qFilter.and("status", "=", (Object)status.getValue());
        }
        return QueryServiceHelper.exists((String)ENTITY_NAME, (QFilter[])new QFilter[]{qFilter});
    }

    public boolean checkEntityByRpaSchemeRef(DynamicObject[] dys) {
        List entityIds = Arrays.stream(dys).map(dy -> dy.getLong("entity.id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("entryentity.entity_id", "in", entityIds);
        qFilter.and(new QFilter("rpaintegration", "=", (Object)dys[0].getLong("rpainte.id")));
        return QueryServiceHelper.exists((String)ENTITY_NAME, (QFilter[])qFilter.toArray());
    }

    public void updateStatus(RpaConstants.Status status, List<Long> pkIds) {
        DynamicObject[] objs;
        long currUserId = RequestContext.get().getCurrUserId();
        Date now = TimeServiceHelper.now();
        for (DynamicObject obj : objs = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)"id,status,modifier,modifytime", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)})) {
            obj.set("status", (Object)status.getValue());
            obj.set("modifier", (Object)currUserId);
            obj.set("modifytime", (Object)now);
        }
        SaveServiceHelper.save((DynamicObject[])objs);
    }

    public void deleteById(List<Long> Ids) {
        try (TXHandle tx = TX.required();){
            try {
                DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("id", "in", Ids)});
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public void copyRpaScheme(Long id) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_NAME);
        DynamicObjectCollection templateList = (DynamicObjectCollection)dynamicObject.get("entrytemplate");
        DynamicObjectCollection entityList = (DynamicObjectCollection)dynamicObject.get("entryentity");
        RpaScheme oldModel = this.transToModel(dynamicObject);
        RpaScheme newModel = new RpaScheme();
        try {
            BeanUtils.copyProperties((Object)newModel, (Object)oldModel);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        HashSet<String> numberSet = new HashSet<String>(16);
        HashSet<String> nameSet = new HashSet<String>(16);
        String filterNumber = oldModel.getNumber().length() > 44 ? oldModel.getNumber().substring(0, 44) : oldModel.getNumber();
        QFilter qfilter = new QFilter("number", "ftlike", (Object)filterNumber);
        try (DataSet allData = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)ENTITY_NAME, (String)"name, number", (QFilter[])new QFilter[]{qfilter}, null);){
            while (allData.hasNext()) {
                Row row = allData.next();
                numberSet.add(row.getString("number"));
                nameSet.add(row.getString("name"));
            }
        }
        RequestContext requestContext = RequestContext.get();
        Date now = TimeServiceHelper.now();
        newModel.setId(0L);
        newModel.setName(this.getCopyName(oldModel.getName(), nameSet));
        newModel.setNumber(this.getCopyName(oldModel.getNumber(), numberSet));
        newModel.setStatus(RpaConstants.Status.DISABLE.getValue());
        newModel.setCreater(requestContext.getCurrUserId());
        newModel.setCreateTime(now);
        newModel.setModifier(requestContext.getCurrUserId());
        newModel.setModifyTime(now);
        newModel.setRpaRobot(null);
        newModel.setRpaProcess(null);
        DynamicObject newDynObj = this.packageDynamicObject(newModel);
        Long newRpaSchemeId = newDynObj.getLong("id");
        String templateSql = "insert into t_eb_rpa_scheme_template (fid, fentryid, fseq, ftemplate) VALUES(?,?,?,?)";
        String entitySql = "insert into t_eb_rpa_scheme_entity (fid, fentryid, fseq, fentity) VALUES(?,?,?,?)";
        List<Object[]> templateObject = this.packageObjects(templateList, newRpaSchemeId, "template");
        List<Object[]> entityObject = this.packageObjects(entityList, newRpaSchemeId, "entity");
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newDynObj});
                if (CollectionUtils.isNotEmpty(templateObject)) {
                    DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)templateSql, templateObject);
                }
                if (CollectionUtils.isNotEmpty(entityObject)) {
                    DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)entitySql, entityObject);
                }
            }
            catch (Throwable e) {
                tx.markRollback();
                log.error(e.getMessage(), e);
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private List<Object[]> packageObjects(DynamicObjectCollection data, Long newRpaSchemeId, String type) {
        ArrayList<Object[]> objs = new ArrayList<Object[]>(data.size());
        long[] id = GlobalIdUtil.genGlobalLongIds((int)data.size());
        for (int i = 0; i < data.size(); ++i) {
            Object[] obj = new Object[]{newRpaSchemeId, id[i], ((DynamicObject)data.get(i)).getLong("seq"), type.equals("template") ? ((DynamicObject)data.get(i)).get("template.id") : ((DynamicObject)data.get(i)).get("entity.id")};
            objs.add(obj);
        }
        return objs;
    }

    private String getCopyName(String name, Set<String> nameSet) {
        String copyName = "";
        for (int i = 0; i < nameSet.size(); ++i) {
            StringBuilder appendName = new StringBuilder("copy");
            StringBuilder preName = new StringBuilder(name);
            if (i > 0) {
                appendName.append(i);
            }
            String string = copyName = name.length() + appendName.length() > 50 ? preName.substring(0, 50 - appendName.length()) + appendName : preName.append((CharSequence)appendName).toString();
            if (nameSet.contains(copyName)) continue;
            return copyName;
        }
        return copyName;
    }

    private RpaScheme transToModel(DynamicObject dynamicObject) {
        RpaScheme model = new RpaScheme();
        model.setId(dynamicObject.getLong("id"));
        model.setRpaInteId(dynamicObject.getDynamicObject("rpaintegration").getLong("id"));
        model.setNumber(dynamicObject.getString("number"));
        model.setName(dynamicObject.getString("name"));
        model.setStatus(dynamicObject.getString("status"));
        model.setModelId(dynamicObject.getDynamicObject("model").getLong("id"));
        model.setBizModelId(dynamicObject.getDynamicObject("bizmodel").getLong("id"));
        model.setDataTypeId(dynamicObject.getDynamicObject("datatype").getLong("id"));
        model.setVersionId(dynamicObject.getDynamicObject("version").getLong("id"));
        model.setPeriodId(dynamicObject.getDynamicObject("period").getLong("id"));
        model.setDescription(dynamicObject.getString("description"));
        model.setRpaProcess(dynamicObject.getString("rpaprocess"));
        model.setRpaRobot(dynamicObject.getString("rparobot"));
        model.setExportPath(dynamicObject.getString("exportpath"));
        model.setInstallPath(dynamicObject.getString("installpath"));
        model.setFileName(dynamicObject.getString("filename"));
        model.setFileType(dynamicObject.getString("filetype"));
        model.setSheetName(dynamicObject.getString("sheetname"));
        model.setCreateIni(dynamicObject.getString("createini"));
        model.setCreater(dynamicObject.getDynamicObject("creater").getLong("id"));
        model.setCreateTime(dynamicObject.getDate("createtime"));
        model.setModifier(dynamicObject.getDynamicObject("modifier").getLong("id"));
        model.setModifyTime(dynamicObject.getDate("modifytime"));
        DynamicObjectCollection templateList = (DynamicObjectCollection)dynamicObject.get("entrytemplate");
        DynamicObjectCollection entityList = (DynamicObjectCollection)dynamicObject.get("entryentity");
        List templates = templateList.stream().map(template -> template.getString("template.number")).collect(Collectors.toList());
        List entityS = entityList.stream().map(entity -> entity.getString("entity.number")).collect(Collectors.toList());
        model.setTemplate(String.join((CharSequence)",", templates));
        model.setEntity(String.join((CharSequence)",", entityS));
        return model;
    }

    private DynamicObject packageDynamicObject(RpaScheme model) {
        DynamicObject dynamicObject;
        Long id = model.getId();
        if (IDUtils.isNull((Long)id)) {
            id = GlobalIdUtil.genGlobalLongId();
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
            dynamicObject.set("creater", (Object)model.getCreater());
            dynamicObject.set("createtime", (Object)model.getCreateTime());
        } else {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_NAME);
        }
        dynamicObject.set("id", (Object)id);
        dynamicObject.set("rpaintegration", (Object)model.getRpaInteId());
        dynamicObject.set("number", (Object)model.getNumber());
        dynamicObject.set("name", (Object)model.getName());
        dynamicObject.set("status", (Object)model.getStatus());
        dynamicObject.set("model", (Object)model.getModelId());
        dynamicObject.set("bizmodel", (Object)model.getBizModelId());
        dynamicObject.set("description", (Object)model.getDescription());
        dynamicObject.set("datatype", (Object)model.getDataTypeId());
        dynamicObject.set("version", (Object)model.getVersionId());
        dynamicObject.set("period", (Object)model.getPeriodId());
        dynamicObject.set("rpaprocess", (Object)model.getRpaProcess());
        dynamicObject.set("rparobot", (Object)model.getRpaRobot());
        dynamicObject.set("exportpath", (Object)model.getExportPath());
        dynamicObject.set("installpath", (Object)model.getInstallPath());
        dynamicObject.set("createini", (Object)model.getCreateIni());
        dynamicObject.set("filename", (Object)model.getFileName());
        dynamicObject.set("filetype", (Object)model.getFileType());
        dynamicObject.set("sheetname", (Object)model.getSheetName());
        dynamicObject.set("modifier", (Object)model.getModifier());
        dynamicObject.set("modifytime", (Object)model.getModifyTime());
        return dynamicObject;
    }

    private static class InnerClass {
        private static final RpaSchemeDao instance = new RpaSchemeDao();

        private InnerClass() {
        }
    }
}

