/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.rpa.dao;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.rpa.RpaConstants;
import kd.epm.eb.business.rpa.entity.RpaScheme;
import kd.epm.eb.business.rpa.entity.RpaTaskLog;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.lang3.StringUtils;

public class RpaTaskLogDao {
    private static final Log log = LogFactory.getLog(RpaTaskLogDao.class);
    private static final String ENTITY_NAME = "eb_rpa_task_log";

    public static RpaTaskLogDao getInstance() {
        return InnerClass.instance;
    }

    private RpaTaskLogDao() {
    }

    public DynamicObject load(Long id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_NAME);
    }

    public DynamicObjectCollection queryByTime(Date startTime, Date endTime) {
        QFilter qFilter = new QFilter("endtime", ">=", (Object)startTime);
        qFilter.and("endtime", "<=", (Object)endTime);
        return QueryServiceHelper.query((String)ENTITY_NAME, (String)"id, tasktype, entity, template, status, starttime, endtime", (QFilter[])new QFilter[]{qFilter});
    }

    public void saveTaskLog(String taskID, String procCode, String status, RpaScheme rpaScheme, RpaConstants.RpaLogType logType) {
        Long userId = RequestContext.get().getCurrUserId();
        Date now = TimeServiceHelper.now();
        String nowStr = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(now);
        RpaTaskLog log = new RpaTaskLog();
        log.setScheme(rpaScheme.getId());
        log.setTaskType(logType.name());
        log.setTaskId(taskID);
        log.setModel(rpaScheme.getModelId());
        log.setBizModel(rpaScheme.getBizModelId());
        log.setDataType(rpaScheme.getDataTypeId());
        log.setVersion(rpaScheme.getVersionId());
        log.setPeriod(rpaScheme.getPeriodId());
        log.setRpaProcessCode(procCode);
        log.setStatus(status);
        log.setModifier(userId);
        log.setModifyTime(now);
        log.setStartTime(nowStr);
        log.setEndTime(nowStr);
        if (StringUtils.isNotBlank((CharSequence)rpaScheme.getEntity())) {
            String entity = rpaScheme.getEntity().length() > 2000 ? rpaScheme.getEntity().substring(0, 2000) : rpaScheme.getEntity();
            log.setEntity(entity);
        }
        if (StringUtils.isNotBlank((CharSequence)rpaScheme.getTemplate())) {
            String template = rpaScheme.getTemplate().length() > 2000 ? rpaScheme.getTemplate().substring(0, 2000) : rpaScheme.getTemplate();
            log.setTemplate(template);
        }
        DynamicObject dynamicObject = this.packageDynamicObject(log);
        this.save(dynamicObject);
    }

    public void updateStatus(String taskId, Map<String, Object> taskInfo) {
        String selectFields = "id, status, starttime, endtime, robotno, robotname, rpaprocess, rpaprocessver, description";
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("taskid", "=", (Object)taskId)});
        if (dynamicObject == null) {
            return;
        }
        dynamicObject.set("status", taskInfo.get("status"));
        dynamicObject.set("starttime", taskInfo.get("startTime"));
        dynamicObject.set("endtime", taskInfo.get("endTime"));
        dynamicObject.set("robotno", taskInfo.get("currRobotNo"));
        dynamicObject.set("robotname", taskInfo.get("currRobotName"));
        dynamicObject.set("rpaprocess", taskInfo.get("procName"));
        dynamicObject.set("rpaprocessver", taskInfo.get("procVer"));
        Object description = taskInfo.get("description");
        if (description != null) {
            String desc = description.toString().length() > 500 ? description.toString().substring(0, 500) : description.toString();
            dynamicObject.set("description", (Object)desc);
        }
        this.save(dynamicObject);
    }

    public void save(DynamicObject newDynObj) {
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newDynObj});
            }
            catch (Throwable e) {
                tx.markRollback();
                log.error(e.getMessage(), e);
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private DynamicObject packageDynamicObject(RpaTaskLog model) {
        DynamicObject dynamicObject;
        Long id = model.getId();
        if (IDUtils.isNull((Long)id)) {
            id = GlobalIdUtil.genGlobalLongId();
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
        } else {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_NAME);
        }
        dynamicObject.set("id", (Object)id);
        dynamicObject.set("scheme", (Object)model.getScheme());
        dynamicObject.set("tasktype", (Object)model.getTaskType());
        dynamicObject.set("taskid", (Object)model.getTaskId());
        dynamicObject.set("model", (Object)model.getModel());
        dynamicObject.set("bizmodel", (Object)model.getBizModel());
        dynamicObject.set("datatype", (Object)model.getDataType());
        dynamicObject.set("version", (Object)model.getVersion());
        dynamicObject.set("period", (Object)model.getPeriod());
        dynamicObject.set("entity", (Object)model.getEntity());
        dynamicObject.set("template", (Object)model.getTemplate());
        dynamicObject.set("status", (Object)model.getStatus());
        dynamicObject.set("rpaprocess", (Object)model.getRpaProcess());
        dynamicObject.set("rpaprocesscode", (Object)model.getRpaProcessCode());
        dynamicObject.set("robotno", (Object)model.getRobotName());
        dynamicObject.set("robotname", (Object)model.getRobotName());
        dynamicObject.set("starttime", (Object)model.getStartTime());
        dynamicObject.set("endtime", (Object)model.getEndTime());
        dynamicObject.set("modifier", (Object)model.getModifier());
        dynamicObject.set("modifytime", (Object)model.getModifyTime());
        return dynamicObject;
    }

    private static class InnerClass {
        private static final RpaTaskLogDao instance = new RpaTaskLogDao();

        private InnerClass() {
        }
    }
}

