/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.servicehelper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.epm.eb.common.dimension.property.PropertyMemObj;
import kd.epm.eb.common.dimension.property.PropertyObj;
import kd.epm.eb.common.entity.property.CustomProperty;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.QFBuilder;

public class DimensionPropertyServiceHelper {
    private static final DimensionPropertyServiceHelper instance = new DimensionPropertyServiceHelper();

    private DimensionPropertyServiceHelper() {
    }

    public static DimensionPropertyServiceHelper getInstance() {
        return instance;
    }

    public List<Long> queryDimensionPropertys(Long modelId, Long dimensionId) {
        if (modelId == null || modelId == 0L || dimensionId == null || dimensionId == 0L) {
            return null;
        }
        LinkedList<Long> propertyIds = new LinkedList<Long>();
        try (DataSet ds = DB.queryDataSet((String)"dimensionproperty", (DBRoute)DBRoute.of((String)"epm"), (String)"select fid from t_eb_customproperty where fmodelid = ? and fdimensionid = ?", (Object[])new Object[]{modelId, dimensionId});){
            if (ds != null) {
                Row row = null;
                while (ds.hasNext()) {
                    row = ds.next();
                    propertyIds.add(row.getLong("fid"));
                }
            }
        }
        return propertyIds;
    }

    public DynamicObjectCollection queryDimensionPropertys(Long modelId, Long dimensionId, String selectFields) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        QFilter qFilter1 = new QFilter("dimension", "=", (Object)dimensionId);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_customproperty", (String)selectFields, (QFilter[])new QFilter[]{qFilter, qFilter1}, (String)"dseq asc");
        return dynamicObjects;
    }

    public DynamicObjectCollection queryDimensionPropertyValuie(Long propertyId, String selectFields) {
        QFilter qFilter = new QFilter("property", "=", (Object)propertyId);
        return QueryServiceHelper.query((String)"eb_custompropertyvalue", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"dseq asc");
    }

    public List<Map<String, Object>> queryDimensionPropertyValue(List<Long> propertyIds, String selectFields) {
        List rst;
        QFilter qFilter = new QFilter("property", "in", propertyIds);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryPropertyValue", (String)"eb_custompropertyvalue", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"number");){
            rst = CommonServiceHelper.transDataSet((DataSet)ds);
        }
        return rst;
    }

    public List<Map<String, Object>> queryDimensionPropertyValue(Long propertyId, String selectFields, QFBuilder builder) {
        List rst;
        QFilter filter = new QFilter("property", "=", (Object)propertyId);
        if (builder != null && !builder.getFilters().isEmpty()) {
            filter.and(builder.toFilter());
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryPropertyValue", (String)"eb_custompropertyvalue", (String)selectFields, (QFilter[])filter.toArray(), (String)"number");){
            rst = CommonServiceHelper.transDataSet((DataSet)ds);
        }
        return rst;
    }

    public Map<String, CustomProperty> queryDimCustomProperties(long modelId, long dimensionId) {
        LinkedHashMap<String, CustomProperty> propertyMap = new LinkedHashMap<String, CustomProperty>(16);
        DynamicObjectCollection properties = this.queryDimensionPropertys(modelId, dimensionId, "id,number,name,dseq");
        for (DynamicObject property : properties) {
            CustomProperty customProperty = new CustomProperty(property.getLong("id"), property.getString("number"), property.getString("name"), property.getInt("dseq"));
            DynamicObjectCollection values = this.queryDimensionPropertyValuie(property.getLong("id"), "id,number,name,dseq");
            Map customPropertyValues = customProperty.getValues();
            for (DynamicObject value : values) {
                customPropertyValues.put(value.getString("number"), new CustomPropertyValue(Long.valueOf(value.getLong("id")), value.getString("number"), value.getString("name"), value.getInt("dseq")));
            }
            propertyMap.put(customProperty.getNumber(), customProperty);
        }
        return propertyMap;
    }

    public int getMaxSeq(Long modelId, Long dimensionId) {
        int seq = 0;
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        QFilter qFilter1 = new QFilter("dimension", "=", (Object)dimensionId);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_customproperty", (String)"dseq", (QFilter[])new QFilter[]{qFilter, qFilter1}, (String)"dseq desc", (int)1);
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            seq = ((DynamicObject)dynamicObjects.get(0)).getInt("dseq");
        }
        return seq;
    }

    public Map<Long, List<PropertyObj>> queryMembersCustomProperties(List<Long> memberids, String memberKey) {
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(16);
        if (memberids.size() > 0) {
            DynamicObject[] load;
            QFBuilder qfBuilder = new QFBuilder("id", "in", memberids);
            String selectFileds = "id ,dimension,propertyentry.propertyvalue";
            for (DynamicObject object : load = BusinessDataServiceHelper.load((String)memberKey, (String)selectFileds, (QFilter[])qfBuilder.toArray())) {
                map.put(object.getString("id"), object);
            }
        }
        HashMap<Long, List<PropertyObj>> properties = new HashMap<Long, List<PropertyObj>>(memberids.size());
        for (Long memberid : memberids) {
            DynamicObject object = (DynamicObject)map.get(String.valueOf(memberid));
            ArrayList<PropertyObj> list = new ArrayList<PropertyObj>(16);
            if (object != null) {
                if (!object.getDynamicObjectType().getProperties().containsKey((Object)"propertyentry")) continue;
                DynamicObjectCollection propertyentry = object.getDynamicObjectCollection("propertyentry");
                for (DynamicObject dynamicObject : propertyentry) {
                    DynamicObject propertyValue = dynamicObject.getDynamicObject("propertyvalue");
                    if (propertyValue == null) continue;
                    DynamicObject property = propertyValue.getDynamicObject("property");
                    PropertyObj propertyObj = new PropertyObj(Long.valueOf(property.getLong("id")), property.getString("name"), property.getString("number"));
                    ArrayList<PropertyMemObj> propertyValueEntries = new ArrayList<PropertyMemObj>(4);
                    propertyValueEntries.add(new PropertyMemObj(Long.valueOf(propertyValue.getLong("id")), propertyValue.getString("name"), propertyValue.getString("number"), 10));
                    propertyObj.setPropertyValueEntries(propertyValueEntries);
                    list.add(propertyObj);
                }
            }
            properties.put(memberid, list);
        }
        return properties;
    }

    public Map<String, List<PropertyObj>> queryMembersCustomProperties(List<String> memberNumbers, long modelId, String dimensionNum) {
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(16);
        if (memberNumbers.size() > 0) {
            DynamicObject[] load;
            QFBuilder qfBuilder = new QFBuilder("number", "in", memberNumbers);
            qfBuilder.add("model", "=", (Object)modelId);
            qfBuilder.add("dimension.number", "=", (Object)dimensionNum);
            String selectFileds = "number,propertyentry.propertyvalue";
            String memberKey = SysDimensionEnum.getMemberTreemodelByNumber((String)dimensionNum);
            for (DynamicObject object : load = BusinessDataServiceHelper.load((String)memberKey, (String)selectFileds, (QFilter[])qfBuilder.toArray())) {
                map.put(object.getString("number"), object);
            }
        }
        HashMap<String, List<PropertyObj>> properties = new HashMap<String, List<PropertyObj>>(memberNumbers.size());
        for (String number : memberNumbers) {
            DynamicObject object = (DynamicObject)map.get(String.valueOf(number));
            ArrayList<PropertyObj> list = new ArrayList<PropertyObj>(16);
            if (object != null) {
                if (!object.getDynamicObjectType().getProperties().containsKey((Object)"propertyentry")) continue;
                DynamicObjectCollection propertyentry = object.getDynamicObjectCollection("propertyentry");
                for (DynamicObject dynamicObject : propertyentry) {
                    DynamicObject propertyValue = dynamicObject.getDynamicObject("propertyvalue");
                    if (propertyValue == null) continue;
                    DynamicObject property = propertyValue.getDynamicObject("property");
                    PropertyObj propertyObj = new PropertyObj(Long.valueOf(property.getLong("id")), property.getString("name"), property.getString("number"));
                    ArrayList<PropertyMemObj> propertyValueEntries = new ArrayList<PropertyMemObj>(4);
                    propertyValueEntries.add(new PropertyMemObj(Long.valueOf(propertyValue.getLong("id")), propertyValue.getString("name"), propertyValue.getString("number"), 10));
                    propertyObj.setPropertyValueEntries(propertyValueEntries);
                    list.add(propertyObj);
                }
            }
            properties.put(number, list);
        }
        return properties;
    }

    public Map<Long, List<PropertyObj>> queryDimensionPropertys(Long modelId, List<Long> dimensionIds) {
        HashMap<Long, List<PropertyObj>> result = new HashMap<Long, List<PropertyObj>>(16);
        if (modelId == null || modelId == 0L || dimensionIds == null || (long)dimensionIds.size() == 0L) {
            return result;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("model", "=", (Object)modelId));
        filters.add(new QFilter("dimension", "in", dimensionIds));
        DynamicObjectCollection propertyDys = this.getPropertyDysByFilter(filters);
        Map<Long, List<DynamicObject>> propertysMap = propertyDys.stream().collect(Collectors.groupingBy(dy -> dy.getLong("dimId")));
        for (Long dimId : dimensionIds) {
            ArrayList<PropertyObj> curList = new ArrayList<PropertyObj>(16);
            if (propertysMap.containsKey(dimId)) {
                List curPropertyDys = propertysMap.get(dimId).stream().sorted((x, y) -> -Long.compare(x.getInt("dseq"), y.getInt("dseq"))).collect(Collectors.toList());
                for (DynamicObject propertyDy : curPropertyDys) {
                    PropertyObj propertyObj = new PropertyObj(Long.valueOf(propertyDy.getLong("id")), propertyDy.getString("name"), propertyDy.getString("number"));
                    propertyObj.setDseq(propertyDy.getInt("dseq"));
                    curList.add(propertyObj);
                }
            }
            result.put(dimId, curList);
        }
        return result;
    }

    public Map<String, List<PropertyObj>> queryDimensionPropertysByNum(Long modelId, List<String> dimensionNums) {
        HashMap<String, List<PropertyObj>> result = new HashMap<String, List<PropertyObj>>(16);
        if (modelId == null || modelId == 0L || dimensionNums == null || (long)dimensionNums.size() == 0L) {
            return result;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("model", "=", (Object)modelId));
        filters.add(new QFilter("dimension.number", "in", dimensionNums));
        DynamicObjectCollection propertyDys = this.getPropertyDysByFilter(filters);
        Map<String, List<DynamicObject>> propertysMap = propertyDys.stream().collect(Collectors.groupingBy(dy -> dy.getString("dimNum")));
        for (String dimNum : dimensionNums) {
            ArrayList<PropertyObj> curList = new ArrayList<PropertyObj>(16);
            if (propertysMap.containsKey(dimNum)) {
                List curPropertyDys = propertysMap.get(dimNum).stream().sorted((x, y) -> -Long.compare(x.getInt("dseq"), y.getInt("dseq"))).collect(Collectors.toList());
                for (DynamicObject propertyDy : curPropertyDys) {
                    PropertyObj propertyObj = new PropertyObj(Long.valueOf(propertyDy.getLong("id")), propertyDy.getString("name"), propertyDy.getString("number"));
                    propertyObj.setDseq(propertyDy.getInt("dseq"));
                    curList.add(propertyObj);
                }
            }
            result.put(dimNum, curList);
        }
        return result;
    }

    DynamicObjectCollection getPropertyDysByFilter(List<QFilter> filters) {
        return QueryServiceHelper.query((String)"eb_customproperty", (String)"id,dimension dimId,dimension.number dimNum,dseq,name,number", (QFilter[])filters.toArray(new QFilter[filters.size()]));
    }

    public boolean checkPropertyExistValue(Long propertyId) {
        QFilter qFilter = new QFilter("property", "=", (Object)propertyId);
        return QueryServiceHelper.exists((String)"eb_custompropertyvalue", (QFilter[])new QFilter[]{qFilter});
    }

    public void deleteProperty(Object[] propertyIds) {
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"eb_customproperty"), (Object[])propertyIds);
    }
}

