/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.servicehelper;

import com.google.common.collect.Sets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.TreeNodeUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.ebBusiness.serviceHelper.TemplateServiceHelper;
import org.jetbrains.annotations.NotNull;

public class DimensionServiceHelper {
    public static final String FIELDS = "id, name, number, shortnumber, dseq, fieldmapped, model.id, membermodel";

    public static void initDimensionDyObject(DynamicObject dy) {
        dy.set("status", (Object)"C");
        dy.set("enable", (Object)"1");
        DimensionServiceHelper.initCommonDyObject(dy);
    }

    public static void initDimensionDyObject(DynamicObject dy, DynamicObject user, Date createTime) {
        dy.set("status", (Object)"C");
        dy.set("enable", (Object)"1");
        DimensionServiceHelper.initCommonDyObject(dy, user, createTime);
    }

    public static void initCommonDyObject(DynamicObject dy) {
        DimensionServiceHelper.initCommonDyObject(dy, null, null);
    }

    public static void initCommonDyObject(DynamicObject dy, DynamicObject user, Date createTime) {
        if (createTime == null) {
            createTime = DimensionServiceHelper.getCurrentDate();
        }
        dy.set("createtime", (Object)createTime);
        dy.set("modifytime", (Object)createTime);
        if (user == null) {
            user = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
            user.set("id", (Object)UserUtils.getUserId());
        }
        dy.set("creator", (Object)user);
        dy.set("modifier", (Object)user);
    }

    public static void initDimensionAndModel(DynamicObject dy, long modelid, long dimensionId) {
        DynamicObject model = BusinessDataServiceHelper.newDynamicObject((String)"epm_model");
        model.set("id", (Object)modelid);
        DynamicObject dimension = BusinessDataServiceHelper.newDynamicObject((String)"epm_dimension");
        dimension.set("id", (Object)dimensionId);
        dy.set("model", (Object)model);
        dy.set("dimension", (Object)dimension);
    }

    private static Date getCurrentDate() {
        LocalDateTime localDateTime = LocalDateTime.now();
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        return Date.from(instant);
    }

    public static int getDSeq(long memberId, String entityNumber) {
        return DimensionServiceHelper.getMaxDSeq(memberId, entityNumber, 0L) + 1;
    }

    public static int getDSeq(long memberId, String entityNumber, long viewId) {
        return DimensionServiceHelper.getMaxDSeq(memberId, entityNumber, viewId) + 1;
    }

    public static int getMaxDSeq(long memberId, String entityNumber, long viewId) {
        QFBuilder builder = new QFBuilder();
        builder.add("parent", "=", (Object)memberId);
        if ("eb_viewmember".equals(entityNumber) && viewId != 0L) {
            builder.add("view", "=", (Object)viewId);
        }
        int seq = 0;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getMaxDSeq", (String)entityNumber, (String)"dseq", (QFilter[])builder.toArrays(), (String)"dseq desc", (int)1);){
            if (ds != null && ds.hasNext()) {
                seq = ds.next().getInteger("dseq");
            }
        }
        return seq;
    }

    public static int getDimSeq(long modelId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        QFilter[] qFilters = new QFilter[]{qFilter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"epm_dimension", (String)"dseq", (QFilter[])qFilters, (String)"dseq");
        if (dcs != null) {
            if (dcs.size() == 0) {
                return 1;
            }
            return ((DynamicObject)dcs.get(dcs.size() - 1)).getInt("dseq") + 1;
        }
        return 1;
    }

    public static String getMappedSeq(long modelId) {
        HashSet<String> mapSet = new HashSet<String>(16);
        String sql = "select ffieldmapped from t_eb_dimension where fmodelid = ? and fissysdimension = '0'";
        try (DataSet ds = DB.queryDataSet((String)"queryFieldMapped", (DBRoute)BgBaseConstant.epm, (String)sql, (Object[])new Object[]{modelId});){
            if (ds != null) {
                for (Row row : ds) {
                    mapSet.add(row.getString("ffieldmapped"));
                }
            }
        }
        String fieldmapped = "dim1";
        for (int i = 1; i < 50; ++i) {
            String _tmpStr = "dim" + i;
            if (mapSet.contains(_tmpStr)) continue;
            fieldmapped = _tmpStr;
            break;
        }
        return fieldmapped;
    }

    public static DynamicObject queryDimensionByNumber(Long modelid, String selectFields, String dimsionNumber) {
        QFilter filter1 = new QFilter("model", "=", (Object)modelid);
        QFilter[] filters = new QFilter[]{filter1, new QFilter("number", "=", (Object)dimsionNumber)};
        return BusinessDataServiceHelper.loadSingle((String)"epm_dimension", (String)selectFields, (QFilter[])filters);
    }

    public static DynamicObject queryDimensionById(Long modelid, Long dimensionId, String selectFields) {
        QFilter fmodelid = new QFilter("model", "=", (Object)modelid);
        QFilter fmodelid2 = new QFilter("id", "=", (Object)dimensionId);
        QFilter[] filters = new QFilter[]{fmodelid, fmodelid2};
        return QueryServiceHelper.queryOne((String)"epm_dimension", (String)selectFields, (QFilter[])filters);
    }

    public static DynamicObjectCollection queryDimensionByIds(Long modelid, Long[] dimensionIds, String selectFields) {
        QFilter fmodelid = new QFilter("model", "=", (Object)modelid);
        QFilter fmodelid2 = new QFilter("id", "in", (Object)dimensionIds);
        QFilter[] filters = new QFilter[]{fmodelid, fmodelid2};
        return QueryServiceHelper.query((String)"epm_dimension", (String)selectFields, (QFilter[])filters);
    }

    public static DynamicObjectCollection queryDimensionByIds(Long modelid, List<Long> dimensionIds, String selectFields) {
        QFilter fmodelid = new QFilter("model", "=", (Object)modelid);
        QFilter fmodelid2 = new QFilter("id", "in", dimensionIds);
        QFilter[] filters = new QFilter[]{fmodelid, fmodelid2};
        return QueryServiceHelper.query((String)"epm_dimension", (String)selectFields, (QFilter[])filters, (String)"dseq");
    }

    public static DynamicObject queryDimensionBySeq(int seq, Long modelId, String selectFields) {
        QFilter fmodelid = new QFilter("model", "=", (Object)modelId);
        QFilter fmodelid2 = new QFilter("dseq", "=", (Object)seq);
        QFilter[] filters = new QFilter[]{fmodelid, fmodelid2};
        return QueryServiceHelper.queryOne((String)"epm_dimension", (String)selectFields, (QFilter[])filters);
    }

    public static DynamicObjectCollection queryAllUserDefineDimension(Long modelId, String selectFields) {
        QFilter qfModel = new QFilter("model", "=", (Object)modelId);
        QFilter qfIsSys = new QFilter("issysdimension", "=", (Object)Character.valueOf('0'));
        return QueryServiceHelper.query((String)"epm_dimension", (String)selectFields, (QFilter[])new QFilter[]{qfModel, qfIsSys});
    }

    public static DynamicObject queryMemberByNumber(String memberKey, long modelId, long dimensionId, String memberNumber, String selectFields) {
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        QFilter qf2 = new QFilter("number", "=", (Object)memberNumber);
        if (IDUtils.isNotNull((long)dimensionId)) {
            qf2.and(new QFilter("dimension", "=", (Object)dimensionId));
        }
        return QueryServiceHelper.queryOne((String)memberKey, (String)selectFields, (QFilter[])new QFilter[]{qf, qf2});
    }

    public static List<DynamicObject> queryAllDim(Long modelid, String selectFields) {
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"epm_dimension", (String)selectFields, (QFilter[])new QFBuilder().add("model", "=", (Object)modelid).toArrays(), (String)"dseq");
        ArrayList<DynamicObject> allDim = new ArrayList<DynamicObject>(50);
        allDim.addAll((Collection<DynamicObject>)dims);
        return allDim;
    }

    public static List<DynamicObject> queryAllView(Long modelid, Long dimensionid, String selectField) {
        QFBuilder qf = new QFBuilder("model", "=", (Object)modelid);
        qf.add("dimension", "=", (Object)dimensionid);
        DynamicObjectCollection views = QueryServiceHelper.query((String)"eb_dimensionview", (String)selectField, (QFilter[])qf.toArrays(), (String)"source desc,createdate asc");
        ArrayList<DynamicObject> allviews = new ArrayList<DynamicObject>(views.size());
        allviews.addAll((Collection<DynamicObject>)views);
        return allviews;
    }

    public static DynamicObject queryMemberIdByNumber(String entityName, long modelId, String dimNumber) {
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        QFilter qf2 = new QFilter("number", "=", (Object)dimNumber);
        return QueryServiceHelper.queryOne((String)entityName, (String)"id,number", (QFilter[])new QFilter[]{qf, qf2});
    }

    public static DynamicObject queryMemberNameByNumber(String entityName, long modelId, String dimNumber) {
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        QFilter qf2 = new QFilter("number", "=", (Object)dimNumber);
        return QueryServiceHelper.queryOne((String)entityName, (String)"name", (QFilter[])new QFilter[]{qf, qf2});
    }

    public static Set<Long> getAllChildrenId(String entityNumber, Long modelId, Long dimensionId, Long viewId, Long memberId, boolean self) {
        DynamicObject member;
        String field = "id, longnumber";
        boolean hasAccount = SysDimensionEnum.Account.getMemberTreemodel().equals(entityNumber);
        if (hasAccount) {
            field = field + ",dataset.id";
        }
        String _entityNumber = entityNumber;
        if (IDUtils.isNotNull((Long)viewId)) {
            _entityNumber = "eb_viewmember";
        }
        if ((member = QueryServiceHelper.queryOne((String)_entityNumber, (String)field, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)memberId)})) == null) {
            return Collections.emptySet();
        }
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)modelId);
        builder.add("dimension", "=", (Object)dimensionId);
        if (IDUtils.isNotNull((Long)viewId)) {
            builder.add("view", "=", (Object)viewId);
        }
        builder.add("longnumber", "like", (Object)(member.get("longnumber") + "!%"));
        if (hasAccount) {
            builder.add("dataset", "=", member.get("dataset.id"));
        }
        LinkedHashSet children = Sets.newLinkedHashSet();
        if (self) {
            children.add(memberId);
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryChild", (String)_entityNumber, (String)"id", (QFilter[])builder.toArrays(), null);){
            if (ds != null) {
                for (Row row : ds) {
                    children.add(row.getLong("id"));
                }
            }
        }
        return children;
    }

    public static List<Long> getAllViewChildrenId(String entityNumber, Long modelId, Long dimensionId, Long memberId, boolean self) {
        Map member = null;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryChild", (String)entityNumber, (String)"id, view.id, longnumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)memberId)}, null, (int)1);){
            if (ds != null && ds.hasNext()) {
                member = CommonServiceHelper.transDataMap((DataSet)ds);
            }
        }
        if (member == null) {
            return Collections.emptyList();
        }
        LinkedList<Long> children = new LinkedList<Long>();
        if (self) {
            children.add(memberId);
        }
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)modelId);
        builder.add("dimension", "=", (Object)dimensionId);
        builder.add("view", "=", member.get("view.id"));
        builder.add("longnumber", "like", (Object)(member.get("longnumber") + "!%"));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryChild", (String)entityNumber, (String)"id", (QFilter[])builder.toArray(), null);){
            if (ds != null) {
                for (Row row : ds) {
                    children.add(row.getLong("id"));
                }
            }
        }
        return children;
    }

    public static List<Map<String, Object>> getAllChildrenObject(String entityNumber, Long model, Long dimension, Long memberId, String selectFields, boolean self) {
        boolean hasAccount;
        String _selectFields = selectFields;
        if (_selectFields.indexOf("longnumber") == -1) {
            _selectFields = _selectFields + ",longnumber";
        }
        if ((hasAccount = SysDimensionEnum.Account.getMemberTreemodel().equals(entityNumber)) && _selectFields.indexOf("dataset.id") == -1) {
            _selectFields = _selectFields + ",dataset.id";
        }
        Map member = null;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryChild", (String)entityNumber, (String)_selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)memberId)}, null, (int)1);){
            if (ds != null && ds.hasNext()) {
                member = CommonServiceHelper.transDataMap((DataSet)ds);
            }
        }
        if (member == null) {
            return Collections.emptyList();
        }
        LinkedList<Map<String, Object>> children = new LinkedList<Map<String, Object>>();
        if (self) {
            children.add(member);
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)model));
        builder.add(new QFilter("dimension", "=", (Object)dimension));
        builder.add(new QFilter("longnumber", "like", (Object)(member.get("longnumber") + "!%")));
        if (hasAccount) {
            builder.add(new QFilter("dataset", "=", member.get("dataset.id")));
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryChild", (String)entityNumber, (String)selectFields, (QFilter[])builder.toArray(), null);){
            if (ds != null) {
                children.addAll(CommonServiceHelper.transDataSet((DataSet)ds));
            }
        }
        return children;
    }

    public static String getMemberKeyByDimNum(String dimNum) {
        switch (dimNum.toLowerCase(Locale.getDefault())) {
            case "entity": {
                return "epm_entitymembertree";
            }
            case "account": {
                return "epm_accountmembertree";
            }
            case "year": {
                return "epm_yearmembertree";
            }
            case "period": {
                return "epm_periodmembertree";
            }
            case "currency": {
                return "epm_currencymembertree";
            }
            case "audittrail": {
                return "epm_audittrialmembertree";
            }
            case "changetype": {
                return "epm_changetypemembertree";
            }
            case "internalcompany": {
                return "epm_icmembertree";
            }
            case "datatype": {
                return "epm_datatypemembertree";
            }
            case "version": {
                return "epm_versionmembertree";
            }
            case "metric": {
                return "epm_metricmembertree";
            }
            case "budgetperiod": {
                return "epm_bperiodmembertree";
            }
        }
        return "epm_userdefinedmembertree";
    }

    public static DynamicObjectCollection queryDataSet(long modelId, String fields) {
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        return QueryServiceHelper.query((String)"eb_dataset", (String)fields, (QFilter[])new QFilter[]{qf});
    }

    public static DynamicObjectCollection queryDataSet(long modelId) {
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        return QueryServiceHelper.query((String)"eb_dataset", (String)"id,number,name", (QFilter[])new QFilter[]{qf});
    }

    public static DynamicObject getOffsetEntity(long parentId, long modelId) {
        QFilter qFilter = new QFilter("parent", "=", (Object)parentId);
        QFilter qFilter1 = new QFilter("isoffsetentry", "=", (Object)true);
        QFilter qf2 = new QFilter("model", "=", (Object)modelId);
        return QueryServiceHelper.queryOne((String)"epm_entitymembertree", (String)"id,number,offsetsource", (QFilter[])new QFilter[]{qFilter, qFilter1, qf2});
    }

    public static boolean existMember(long memberId, long modelId) {
        QFilter qFilter1 = new QFilter("memberid", "=", (Object)memberId);
        QFilter qf2 = new QFilter("model", "=", (Object)modelId);
        return QueryServiceHelper.exists((String)"eb_viewmember", (QFilter[])new QFilter[]{qFilter1, qf2});
    }

    public static long getIdByNumber(long model, String entityform, String number) {
        String selectFields = "id";
        QFilter filter1 = new QFilter("number", "=", (Object)number);
        QFilter filter2 = new QFilter("model.id", "=", (Object)model);
        QFilter[] filters = new QFilter[]{filter1, filter2};
        DynamicObject dcs = QueryServiceHelper.queryOne((String)entityform, (String)selectFields, (QFilter[])filters);
        if (dcs != null) {
            return dcs.getLong("id");
        }
        return 0L;
    }

    public static long getChangeTypeMemberIdByNumber(long model, String number, long view) {
        QFilter filter1 = new QFilter("number", "=", (Object)number);
        QFilter filter2 = new QFilter("model.id", "=", (Object)model);
        QFilter filter3 = new QFilter("view.id", "=", (Object)view);
        QFilter[] filters = new QFilter[]{filter1, filter2, filter3};
        DynamicObject dcs = QueryServiceHelper.queryOne((String)"epm_changetypemembertree", (String)"id", (QFilter[])filters);
        if (dcs != null) {
            return dcs.getLong("id");
        }
        return 0L;
    }

    public static DynamicObject createICEntity(DynamicObject entity, DynamicObject parent) {
        DynamicObject ICEntity = BusinessDataServiceHelper.newDynamicObject((String)"epm_icmembertree");
        ICEntity.set("status", (Object)"C");
        ICEntity.set("enable", (Object)"1");
        Date modifytime = entity.getDate("modifytime");
        ICEntity.set("createtime", (Object)modifytime);
        ICEntity.set("modifytime", (Object)modifytime);
        long modifier = entity.getLong("modifier.id");
        ICEntity.set("creator", (Object)modifier);
        ICEntity.set("modifier", (Object)modifier);
        ICEntity.set("model", (Object)entity.getLong("model.id"));
        ICEntity.set("dimension", parent.get("dimension"));
        String number = entity.getString("number");
        ICEntity.set("number", (Object)number);
        ICEntity.set("name", (Object)entity.getString("name"));
        ICEntity.set("longnumber", (Object)(parent.getString("longnumber") + "!" + number));
        long parentid = parent.getLong("id");
        ICEntity.set("parent", (Object)parentid);
        ICEntity.set("dseq", (Object)DimensionServiceHelper.getDSeq(parentid, "epm_icmembertree"));
        ICEntity.set("aggoprt", (Object)entity.getString("aggoprt"));
        ICEntity.set("description", entity.get("description"));
        ICEntity.set("membersource", (Object)MemberSourceEnum.ADD.getIndex());
        ICEntity.set("isleaf", (Object)1);
        ICEntity.set("level", (Object)4);
        try {
            ICEntity.set("disable", entity.get("disable"));
            if (((Boolean)entity.get("disable")).booleanValue()) {
                ICEntity.set("disabledate", (Object)TimeServiceHelper.now());
                ICEntity.set("disabler", (Object)UserUtils.getUserId());
            }
        }
        catch (Exception ignored) {
            ICEntity.set("disable", (Object)false);
        }
        return ICEntity;
    }

    public static Long getOrNewICBaseMember(String number, Long modelId) {
        Long membId = (Long)CommonServiceHelper.getValueFromDB((String)SysDimensionEnum.InternalCompany.getMemberTreemodel(), (String)"id", (String)"model,number", (Object[])new Object[]{modelId, number});
        if (membId == null) {
            String parentNumber = "ICEntity";
            QFilter qModel = new QFilter("model", "=", (Object)modelId);
            QFilter qNumber = new QFilter("number", "=", (Object)number);
            QFilter qParent = new QFilter("number", "=", (Object)parentNumber);
            DynamicObject baseEntityMember = QueryServiceHelper.queryOne((String)SysDimensionEnum.Entity.getMemberTreemodel(), (String)"model.id,number,name,aggoprt,description,modifytime,modifier.id", (QFilter[])new QFilter[]{qModel, qNumber});
            if (baseEntityMember == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u672a\u80fd\u83b7\u53d6\u7ec4\u7ec7\u6210\u5458%1", (String)"DimensionServiceHelper_0", (String)"epm-eb-business", (Object[])new Object[]{number}));
            }
            DynamicObject parentICMember = QueryServiceHelper.queryOne((String)SysDimensionEnum.InternalCompany.getMemberTreemodel(), (String)"id,dimension,longnumber", (QFilter[])new QFilter[]{qModel, qParent});
            if (parentICMember == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u672a\u80fd\u83b7\u53d6\u7236\u7ea7\u5f80\u6765\u7ec4\u7ec7\u6210\u5458%1", (String)"DimensionServiceHelper_1", (String)"epm-eb-business", (Object[])new Object[]{parentNumber}));
            }
            DynamicObject newICmember = DimensionServiceHelper.createICEntity(baseEntityMember, parentICMember);
            newICmember.set("enable", (Object)0);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newICmember});
            membId = newICmember.getLong("id");
        }
        return membId;
    }

    public static DynamicObject createOffsetEntry(DynamicObject object) {
        DynamicObject model = object.getDynamicObject("model");
        Long id = object.getLong("id");
        DynamicObject offsetEntry = BusinessDataServiceHelper.newDynamicObject((String)"epm_entitymembertree");
        String number = object.getString("number") + "offsetentry";
        offsetEntry.set("number", (Object)number);
        offsetEntry.set("shownumber", (Object)number);
        offsetEntry.set("name", (Object)ResManager.loadKDString((String)"\u62b5\u9500\u5206\u5f55", (String)"DimensionServiceHelper_2", (String)"epm-eb-business", (Object[])new Object[0]));
        offsetEntry.set("aggoprt", (Object)"1");
        offsetEntry.set("currency", (Object)object.getDynamicObject("currency"));
        offsetEntry.set("isinnerorg", (Object)false);
        offsetEntry.set("isouterorg", (Object)false);
        offsetEntry.set("isleaf", (Object)true);
        offsetEntry.set("isoffsetentry", (Object)true);
        offsetEntry.set("dimension", (Object)object.getDynamicObject("dimension"));
        offsetEntry.set("model", (Object)model);
        offsetEntry.set("level", (Object)(object.getInt("level") + 1));
        offsetEntry.set("parent", (Object)id);
        offsetEntry.set("longnumber", (Object)(object.getString("longnumber") + "!" + number));
        offsetEntry.set("dseq", (Object)DimensionServiceHelper.getDSeq(id, "epm_entitymembertree"));
        long user = UserUtils.getUserId();
        Date newdate = new Date();
        offsetEntry.set("creator", (Object)user);
        offsetEntry.set("modifier", (Object)user);
        offsetEntry.set("createtime", (Object)newdate);
        offsetEntry.set("modifytime", (Object)newdate);
        offsetEntry.set("status", (Object)"C");
        offsetEntry.set("enable", (Object)"1");
        offsetEntry.set("offsetsource", (Object)"1");
        offsetEntry.set("membersource", (Object)MemberSourceEnum.ADD.getIndex());
        offsetEntry.set("disable", object.get("disable"));
        DynamicObjectCollection namechangerds = (DynamicObjectCollection)offsetEntry.get("namechangerds");
        DynamicObject nameChange = namechangerds.addNew();
        nameChange.set("namerds", (Object)ResManager.loadKDString((String)"\u62b5\u9500\u5206\u5f55", (String)"DimensionServiceHelper_2", (String)"epm-eb-business", (Object[])new Object[0]));
        DynamicObjectCollection parentNameChange = object.getDynamicObjectCollection("namechangerds");
        if (parentNameChange != null && parentNameChange.size() > 0) {
            nameChange.set("nameeffdate", (Object)((DynamicObject)parentNameChange.get(parentNameChange.size() - 1)).getDate("nameeffdate"));
        } else {
            nameChange.set("nameeffdate", (Object)newdate);
        }
        nameChange.set("namemodifier", (Object)user);
        nameChange.set("namemodifytime", (Object)newdate);
        return offsetEntry;
    }

    public static DynamicObject createOffsetEntryByViewMember(DynamicObject object) {
        DynamicObject model = object.getDynamicObject("model");
        Long id = object.getLong("id");
        DynamicObject offsetEntry = BusinessDataServiceHelper.newDynamicObject((String)"epm_entitymembertree");
        String number = object.getString("number") + "offsetentry";
        offsetEntry.set("number", (Object)number);
        offsetEntry.set("shownumber", (Object)number);
        offsetEntry.set("name", (Object)ResManager.loadKDString((String)"\u62b5\u9500\u5206\u5f55", (String)"DimensionServiceHelper_2", (String)"epm-eb-business", (Object[])new Object[0]));
        offsetEntry.set("aggoprt", (Object)"1");
        offsetEntry.set("currency", (Object)object.getDynamicObject("currency"));
        offsetEntry.set("isinnerorg", (Object)false);
        offsetEntry.set("isouterorg", (Object)false);
        offsetEntry.set("isleaf", (Object)true);
        offsetEntry.set("isoffsetentry", (Object)true);
        offsetEntry.set("dimension", (Object)object.getDynamicObject("dimension"));
        offsetEntry.set("model", (Object)model);
        offsetEntry.set("level", (Object)(object.getInt("level") + 1));
        offsetEntry.set("parent", (Object)id);
        offsetEntry.set("longnumber", (Object)(object.getString("longnumber") + "!" + number));
        offsetEntry.set("dseq", (Object)DimensionServiceHelper.getDSeq(id, "epm_entitymembertree"));
        long user = UserUtils.getUserId();
        Date newdate = new Date();
        offsetEntry.set("creator", (Object)user);
        offsetEntry.set("modifier", (Object)user);
        offsetEntry.set("createtime", (Object)newdate);
        offsetEntry.set("modifytime", (Object)newdate);
        offsetEntry.set("status", (Object)"C");
        offsetEntry.set("enable", (Object)"1");
        offsetEntry.set("offsetsource", (Object)"2");
        offsetEntry.set("membersource", (Object)MemberSourceEnum.ADD.getIndex());
        DynamicObjectCollection namechangerds = (DynamicObjectCollection)offsetEntry.get("namechangerds");
        DynamicObject nameChange = namechangerds.addNew();
        nameChange.set("namerds", (Object)ResManager.loadKDString((String)"\u62b5\u9500\u5206\u5f55", (String)"DimensionServiceHelper_2", (String)"epm-eb-business", (Object[])new Object[0]));
        DynamicObjectCollection parentNameChange = object.getDynamicObjectCollection("namechangerds");
        if (parentNameChange != null && parentNameChange.size() > 0) {
            nameChange.set("nameeffdate", (Object)((DynamicObject)parentNameChange.get(parentNameChange.size() - 1)).getDate("nameeffdate"));
        } else {
            nameChange.set("nameeffdate", (Object)newdate);
        }
        nameChange.set("namemodifier", (Object)user);
        nameChange.set("namemodifytime", (Object)newdate);
        return offsetEntry;
    }

    public static DynamicObject createCurrencyMember(Long model, Long dimension, String number, String name, Long parent, MemberSourceEnum source, int dseq) {
        DynamicObject currencyTree = BusinessDataServiceHelper.newDynamicObject((String)"epm_currencymembertree");
        DimensionServiceHelper.initDimensionDyObject(currencyTree);
        DynamicObject modelOb = BusinessDataServiceHelper.newDynamicObject((String)"epm_model");
        modelOb.set("id", (Object)model);
        DynamicObject dimensionOb = BusinessDataServiceHelper.newDynamicObject((String)"epm_dimension");
        dimensionOb.set("id", (Object)dimension);
        currencyTree.set("number", (Object)number);
        currencyTree.set("shownumber", (Object)number);
        currencyTree.set("name", (Object)name);
        currencyTree.set("aggoprt", (Object)5);
        currencyTree.set("isleaf", (Object)1);
        currencyTree.set("level", (Object)2);
        currencyTree.set("longnumber", (Object)(SysDimensionEnum.Currency.getNumber() + "!" + number));
        currencyTree.set("parent", (Object)parent);
        currencyTree.set("dseq", (Object)dseq);
        currencyTree.set("model", (Object)modelOb);
        currencyTree.set("dimension", (Object)dimensionOb);
        currencyTree.set("membersource", (Object)source.getIndex());
        return currencyTree;
    }

    public static Map<String, String> getUserDefineDimensionNumAndNameByModel(long modelId, boolean needSeq) {
        HashMap<String, String> dimNumAndName = new HashMap<String, String>(16);
        Collection dims = BusinessDataServiceHelper.loadFromCache((String)"epm_dimension", (String)"number,name", (QFilter[])new QFBuilder().add("model", "=", (Object)modelId).add("issysdimension", "=", (Object)false).toArray(), (String)"dseq").values();
        int seq = 1;
        for (DynamicObject dim : dims) {
            if (needSeq) {
                dimNumAndName.put(dim.getString("number"), dim.getString("name") + "." + seq);
            } else {
                dimNumAndName.put(dim.getString("number"), dim.getString("name"));
            }
            ++seq;
        }
        return dimNumAndName;
    }

    public static kd.epm.eb.common.model.Dimension getDimension(Long modelId, String dimNumber) {
        if (modelId == null || StringUtils.isEmpty((String)dimNumber)) {
            return null;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        builder.add(new QFilter("number", "=", (Object)dimNumber));
        DynamicObject object = QueryServiceHelper.queryOne((String)"epm_dimension", (String)FIELDS, (QFilter[])builder.toArrays());
        return kd.epm.eb.common.model.Dimension.loadFromDynamicobject((DynamicObject)object);
    }

    public static List<kd.epm.eb.common.model.Dimension> getDimensionByModel(Long modelId) {
        ArrayList<kd.epm.eb.common.model.Dimension> dimensions = new ArrayList<kd.epm.eb.common.model.Dimension>(16);
        if (modelId == null) {
            return dimensions;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"epm_dimension", (String)FIELDS, (QFilter[])builder.toArrays(), (String)"dseq");
        dims.forEach(dim -> {
            kd.epm.eb.common.model.Dimension dimension = kd.epm.eb.common.model.Dimension.loadFromDynamicobject((DynamicObject)dim);
            dimension.setModelId(modelId);
            dimensions.add(dimension);
        });
        return dimensions;
    }

    public static List<Long> getViewMemberIds(Long modelId, Long viewid) {
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
        qfBuilder.add("view", "=", (Object)viewid);
        ArrayList<Long> ids = new ArrayList<Long>(100);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"DimensionServiceHelper.getViewIds", (String)"eb_viewmember", (String)"memberid", (QFilter[])qfBuilder.toArray(), (String)"level desc", (int)100);
        for (Row row : dataSet) {
            ids.add(row.getLong("memberid"));
        }
        return ids;
    }

    public static void updateIsLeafByParentId(Long memberId, Long modelId, Long dimensionId, String entityNumber) {
        DimensionServiceHelper.updateIsLeafByParentId(new Long[]{memberId}, modelId, dimensionId, entityNumber);
    }

    public static void updateIsLeafByParentId(Long[] memberIds, @NotNull Long modelId, @NotNull Long dimensionId, @NotNull String entityNumber) {
        BgDimensionServiceHelper.updateIsLeafByParentId((Long[])memberIds, (Long)modelId, (Long)dimensionId, (String)entityNumber);
    }

    public static List<String> getAccountByDataset(@NotNull Long modelId, @NotNull Long datasetId) {
        return DimensionServiceHelper.getAccountByDataset(modelId, datasetId, false);
    }

    public static List<String> getAccountByDataset(@NotNull Long modelId, @NotNull Long datasetId, boolean isIncludeNotLeaf) {
        DynamicObjectCollection dcs;
        LinkedList<String> memList = new LinkedList<String>();
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        builder.add(new QFilter("dataset", "=", (Object)datasetId));
        if (!isIncludeNotLeaf) {
            builder.add(new QFilter("isleaf", "=", (Object)Character.valueOf('1')));
        }
        if ((dcs = QueryServiceHelper.query((String)"epm_accountmembertree", (String)"number", (QFilter[])builder.toArray())) != null && !dcs.isEmpty()) {
            for (DynamicObject dc : dcs) {
                memList.add(dc.getString("number"));
            }
        }
        return memList;
    }

    public static DynamicObject updateIcEntityParentIsLeaf(long parentId) {
        QFilter qfParent = new QFilter("parent", "=", (Object)parentId);
        QFilter qfEnable = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"epm_icmembertree", (String)"id", (QFilter[])new QFilter[]{qfParent, qfEnable});
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)parentId, (String)"epm_icmembertree");
        if (query.size() > 0) {
            object.set("isleaf", (Object)"0");
        } else {
            object.set("isleaf", (Object)"1");
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
        return object;
    }

    public static Long queryMemberRootId(long modelId, long dimensionId, String memberKey) {
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
        qfBuilder.add("dimension", "=", (Object)dimensionId);
        qfBuilder.add("level", "=", (Object)1);
        DynamicObject object = QueryServiceHelper.queryOne((String)memberKey, (String)"id", (QFilter[])qfBuilder.toArray());
        return object == null ? null : Long.valueOf(object.getLong("id"));
    }

    public static List<DynamicObject> queryChildren(String selectFields, long parentId, String entityNumber) {
        QFBuilder builder = new QFBuilder();
        builder.add("parent", "=", (Object)parentId);
        if (!"eb_viewmember".equals(entityNumber)) {
            builder.add("membersource", "!=", (Object)MemberSourceEnum.ANALYZE_VIEW.getIndex());
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)entityNumber, (String)selectFields, (QFilter[])builder.toArray());
        return new ArrayList<DynamicObject>((Collection<DynamicObject>)query);
    }

    public static Map<String, List<TreeNode>> queryShareMemberGroupByParentId(Long modelid, Long dmensionid, String selectFields) {
        QFBuilder qf = new QFBuilder("model", "=", (Object)modelid);
        qf.add("dimension", "=", (Object)dmensionid);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_dimsharemember", (String)selectFields, (QFilter[])qf.toArray());
        HashMap<String, TreeNode> map = new HashMap<String, TreeNode>(query.size());
        if (query.size() > 0) {
            String[] fields = (String[])((DynamicObject)query.get(0)).getDynamicObjectType().getProperties().stream().map(IMetadata::getName).toArray(String[]::new);
            for (DynamicObject object : query) {
                map.put(object.getString("id"), TreeNodeUtils.createTreeNodeByObject((DynamicObject)object, (String)object.getString("number"), (String[])fields));
            }
        }
        HashSet<String> ids = new HashSet<String>(16);
        for (Map.Entry entry : map.entrySet()) {
            TreeNode node = (TreeNode)entry.getValue();
            Long parentId = (Long)TreeNodeUtils.getNodeProperties((String)"parent", (TreeNode)node);
            TreeNode parent = (TreeNode)map.get(String.valueOf(parentId));
            if (parent == null) continue;
            ArrayList<TreeNode> children = parent.getChildren();
            if (children == null) {
                children = new ArrayList<TreeNode>(10);
                parent.setChildren(children);
            }
            children.add(node);
            ids.add(node.getId());
        }
        for (String id : ids) {
            map.remove(id);
        }
        return map.values().stream().collect(Collectors.groupingBy(TreeNode::getParentid));
    }

    public static void afterCreateDim(long modelId, long dimId, long memberId) {
        DynamicObject[] oo;
        QFilter fmodelid = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"eb_templateentity_bg", (String)"id", (QFilter[])new QFilter[]{fmodelid});
        ArrayList<Long> ids = new ArrayList<Long>();
        for (DynamicObject[] dd : dcs) {
            ids.add(dd.getLong("id"));
        }
        for (DynamicObject obj : oo = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_templateentity_bg"))) {
            DynamicObjectCollection dcss = obj.getDynamicObjectCollection("viewpointmembentry");
            DynamicObject item = new DynamicObject(dcss.getDynamicObjectType());
            item.set("viewdimension", (Object)dimId);
            item.set("viewmembid", (Object)memberId);
            item.set("seq", (Object)(dcss.size() + 1));
            dcss.add((Object)item);
        }
        SaveServiceHelper.save((DynamicObject[])oo);
        Object[] ids1 = (Long[])Arrays.stream(oo).map(o -> o.getLong("id")).toArray(Long[]::new);
        TemplateServiceHelper.removeTemplateModelCacheByIds((Object)modelId, (Object[])ids1);
    }

    public static List<DynamicObject> getUserDefineDimensionList(long modelId, boolean needSeq) {
        ArrayList<DynamicObject> userDefineDimList = new ArrayList<DynamicObject>(16);
        Collection dims = BusinessDataServiceHelper.loadFromCache((String)"epm_dimension", (String)"id,number,name", (QFilter[])new QFBuilder().add("model", "=", (Object)modelId).add("issysdimension", "=", (Object)false).toArray(), (String)"dseq").values();
        userDefineDimList.addAll(dims);
        return userDefineDimList;
    }

    public static <T> String buildRangeF7ShowStr(Dimension dimension, Iterable<T> memberInfoList, Function<T, Object> memberSupplier, Function<T, Object> rangeSupplier, Long viewId, IModelCacheHelper modelCacheHelper) {
        StringBuilder sb = new StringBuilder();
        if (dimension != null && memberInfoList != null && memberSupplier != null && rangeSupplier != null) {
            for (T member : memberInfoList) {
                if (member == null) continue;
                Object memberInfo = memberSupplier.apply(member);
                Object scopeVal = rangeSupplier.apply(member);
                boolean memberIsLong = memberInfo instanceof Long;
                boolean scopeIsStr = scopeVal instanceof String;
                RangeEnum rangeByVal = scopeIsStr ? RangeEnum.getRangeByVal((int)Integer.parseInt((String)scopeVal)) : RangeEnum.getRangeByVal((int)((Integer)scopeVal));
                Member _member = null;
                _member = memberIsLong ? modelCacheHelper.getMember(dimension.getNumber(), viewId, (Long)memberInfo) : modelCacheHelper.getMember(dimension.getNumber(), viewId, (String)memberInfo);
                if (_member == null) {
                    throw new KDBizException("member " + memberInfo + " not exist");
                }
                if (rangeByVal == RangeEnum.ONLY) {
                    sb.append(_member.getName()).append('\uff0c');
                    continue;
                }
                sb.append(ResManager.loadResFormat((String)"%1\u7684%2\uff0c%3", (String)"DimensionServiceHelper_3", (String)"epm-eb-business", (Object[])new Object[]{_member.getName(), rangeByVal.getName(), ""}));
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
        }
        return sb.toString();
    }

    public static Pair<String, String> parserPeriod2YP(String periodNumber) {
        Pair result = null;
        if (periodNumber != null && periodNumber.contains("M")) {
            String[] split = periodNumber.split("\\.");
            String yearNum = split[0].substring(2);
            String periodNum = split[1].substring(1);
            result = new Pair((Object)yearNum, (Object)periodNum);
        }
        return result;
    }
}

