/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.servicehelper;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.OlapDataWriter;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.olap.dataSources.ValuePair;
import kd.epm.eb.business.servicehelper.EbOlapServiceHelper;
import kd.epm.eb.common.model.BgData;
import kd.epm.eb.common.model.OlapData;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.StringUtils;

public class EbBatchSave {
    public static final Log log = LogFactory.getLog(EbBatchSave.class);
    public static final int OLAPDATA_SCALA = 10;
    private OlapConnection conn = null;
    private OlapDataWriter writer = null;
    private Object[] values = null;

    private OlapConnection getConn() {
        return this.conn;
    }

    private OlapDataWriter getWriter() {
        return this.writer;
    }

    public void open(String cubecatalog, SaveCommandInfo info) {
        if (StringUtils.isEmpty((String)cubecatalog)) {
            throw new KDBizException("cubecata is null.");
        }
        if (info == null) {
            throw new KDBizException("saveCommandInfo is null.");
        }
        LogStats stats = new LogStats("budget-shrek-log : ");
        stats.addInfo("begin-ebBatchSave-open");
        ShrekIdCodeUtils.setTraceInfo((CommandInfo)info, (Map)ShrekIdCodeUtils.getDefaultIdCodes((LogStats)stats));
        stats.addInfo("end-ebBatchSave-open");
        log.info(stats.toString());
        this.conn = EbOlapServiceHelper.getOlapConnection(cubecatalog);
        if (this.getConn() != null) {
            this.getConn().Open();
            OlapCommand cmd = new OlapCommand(this.getConn(), (CommandInfo)info);
            this.writer = cmd.CreateWriter();
            if (this.getWriter() == null) {
                throw new KDBizException("olap dataWriter is null.");
            }
        } else {
            throw new KDBizException("olap Connection is null.");
        }
    }

    public void add(List<String> dimensions, BgData data) {
        this.add(dimensions, data, null);
    }

    public void add(List<String> dimensions, BgData data, Object value) {
        BigDecimal bigDecimal;
        if (this.getConn() == null || this.getWriter() == null || data == null) {
            return;
        }
        if (value instanceof BigDecimal && (bigDecimal = (BigDecimal)value).scale() > 10) {
            value = bigDecimal.setScale(10, 4);
        }
        String dimNumber = null;
        if (this.values == null || this.values.length != dimensions.size() + 1) {
            this.values = new Object[dimensions.size() + 1];
            this.values[0] = new ValuePair(null, null);
        } else {
            this.clear(this.values);
        }
        if (this.values[0] instanceof ValuePair) {
            ValuePair _pair = (ValuePair)this.values[0];
            _pair.setCurrentValue(value != null ? value : data.getValue());
        }
        int jn = dimensions.size();
        for (int i = 0; i < jn; ++i) {
            dimNumber = dimensions.get(i);
            this.values[i + 1] = data.getMemberNumber(dimNumber);
        }
        this.writer.setValues(this.values);
    }

    public void add(String[] dimensions, OlapData data) {
        if (this.getConn() == null || this.getWriter() == null || dimensions == null || data == null) {
            return;
        }
        this.add(dimensions, data.getMemberNums(), data.getValue());
    }

    public void add(String[] dimensions, String[] dimNumbers, BigDecimal value) {
        if (this.getConn() == null || this.getWriter() == null || dimensions == null || dimNumbers == null) {
            return;
        }
        if (this.values == null || this.values.length != dimensions.length + 1) {
            this.values = new Object[dimensions.length + 1];
            this.values[0] = new ValuePair(null, null);
        } else {
            this.clear(this.values);
        }
        if (this.values[0] instanceof ValuePair) {
            ValuePair _pair = (ValuePair)this.values[0];
            _pair.setCurrentValue((Object)value);
        }
        System.arraycopy(dimNumbers, 0, this.values, 1, dimensions.length);
        this.writer.setValues(this.values);
    }

    protected void clear(Object[] values) {
        if (values == null || values.length == 0) {
            return;
        }
        if (values[0] instanceof ValuePair) {
            ValuePair _pair = (ValuePair)values[0];
            _pair.setInitValue(null);
            _pair.setCurrentValue(null);
        }
        int in = values.length;
        for (int i = 1; i < in; ++i) {
            values[i] = null;
        }
    }

    public void flush() {
        if (this.getWriter() != null) {
            this.getWriter().flush();
        }
    }

    public void close() {
        if (this.getConn() != null) {
            this.getConn().Close();
        }
    }
}

