/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.servicehelper;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.OlapDataReader;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.epm.eb.business.servicehelper.EbBatchSave;
import kd.epm.eb.common.olapdao.ConnectionManager;
import kd.epm.eb.common.shrek.util.ShrekOlapUtils;
import kd.epm.eb.common.utils.LogUtils;
import kd.epm.eb.common.utils.StringUtils;

public class EbOlapServiceHelper
implements Serializable {
    private static final LogUtils log = LogUtils.getInstance(EbOlapServiceHelper.class);
    public static final String OLAPDATASEPARATION = "!!";

    public static EbBatchSave getBatchSave() {
        return new EbBatchSave();
    }

    public static Map<String, Object> queryData(SelectCommandInfo queryInfo, String cubecatalog) {
        HashMap<String, Object> hashMap;
        HashMap<String, Object> cellSets = new HashMap<String, Object>(16);
        if (queryInfo == null || StringUtils.isEmpty((String)cubecatalog)) {
            return cellSets;
        }
        OlapConnection conn = null;
        OlapDataReader cs = null;
        try {
            conn = EbOlapServiceHelper.getOlapConnection(cubecatalog);
            conn.Open();
            queryInfo.setExcludeNull(true);
            OlapCommand cmd = new OlapCommand(conn, (CommandInfo)queryInfo);
            cs = cmd.ExecuteReader();
            List list = queryInfo.getMeasures();
            Object[] values = new Object[queryInfo.getDimensions().size() + list.size()];
            StringBuilder sb = new StringBuilder();
            while (cs.next()) {
                cs.getValues(values);
                if (values[0] == null) continue;
                int size = values.length;
                for (int i = list.size(); i < size; ++i) {
                    if (i == size - 1) {
                        sb.append(values[i].toString());
                        continue;
                    }
                    sb.append(values[i].toString()).append(OLAPDATASEPARATION);
                }
                cellSets.put(sb.toString(), values[0]);
                sb.setLength(0);
            }
            hashMap = cellSets;
        }
        catch (Exception ex) {
            try {
                log.error("budget-olap-log : ", "budget olap query error:", (Throwable)ex);
                throw new KDBizException(ResManager.loadResFormat((String)"olap\u67e5\u8be2\u5931\u8d25\uff1a%1", (String)"EbOlapServiceHelper_0", (String)"epm-eb-business", (Object[])new Object[]{ex.getMessage()}));
            }
            catch (Throwable throwable) {
                ShrekOlapUtils.close((Object[])new Object[]{cs});
                ShrekOlapUtils.close((Object[])new Object[]{conn});
                throw throwable;
            }
        }
        ShrekOlapUtils.close((Object[])new Object[]{cs});
        ShrekOlapUtils.close((Object[])new Object[]{conn});
        return hashMap;
    }

    public static Map<String, Object> queryDataReByConn(SelectCommandInfo queryInfo, String cubecatalog) {
        if (queryInfo == null || StringUtils.isEmpty((String)cubecatalog)) {
            return null;
        }
        OlapDataReader cs = null;
        OlapConnection conn = null;
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        try {
            conn = EbOlapServiceHelper.getOlapConnection(cubecatalog);
            conn.Open();
            queryInfo.setExcludeNull(true);
            OlapCommand cmd = new OlapCommand(conn, (CommandInfo)queryInfo);
            cs = cmd.ExecuteReader();
            map.put("cs", cs);
            map.put("conn", conn);
            return map;
        }
        catch (Exception ex) {
            log.error("budget-olap-log : ", "budget olap query error:", (Throwable)ex);
            throw new KDBizException(ResManager.loadResFormat((String)"olap\u67e5\u8be2\u5931\u8d25\uff1a%1", (String)"EbOlapServiceHelper_0", (String)"epm-eb-business", (Object[])new Object[]{ex.getMessage()}));
        }
    }

    public static OlapConnection getOlapConnection(String cube) {
        return ConnectionManager.getInstance().getConnection(cube, cube);
    }
}

