/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.servicehelper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.servicehelper.QueryTreenodeHelper;

public class SearchHelper {
    public static final String treeentryentity = "treeentryentity";
    private static int focusrow = 0;

    public static TreeMap<Integer, Long> getSearchItemId(String searchitem, DynamicObjectCollection memberColls, Map<Integer, Long> rowTreeMapAll) {
        TreeMap<Integer, Long> rowmap = new TreeMap<Integer, Long>();
        DynamicObject root = null;
        HashMap<Long, TreeMap<Integer, DynamicObject>> searchChild = new HashMap<Long, TreeMap<Integer, DynamicObject>>();
        if (memberColls != null && memberColls.size() > 0) {
            for (int i = 0; i < memberColls.size(); ++i) {
                DynamicObject memberObject = (DynamicObject)memberColls.get(i);
                long parent = memberObject.getLong("parent");
                int dseq = memberObject.getInt("dseq");
                if (parent == 0L) {
                    root = memberObject;
                    continue;
                }
                if (searchChild.containsKey(parent)) {
                    ((TreeMap)searchChild.get(parent)).put(dseq, memberObject);
                    continue;
                }
                TreeMap<Integer, DynamicObject> children = new TreeMap<Integer, DynamicObject>();
                children.put(dseq, memberObject);
                searchChild.put(parent, children);
            }
        }
        if (root != null && (root.getString("number").toLowerCase().contains(searchitem) || root.getString("name").toLowerCase().contains(searchitem))) {
            rowmap.put(0, root.getLong("id"));
        }
        if (root != null) {
            SearchHelper.expandNextLevel(0, root, searchChild, searchitem, rowmap, rowTreeMapAll);
        }
        return rowmap;
    }

    public static TreeMap<Integer, Long> getSearchItemId(String searchitem, DynamicObjectCollection memberColls, Map<Integer, Long> rowTreeMapAll, boolean hasBreakNode) {
        TreeMap<Integer, Long> rowmap = new TreeMap<Integer, Long>();
        DynamicObject root = null;
        HashMap<Long, TreeSet<DynamicObject>> searchChild = new HashMap<Long, TreeSet<DynamicObject>>(16);
        HashSet<Long> membIds = new HashSet<Long>(16);
        Long rootId = 0L;
        if (hasBreakNode) {
            for (DynamicObject memb : memberColls) {
                membIds.add(memb.getLong("id"));
                if (rootId != 0L || memb.getLong("parent") != 0L) continue;
                rootId = memb.getLong("id");
            }
        }
        if (memberColls != null && memberColls.size() > 0) {
            Comparator comparator = SearchHelper.getMembDseqComparator();
            for (int i = 0; i < memberColls.size(); ++i) {
                DynamicObject memberObject = (DynamicObject)memberColls.get(i);
                long parent = memberObject.getLong("parent");
                int dseq = memberObject.getInt("dseq");
                if (parent == 0L) {
                    root = memberObject;
                    continue;
                }
                if (hasBreakNode && !membIds.contains(parent)) {
                    parent = rootId;
                }
                if (searchChild.containsKey(parent)) {
                    ((TreeSet)searchChild.get(parent)).add(memberObject);
                    continue;
                }
                TreeSet<DynamicObject> children = new TreeSet<DynamicObject>(comparator);
                children.add(memberObject);
                searchChild.put(parent, children);
            }
        }
        if (root != null && (root.getString("number").toLowerCase().contains(searchitem) || root.getString("name").toLowerCase().contains(searchitem))) {
            rowmap.put(0, root.getLong("id"));
        }
        if (root != null) {
            SearchHelper.expand2NextLevel(0, root, searchChild, searchitem, rowmap, rowTreeMapAll);
        }
        return rowmap;
    }

    private static Comparator getMembDseqComparator() {
        Comparator<DynamicObject> comparator = new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                int dseq = o1.getInt("dseq") - o2.getInt("dseq");
                if (dseq == 0) {
                    Long id1 = o1.getLong("id");
                    Long id2 = o2.getLong("id");
                    return id1.compareTo(id2);
                }
                return dseq;
            }
        };
        return comparator;
    }

    private static int expandNextLevel(int row, DynamicObject parent, Map<Long, TreeMap<Integer, DynamicObject>> searchChild, String searchitem, Map<Integer, Long> rowmap, Map<Integer, Long> rowTreeMapAll) {
        if (searchChild.containsKey(parent.getLong("id"))) {
            TreeMap<Integer, DynamicObject> childrenMap = searchChild.get(parent.getLong("id"));
            Collection<DynamicObject> children = childrenMap.values();
            for (DynamicObject child : children) {
                rowTreeMapAll.put(++row, child.getLong("id"));
                if (child.getString("number").toLowerCase().contains(searchitem) || child.getString("name").toLowerCase().contains(searchitem)) {
                    rowmap.put(row, child.getLong("id"));
                }
                row = SearchHelper.expandNextLevel(row, child, searchChild, searchitem, rowmap, rowTreeMapAll);
            }
        }
        return row;
    }

    private static int expand2NextLevel(int row, DynamicObject parent, Map<Long, TreeSet<DynamicObject>> searchChild, String searchitem, Map<Integer, Long> rowmap, Map<Integer, Long> rowTreeMapAll) {
        if (searchChild.containsKey(parent.getLong("id"))) {
            TreeSet<DynamicObject> children = searchChild.get(parent.getLong("id"));
            for (DynamicObject child : children) {
                rowTreeMapAll.put(++row, child.getLong("id"));
                if (StringUtils.isNotEmpty((String)child.getString("number")) && child.getString("number").toLowerCase().contains(searchitem) || StringUtils.isNotEmpty((String)child.getString("name")) && child.getString("name").toLowerCase().contains(searchitem)) {
                    rowmap.put(row, child.getLong("id"));
                }
                row = SearchHelper.expand2NextLevel(row, child, searchChild, searchitem, rowmap, rowTreeMapAll);
            }
        }
        return row;
    }

    public static List<String> getOrgParentNodeList(Long modelid, Long dimensionid, String nodeid, String entityname) {
        List<Map<String, String>> treeList = QueryTreenodeHelper.getallnode(entityname, dimensionid, modelid);
        ArrayList<String> orgparent = new ArrayList<String>();
        orgparent.addAll(QueryTreenodeHelper.queryAllParentNodeList(nodeid, new ArrayList<String>(16), treeList));
        return orgparent;
    }

    public static int fillTreeEntryEntity(IDataModel model, DynamicObjectCollection memberColls, List<String> propertyList, String focusID, int parentRow, String parentId) {
        focusrow = 0;
        model.beginInit();
        model.batchInsertEntryRow(treeentryentity, parentRow, memberColls.size() - 1);
        model.endInit();
        DynamicObject root = null;
        HashMap<Long, TreeMap<Integer, DynamicObject>> searchChild = new HashMap<Long, TreeMap<Integer, DynamicObject>>();
        if (memberColls != null && memberColls.size() > 0) {
            for (int i = 0; i < memberColls.size(); ++i) {
                DynamicObject memberObject = (DynamicObject)memberColls.get(i);
                long parent = memberObject.getLong("parent");
                int dseq = memberObject.getInt("dseq");
                if (memberObject.getString("id").equals(parentId)) {
                    root = memberObject;
                    continue;
                }
                if (searchChild.containsKey(parent)) {
                    ((TreeMap)searchChild.get(parent)).put(dseq, memberObject);
                    continue;
                }
                TreeMap<Integer, DynamicObject> children = new TreeMap<Integer, DynamicObject>();
                children.put(dseq, memberObject);
                searchChild.put(parent, children);
            }
        }
        if (root == null) {
            return focusrow;
        }
        searchChild.remove(root.getLong("parent"));
        SearchHelper.expandNextLevel(model, propertyList, parentRow, root, searchChild, focusID);
        return focusrow;
    }

    public static Map<Long, TreeSet<DynamicObject>> fillParentMapChild(DynamicObjectCollection memberColls) {
        HashMap<Long, TreeSet<DynamicObject>> searchChild = new HashMap<Long, TreeSet<DynamicObject>>();
        if (memberColls != null && memberColls.size() > 0) {
            String parentKey = "parent";
            if (!(((DynamicObject)memberColls.get(memberColls.size() - 1)).get("parent") instanceof Long)) {
                parentKey = "parent.id";
            }
            Comparator comparator = SearchHelper.getMembDseqComparator();
            for (int i = 0; i < memberColls.size(); ++i) {
                DynamicObject memberObject = (DynamicObject)memberColls.get(i);
                long parent = memberObject.getLong(parentKey);
                int dseq = memberObject.getInt("dseq");
                if (searchChild.containsKey(parent)) {
                    ((TreeSet)searchChild.get(parent)).add(memberObject);
                    continue;
                }
                TreeSet<DynamicObject> children = new TreeSet<DynamicObject>(comparator);
                children.add(memberObject);
                searchChild.put(parent, children);
            }
        }
        return searchChild;
    }

    private static int expandNextLevel(IDataModel model, List<String> propertyList, int row, DynamicObject parent, Map<Long, TreeMap<Integer, DynamicObject>> searchChild, String focusID) {
        if (searchChild.containsKey(parent.getLong("id"))) {
            TreeMap<Integer, DynamicObject> childrenMap = searchChild.get(parent.getLong("id"));
            Collection<DynamicObject> children = childrenMap.values();
            for (DynamicObject child : children) {
                DynamicObject rowObj = model.getEntryRowEntity(treeentryentity, ++row);
                for (int k = 0; k < propertyList.size() - 1; ++k) {
                    String property = propertyList.get(k);
                    if ("showdproperty".equals(property)) {
                        StringBuilder sb = new StringBuilder();
                        for (int i = 1; i <= 10; ++i) {
                            String dpname = child.getString("dpname" + i);
                            String dppaname = child.getString("dppaname" + i);
                            if (!StringUtils.isNotEmpty((String)dpname) || !StringUtils.isNotEmpty((String)dppaname)) continue;
                            sb.append(dppaname).append(':').append(dpname).append(";");
                        }
                        rowObj.set(property, (Object)sb.toString());
                        continue;
                    }
                    if ("cycle".equals(property)) {
                        rowObj.set("daterangefield_startdate", child.get("daterangefield_startdate1"));
                        rowObj.set("daterangefield_enddate", child.get("daterangefield_enddate1"));
                        continue;
                    }
                    if ("drcrdirect1".equals(property)) {
                        rowObj.set(property, child.get("drcrdirect"));
                        continue;
                    }
                    rowObj.set(property, child.get(property));
                }
                if (!child.getBoolean("isleaf")) {
                    rowObj.set("isgroupnode", (Object)true);
                }
                rowObj.set("id", (Object)child.getLong("id"));
                rowObj.set("pid", (Object)parent.getLong("id"));
                if (focusID.equals(child.getString("id"))) {
                    focusrow = row;
                }
                row = SearchHelper.expandNextLevel(model, propertyList, row, child, searchChild, focusID);
            }
        }
        return row;
    }
}

