/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.sharecost;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kd.epm.eb.business.sharecost.DimOrMembObject;
import kd.epm.eb.business.sharecost.EntityRowObject;
import kd.epm.eb.business.sharecost.SchemeTab;
import kd.epm.eb.common.enums.SysDimensionEnum;

public class TabManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<SchemeTab> tabList = new ArrayList<SchemeTab>(16);

    public List<SchemeTab> getTabList() {
        return this.tabList;
    }

    public void setTabList(List<SchemeTab> tabList) {
        this.tabList = tabList;
    }

    public SchemeTab createNewTab() {
        int newTabNum = this.tabList.size() + 1;
        SchemeTab tab = new SchemeTab(String.valueOf(newTabNum));
        this.tabList.add(tab);
        return tab;
    }

    public SchemeTab getTabByKey(String tabKey) {
        SchemeTab SchemeTab2 = null;
        for (SchemeTab t : this.tabList) {
            if (!t.getTapKey().equals(tabKey)) continue;
            SchemeTab2 = t;
            break;
        }
        return SchemeTab2;
    }

    public boolean removeTabByKey(String tabKey) {
        boolean success = false;
        Iterator<SchemeTab> iterator = this.tabList.iterator();
        while (iterator.hasNext()) {
            SchemeTab tab = iterator.next();
            if (!tab.getTapKey().equals(tabKey)) continue;
            iterator.remove();
            success = true;
            break;
        }
        return success;
    }

    public void replaceSchemeTab(SchemeTab tab) {
        if (tab == null) {
            return;
        }
        int tabIndex = 0;
        for (SchemeTab t : this.tabList) {
            if (t.getTapKey().equals(tab.getTapKey())) break;
            ++tabIndex;
        }
        if (tabIndex == this.tabList.size()) {
            this.tabList.add(tab);
        } else {
            this.tabList.set(tabIndex, tab);
        }
    }

    public EntityRowObject getRowObject(String tabKey, int rowNum) {
        EntityRowObject rowObj = null;
        block0: for (SchemeTab tab : this.tabList) {
            String key = tab.getTapKey();
            if (!key.equals(tabKey)) continue;
            for (EntityRowObject row : tab.getRowObjects()) {
                if (row.getRowNum() != rowNum) continue;
                rowObj = row;
                break block0;
            }
        }
        return rowObj;
    }

    public void changeRowObjMemberNum2List() {
        this.tabList.forEach(tab -> tab.getRowObjects().forEach(row -> {
            ArrayList<String> AnumList = new ArrayList<String>(16);
            ArrayList<String> SnumList = new ArrayList<String>(16);
            HashMap<String, List<String>> ArangeMembNums = new HashMap<String, List<String>>(16);
            HashMap<String, List<String>> SrangeMembNums = new HashMap<String, List<String>>(16);
            row.getAcceptors().forEach(acceptor -> AnumList.add(acceptor.getNumber()));
            row.setAcceptorsNumList(AnumList);
            row.getSenders().forEach(sender -> SnumList.add(sender.getNumber()));
            row.setSendersNumList(SnumList);
            row.getSenderDimRange().forEach((dimNum, membs) -> {
                if (membs != null) {
                    ArrayList membNums = new ArrayList(16);
                    membs.forEach(membObj -> membNums.add(membObj.getNumber()));
                    SrangeMembNums.put((String)dimNum, membNums);
                }
            });
            row.setSenderDimRangeNums(SrangeMembNums);
            row.getAcceptorDimRange().forEach((dimNum, membs) -> {
                if (membs != null) {
                    ArrayList membNums = new ArrayList(16);
                    membs.forEach(membObj -> membNums.add(membObj.getNumber()));
                    ArangeMembNums.put((String)dimNum, membNums);
                }
            });
            row.setAcceptorDimRangeNums(ArangeMembNums);
        }));
    }

    public void changeRowObjNumList2Member() {
        this.tabList.forEach(tab -> tab.getRowObjects().forEach(row -> {
            List<DimOrMembObject> senderList = this.buildMembObjByNumber(row.getSendersNumList());
            List<DimOrMembObject> acceptorList = this.buildMembObjByNumber(row.getAcceptorsNumList());
            HashMap<String, List<DimOrMembObject>> ARangeDimMembs = new HashMap<String, List<DimOrMembObject>>(16);
            HashMap<String, List<DimOrMembObject>> SRangeDimMembs = new HashMap<String, List<DimOrMembObject>>(16);
            row.getSenderDimRangeNums().forEach((dimNum, membNums) -> {
                if (!dimNum.equals(SysDimensionEnum.Year.getNumber())) {
                    List<DimOrMembObject> membObjs = this.buildMembObjByNumber((List<String>)membNums);
                    SRangeDimMembs.put((String)dimNum, membObjs);
                }
            });
            row.getAcceptorDimRangeNums().forEach((dimNum, membNums) -> {
                if (!dimNum.equals(SysDimensionEnum.Year.getNumber())) {
                    List<DimOrMembObject> membObjs = this.buildMembObjByNumber((List<String>)membNums);
                    ARangeDimMembs.put((String)dimNum, membObjs);
                }
            });
            row.setAcceptors(acceptorList);
            row.setSenders(senderList);
            row.setAcceptorDimRange(ARangeDimMembs);
            row.setSenderDimRange(SRangeDimMembs);
            row.setAcceptorsNumList(null);
            row.setSendersNumList(null);
            row.setSenderDimRangeNums(null);
            row.setAcceptorDimRangeNums(null);
        }));
    }

    public List<DimOrMembObject> buildMembObjByNumber(List<String> membNums) {
        ArrayList<DimOrMembObject> membObjs = new ArrayList<DimOrMembObject>(16);
        if (membNums != null) {
            membNums.forEach(membNum -> {
                DimOrMembObject member = new DimOrMembObject();
                member.setNumber((String)membNum);
                membObjs.add(member);
            });
        }
        return membObjs;
    }

    public void clearRowObjNumList() {
        this.tabList.forEach(tab -> tab.getRowObjects().forEach(row -> {
            row.setAcceptorsNumList(null);
            row.setSendersNumList(null);
            row.setAcceptorDimRangeNums(null);
            row.setSenderDimRangeNums(null);
        }));
    }
}

