/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.target.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.decompose.service.DataDecomposeService;
import kd.epm.eb.business.decompose.service.DecomposeTaskService;
import kd.epm.eb.business.target.entity.TargetSchemeDimMapper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.decompose.DecDimensionUtil;
import kd.epm.eb.common.decompose.DynamicObjectUtil;
import kd.epm.eb.common.decompose.TaskStatus;
import kd.epm.eb.common.decompose.entity.BgNumberCell;
import kd.epm.eb.common.decompose.entity.DecomposeSchemeStatus;
import kd.epm.eb.common.decompose.entity.TaskFirstFlag;
import kd.epm.eb.common.enums.DataTypeEnum;
import kd.epm.eb.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.shrek.controller.ShrekOlapReader;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.adjustdecompose.AdjustServiceHelper;
import kd.epm.eb.olap.api.base.IKDValue;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.impl.metadata.KDCell;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class TargetSchemeService {
    private static final Log log = LogFactory.getLog(TargetSchemeService.class);
    private static final String FIELD_STATUS = "status";

    public static TargetSchemeService getInstance() {
        return InnerClass.instance;
    }

    private TargetSchemeService() {
    }

    private static String getDecomposeSchemeCn() {
        return ResManager.loadKDString((String)"\u76ee\u6807\u5206\u89e3\u65b9\u6848", (String)"TargetSchemeService_1", (String)"epm-eb-business", (Object[])new Object[0]);
    }

    private static String getSomeAndTarMapperMemberDesc(String scrMember) {
        return ResManager.loadResFormat((String)"\u627f\u63a5\u65b9\u6b64\u7f16\u7801\u7684\u7ef4\u5ea6\u6210\u5458\u5df2\u88ab\u76ee\u6807\u65b9%1\u6620\u5c04\u5360\u7528", (String)"TargetSchemeService_5", (String)"epm-eb-business", (Object[])new Object[]{scrMember});
    }

    private static String getSomeAndSrcMapperMemberDesc(String memberNumbers) {
        return ResManager.loadResFormat((String)"\u8be5\u7ef4\u5ea6\u6210\u5458\u5df2\u88ab\u6620\u5c04\u5230\u627f\u63a5\u65b9%1\uff0c\u4e14\u627f\u63a5\u65b9\u5b58\u5728\u6b64\u7f16\u7801\u7684\u7ef4\u5ea6\u6210\u5458", (String)"TargetSchemeService_2", (String)"epm-eb-business", (Object[])new Object[]{memberNumbers});
    }

    private static String getNoneDimMapperDesc() {
        return ResManager.loadKDString((String)"\u6ca1\u6709\u5339\u914d\u5230\u5bf9\u5e94\u7684\u7ef4\u5ea6\u627f\u63a5\u6210\u5458", (String)"TargetSchemeService_4", (String)"epm-eb-business", (Object[])new Object[0]);
    }

    public List<IKDCell> getSrcOlap(Long id) {
        ArrayList<IKDCell> cells = new ArrayList<IKDCell>(16);
        DynamicObject targetSchemeRecord = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bgm_targetschemerecord");
        DynamicObject targetScheme = targetSchemeRecord.getDynamicObject("targetscheme");
        DynamicObject srcModel = targetScheme.getDynamicObject("model");
        long srcModelId = srcModel.getLong("id");
        IModelCacheHelper srcModelCache = ModelCacheContext.getOrCreate((Long)srcModelId);
        DynamicObject srcBizModel = targetScheme.getDynamicObject("bizmodel");
        long srcDatasetId = srcBizModel.getLong("id");
        Map<String, List<String>> dimMemberMap = this.getMappingMapByTargetScheme(targetScheme, srcModel, srcModelId, srcModelCache, srcDatasetId, true);
        String srcEntity = targetSchemeRecord.getString("entity");
        List entityMembers = Arrays.stream(srcEntity.split(",")).collect(Collectors.toList());
        String entityDimNumber = SysDimensionEnum.Entity.getNumber();
        dimMemberMap.put(entityDimNumber, entityMembers);
        SelectCommandInfo queryInfo = new SelectCommandInfo();
        dimMemberMap.forEach((dimNumber, members) -> {
            String[] memberArray = members.toArray(new String[0]);
            queryInfo.addFilter(dimNumber, memberArray);
        });
        queryInfo.setDimensions(Arrays.asList(srcModelCache.getDimensionNums(Long.valueOf(srcDatasetId))));
        queryInfo.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        Dataset dataSet = DatasetServiceHelper.getInstance().getDataSet(Long.valueOf(srcDatasetId));
        try (ShrekOlapReader reader = ShrekOlapServiceHelper.queryReader((Model)srcModelCache.getModelobj(), (Dataset)dataSet, (SelectCommandInfo)queryInfo, (LogStats)new LogStats("portionToDetailFromEntityInput"));){
            while (reader.hasNext()) {
                IKDValue val;
                IKDCell cell = KDCell.of((Object[])reader.next());
                if (cell == null || (val = cell.getValue()) == null) continue;
                cells.add(cell);
            }
        }
        return cells;
    }

    public Map<String, List<String>> getMappingMapByTargetScheme(DynamicObject targetScheme, DynamicObject srcModel, long srcModelId, IModelCacheHelper srcModelCache, long srcDatasetId, boolean needLeaf) {
        HashMap<String, List<String>> dimMemberMap = new HashMap<String, List<String>>(16);
        DynamicObject srcBussModel = targetScheme.getDynamicObject("bizctrl");
        long srcBizId = srcBussModel.getLong("id");
        DynamicObject srcDataType = targetScheme.getDynamicObject("datatype");
        ArrayList<String> dataTypeMembers = new ArrayList<String>(16);
        dataTypeMembers.add(srcDataType.getString("number"));
        dimMemberMap.put(SysDimensionEnum.DataType.getNumber(), dataTypeMembers);
        DynamicObject srcVersion = targetScheme.getDynamicObject("version");
        ArrayList<String> versionMembers = new ArrayList<String>(16);
        versionMembers.add(srcVersion.getString("number"));
        dimMemberMap.put(SysDimensionEnum.Version.getNumber(), versionMembers);
        DynamicObject srcAuditTrail = targetScheme.getDynamicObject("audittrail");
        ArrayList<String> auditTrailMembers = new ArrayList<String>(16);
        auditTrailMembers.add(srcAuditTrail.getString("number"));
        dimMemberMap.put(SysDimensionEnum.AuditTrail.getNumber(), auditTrailMembers);
        String srcChangeType = targetScheme.getString("changetype");
        List srcChangeTypeList = Arrays.stream(srcChangeType.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        String changeTypeDimNumber = SysDimensionEnum.ChangeType.getNumber();
        List changeTypeMembers = srcChangeTypeList.stream().map(e -> {
            Member member = srcModelCache.getMember(changeTypeDimNumber, null, e);
            return member.getNumber();
        }).collect(Collectors.toList());
        dimMemberMap.put(changeTypeDimNumber, changeTypeMembers);
        DynamicObject srcCurrency = targetScheme.getDynamicObject("currency");
        ArrayList<String> currencyMembers = new ArrayList<String>(16);
        currencyMembers.add(srcCurrency.getString("number"));
        dimMemberMap.put(SysDimensionEnum.Currency.getNumber(), currencyMembers);
        String srcBudgetPeriod = targetScheme.getString("budgetperiod");
        List srcBudgetPeriodList = Arrays.stream(srcBudgetPeriod.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        String budgetPeriodDimNumber = SysDimensionEnum.BudgetPeriod.getNumber();
        List budgetPeriodMembers = srcBudgetPeriodList.stream().map(e -> {
            Member member = srcModelCache.getMember(budgetPeriodDimNumber, null, e);
            return member.getNumber();
        }).collect(Collectors.toList());
        dimMemberMap.put(budgetPeriodDimNumber, budgetPeriodMembers);
        this.dealAccountDimMember(targetScheme, srcModelCache, srcDatasetId, dimMemberMap);
        List dimensionList = srcModelCache.getDimensionList(Long.valueOf(srcDatasetId));
        String modelNumber = srcModel.getString("shownumber");
        this.dealOtherDimMember(srcModelId, srcBizId, dimMemberMap, dimensionList, modelNumber, needLeaf);
        return dimMemberMap;
    }

    private void dealAccountDimMember(DynamicObject targetScheme, IModelCacheHelper srcModelCache, long srcDatasetId, Map<String, List<String>> dimMemberMap) {
        String accountDimNumber = SysDimensionEnum.Account.getNumber();
        String srcAccount = targetScheme.getString("account");
        if (StringUtils.isBlank((CharSequence)srcAccount)) {
            Dimension dimension = srcModelCache.getDimension(accountDimNumber);
            List members = dimension.getAllMembersByDataSetId(Long.valueOf(srcDatasetId));
            List accountMembers = members.stream().filter(Member::isLeaf).map(BaseCache::getNumber).collect(Collectors.toList());
            dimMemberMap.put(accountDimNumber, accountMembers);
        } else {
            List srcAccountList = Arrays.stream(srcAccount.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            List accountMembers = srcAccountList.stream().map(e -> {
                Member member = srcModelCache.getMember(accountDimNumber, null, e);
                return member.getNumber();
            }).collect(Collectors.toList());
            dimMemberMap.put(accountDimNumber, accountMembers);
        }
    }

    private void dealOtherDimMember(long srcModelId, long srcBizId, Map<String, List<String>> dimMemberMap, List<Dimension> dimensionList, String modelNumber, boolean needLeaf) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)srcModelId);
        if (CollectionUtils.isNotEmpty(dimensionList)) {
            for (Dimension dimension : dimensionList) {
                String dimNumber = dimension.getNumber();
                if (dimMemberMap.containsKey(dimNumber)) continue;
                List<Object> leafMembers = new ArrayList<String>(16);
                Long viewId = BusinessModelServiceHelper.getInstance().getViewId(Long.valueOf(srcBizId), dimNumber, Long.valueOf(srcModelId));
                List members = dimension.getAllMembers(viewId);
                members = members.stream().sorted(Comparator.comparing(BaseCache::getSeq)).collect(Collectors.toList());
                if (SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
                    for (Member member : members) {
                        DataTypeEnum typeEnum = DataTypeEnum.getDataTypeEnumByIndex((String)member.getDatatype());
                        if (DataTypeEnum.DATETP == typeEnum || DataTypeEnum.TXT == typeEnum || !member.isLeaf()) continue;
                        leafMembers.add(member.getNumber());
                    }
                } else {
                    if (needLeaf) {
                        leafMembers = members.stream().filter(Member::isLeaf).map(BaseCache::getNumber).collect(Collectors.toList());
                    }
                    if (!dimension.isPreset()) {
                        Member rootMember = modelCacheHelper.getRootMember(dimNumber, viewId);
                        leafMembers.add(rootMember.getNumber());
                    } else if (SysDimensionEnum.InternalCompany.getNumber().equals(dimNumber)) {
                        leafMembers.add("ICTotal");
                    }
                }
                dimMemberMap.put(dimNumber, leafMembers);
            }
        }
    }

    public List<TargetSchemeDimMapper> checkDimMapper(List<IKDCell> datas, long srcModelId, long srcBizModelId, long srcBizCtrl, long tarBizCtrl) {
        ArrayList<TargetSchemeDimMapper> result = new ArrayList<TargetSchemeDimMapper>(16);
        IModelCacheHelper srcModelCache = ModelCacheContext.getOrCreate((Long)srcModelId);
        List srcDimensions = srcModelCache.getDimensionList(Long.valueOf(srcBizModelId));
        Map srcViewIds = srcModelCache.getViewsByBusModel(Long.valueOf(srcBizCtrl));
        List srcDimNumbers = srcDimensions.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        DynamicObjectCollection dimMapper = this.getDimMapper(srcModelId, srcBizCtrl, tarBizCtrl);
        Map<String, List<DynamicObject>> dimMapperMap = dimMapper.stream().collect(Collectors.groupingBy(e -> e.getString("select_dimension")));
        Map<String, List<DynamicObject>> srcMemberMapperMap = dimMapper.stream().collect(Collectors.groupingBy(e -> e.getString("entryentity.scrmember")));
        Map<String, DynamicObject> tarMemberMapperMap = dimMapper.stream().collect(Collectors.toMap(e -> e.getString("entryentity.tarmember"), e -> e, (v1, v2) -> v1));
        if (CollectionUtils.isNotEmpty(datas)) {
            for (IKDCell cell : datas) {
                boolean leafFlag;
                List tarDimNumbers;
                String[] number = cell.getMeta().getNumber();
                HashMap<String, String> srcMemberMap = new HashMap<String, String>(16);
                for (int i = 0; i < srcDimensions.size(); ++i) {
                    Dimension srcDim = (Dimension)srcDimensions.get(i);
                    String srcDimNumber = srcDim.getNumber();
                    String srcMemberNumber = number[i];
                    srcMemberMap.put(srcDimNumber, srcMemberNumber);
                }
                String accountDimNumber = SysDimensionEnum.Account.getNumber();
                Dimension account = srcModelCache.getDimension(accountDimNumber);
                String srcAccountMemberNumber = (String)srcMemberMap.get(accountDimNumber);
                Member scrMember = srcModelCache.getMember(accountDimNumber, null, srcAccountMemberNumber);
                List<DynamicObject> accountMapper = dimMapperMap.get(accountDimNumber);
                Long tarDatasetId = 0L;
                String subDimNumber = "";
                if (CollectionUtils.isNotEmpty(accountMapper)) {
                    List srcAccountMappers = accountMapper.stream().map(e -> e.getString("entryentity.scrmember")).collect(Collectors.toList());
                    if (!srcAccountMappers.contains(srcAccountMemberNumber)) {
                        boolean leafFlag2;
                        TargetSchemeDimMapper targetSchemeDimMapper = new TargetSchemeDimMapper(accountDimNumber, account.getName(), srcAccountMemberNumber, scrMember.getName(), TargetSchemeService.getNoneDimMapperDesc());
                        result.add(targetSchemeDimMapper);
                        tarDimNumbers = srcModelCache.getDimensionListByBusModel(Long.valueOf(tarBizCtrl)).stream().map(BaseCache::getNumber).collect(Collectors.toList());
                        List intersection = srcDimNumbers.stream().filter(tarDimNumbers::contains).collect(Collectors.toList());
                        if (CollectionUtils.isNotEmpty((Collection)intersection) && BooleanUtils.isFalse((Boolean)(leafFlag2 = this.checkDimLeafExist(srcModelCache, intersection, srcMemberMap, srcViewIds, srcMemberMapperMap)))) continue;
                        this.checkOtherDimMemberMapping(srcBizCtrl, tarBizCtrl, result, srcModelCache, dimMapperMap, srcMemberMap, subDimNumber, intersection, tarMemberMapperMap, srcMemberMapperMap);
                        continue;
                    }
                    List<DynamicObject> srcAccountMemberMappers = srcMemberMapperMap.get(srcAccountMemberNumber);
                    if (!CollectionUtils.isNotEmpty(srcAccountMemberMappers)) continue;
                    for (DynamicObject dynamicObject : srcAccountMemberMappers) {
                        boolean leafFlag3;
                        String tarMemberNumber = dynamicObject.getString("entryentity.tarmember");
                        subDimNumber = dynamicObject.getString("entryentity.subdimension");
                        tarDatasetId = srcModelCache.getMember(accountDimNumber, null, tarMemberNumber).getDatasetId();
                        tarDimNumbers = tarDatasetId != null && tarDatasetId != 0L ? srcModelCache.getDimensionList(tarDatasetId).stream().map(BaseCache::getNumber).collect(Collectors.toList()) : srcModelCache.getDimensionListByBusModel(Long.valueOf(tarBizCtrl)).stream().map(BaseCache::getNumber).collect(Collectors.toList());
                        List<String> intersection = srcDimNumbers.stream().filter(tarDimNumbers::contains).collect(Collectors.toList());
                        if (CollectionUtils.isNotEmpty(intersection) && BooleanUtils.isFalse((Boolean)(leafFlag3 = this.checkDimLeafExist(srcModelCache, intersection, srcMemberMap, srcViewIds, srcMemberMapperMap)))) continue;
                        this.checkOtherDimMemberMapping(srcBizCtrl, tarBizCtrl, result, srcModelCache, dimMapperMap, srcMemberMap, subDimNumber, intersection, tarMemberMapperMap, srcMemberMapperMap);
                    }
                    continue;
                }
                TargetSchemeDimMapper targetSchemeDimMapper = new TargetSchemeDimMapper(accountDimNumber, account.getName(), srcAccountMemberNumber, scrMember.getName(), TargetSchemeService.getNoneDimMapperDesc());
                result.add(targetSchemeDimMapper);
                tarDimNumbers = srcModelCache.getDimensionListByBusModel(Long.valueOf(tarBizCtrl)).stream().map(BaseCache::getNumber).collect(Collectors.toList());
                List<String> intersection = srcDimNumbers.stream().filter(tarDimNumbers::contains).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(intersection) && BooleanUtils.isFalse((Boolean)(leafFlag = this.checkDimLeafExist(srcModelCache, intersection, srcMemberMap, srcViewIds, srcMemberMapperMap)))) continue;
                this.checkOtherDimMemberMapping(srcBizCtrl, tarBizCtrl, result, srcModelCache, dimMapperMap, srcMemberMap, subDimNumber, intersection, tarMemberMapperMap, srcMemberMapperMap);
            }
        }
        return result;
    }

    private void checkOtherDimMemberMapping(long srcBizCtrl, long tarBizCtrl, List<TargetSchemeDimMapper> result, IModelCacheHelper srcModelCache, Map<String, List<DynamicObject>> dimMapperMap, Map<String, String> srcMemberMap, String subDimNumber, List<String> intersection, Map<String, DynamicObject> tarMemberMapperMap, Map<String, List<DynamicObject>> srcMemberMapperMap) {
        srcMemberMap.forEach((dimNumber, memberNumber) -> {
            if (!SysDimensionEnum.Account.getNumber().equals(dimNumber) && !subDimNumber.equals(dimNumber) && intersection.contains(dimNumber)) {
                List mapperList = (List)dimMapperMap.get(dimNumber);
                Long srcViewId = srcModelCache.getViewByBusModelAndDimNumber(Long.valueOf(srcBizCtrl), dimNumber);
                Long targViewId = srcModelCache.getViewByBusModelAndDimNumber(Long.valueOf(tarBizCtrl), dimNumber);
                Member tarMember = srcModelCache.getMember(dimNumber, targViewId, memberNumber);
                if (tarMember == null) {
                    tarMember = srcModelCache.getMemberByAnyView(Long.valueOf(tarBizCtrl), dimNumber, memberNumber);
                }
                Dimension dimension = srcModelCache.getDimension(dimNumber);
                Member member = srcModelCache.getMember(dimNumber, srcViewId, memberNumber);
                if (member == null) {
                    member = srcModelCache.getMemberByAnyView(Long.valueOf(srcBizCtrl), dimNumber, memberNumber);
                }
                if (CollectionUtils.isNotEmpty((Collection)mapperList)) {
                    List dimMappers = mapperList.stream().map(e -> e.getString("entryentity.scrmember")).collect(Collectors.toList());
                    if (dimMappers.contains(memberNumber)) {
                        if (tarMember != null) {
                            List dynamicObjects = (List)srcMemberMapperMap.get(memberNumber);
                            List tarMembers = dynamicObjects.stream().map(e -> e.getString("entryentity.tarmember")).collect(Collectors.toList());
                            TargetSchemeDimMapper targetSchemeDimMapper = new TargetSchemeDimMapper((String)dimNumber, dimension.getName(), (String)memberNumber, member.getName(), TargetSchemeService.getSomeAndSrcMapperMemberDesc(StringUtils.join(tarMembers, (String)",")));
                            result.add(targetSchemeDimMapper);
                        }
                    } else {
                        this.checkOtherDimWithOutDimMapping(result, tarMemberMapperMap, (String)dimNumber, (String)memberNumber, tarMember, dimension, member);
                    }
                } else {
                    this.checkOtherDimWithOutDimMapping(result, tarMemberMapperMap, (String)dimNumber, (String)memberNumber, tarMember, dimension, member);
                }
            }
        });
    }

    private void checkOtherDimWithOutDimMapping(List<TargetSchemeDimMapper> result, Map<String, DynamicObject> tarMemberMapperMap, String dimNumber, String memberNumber, Member tarMember, Dimension dimension, Member member) {
        if (tarMember == null) {
            TargetSchemeDimMapper targetSchemeDimMapper = new TargetSchemeDimMapper(dimNumber, dimension.getName(), memberNumber, member.getName(), TargetSchemeService.getNoneDimMapperDesc());
            result.add(targetSchemeDimMapper);
        } else if (tarMemberMapperMap.containsKey(tarMember.getNumber())) {
            DynamicObject dynamicObject = tarMemberMapperMap.get(tarMember.getNumber());
            String scrMember = dynamicObject.getString("entryentity.scrmember");
            TargetSchemeDimMapper targetSchemeDimMapper = new TargetSchemeDimMapper(dimNumber, dimension.getName(), memberNumber, member.getName(), TargetSchemeService.getSomeAndTarMapperMemberDesc(scrMember));
            result.add(targetSchemeDimMapper);
        }
    }

    public void executeTargetSchemeToDecompose(long id, List<IKDCell> datas, long srcModelId, long srcBizModelId, long srcBizCtrl, long tarBizCtrl, String schemeStatus) {
        DynamicObject targetSchemeRecord = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bgm_targetschemerecord");
        DynamicObject tarDatatype = targetSchemeRecord.getDynamicObject("datatype");
        DynamicObject tarVersion = targetSchemeRecord.getDynamicObject("version");
        DynamicObject tarAuditTrail = targetSchemeRecord.getDynamicObject("audittrail");
        IModelCacheHelper srcModelCache = ModelCacheContext.getOrCreate((Long)srcModelId);
        List srcDimensions = srcModelCache.getDimensionList(Long.valueOf(srcBizModelId));
        Map srcViewIds = srcModelCache.getViewsByBusModel(Long.valueOf(srcBizModelId));
        DynamicObjectCollection dimMapper = this.getDimMapper(srcModelId, srcBizCtrl, tarBizCtrl);
        Map<String, List<DynamicObject>> dimMapperMap = dimMapper.stream().collect(Collectors.groupingBy(e -> e.getString("select_dimension")));
        Map<String, List<DynamicObject>> srcMemberMapperMap = dimMapper.stream().collect(Collectors.groupingBy(e -> e.getString("entryentity.scrmember")));
        if (CollectionUtils.isNotEmpty(datas)) {
            HashMap metricMemberHasAggMap = new HashMap(16);
            List metricMembers = srcModelCache.getMembers(null, SysDimensionEnum.Metric.getNumber());
            if (CollectionUtils.isNotEmpty((Collection)metricMembers)) {
                metricMembers.forEach(e -> metricMemberHasAggMap.put(e.getNumber(), e.hasAgg()));
            }
            ArrayList<BgNumberCell> bgNumberCells = new ArrayList<BgNumberCell>(16);
            DynamicObject scheme = this.saveTargetDecomposeScheme(id, schemeStatus);
            DynamicObjectCollection saveDatas = new DynamicObjectCollection();
            ArrayList<Long> doneTaskIdList = new ArrayList<Long>(16);
            for (IKDCell cell : datas) {
                HashMap<Object, String> tarDimMemberMapperMap = new HashMap<Object, String>(16);
                String[] number = cell.getMeta().getNumber();
                HashMap<String, String> srcMemberMap = new HashMap<String, String>(16);
                for (int i = 0; i < srcDimensions.size(); ++i) {
                    Dimension srcDim = (Dimension)srcDimensions.get(i);
                    String srcDimNumber = srcDim.getNumber();
                    String srcMemberNumber = number[i];
                    srcMemberMap.put(srcDimNumber, srcMemberNumber);
                }
                String accountDimNumber = SysDimensionEnum.Account.getNumber();
                String srcAccountMemberNumber = (String)srcMemberMap.get(accountDimNumber);
                String srcMetricMemberNumber = (String)srcMemberMap.get(SysDimensionEnum.Metric.getNumber());
                boolean metricMemberHasAgg = metricMemberHasAggMap.get(srcMetricMemberNumber) != null ? (Boolean)metricMemberHasAggMap.get(srcMetricMemberNumber) : true;
                List<DynamicObject> accountMappers = dimMapperMap.get(accountDimNumber);
                List srcAccountMappers = accountMappers.stream().map(e -> e.getString("entryentity.scrmember")).collect(Collectors.toList());
                if (srcAccountMappers.contains(srcAccountMemberNumber)) {
                    List<DynamicObject> accountMemberMappers = srcMemberMapperMap.get(srcAccountMemberNumber);
                    for (DynamicObject accountMapper : accountMemberMappers) {
                        boolean leafFlag;
                        boolean dimRootFlag;
                        String accountTarMemberNumber = accountMapper.getString("entryentity.tarmember");
                        tarDimMemberMapperMap.put(accountDimNumber, accountTarMemberNumber);
                        String subDimNumber = accountMapper.getString("entryentity.subdimension");
                        String subMemberNumber = accountMapper.getString("entryentity.submember");
                        if (StringUtils.isNotBlank((CharSequence)subDimNumber) && StringUtils.isNotBlank((CharSequence)subMemberNumber)) {
                            tarDimMemberMapperMap.put(subDimNumber, subMemberNumber);
                        }
                        Long tarDatasetId = srcModelCache.getMember(accountDimNumber, null, accountTarMemberNumber).getDatasetId();
                        List tarDimNumbers = srcModelCache.getDimensionList(tarDatasetId).stream().map(BaseCache::getNumber).collect(Collectors.toList());
                        List<String> srcDimNumbers = srcDimensions.stream().map(BaseCache::getNumber).collect(Collectors.toList());
                        List<String> intersection = srcDimNumbers.stream().filter(tarDimNumbers::contains).collect(Collectors.toList());
                        srcDimNumbers.removeAll(intersection);
                        tarDimNumbers.removeAll(intersection);
                        String finalSubDimNumber = subDimNumber;
                        if (CollectionUtils.isNotEmpty(srcDimNumbers) && metricMemberHasAgg && BooleanUtils.isFalse((Boolean)(dimRootFlag = this.checkDimRootAllExist(srcModelCache, srcDimNumbers, srcViewIds, srcMemberMap))) || CollectionUtils.isNotEmpty(intersection) && BooleanUtils.isFalse((Boolean)(leafFlag = this.checkDimLeafExist(srcModelCache, intersection, srcMemberMap, srcViewIds, srcMemberMapperMap)))) continue;
                        List tarMemberList = new ArrayList(16);
                        ArrayList<String> carDimNumbers = new ArrayList<String>(16);
                        for (Map.Entry entry : srcMemberMap.entrySet()) {
                            String dimNumber = (String)entry.getKey();
                            String memberNumber = (String)entry.getValue();
                            if (SysDimensionEnum.Account.getNumber().equals(dimNumber) || finalSubDimNumber.equals(dimNumber)) continue;
                            Long viewId = srcModelCache.getViewByBusModelAndDimNumber(Long.valueOf(tarBizCtrl), dimNumber);
                            if (SysDimensionEnum.DataType.getNumber().equals(dimNumber)) {
                                tarDimMemberMapperMap.put(dimNumber, tarDatatype.getString("number"));
                                continue;
                            }
                            if (SysDimensionEnum.Version.getNumber().equals(dimNumber)) {
                                tarDimMemberMapperMap.put(dimNumber, tarVersion.getString("number"));
                                continue;
                            }
                            if (SysDimensionEnum.AuditTrail.getNumber().equals(dimNumber)) {
                                tarDimMemberMapperMap.put(dimNumber, tarAuditTrail.getString("number"));
                                continue;
                            }
                            if (!CollectionUtils.isNotEmpty(intersection) || !intersection.contains(dimNumber)) continue;
                            carDimNumbers.add(dimNumber);
                            String string = "";
                            List<DynamicObject> mapperList = dimMapperMap.get(dimNumber);
                            if (CollectionUtils.isNotEmpty(mapperList)) {
                                List dimMappers = mapperList.stream().map(e -> e.getString("entryentity.scrmember")).collect(Collectors.toList());
                                if (dimMappers.contains(memberNumber)) {
                                    List tarMembers = srcMemberMapperMap.get(memberNumber).stream().map(e -> e.getString("entryentity.tarmember")).collect(Collectors.toList());
                                    tarMemberList.add(tarMembers);
                                    continue;
                                }
                                Member tarMember = srcModelCache.getMember(dimNumber, viewId, memberNumber);
                                if (tarMember == null) {
                                    tarMember = srcModelCache.getMemberByAnyView(Long.valueOf(tarBizCtrl), dimNumber, memberNumber);
                                }
                                if (tarMember == null) continue;
                                String string2 = tarMember.getNumber();
                                tarMemberList.add(Lists.newArrayList((Object[])new String[]{string2}));
                                continue;
                            }
                            Member tarMember = srcModelCache.getMember(dimNumber, viewId, memberNumber);
                            if (tarMember == null) {
                                tarMember = srcModelCache.getMemberByAnyView(Long.valueOf(tarBizCtrl), dimNumber, memberNumber);
                            }
                            if (tarMember == null) continue;
                            String string3 = tarMember.getNumber();
                            tarMemberList.add(Lists.newArrayList((Object[])new String[]{string3}));
                        }
                        if (CollectionUtils.isNotEmpty(tarDimNumbers)) {
                            for (String tarDimNumber : tarDimNumbers) {
                                if (tarDimNumber.equals(finalSubDimNumber)) continue;
                                Dimension dimension = srcModelCache.getDimension(tarDimNumber);
                                tarDimMemberMapperMap.put(tarDimNumber, dimension.getNoneNumber());
                            }
                        }
                        tarMemberList = Lists.cartesianProduct(tarMemberList);
                        for (int i = 0; i < tarMemberList.size(); ++i) {
                            List tarCarMember = (List)tarMemberList.get(i);
                            DynamicObject task = BusinessDataServiceHelper.newDynamicObject((String)"eb_decompose_task");
                            for (int j = 0; j < carDimNumbers.size(); ++j) {
                                String dimNumber = (String)carDimNumbers.get(j);
                                String string = (String)tarCarMember.get(j);
                                tarDimMemberMapperMap.put(dimNumber, string);
                                if (!SysDimensionEnum.Entity.getNumber().equals(dimNumber)) continue;
                                Long viewId = srcModelCache.getViewByBusModelAndDimNumber(Long.valueOf(tarBizCtrl), dimNumber);
                                Member member = srcModelCache.getMember(dimNumber, viewId, string);
                                if (member == null) {
                                    member = srcModelCache.getMemberByAnyView(Long.valueOf(tarBizCtrl), dimNumber, string);
                                }
                                task.set("entity", (Object)member.getId());
                            }
                            boolean someRootFlag = false;
                            for (Map.Entry entry : tarDimMemberMapperMap.entrySet()) {
                                String dimNumber = (String)entry.getKey();
                                Dimension dimension = srcModelCache.getDimension(dimNumber);
                                String memberNumber = (String)entry.getValue();
                                if (dimension.isPreset() || !intersection.contains(dimNumber) || !memberNumber.equals(dimNumber)) continue;
                                someRootFlag = true;
                            }
                            if (someRootFlag) continue;
                            Long taskId = GlobalIdUtil.genGlobalLongId();
                            task.set("id", (Object)taskId);
                            task.set("scheme", (Object)scheme);
                            task.set("value", (Object)cell.getValue());
                            String string = AdjustServiceHelper.toJsonString(tarDimMemberMapperMap);
                            task.set("srcdimensionjson", (Object)string);
                            task.set("hashcode", (Object)tarDimMemberMapperMap.hashCode());
                            task.set("firstflag", (Object)TaskFirstFlag.FIRST_FLAG.getNumber());
                            List decDimension = DecDimensionUtil.getDecDimensionListFromSrc((IModelCacheHelper)srcModelCache, (String)string, null, (DynamicObject)scheme);
                            String decDimensionFromSrc = JSON.toJSONString((Object)decDimension);
                            String metricNumber = SysDimensionEnum.Metric.getNumber();
                            String metricMemberNumber = (String)tarDimMemberMapperMap.get(SysDimensionEnum.Metric.getNumber());
                            Member metricMember = srcModelCache.getMember(metricNumber, null, metricMemberNumber);
                            DecomposeTaskService instance = DecomposeTaskService.getInstance();
                            if (!instance.metricIsCurrencyOrUnCurrencyAndHasAgg(metricMember)) {
                                task.set(FIELD_STATUS, (Object)TaskStatus.DONE.getValue());
                                doneTaskIdList.add(taskId);
                            } else if (DecomposeSchemeStatus.SAVE.getNumber().equalsIgnoreCase(schemeStatus)) {
                                task.set(FIELD_STATUS, (Object)TaskStatus.WAIT.getValue());
                            } else if (CollectionUtils.isNotEmpty((Collection)decDimension)) {
                                task.set(FIELD_STATUS, (Object)TaskStatus.WAIT.getValue());
                            } else {
                                task.set(FIELD_STATUS, (Object)TaskStatus.DONE.getValue());
                                doneTaskIdList.add(taskId);
                            }
                            task.set("decdimensionjson", (Object)decDimensionFromSrc);
                            task.set("creater", (Object)UserUtils.getUserId());
                            task.set("createdate", (Object)TimeServiceHelper.now());
                            task.set("modifier", (Object)UserUtils.getUserId());
                            task.set("modifydate", (Object)TimeServiceHelper.now());
                            DynamicObjectUtil.init2Update((DynamicObject)task);
                            saveDatas.add((Object)task);
                            BigDecimal decimal = cell.getValue().getDecimal();
                            BgNumberCell bgNumberCell = new BgNumberCell(tarDatasetId, tarDimMemberMapperMap, decimal);
                            bgNumberCells.add(bgNumberCell);
                        }
                    }
                    continue;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u79d1\u76ee\u6210\u5458\u65e0\u7ef4\u5ea6\u627f\u63a5\u6620\u5c04\u3002", (String)"TargetSchemeService_0", (String)"epm-eb-business", (Object[])new Object[0]));
            }
            if (saveDatas.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])((DynamicObject[])saveDatas.toArray((Object[])new DynamicObject[0])));
                DataDecomposeService decomposeService = DataDecomposeService.getInstance();
                int size = bgNumberCells.size();
                log.info("\u76ee\u6807\u4e0b\u8fbe\u751f\u6210\u5206\u89e3\u65b9\u6848\u843d\u591a\u7ef4\u6570\u636esize:" + size);
                log.info("\u76ee\u6807\u4e0b\u8fbe\u751f\u6210\u5206\u89e3\u65b9\u6848\u7b2c\u4e00\u6761\u843d\u591a\u7ef4\u7684\u6570\u636e:" + JSON.toJSONString(bgNumberCells.get(0)));
                decomposeService.avgToDetail(srcModelId, bgNumberCells);
                if (doneTaskIdList.size() == saveDatas.size()) {
                    QFilter filter = new QFilter("targetrecord", "=", (Object)id);
                    DynamicObject decomposeScheme = BusinessDataServiceHelper.loadSingle((String)"eb_decompose_scheme", (String)"id, number, name, status", (QFilter[])new QFilter[]{filter});
                    decomposeScheme.set(FIELD_STATUS, (Object)DecomposeSchemeStatus.FINISHED.getNumber());
                    SaveServiceHelper.update((DynamicObject)decomposeScheme);
                }
            } else {
                DeleteServiceHelper.delete((String)"eb_decompose_scheme", (QFilter[])new QFilter[]{new QFilter("targetrecord", "=", (Object)id)});
                throw new KDBizException(ResManager.loadKDString((String)"\u76ee\u6807\u8bb0\u5f55\u4e0b\u8fbe\u5931\u8d25\u3002", (String)"TargetSchemeService_3", (String)"epm-eb-business", (Object[])new Object[0]));
            }
        }
    }

    private boolean checkDimLeafExist(IModelCacheHelper srcModelCache, List<String> intersection, Map<String, String> srcMemberMap, Map<String, Long> srcViewIdMap, Map<String, List<DynamicObject>> scrMemberMapperMap) {
        if (CollectionUtils.isNotEmpty(intersection)) {
            for (String dimNumber : intersection) {
                Dimension dimension = srcModelCache.getDimension(dimNumber);
                String srcMember = srcMemberMap.get(dimNumber);
                List<DynamicObject> srcMemberMappers = scrMemberMapperMap.get(srcMember);
                if (CollectionUtils.isNotEmpty(srcMemberMappers) || (dimension.isPreset() || !dimNumber.equals(srcMember)) && (!SysDimensionEnum.InternalCompany.getNumber().equals(dimNumber) || srcModelCache.getMemberByAnyView(srcViewIdMap.get(dimNumber), dimNumber, srcMember) == null || !"ICTotal".equals(srcModelCache.getMemberByAnyView(srcViewIdMap.get(dimNumber), dimNumber, srcMember).getNumber()))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkDimRootAllExist(IModelCacheHelper srcModelCache, List<String> srcDimensionNumbers, Map<String, Long> srcViewIdMap, Map<String, String> srcMemberMap) {
        if (CollectionUtils.isNotEmpty(srcDimensionNumbers)) {
            for (String srcDimNumber : srcDimensionNumbers) {
                Dimension dimension = srcModelCache.getDimension(srcDimNumber);
                String srcMember = srcMemberMap.get(srcDimNumber);
                if ((dimension.isPreset() || srcDimNumber.equals(srcMember)) && (!SysDimensionEnum.InternalCompany.getNumber().equals(srcDimNumber) || srcModelCache.getMemberByAnyView(srcViewIdMap.get(srcDimNumber), srcDimNumber, srcMember) == null || "ICTotal".equals(srcModelCache.getMemberByAnyView(srcViewIdMap.get(srcDimNumber), srcDimNumber, srcMember).getNumber()))) continue;
                return false;
            }
        }
        return true;
    }

    private DynamicObject saveTargetDecomposeScheme(long id, String schemeStatus) {
        DynamicObjectCollection saveDatas = new DynamicObjectCollection();
        DynamicObject targetSchemeRecord = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bgm_targetschemerecord");
        DynamicObject tarDatatype = targetSchemeRecord.getDynamicObject("datatype");
        DynamicObject tarVersion = targetSchemeRecord.getDynamicObject("version");
        DynamicObject tarAuditTrail = targetSchemeRecord.getDynamicObject("audittrail");
        DynamicObject tarModel = targetSchemeRecord.getDynamicObject("model");
        DynamicObject tarBussModel = targetSchemeRecord.getDynamicObject("bizctrl");
        String name = targetSchemeRecord.getString("desc");
        String number = targetSchemeRecord.getString("number");
        String td = "-TarDec";
        DynamicObject targetScheme = targetSchemeRecord.getDynamicObject("targetscheme");
        DynamicObject srcCurrency = targetScheme.getDynamicObject("currency");
        String srcBudgetPeriod = targetScheme.getString("budgetperiod");
        DynamicObject scheme = BusinessDataServiceHelper.newDynamicObject((String)"eb_decompose_scheme");
        long schemeId = GlobalIdUtil.genGlobalLongId();
        scheme.set("id", (Object)schemeId);
        scheme.set("number", (Object)(number + td));
        scheme.set("name", (Object)(name + TargetSchemeService.getDecomposeSchemeCn()));
        scheme.set("bizmodel", (Object)tarBussModel);
        scheme.set(FIELD_STATUS, (Object)schemeStatus);
        scheme.set("type", (Object)"1");
        scheme.set("targetrecord", (Object)targetSchemeRecord);
        scheme.set("datatype", (Object)tarDatatype);
        scheme.set("version", (Object)tarVersion);
        scheme.set("audittrail", (Object)tarAuditTrail);
        scheme.set("budgetperiod", (Object)srcBudgetPeriod);
        scheme.set("currency", (Object)srcCurrency);
        scheme.set("model", (Object)tarModel);
        scheme.set("createoperator", (Object)UserUtils.getUserId());
        scheme.set("createtime", (Object)TimeServiceHelper.now());
        scheme.set("modifyoperator", (Object)UserUtils.getUserId());
        scheme.set("modifytime", (Object)TimeServiceHelper.now());
        try {
            IModelCacheHelper tarModelCache = ModelCacheContext.getOrCreate((Long)tarModel.getLong("id"));
            Map viewsByBusModel = tarModelCache.getViewsByBusModelIncludeBase(Long.valueOf(tarBussModel.getLong("id")));
            scheme.set("entityview", viewsByBusModel.get(SysDimensionEnum.Entity.getNumber()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        saveDatas.add((Object)scheme);
        if (saveDatas.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])((DynamicObject[])saveDatas.toArray((Object[])new DynamicObject[0])));
        }
        return scheme;
    }

    private DynamicObjectCollection getDimMapper(long srcModelId, long srcBizCtrl, long tarBizCtrl) {
        QFilter model = new QFilter("model", "=", (Object)srcModelId);
        QFilter scrBussModel = new QFilter("scrbussmodel", "=", (Object)srcBizCtrl);
        QFilter tarBussModel = new QFilter("tarbussmodel", "=", (Object)tarBizCtrl);
        QFilter useStatus = new QFilter("usestatus", "=", (Object)"1");
        String selectFields = "select_dimension,entryentity.scrmember,entryentity.tarmember,entryentity.subdimension,entryentity.submember";
        return QueryServiceHelper.query((String)"bgm_targetschemedimmapper", (String)selectFields, (QFilter[])new QFilter[]{model, scrBussModel, tarBussModel, useStatus});
    }

    public List<Long> getMappingDataSetByTargetRecord(long id) {
        ArrayList<Long> dataSets = new ArrayList(16);
        DynamicObjectCollection schemes = QueryServiceHelper.query((String)"eb_decompose_scheme", (String)"id,number,model", (QFilter[])new QFilter("targetrecord", "=", (Object)id).toArray());
        if (CollectionUtils.isNotEmpty((Collection)schemes)) {
            long schemeId = ((DynamicObject)schemes.get(0)).getLong("id");
            long modelId = ((DynamicObject)schemes.get(0)).getLong("model");
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            DynamicObjectCollection tasks = QueryServiceHelper.query((String)"eb_decompose_task", (String)"srcdimensionjson", (QFilter[])new QFilter("scheme", "=", (Object)schemeId).toArray(), (String)"createdate desc");
            if (CollectionUtils.isNotEmpty((Collection)tasks)) {
                for (DynamicObject task : tasks) {
                    String srcDimensionJson = task.getString("srcdimensionjson");
                    Map memberMap = (Map)JSON.parseObject((String)srcDimensionJson, HashMap.class);
                    Long datasetId = DecDimensionUtil.getDatasetId((IModelCacheHelper)modelCacheHelper, (Map)memberMap);
                    dataSets.add(datasetId);
                }
            }
        }
        dataSets = dataSets.stream().distinct().collect(Collectors.toList());
        return dataSets;
    }

    public Map<String, List<Long>> getMappingByTargetRecord(long id, long tarDatasetId, Long businessmodel) {
        HashMap<String, List<Long>> mappingIdMap = new HashMap<String, List<Long>>(16);
        DynamicObjectCollection schemes = QueryServiceHelper.query((String)"eb_decompose_scheme", (String)"id,number,model", (QFilter[])new QFilter("targetrecord", "=", (Object)id).toArray());
        if (CollectionUtils.isNotEmpty((Collection)schemes)) {
            long schemeId = ((DynamicObject)schemes.get(0)).getLong("id");
            long modelId = ((DynamicObject)schemes.get(0)).getLong("model");
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            String[] dimensionNums = modelCacheHelper.getDimensionNums(Long.valueOf(tarDatasetId));
            DynamicObjectCollection tasks = QueryServiceHelper.query((String)"eb_decompose_task", (String)"srcdimensionjson", (QFilter[])new QFilter("scheme", "=", (Object)schemeId).toArray(), (String)"createdate desc");
            if (CollectionUtils.isNotEmpty((Collection)tasks)) {
                for (DynamicObject task : tasks) {
                    String srcDimensionJson = task.getString("srcdimensionjson");
                    Map memberMap = (Map)JSON.parseObject((String)srcDimensionJson, HashMap.class);
                    Long datasetId = DecDimensionUtil.getDatasetId((IModelCacheHelper)modelCacheHelper, (Map)memberMap);
                    if (tarDatasetId != datasetId) continue;
                    for (String dimensionNum : dimensionNums) {
                        if (!memberMap.containsKey(dimensionNum)) continue;
                        String memberNumber = (String)memberMap.get(dimensionNum);
                        Member member = modelCacheHelper.getMemberByAnyView(businessmodel, dimensionNum, memberNumber);
                        long memberId = member.getId();
                        List memberIds = (List)mappingIdMap.get(dimensionNum);
                        if (CollectionUtils.isNotEmpty((Collection)memberIds)) {
                            if (memberIds.contains(memberId)) continue;
                            memberIds.add(memberId);
                            continue;
                        }
                        mappingIdMap.put(dimensionNum, Lists.newArrayList((Object[])new Long[]{memberId}));
                    }
                }
            }
        }
        return mappingIdMap;
    }

    private static class InnerClass {
        private static TargetSchemeService instance = new TargetSchemeService();

        private InnerClass() {
        }
    }
}

