/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.task.service;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.task.entity.RelTemplateDto;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.task.MonitorOperationEnum;
import kd.epm.eb.common.enums.task.PreTaskMonitorLogic;
import kd.epm.eb.common.enums.task.PreTaskStatusEnum;
import kd.epm.eb.common.enums.task.ReportOperationEnum;
import kd.epm.eb.common.enums.task.SubTaskStatusEnum;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.params.ParamEnum;
import kd.epm.eb.common.params.ParamQueryServiceHelper;
import kd.epm.eb.common.reportprocess.utils.ReportProcessUtil;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarCommonUtil;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarUtil;
import org.apache.commons.collections4.CollectionUtils;

public class BgTaskDeployListService {
    private static final Log log = LogFactory.getLog(BgTaskDeployListService.class);
    public static String TASK_PACKAGE_SELECT_FIELD = "id,name,number,datatype,year,version,orgview,creater,createdate,modifier,modifydate,group,catalog,bizmodel,model,description,org,state,taskprocessshow,commitcheck";

    public static BgTaskDeployListService getInstance() {
        return new BgTaskDeployListService();
    }

    public DynamicObject[] getTaskPackageData(List<QFilter> qFilters) {
        if (qFilters == null || qFilters.size() < 1) {
            return new DynamicObject[0];
        }
        return BusinessDataServiceHelper.load((String)"eb_tasklist", (String)TASK_PACKAGE_SELECT_FIELD, (QFilter[])qFilters.toArray(new QFilter[0]), (String)"tpseq");
    }

    public DynamicObject getTaskPackageData(Long model, Long taskPackageId) {
        QFBuilder qf = new QFBuilder("model", "=", (Object)model);
        qf.add("id", "=", (Object)taskPackageId);
        return BusinessDataServiceHelper.loadSingle((String)"eb_tasklist", (String)TASK_PACKAGE_SELECT_FIELD, (QFilter[])qf.toArrays());
    }

    public DynamicObject[] getSubTaskData(long model, long taskPackage) {
        return this.getSubTaskData(model, taskPackage, this.getSubTaskSelectFiled());
    }

    public DynamicObject[] getSubTaskData(long model, long taskPackage, String selectFiled) {
        QFBuilder qf = new QFBuilder("model", "=", (Object)model);
        qf.add("tasklist", "=", (Object)taskPackage);
        return BusinessDataServiceHelper.load((String)"eb_task", (String)selectFiled, (QFilter[])qf.toArrays(), (String)"taskseq");
    }

    public Set<Long> getSubTaskIds(long model, long taskPackage, boolean onlyEnable) {
        DynamicObjectCollection query;
        QFBuilder qf = new QFBuilder("model", "=", (Object)model);
        qf.add("tasklist", "=", (Object)taskPackage);
        if (onlyEnable) {
            qf.add("isclosed", "=", (Object)SubTaskStatusEnum.ENABLE.getValue());
        }
        if (CollectionUtils.isNotEmpty((Collection)(query = QueryServiceHelper.query((String)"eb_task", (String)"id", (QFilter[])qf.toArray())))) {
            return query.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        }
        return new HashSet<Long>(0);
    }

    public Map<Object, DynamicObject> getSubTaskDataMap(long model, long taskPackage) {
        QFBuilder qf = new QFBuilder("model", "=", (Object)model);
        qf.add("tasklist", "=", (Object)taskPackage);
        Map tasks = BusinessDataServiceHelper.loadFromCache((String)"eb_task", (QFilter[])qf.toArrays());
        if (tasks == null || tasks.size() == 0) {
            return new LinkedHashMap<Object, DynamicObject>(16);
        }
        return tasks;
    }

    public DynamicObject getSubTaskData(long subTaskId) {
        QFBuilder qf = new QFBuilder("id", "=", (Object)subTaskId);
        return BusinessDataServiceHelper.loadSingle((String)"eb_task", (String)this.getSubTaskSelectFiled(), (QFilter[])qf.toArrays());
    }

    public Integer getSubMaxSeq(long model, long taskPackage) {
        QFBuilder qf = new QFBuilder("model", "=", (Object)model);
        qf.add("tasklist", "=", (Object)taskPackage);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_task", (String)"taskseq", (QFilter[])qf.toArrays(), (String)"taskseq desc");
        if (query != null && query.size() > 0) {
            return ((DynamicObject)query.get(0)).getInt("taskseq");
        }
        return 0;
    }

    public boolean existCurSubTask(long subTaskId) {
        QFBuilder qf = new QFBuilder("id", "=", (Object)subTaskId);
        return QueryServiceHelper.exists((String)"eb_task", (QFilter[])qf.toArrays());
    }

    private String getSubTaskSelectFiled() {
        return "id,name,number,tasklist,model,begintime,time,deadline,creater,createdate,modifier,modifydate,relytasks,isclosed,approvaltype,description,tasktemplate,entryentity,entryentity.templateid,group,taskseq,monitorop,pretaskstatus,pretasklogic";
    }

    public Set<Long> getExistSubTask(DynamicObject[] taskPackageData) {
        DynamicObjectCollection query;
        HashSet<Long> existSubTaskId = new HashSet<Long>(10);
        ArrayList<Long> taskPackageIds = new ArrayList<Long>(10);
        if (taskPackageData != null && taskPackageData.length > 0) {
            for (DynamicObject taskPackage : taskPackageData) {
                taskPackageIds.add(taskPackage.getLong("id"));
            }
        }
        if (taskPackageIds.size() > 0 && (query = QueryServiceHelper.query((String)"eb_task", (String)"id,tasklist", (QFilter[])new QFilter("tasklist", "in", taskPackageIds).toArray())) != null && query.size() > 0) {
            for (DynamicObject subTask : query) {
                existSubTaskId.add(subTask.getLong("tasklist"));
            }
        }
        return existSubTaskId;
    }

    public Boolean existSubTask(Long model, Long taskPackageId) {
        QFilter qFilter = new QFilter("model", "=", (Object)model);
        qFilter.and("tasklist", "=", (Object)taskPackageId);
        return QueryServiceHelper.exists((String)"eb_task", (QFilter[])qFilter.toArray());
    }

    public DynamicObject[] getTaskDisPatchSaveData(Long taskPackageId) {
        return BusinessDataServiceHelper.load((String)"eb_taskdispatchsave", (String)"id,taskid,executors,supervisor,distorg", (QFilter[])new QFilter("task", "=", (Object)taskPackageId).toArray());
    }

    public Map<Long, Map<String, String>> getSubTaskDisPatchInfo(Long taskPackageId) {
        HashMap<Long, Map<String, String>> subTaskDisPatchInfo = new HashMap<Long, Map<String, String>>(16);
        DynamicObject[] taskDisPatchSaveData = this.getTaskDisPatchSaveData(taskPackageId);
        if (taskDisPatchSaveData == null || taskDisPatchSaveData.length == 0) {
            return subTaskDisPatchInfo;
        }
        Map<Long, List<DynamicObject>> subTaskGroup = Arrays.stream(taskDisPatchSaveData).collect(Collectors.groupingBy(e -> e.getLong("taskid.id")));
        subTaskGroup.forEach((subTaskId, disPatchInfos) -> {
            HashSet<Long> orgIds = new HashSet<Long>(16);
            HashSet<Long> executorIds = new HashSet<Long>(16);
            HashSet<Long> supervisorIds = new HashSet<Long>(16);
            ArrayList<String> orgNames = new ArrayList<String>(16);
            ArrayList<String> executorNames = new ArrayList<String>(16);
            ArrayList<String> supervisorNames = new ArrayList<String>(16);
            for (DynamicObject disPatchInfo : disPatchInfos) {
                DynamicObjectCollection entryEntity;
                DynamicObjectCollection executors;
                long orgId;
                if (disPatchInfo.get("distorg") != null && orgIds.add(orgId = disPatchInfo.getLong("distorg.id"))) {
                    orgNames.add(disPatchInfo.getString("distorg.name"));
                }
                if (CollectionUtils.isNotEmpty((Collection)(executors = disPatchInfo.getDynamicObjectCollection("executors")))) {
                    for (DynamicObject executor : executors) {
                        long executorId = executor.getLong("fbasedataid_id");
                        if (!executorIds.add(executorId)) continue;
                        executorNames.add(executor.getString("fbasedataid.name"));
                    }
                }
                if (!CollectionUtils.isNotEmpty((Collection)(entryEntity = disPatchInfo.getDynamicObjectCollection("entryentity")))) continue;
                for (DynamicObject object : entryEntity) {
                    long supervisorId = object.getLong("supervisor.id");
                    if (!supervisorIds.add(supervisorId)) continue;
                    supervisorNames.add(object.getString("supervisor.name"));
                }
            }
            HashMap<String, String> info = new HashMap<String, String>(3);
            info.put("disPatchOrg", String.join((CharSequence)",", orgNames));
            info.put("executor", String.join((CharSequence)",", executorNames));
            info.put("supervisor", String.join((CharSequence)",", supervisorNames));
            subTaskDisPatchInfo.put((Long)subTaskId, (Map<String, String>)info);
        });
        return subTaskDisPatchInfo;
    }

    public Map<Long, Map<Long, RelTemplateDto>> getSubTaskRelTemplates(Set<Long> subTaskIds, Long modelId) {
        LinkedHashMap<Long, Map<Long, RelTemplateDto>> taskRelTemplateDtos = new LinkedHashMap<Long, Map<Long, RelTemplateDto>>(16);
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)modelId);
        HashSet<Long> templateIds = new HashSet<Long>(16);
        try (DataSet ds = DB.queryDataSet((String)"getSubTaskRelTemplates", (DBRoute)DBRoute.of((String)"epm"), (String)("select fid,fentryid,ftemplatetype,ftemplateid from t_eb_taskreftemplate where fid in (" + StringUtils.join((Object[])subTaskIds.toArray(), (String)",") + ") order by fid,fseq"));){
            while (ds.hasNext()) {
                Row next = ds.next();
                Long taskId2 = next.getLong("fid");
                Long templateId = next.getLong("ftemplateid");
                DynamicObject[] templateType = next.getString("ftemplatetype");
                RelTemplateDto relTemplateDto = new RelTemplateDto();
                relTemplateDto.setTaskId(taskId2);
                relTemplateDto.setId(templateId);
                relTemplateDto.setType((String)templateType);
                Map relTemplateDtos = taskRelTemplateDtos.computeIfAbsent(taskId2, e -> new LinkedHashMap(16));
                relTemplateDtos.put(templateId, relTemplateDto);
                templateIds.add(templateId);
            }
        }
        if (taskRelTemplateDtos.size() < 1) {
            return taskRelTemplateDtos;
        }
        HashMap<Long, String> templateNames = new HashMap<Long, String>(16);
        HashMap<Long, String> templateNumbers = new HashMap<Long, String>(16);
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("id", "in", templateIds));
        DynamicObject[] templates = BusinessDataServiceHelper.load((String)"eb_templateentity", (String)"id, name, number,templatetype", (QFilter[])builder.toArrays());
        if (templates != null && templates.length > 0) {
            for (DynamicObject template : templates) {
                long templateId = template.getLong("id");
                templateNames.put(templateId, template.getString("name"));
                templateNumbers.put(templateId, template.getString("number"));
            }
        }
        Map templateVarInfo = TemplateVarCommonUtil.getTemplateVarInfo(templateIds);
        taskRelTemplateDtos.forEach((taskId, taskTemplates) -> {
            if (taskTemplates != null && taskTemplates.size() > 0) {
                taskTemplates.forEach((templateId, relTemplateDto) -> {
                    relTemplateDto.setName((String)templateNames.get(templateId));
                    relTemplateDto.setNumber((String)templateNumbers.get(templateId));
                    relTemplateDto.setTemplateVar(this.getTemplateVariable(orCreate, (Map)templateVarInfo.get(templateId)));
                });
            }
        });
        return taskRelTemplateDtos;
    }

    public Map<Long, RelTemplateDto> getSubTaskRelTemplates(IModelCacheHelper orCreate, Long modeId, List<Long> tempIds, Long taskId) {
        LinkedHashMap<Long, RelTemplateDto> relTemplateDtoMap = new LinkedHashMap<Long, RelTemplateDto>(16);
        Map templateVarInfo = TemplateVarCommonUtil.getTemplateVarInfo(new HashSet<Long>(tempIds));
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("id", "in", tempIds));
        builder.add(new QFilter("model", "=", (Object)modeId));
        DynamicObject[] templates = BusinessDataServiceHelper.load((String)"eb_templateentity", (String)"id, name, number,templatetype", (QFilter[])builder.toArrays());
        if (templates != null && templates.length > 0) {
            for (DynamicObject template : templates) {
                long templateId = template.getLong("id");
                RelTemplateDto relTemplateDto = relTemplateDtoMap.computeIfAbsent(templateId, e -> new RelTemplateDto());
                relTemplateDto.setId(templateId);
                relTemplateDto.setTaskId(taskId);
                relTemplateDto.setType(template.getString("templatetype"));
                relTemplateDto.setName(template.getString("name"));
                relTemplateDto.setNumber(template.getString("number"));
                relTemplateDto.setTemplateVar(this.getTemplateVariable(orCreate, (Map)templateVarInfo.get(templateId)));
            }
        }
        return relTemplateDtoMap;
    }

    public String getTemplateVariable(IModelCacheHelper orCreate, Map<String, List<String>> templateVars) {
        StringBuilder variable = new StringBuilder();
        if (templateVars != null && templateVars.size() != 0) {
            for (Map.Entry<String, List<String>> entry : templateVars.entrySet()) {
                String dimNumber = entry.getKey();
                List<String> varList = entry.getValue();
                if (CollectionUtils.isEmpty(varList)) continue;
                HashSet<String> varSet = new HashSet<String>(varList);
                Dimension dimension = orCreate.getDimension(dimNumber);
                variable.append(dimension.getName());
                variable.append(":");
                variable.append(String.join((CharSequence)",", varSet));
                variable.append(";");
            }
        }
        return variable.toString();
    }

    public Map<String, List<String>> getTemplateVars(List<Long> templateIds) {
        HashMap<String, List<String>> variables = new HashMap<String, List<String>>(16);
        Map variablesInDataset = TemplateVarCommonUtil.getVarDimFromTemplateIds(templateIds);
        if (variablesInDataset == null) {
            return variables;
        }
        TemplateVarUtil.mergeVariables((Map)variablesInDataset, variables);
        return variables;
    }

    public boolean existSameTaskCatLogName(Long modelId, Long year, Long version, Long datatype, String catLogName, Long id) {
        QFBuilder qb = new QFBuilder();
        qb.add("model", "=", (Object)modelId);
        qb.add("year", "=", (Object)year);
        qb.add("version", "=", (Object)version);
        qb.add("datatype", "=", (Object)datatype);
        qb.add("catalog", "=", (Object)catLogName);
        qb.add(new QFilter("id", "!=", (Object)id));
        return QueryServiceHelper.exists((String)"eb_tasklist", (QFilter[])qb.toArrays());
    }

    public boolean existSameSubTaskName(Long modelId, Long taskPackId, String name, Long id) {
        QFBuilder qb = new QFBuilder();
        qb.add("model", "=", (Object)modelId);
        qb.add("tasklist", "=", (Object)taskPackId);
        qb.add("name", "=", (Object)name);
        qb.add(new QFilter("id", "!=", (Object)id));
        return QueryServiceHelper.exists((String)"eb_task", (QFilter[])qb.toArrays());
    }

    public Date getOldBeginTime(Long taskId) {
        DynamicObject oldTask = QueryServiceHelper.queryOne((String)"eb_task", (String)"id,number,begintime", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taskId)});
        if (oldTask != null) {
            return oldTask.getDate("begintime");
        }
        return null;
    }

    public String checkVarInTemplate(BizModel model, DynamicObjectCollection varListEntries, List<Long> templateIds) {
        if (!TemplateVarCommonUtil.checkIsVar((String)"isNeedVar", (String)"").booleanValue()) {
            return null;
        }
        HashMap<String, List<String>> taskVariable = new HashMap<String, List<String>>(16);
        HashMap<String, Object> accountVarMember = new HashMap<String, Object>(16);
        for (DynamicObject entry : varListEntries) {
            ArrayList<String> var;
            if (entry.get("dimension") == null || entry.get("variablenumber") == null || entry.get("variable") == null || StringUtils.isEmpty((CharSequence)entry.get("variable").toString())) continue;
            String dimension = entry.getString("dimension.number");
            String varNum = entry.getDynamicObject("variablenumber").getString("number");
            if (SysDimensionEnum.Account.getNumber().equals(dimension)) {
                String memberJson = entry.getString("variablejson");
                accountVarMember.put(varNum, SerializationUtils.fromJsonString((String)memberJson, Map.class));
            }
            if ((var = (ArrayList<String>)taskVariable.get(dimension)) == null) {
                var = new ArrayList<String>(16);
            }
            var.add(varNum);
            taskVariable.put(dimension, var);
        }
        HashMap<String, List<String>> variables = new HashMap<String, List<String>>(16);
        Map variablesInDataset = TemplateVarCommonUtil.getVarDimFromTemplateIds(templateIds);
        if (variablesInDataset == null) {
            return "";
        }
        TemplateVarUtil.mergeVariables((Map)variablesInDataset, variables);
        Map<String, Set<String>> needFillValueVariableMes = this.checkVarAndRetErrMessage(taskVariable, variables);
        String checkVar = TemplateVarCommonUtil.getErrorMessage(needFillValueVariableMes, (Boolean)false);
        String checkAccount = TemplateVarCommonUtil.checkAccountVarByMember(accountVarMember, (Map)variablesInDataset, (Long)model.getId());
        if (StringUtils.isEmpty((CharSequence)checkVar) && StringUtils.isEmpty((CharSequence)checkAccount)) {
            return "";
        }
        String errInfo = null;
        errInfo = StringUtils.isEmpty((CharSequence)checkVar) ? checkAccount : (StringUtils.isEmpty((CharSequence)checkAccount) ? checkVar : checkVar.substring(0, checkVar.length() - 1) + "\uff1b" + checkAccount);
        return errInfo;
    }

    public Map<String, Set<String>> checkVarAndRetErrMessage(Map<String, List<String>> taskListVariable, Map<String, List<String>> taskVariable) {
        if (!TemplateVarCommonUtil.checkIsVar((String)"isNeedVar", (String)"").booleanValue()) {
            return null;
        }
        HashMap<String, Set<String>> needFillValueVariable = new HashMap<String, Set<String>>(16);
        if (taskVariable == null || taskVariable.size() == 0) {
            return needFillValueVariable;
        }
        for (Map.Entry<String, List<String>> variable : taskVariable.entrySet()) {
            String dimension = variable.getKey();
            HashSet<String> tmp = new HashSet<String>(variable.getValue().size());
            List<String> taskVarList = taskListVariable.get(dimension);
            for (String varNumber : variable.getValue()) {
                if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension) && (varNumber.startsWith("@NextY") || varNumber.startsWith("@BaseY") || varNumber.startsWith("@LastY"))) {
                    if (taskVarList != null && taskVarList.contains("@BaseY")) continue;
                    tmp.add("@BaseY");
                    continue;
                }
                if (taskVarList != null && taskVarList.contains(varNumber)) continue;
                tmp.add(varNumber);
            }
            if (tmp.isEmpty()) continue;
            needFillValueVariable.put(dimension, tmp);
        }
        return needFillValueVariable;
    }

    public String getNeedFillValueVariableMes(Map<String, Set<String>> needFillValueVariableMes, IModelCacheHelper modelCache) {
        if (needFillValueVariableMes == null || needFillValueVariableMes.size() == 0) {
            return "";
        }
        StringBuilder mes = new StringBuilder();
        for (Map.Entry<String, Set<String>> entry : needFillValueVariableMes.entrySet()) {
            String dimNumber = entry.getKey();
            Set<String> varNumbers = entry.getValue();
            String dimName = modelCache.getDimension(dimNumber).getName();
            mes.append(dimName);
            mes.append(":");
            mes.append(StringUtils.join((Object[])varNumbers.toArray(), (String)","));
            mes.append(";  ");
        }
        return mes.toString();
    }

    public List<Map<String, Object>> getCurVariableInfo(Long curTaskPackageId) {
        ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>(16);
        String sqlPart = "select fdimension,fvariablenumber,fvariable,fvariablejsontext from t_eb_taskvariableset where fid = ? order by fseq;";
        try (DataSet rows = DB.queryDataSet((String)"getCurVariableInfo", (DBRoute)DBRoute.of((String)"epm"), (String)sqlPart, (Object[])new Object[]{curTaskPackageId});){
            while (rows.hasNext()) {
                HashMap<String, Object> data = new HashMap<String, Object>(16);
                Row memberRow = rows.next();
                data.put("dimension", memberRow.get("fdimension"));
                data.put("variable", memberRow.get("fvariablenumber"));
                data.put("variableValue", memberRow.getString("fvariable"));
                data.put("variableJson", memberRow.getString("fvariablejsontext"));
                datas.add(data);
            }
        }
        return datas;
    }

    public Map<String, Long> getVariablesId(Set<String> varNumbers, Long modelId) {
        HashMap<String, Long> variableIdMap = new HashMap<String, Long>(16);
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        Set varNumbers1 = varNumbers.stream().map(varNumber -> {
            if (varNumber.startsWith("@NextY") || varNumber.startsWith("@BaseY") || varNumber.startsWith("@LastY")) {
                return "@BaseY";
            }
            return varNumber;
        }).collect(Collectors.toSet());
        qFilter.and("number", "in", varNumbers1);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getVariablesId", (String)"eb_periodvariable", (String)"id,number,dimension.number", (QFilter[])qFilter.toArray(), (String)"dimension");){
            if (ds != null) {
                while (ds.hasNext()) {
                    Row row = ds.next();
                    variableIdMap.put(row.getString("dimension.number") + "_" + row.getString("number"), row.getLong("id"));
                }
            }
        }
        return variableIdMap;
    }

    public Long getUserInItDefaultPeriod(Long modelId, Long bizModelId) {
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue() || IDUtils.isEmptyLong((Long)bizModelId).booleanValue()) {
            return null;
        }
        String sqlPart = "select fyearid from t_eb_tasklist where fmodelid = ? and fbizmodelid = ? order by fmodifydate desc;";
        try (DataSet rows = DB.queryDataSet((String)"getUserInItDefaultPeriod", (DBRoute)DBRoute.of((String)"epm"), (String)sqlPart, (Object[])new Object[]{modelId, bizModelId});){
            if (rows.hasNext()) {
                Row next = rows.next();
                Long l = next.getLong(0);
                return l;
            }
        }
        return null;
    }

    public DynamicObjectCollection getHasDataTaskPagePeriods(Long modelId, Long bizModelId) {
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue() || IDUtils.isEmptyLong((Long)bizModelId).booleanValue()) {
            return null;
        }
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("bizmodel", "=", (Object)bizModelId);
        return QueryServiceHelper.query((String)"eb_tasklist", (String)"year.id,year.name", (QFilter[])qFilter.toArray(), (String)"modifydate desc");
    }

    public Set<Long> getTaskProcessTemplateIds(Long taskId) {
        HashSet<Long> templateIds = new HashSet<Long>(16);
        if (taskId == null || taskId == 0L) {
            return templateIds;
        }
        String sql = "select ftemplateid from t_eb_taskprocess where ftaskid = ? group by ftemplateid";
        try (DataSet rst = DB.queryDataSet((String)"queryTaskProcess", (DBRoute)DBRoute.of((String)"epm"), (String)sql, (Object[])new Object[]{taskId});){
            while (rst.hasNext()) {
                Row row = rst.next();
                if (row.getLong("ftemplateid") == 0L) continue;
                templateIds.add(row.getLong("ftemplateid"));
            }
        }
        return templateIds;
    }

    public boolean checkCircle(Object headNode, Map<Object, Set<Object>> relMap, Set<Object> relNodes) {
        if (relNodes != null && relNodes.size() > 0) {
            if (relNodes.contains(headNode)) {
                return true;
            }
            for (Object relNode : relNodes) {
                if (!this.checkCircle(headNode, relMap, relMap.get(relNode))) continue;
                return true;
            }
        }
        return false;
    }

    public Long getDefaultViewId(Long modelId, Long bizModelId, Long taskListId) {
        Long taskListOrgViewId = this.getTaskListOrgViewId(taskListId);
        if (IDUtils.isNotEmptyLong((Long)taskListOrgViewId).booleanValue()) {
            return taskListOrgViewId;
        }
        Long bizModelRelOrgViewId = BusinessModelServiceHelper.getInstance().getViewId(bizModelId, SysDimensionEnum.Entity.getNumber(), modelId);
        DynamicObjectCollection taskDisPatchData = this.getSubTaskDisPatchData(taskListId, bizModelRelOrgViewId, "1");
        if (CollectionUtils.isNotEmpty((Collection)taskDisPatchData)) {
            return ((DynamicObject)taskDisPatchData.get(0)).getLong("orgview");
        }
        DynamicObjectCollection taskDisPatchStashData = this.getSubTaskDisPatchData(taskListId, bizModelRelOrgViewId, "0");
        if (CollectionUtils.isNotEmpty((Collection)taskDisPatchStashData)) {
            return ((DynamicObject)taskDisPatchStashData.get(0)).getLong("orgview");
        }
        return bizModelRelOrgViewId;
    }

    public DynamicObjectCollection getSubTaskDisPatchData(Long taskListId, Long bizModelRelOrgViewId, String taskStatus) {
        QFilter qFilter = new QFilter("task", "=", (Object)taskListId);
        qFilter.and("taskstatus", "=", (Object)taskStatus);
        qFilter.and("distorg", "!=", (Object)0L);
        qFilter.and(new QFilter("orgview", "=", (Object)bizModelRelOrgViewId).or("orgview.parent", "=", (Object)bizModelRelOrgViewId));
        return QueryServiceHelper.query((String)"eb_taskdispatchsave", (String)"orgview", (QFilter[])qFilter.toArray(), (String)"modifydate desc,orgview", (int)1);
    }

    public Long getTaskListOrgViewId(Long taskListId) {
        DynamicObject query = QueryServiceHelper.queryOne((String)"eb_tasklist", (String)"orgview", (QFilter[])new QFilter("id", "=", (Object)taskListId).toArray());
        if (query != null) {
            return query.getLong("orgview");
        }
        return 0L;
    }

    public boolean isOpenTaskPermControl(Long modelId) {
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            return true;
        }
        return ParamQueryServiceHelper.getBoolean((long)modelId, (ParamEnum)ParamEnum.BG032);
    }

    public boolean isAssigned(Long subTaskId) {
        return QueryServiceHelper.exists((String)"eb_taskprocess", (QFilter[])new QFilter("task", "=", (Object)subTaskId).toArray());
    }

    public Set<String> checkSubTaskMonitorComplete(Long modelId, Long taskPackageId) {
        HashSet<String> subTaskName = new HashSet<String>(16);
        DynamicObject[] subTaskData = this.getSubTaskData(modelId, taskPackageId);
        if (subTaskData != null && subTaskData.length > 0) {
            for (DynamicObject subTaskDatum : subTaskData) {
                if (!this.checkTaskMonitorComplete(subTaskDatum)) continue;
                subTaskName.add(subTaskDatum.getString("name"));
            }
        }
        return subTaskName;
    }

    public boolean checkTaskMonitorComplete(DynamicObject subTaskData) {
        if (subTaskData == null) {
            return false;
        }
        MonitorOperationEnum monitorOp = MonitorOperationEnum.getEnumByValue((String)subTaskData.getString("monitorop"));
        PreTaskStatusEnum preTaskStatus = PreTaskStatusEnum.getEnumByValue((String)subTaskData.getString("pretaskstatus"));
        DynamicObjectCollection relyTasks = subTaskData.getDynamicObjectCollection("relytasks");
        if (monitorOp == null && preTaskStatus == null && CollectionUtils.isEmpty((Collection)relyTasks)) {
            return false;
        }
        return preTaskStatus == null || monitorOp == null || CollectionUtils.isEmpty((Collection)relyTasks);
    }

    public String getNameByIdAndEntityName(Long id, String entityName) {
        String name = "";
        DynamicObject query = QueryServiceHelper.queryOne((String)entityName, (String)"name", (QFilter[])new QFilter("id", "=", (Object)id).toArray());
        if (query != null) {
            return query.getString("name");
        }
        return name;
    }

    public Map<Long, String> getSubTaskName(Set<Long> taskIds) {
        DynamicObjectCollection query;
        if (CollectionUtils.isNotEmpty(taskIds) && CollectionUtils.isNotEmpty((Collection)(query = QueryServiceHelper.query((String)"eb_task", (String)"id,name", (QFilter[])new QFilter("id", "in", taskIds).toArray())))) {
            return query.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getString("name")));
        }
        return new HashMap<Long, String>(0);
    }

    public Map<String, String> getSubTaskDispatchOrgStatus(Set<Long> subTaskIds) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_taskdispatchsave", (String)"taskid,distorg,taskstatus", (QFilter[])new QFilter("taskid", "in", subTaskIds).toArray());
        if (CollectionUtils.isEmpty((Collection)query)) {
            return new HashMap<String, String>(0);
        }
        HashMap<String, String> subTaskDispatchOrgStatus = new HashMap<String, String>(query.size());
        for (DynamicObject object : query) {
            long distOrg = object.getLong("distorg");
            long subTaskId = object.getLong("taskid");
            String status = object.getString("taskstatus");
            subTaskDispatchOrgStatus.put(subTaskId + "_" + distOrg, status);
        }
        return subTaskDispatchOrgStatus;
    }

    public String checkTaskMonitor(Long modelId, Set<Long> subTaskIds, ReportOperationEnum reportOperation, Long submitOrgId, Long entityViewId) {
        if (CollectionUtils.isEmpty(subTaskIds)) {
            return null;
        }
        DynamicObject[] query = BusinessDataServiceHelper.load((String)"eb_task", (String)"name,relytasks,monitorop,pretaskstatus,pretasklogic", (QFilter[])new QFilter("id", "in", subTaskIds).toArray());
        if (query == null || query.length == 0) {
            return null;
        }
        HashSet<Long> preTaskIds = new HashSet<Long>(16);
        for (DynamicObject object : query) {
            DynamicObjectCollection relyTasks = object.getDynamicObjectCollection("relytasks");
            if (!CollectionUtils.isNotEmpty((Collection)relyTasks)) continue;
            for (DynamicObject relyTask : relyTasks) {
                preTaskIds.add(relyTask.getLong("fbasedataid_id"));
            }
        }
        if (preTaskIds.isEmpty()) {
            return null;
        }
        QFilter taskProcessQFilter = new QFilter("task", "in", preTaskIds);
        Map reportProcessStatus = ReportProcessUtil.getReportProcessStatus((Long)modelId, (QFilter)taskProcessQFilter, (boolean)false);
        if (reportProcessStatus.isEmpty()) {
            return null;
        }
        for (DynamicObject subTask : query) {
            boolean case2;
            DynamicObjectCollection preTasks = subTask.getDynamicObjectCollection("relytasks");
            MonitorOperationEnum monitorOp = MonitorOperationEnum.getEnumByValue((String)subTask.getString("monitorop"));
            PreTaskStatusEnum preTaskStatus = PreTaskStatusEnum.getEnumByValue((String)subTask.getString("pretaskstatus"));
            if (CollectionUtils.isEmpty((Collection)preTasks) || monitorOp == null || preTaskStatus == null) continue;
            PreTaskMonitorLogic preTaskMonitorLogic = PreTaskMonitorLogic.getEnumByValue((String)subTask.getString("pretasklogic"));
            boolean case1 = monitorOp == MonitorOperationEnum.EDIT_AND_SUBMIT;
            boolean bl = case2 = monitorOp == MonitorOperationEnum.SUBMIT && reportOperation == ReportOperationEnum.SUBMIT;
            if (!case1 && !case2) continue;
            Set curTaskRelPreTaskIds = preTasks.stream().map(e -> e.getLong("fbasedataid_id")).collect(Collectors.toSet());
            Map subTaskRelTaskProcess = ReportProcessUtil.getSubTaskRelTaskProcess(curTaskRelPreTaskIds, (PreTaskMonitorLogic)preTaskMonitorLogic, (Long)submitOrgId);
            for (DynamicObject preTask : preTasks) {
                Member member;
                HashSet matchStatus;
                Set preTaskProcessIds = (Set)subTaskRelTaskProcess.get(preTask.getLong("fbasedataid_id"));
                if (CollectionUtils.isEmpty((Collection)preTaskProcessIds)) continue;
                HashSet<String> preTaskRelProcessStatus = new HashSet<String>(16);
                for (Long processId : preTaskProcessIds) {
                    String processStatus = (String)reportProcessStatus.get(String.valueOf(processId));
                    if (processStatus == null) continue;
                    preTaskRelProcessStatus.add(processStatus);
                }
                if (CollectionUtils.isEmpty(preTaskRelProcessStatus)) continue;
                if (PreTaskStatusEnum.SUBMITTED == preTaskStatus) {
                    matchStatus = Sets.newHashSet((Object[])new String[]{BgTaskStateEnum.UNDERWAY.getNumber(), BgTaskStateEnum.COMPLETED.getNumber(), BgTaskStateEnum.READONLY.getNumber()});
                    if (matchStatus.containsAll(preTaskRelProcessStatus)) continue;
                    if (preTaskMonitorLogic == PreTaskMonitorLogic.BY_ORG) {
                        member = ModelCacheContext.getOrCreate((Long)modelId).getMember("Entity", entityViewId, submitOrgId);
                        return ResManager.loadResFormat((String)"\u524d\u7f6e\u4efb\u52a1%1\u4e0b\u7684%2\u7ec4\u7ec7\u5b58\u5728\u62a5\u8868\u672a\u63d0\u4ea4\uff0c\u4e0d\u80fd%3\u5f53\u524d\u62a5\u8868\u3002", (String)"BgTaskDeployListService_2", (String)"epm-eb-business", (Object[])new Object[]{preTask.getString("fbasedataid.name"), member != null ? member.getName() : "", reportOperation.getName().loadKDString()});
                    }
                    return ResManager.loadResFormat((String)"\u524d\u7f6e\u4efb\u52a1%1\u5b58\u5728\u62a5\u8868\u672a\u63d0\u4ea4\uff0c\u4e0d\u80fd%2\u5f53\u524d\u62a5\u8868\u3002", (String)"BgTaskDeployListService_0", (String)"epm-eb-business", (Object[])new Object[]{preTask.getString("fbasedataid.name"), reportOperation.getName().loadKDString()});
                }
                if (PreTaskStatusEnum.COMPLETED != preTaskStatus || (matchStatus = Sets.newHashSet((Object[])new String[]{BgTaskStateEnum.COMPLETED.getNumber(), BgTaskStateEnum.READONLY.getNumber()})).containsAll(preTaskRelProcessStatus)) continue;
                if (preTaskMonitorLogic == PreTaskMonitorLogic.BY_ORG) {
                    member = ModelCacheContext.getOrCreate((Long)modelId).getMember("Entity", entityViewId, submitOrgId);
                    return ResManager.loadResFormat((String)"\u524d\u7f6e\u4efb\u52a1%1\u4e0b\u7684%2\u7ec4\u7ec7\u5b58\u5728\u62a5\u8868\u672a\u5ba1\u6838\uff0c\u4e0d\u80fd%3\u5f53\u524d\u62a5\u8868\u3002", (String)"BgTaskDeployListService_3", (String)"epm-eb-business", (Object[])new Object[]{preTask.getString("fbasedataid.name"), member != null ? member.getName() : "", reportOperation.getName().loadKDString()});
                }
                return ResManager.loadResFormat((String)"\u524d\u7f6e\u4efb\u52a1%1\u5b58\u5728\u62a5\u8868\u672a\u5ba1\u6838\uff0c\u4e0d\u80fd%2\u5f53\u524d\u62a5\u8868\u3002", (String)"BgTaskDeployListService_1", (String)"epm-eb-business", (Object[])new Object[]{preTask.getString("fbasedataid.name"), reportOperation.getName().loadKDString()});
            }
        }
        return null;
    }

    public boolean isTaskPackageNotExistEnableTask(Long taskPackageId) {
        QFilter qFilter = new QFilter("tasklist", "=", (Object)taskPackageId).and("isclosed", "=", (Object)SubTaskStatusEnum.ENABLE.getValue());
        return !QueryServiceHelper.exists((String)"eb_task", (QFilter[])qFilter.toArray());
    }

    public boolean isTaskNotEnable(Long taskId) {
        QFilter qFilter = new QFilter("id", "=", (Object)taskId).and("isclosed", "!=", (Object)SubTaskStatusEnum.ENABLE.getValue());
        return QueryServiceHelper.exists((String)"eb_task", (QFilter[])qFilter.toArray());
    }

    public Map<Long, SubTaskStatusEnum> getSubTasksStatus(Collection<Long> taskIds) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_task", (String)"id,isclosed", (QFilter[])new QFilter("id", "in", taskIds).toArray());
        if (CollectionUtils.isEmpty((Collection)query)) {
            return new HashMap<Long, SubTaskStatusEnum>(0);
        }
        return query.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> SubTaskStatusEnum.getEnumByValue((String)e.getString("isclosed"))));
    }

    public List<Long> getTaskPackageOrderList(Collection<Long> packageIds) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_tasklist", (String)"id", (QFilter[])new QFilter("id", "in", packageIds).toArray(), (String)"tpseq");
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            return query.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        }
        return new ArrayList<Long>(0);
    }

    public Integer getTaskPackageMaxSeq(Long modelId) {
        QFBuilder qf = new QFBuilder("model", "=", (Object)modelId);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_tasklist", (String)"tpseq", (QFilter[])qf.toArrays(), (String)"tpseq desc");
        if (query != null && query.size() > 0) {
            return ((DynamicObject)query.get(0)).getInt("tpseq");
        }
        return 0;
    }

    public Set<Long> getExistNoUnableTaskPackageIds(Long modelId) {
        QFBuilder qf = new QFBuilder("model", "=", (Object)modelId);
        qf.add("isclosed", "!=", (Object)SubTaskStatusEnum.UNABLE.getValue());
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_task", (String)"tasklist", (QFilter[])qf.toArrays());
        if (CollectionUtils.isEmpty((Collection)query)) {
            return new HashSet<Long>(0);
        }
        return query.stream().map(e -> e.getLong("tasklist")).collect(Collectors.toSet());
    }

    public Map<Long, Set<String>> getSubTaskExecuteOrgNames(Long modelId, Collection<Long> subTaskIds) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_taskprocess", (String)"task,org,orgview", (QFilter[])new QFilter("task", "in", subTaskIds).toArray());
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            HashMap<Long, Set<String>> subTaskExecuteOrgNames = new HashMap<Long, Set<String>>(query.size());
            for (DynamicObject object : query) {
                Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), Long.valueOf(object.getLong("orgview")), Long.valueOf(object.getLong("org")));
                if (member == null) continue;
                subTaskExecuteOrgNames.computeIfAbsent(object.getLong("task"), e -> new HashSet(10)).add(member.getName());
            }
            return subTaskExecuteOrgNames;
        }
        return new HashMap<Long, Set<String>>(0);
    }
}

