/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.taskflow;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.impl.MutexFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.spread.template.TemplateMutexServiceHelper;

public class TaskFlowLockHelper {
    private static final long LOCK_KEEP_TIME_MS = Long.parseLong(System.getProperty("mutex.maxkeeptime_h", "8")) * 60L * 60L * 1000L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean lock(Long taskFlowId, Long model) {
        try (DataMutex dataMutex = MutexFactory.createDataMutex();){
            boolean bl = dataMutex.require(String.valueOf(taskFlowId), String.valueOf(model), "eb_bgmtaskflow", "alter", true);
            return bl;
        }
        catch (IOException ex) {
            throw new RuntimeException("IOException when closing data mutex!", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean unlock(Long taskFlowId, Long model) {
        Map<String, String> lockInfo = TaskFlowLockHelper.getLockInfo(taskFlowId, model);
        String userId = lockInfo.get("userid");
        if (userId == null) return false;
        if (!userId.equals(UserUtils.getUserId().toString())) return false;
        try (DataMutex dataMutex = MutexFactory.createDataMutex();){
            boolean bl = dataMutex.release(String.valueOf(taskFlowId), "eb_bgmtaskflow", "alter");
            return bl;
        }
        catch (IOException ex) {
            throw new RuntimeException("IOException when closing data mutex!", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getLockInfo(Long taskFlowId, Long model) {
        try (DataMutex dataMutex = MutexFactory.createDataMutex();){
            Map lockInfo = dataMutex.getLockInfo(String.valueOf(taskFlowId), String.valueOf(model), "eb_bgmtaskflow");
            Map map = lockInfo = lockInfo == null ? Collections.emptyMap() : lockInfo;
            return map;
        }
        catch (IOException ex) {
            throw new RuntimeException("IOException when closing data mutex!", ex);
        }
    }

    public static void checkIsLock(Long taskFlowId, Long model) {
        Map<String, String> lockInfo = TaskFlowLockHelper.getLockInfo(taskFlowId, model);
        if (lockInfo.size() == 0) {
            return;
        }
        String lockTime = lockInfo.get("lockedTime");
        if (System.currentTimeMillis() - Long.parseLong(lockTime) > LOCK_KEEP_TIME_MS) {
            TaskFlowLockHelper.unlock(taskFlowId, model);
        } else {
            TaskFlowLockHelper.showTips(lockInfo, taskFlowId);
        }
    }

    public static void checkIsLockInPage(Long taskFlowId, Long model, IFormView view) {
        Map<String, String> lockInfo = TaskFlowLockHelper.getLockInfo(taskFlowId, model);
        if (lockInfo.size() == 0) {
            return;
        }
        String lockTime = lockInfo.get("lockedTime");
        if (System.currentTimeMillis() - Long.parseLong(lockTime) > LOCK_KEEP_TIME_MS) {
            TaskFlowLockHelper.unlock(taskFlowId, model);
        } else {
            if (lockInfo.size() == 0) {
                return;
            }
            Long userId = IDUtils.toLong((Object)lockInfo.get("userid"));
            if (UserUtils.getUserId().equals(userId)) {
                return;
            }
            String username = TaskFlowLockHelper.getOrgNameById(userId);
            String msg = username == null ? ResManager.loadResFormat((String)"\u7528\u6237id\u4e3a%1\u6b63\u5728\u7f16\u8f91\uff0c\u53ea\u80fd\u67e5\u770b\u3002", (String)"TaskFlowLockHelper_4", (String)"epm-eb-business", (Object[])new Object[]{userId}) : ResManager.loadResFormat((String)"\u7528\u6237%1\u6b63\u5728\u7f16\u8f91\uff0c\u53ea\u80fd\u67e5\u770b\u3002", (String)"TaskFlowLockHelper_3", (String)"epm-eb-business", (Object[])new Object[]{username});
            view.setEnable(Boolean.valueOf(false), new String[]{"btn_save", "baseinfoflex", "nodeentry"});
            view.setVisible(Boolean.valueOf(false), new String[]{"advcontoolbarap"});
            view.showTipNotification(msg);
            view.getPageCache().put("checkIsLockInPage", "false");
        }
    }

    public static void showTips(Map<String, String> lockInfo, Long schemeId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"eb_bgmtaskflow", (String)"id,number");
        if (dynamicObject != null) {
            TaskFlowLockHelper.showTips(lockInfo, dynamicObject.getString("number"));
        }
    }

    public static void showTips(Map<String, String> lockinfo, String schemeNum) {
        if (lockinfo == null || lockinfo.size() == 0) {
            return;
        }
        String username = TaskFlowLockHelper.getOrgNameById(IDUtils.toLong((Object)lockinfo.get("userid")));
        String msg = username == null ? ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a%1\u7684\u4efb\u52a1\u6267\u884c\u987a\u5e8f\u6b63\u5728\u88ab\u7528\u6237id\u4e3a%2\u7684\u7528\u6237\u7f16\u8f91\uff0c\u8bf7\u5148\u8010\u5fc3\u7b49\u5f85\uff0c\u6025\u7528\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5230\u7cfb\u7edf\u7ba1\u7406-\u7f51\u7edc\u4e92\u65a5\u4e2d\u89e3\u9501\u3002", (String)"TaskFlowLockHelper_1", (String)"epm-eb-business", (Object[])new Object[]{schemeNum, lockinfo.get("userid")}) : ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a%1\u7684\u4efb\u52a1\u6267\u884c\u987a\u5e8f\u6b63\u5728\u88ab\u7528\u6237%2\u4f7f\u7528\uff0c\u8bf7\u5148\u8010\u5fc3\u7b49\u5f85\uff0c\u6025\u7528\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5230\u7cfb\u7edf\u7ba1\u7406-\u7f51\u7edc\u4e92\u65a5\u4e2d\u89e3\u9501\u3002", (String)"TaskFlowLockHelper_2", (String)"epm-eb-business", (Object[])new Object[]{schemeNum, username});
        throw new KDBizException(msg);
    }

    public static String getOrgNameById(Long orgid) {
        QFilter filter = new QFilter("id", "=", (Object)orgid);
        String username = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)TemplateMutexServiceHelper.class.getName(), (String)"bos_user", (String)"name", (QFilter[])new QFilter[]{filter}, null);){
            while (dataSet.hasNext()) {
                username = dataSet.next().getString("name");
            }
        }
        return username;
    }
}

