/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.taskflow;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.approvetype.ApproveUtils;
import kd.epm.eb.business.bizflow.pojo.NodeInstance;
import kd.epm.eb.business.bizflow.pojo.event.NodeUpdateEvent;
import kd.epm.eb.business.bizflow.util.BizFlowEventUtil;
import kd.epm.eb.business.bizflow.util.BizFlowInstanceUtil;
import kd.epm.eb.business.bizflow.util.NodeInstanceUtil;
import kd.epm.eb.business.taskflow.TaskTransRelationServiceHelper;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.taskflow.TaskFlowInstDto;
import kd.epm.eb.common.taskflow.TaskFlowNodeType;
import kd.epm.eb.common.taskflow.TaskTransRelation;
import kd.epm.eb.common.taskflow.TaskTransRelationDetail;
import kd.epm.eb.common.taskflow.graph.TaskFlowGraph;
import kd.epm.eb.common.taskflow.graph.TaskFlowLine;
import kd.epm.eb.common.taskflow.graph.TaskFlowNode;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;

public class TaskFlowServiceHelper {
    private static final Log log = LogFactory.getLog(TaskFlowServiceHelper.class);

    public static Map<Long, Set<Long>> getLockedOrgIds(Set<Long> processIds) {
        QFilter reportFilter = new QFilter("id", "in", processIds);
        DynamicObjectCollection reportList = QueryServiceHelper.query((String)"eb_reportprocess", (String)"id,status", (QFilter[])reportFilter.toArray());
        HashSet<Long> reportIds = new HashSet<Long>(16);
        for (DynamicObject report : reportList) {
            String reportStatus = report.getString("status");
            if (BgTaskStateEnum.UNDERWAY.getNumber().equals(reportStatus) || BgTaskStateEnum.COMPLETED.getNumber().equals(reportStatus)) continue;
            reportIds.add(report.getLong("id"));
        }
        log.info("TaskFlowServiceHelper#getLockedOrgIds start, reportIds={}", reportIds);
        if (reportIds.isEmpty()) {
            log.error("TaskFlowServiceHelper#getLockedOrgIds reportIds is empty");
            return Maps.newHashMap();
        }
        List<NodeInstance> nodeInstanceList = NodeInstanceUtil.getInsByTarObjs(reportIds, null);
        if (CollectionUtils.isEmpty(nodeInstanceList)) {
            log.error("TaskFlowServiceHelper#getLockedOrgIds nodeInstanceList is empty");
            return Maps.newHashMap();
        }
        Set<Long> flowInstanceIds = nodeInstanceList.stream().map(NodeInstance::getFlowInstanceId).collect(Collectors.toSet());
        Map<Long, Long> instFlowMap = BizFlowInstanceUtil.getFowIdByInsId(flowInstanceIds);
        if (CollectionUtils.isEmpty(instFlowMap)) {
            log.error("TaskFlowServiceHelper#getLockedOrgIds instFlowMap is empty");
            return Maps.newHashMap();
        }
        Map<Long, TaskFlowGraph> taskFlowGraphMap = TaskFlowServiceHelper.getTaskFlowGraphs(instFlowMap.values(), true);
        if (CollectionUtils.isEmpty(taskFlowGraphMap)) {
            log.error("TaskFlowServiceHelper#getLockedOrgIds taskFlowGraphMap is empty");
            return Maps.newHashMap();
        }
        HashMap<Long, Long> reportOrgMap = new HashMap<Long, Long>(16);
        HashMap<Long, List> reportFlowInstMap = new HashMap<Long, List>(16);
        for (NodeInstance nodeInstance : nodeInstanceList) {
            Long l = nodeInstance.getFlowInstanceId();
            Long flowGraphId = instFlowMap.get(l);
            String nodeKey = nodeInstance.getNodeKey();
            Long reportId = nodeInstance.getRefObj();
            Long orgId = nodeInstance.getTaskDimMember();
            TaskFlowGraph taskFlowGraph = taskFlowGraphMap.get(flowGraphId);
            if (taskFlowGraph == null) continue;
            reportOrgMap.put(reportId, orgId);
            List flowInstDtoList = reportFlowInstMap.computeIfAbsent(reportId, v -> new ArrayList(16));
            TaskFlowInstDto taskFlowInstDto = new TaskFlowInstDto();
            taskFlowInstDto.setFlowInstanceId(l);
            taskFlowInstDto.setFlowGraphId(flowGraphId);
            taskFlowInstDto.setNodeKey(nodeKey);
            flowInstDtoList.add(taskFlowInstDto);
        }
        HashSet<Long> passedReportIds = new HashSet<Long>(16);
        block2: for (Map.Entry entry : reportFlowInstMap.entrySet()) {
            Long reportId = (Long)entry.getKey();
            Long submitOrgId = (Long)reportOrgMap.get(reportId);
            List taskFlowInstList = (List)entry.getValue();
            for (TaskFlowInstDto taskFlowInst : taskFlowInstList) {
                boolean isJoinNode;
                Object relation;
                List taskFlowLineList;
                TaskFlowNode currentNode;
                Long flowInstanceId = taskFlowInst.getFlowInstanceId();
                Long flowGraphId = taskFlowInst.getFlowGraphId();
                String nodeKey = taskFlowInst.getNodeKey();
                TaskFlowGraph taskFlowGraph = taskFlowGraphMap.get(flowGraphId);
                if (taskFlowGraph == null || (currentNode = taskFlowGraph.getNode(nodeKey)) == null || CollectionUtils.isEmpty((Collection)(taskFlowLineList = taskFlowGraph.getNodePreRelLine(currentNode.getNumber())))) continue;
                boolean isStartNode = TaskFlowServiceHelper.isStartNodeForPreNode(taskFlowLineList, taskFlowGraph);
                if (isStartNode) {
                    log.info("TaskFlowServiceHelper#getLockedOrgIds flowInstanceId={}, reportId={}, isStartNode=true", (Object)flowInstanceId, (Object)reportId);
                    passedReportIds.add(reportId);
                    continue block2;
                }
                Set<String> allPreNodes = taskFlowLineList.stream().map(TaskFlowLine::getSourceNodeNum).collect(Collectors.toSet());
                boolean isAllFinished = NodeInstanceUtil.checkNodeAllComplete(flowInstanceId, allPreNodes);
                if (isAllFinished) {
                    log.info("TaskFlowServiceHelper#getLockedOrgIds flowInstanceId={}, reportId={}, isAllFinished=true", (Object)flowInstanceId, (Object)reportId);
                    passedReportIds.add(reportId);
                    continue block2;
                }
                ArrayList<TaskFlowLine> noRelationLineList = new ArrayList<TaskFlowLine>(16);
                ArrayList<TaskFlowLine> hasRelationLineList = new ArrayList<TaskFlowLine>(16);
                for (TaskFlowLine taskFlowLine2 : taskFlowLineList) {
                    relation = taskFlowLine2.getTransRelation();
                    List relationList = null;
                    if (relation != null) {
                        relationList = relation.getDetailList();
                    }
                    if (CollectionUtils.isEmpty(relationList)) {
                        noRelationLineList.add(taskFlowLine2);
                        continue;
                    }
                    hasRelationLineList.add(taskFlowLine2);
                }
                boolean bl = isJoinNode = taskFlowLineList.size() > 1;
                if (isJoinNode) {
                    if (noRelationLineList.size() == taskFlowLineList.size()) continue;
                    ArrayList<TaskFlowLine> matchLineList = new ArrayList<TaskFlowLine>(16);
                    block5: for (TaskFlowLine taskFlowLine3 : hasRelationLineList) {
                        TaskTransRelation relation2 = taskFlowLine3.getTransRelation();
                        List detailList = relation2.getDetailList();
                        for (TaskTransRelationDetail detail : detailList) {
                            Set outputOrgIds = detail.getOutputOrgIds();
                            if (!outputOrgIds.contains(submitOrgId)) continue;
                            matchLineList.add(taskFlowLine3);
                            continue block5;
                        }
                    }
                    if (matchLineList.isEmpty()) {
                        Set<String> preNodes = taskFlowLineList.stream().map(TaskFlowLine::getSourceNodeNum).collect(Collectors.toSet());
                        boolean isFinished = NodeInstanceUtil.checkNodeAllComplete(flowInstanceId, preNodes);
                        if (!isFinished) continue;
                        log.info("TaskFlowServiceHelper#getLockedOrgIds flowInstanceId={}, reportId={}, matchLineList is empty, isAllFinished=true", (Object)flowInstanceId, (Object)reportId);
                        passedReportIds.add(reportId);
                        continue block2;
                    }
                    boolean noRelationLinePass = false;
                    if (noRelationLineList.isEmpty()) {
                        noRelationLinePass = true;
                    } else {
                        Set<String> preNodesForNoRelation = noRelationLineList.stream().map(TaskFlowLine::getSourceNodeNum).collect(Collectors.toSet());
                        boolean isFinished = NodeInstanceUtil.checkNodeAllComplete(flowInstanceId, preNodesForNoRelation);
                        if (isFinished) {
                            noRelationLinePass = true;
                        }
                    }
                    log.info("TaskFlowServiceHelper#getLockedOrgIds flowInstanceId={}, reportId={}, noRelationLinePass={}", new Object[]{flowInstanceId, reportId, matchLineList.size(), noRelationLinePass});
                    if (!noRelationLinePass) continue;
                    int matchOutputLines = 0;
                    block7: for (TaskFlowLine taskFlowLine4 : matchLineList) {
                        TaskTransRelation relation3 = taskFlowLine4.getTransRelation();
                        List detailList = relation3.getDetailList();
                        for (TaskTransRelationDetail detail : detailList) {
                            Set outputOrgIds = detail.getOutputOrgIds();
                            if (!outputOrgIds.contains(submitOrgId)) continue;
                            Set inputOrgIds = detail.getInputOrgIds();
                            boolean isAuditPass = TaskFlowServiceHelper.isAuditPassForOrgIds(flowInstanceId, taskFlowLine4.getSourceNodeNum(), inputOrgIds);
                            if (!isAuditPass) continue;
                            ++matchOutputLines;
                            continue block7;
                        }
                    }
                    log.info("TaskFlowServiceHelper#getLockedOrgIds flowInstanceId={}, reportId={}, matchLineList size={}, matchOutputLines={}", new Object[]{flowInstanceId, reportId, matchLineList.size(), matchOutputLines});
                    boolean hasRelationLinePass = matchOutputLines == matchLineList.size();
                    if (!hasRelationLinePass) continue;
                    log.info("TaskFlowServiceHelper#getLockedOrgIds flowInstanceId={}, reportId={}, hasRelationLinePass=true, noRelationLinePass=true", (Object)flowInstanceId, (Object)reportId);
                    passedReportIds.add(reportId);
                    continue block2;
                }
                if (hasRelationLineList.isEmpty()) continue;
                TaskFlowLine taskFlowLine = (TaskFlowLine)taskFlowLineList.get(0);
                relation = taskFlowLine.getTransRelation();
                List detailList = relation.getDetailList();
                for (TaskTransRelationDetail detail : detailList) {
                    Set outputOrgIds = detail.getOutputOrgIds();
                    if (!outputOrgIds.contains(submitOrgId)) continue;
                    Set inputOrgIds = detail.getInputOrgIds();
                    boolean isAuditPass = TaskFlowServiceHelper.isAuditPassForOrgIds(flowInstanceId, taskFlowLine.getSourceNodeNum(), inputOrgIds);
                    if (!isAuditPass) continue;
                    log.info("TaskFlowServiceHelper#getLockedOrgIds flowInstanceId={}, reportId={}, isJoinNode=false, isAuditPass=true", (Object)flowInstanceId, (Object)reportId);
                    passedReportIds.add(reportId);
                    continue block2;
                }
            }
        }
        HashMap<Long, Set<Long>> hashMap = new HashMap<Long, Set<Long>>(16);
        Set set = reportOrgMap.keySet();
        log.info("TaskFlowServiceHelper#getLockedOrgIds flowInstanceIds={}, match flow reportIds={}, passedReportIds={}", new Object[]{flowInstanceIds, set, passedReportIds});
        if (passedReportIds.size() != set.size()) {
            Set lockedReportIds = set.stream().filter(id -> !passedReportIds.contains(id)).collect(Collectors.toSet());
            for (Long lockReportId : lockedReportIds) {
                Long lockOrgId = (Long)reportOrgMap.get(lockReportId);
                hashMap.computeIfAbsent(lockOrgId, v -> new HashSet(16)).add(lockReportId);
            }
        }
        return hashMap;
    }

    public static boolean canUnaudit(Long approveBillId) {
        log.info("TaskFlowServiceHelper#canUnaudit approveBillId={}, start", (Object)approveBillId);
        Map<Long, List<Long>> billReportMap = ApproveUtils.getInstance().getReportProcessIdsByBillIds(Collections.singleton(approveBillId));
        if (CollectionUtils.isEmpty(billReportMap)) {
            log.info("TaskFlowServiceHelper#canUnaudit approveBillId={}, billReportMap is empty", (Object)approveBillId);
            return true;
        }
        HashSet<Long> reportIds = new HashSet<Long>(16);
        billReportMap.values().stream().forEach(ids -> reportIds.addAll((Collection<Long>)ids));
        List<NodeInstance> nodeInstanceList = NodeInstanceUtil.getInsByTarObjs(reportIds, null);
        if (CollectionUtils.isEmpty(nodeInstanceList)) {
            log.error("TaskFlowServiceHelper#canUnaudit approveBillId={}, nodeInstanceList is empty", (Object)approveBillId);
            return true;
        }
        Set<Long> flowInstanceIds = nodeInstanceList.stream().map(NodeInstance::getFlowInstanceId).collect(Collectors.toSet());
        Map<Long, Long> instFlowMap = BizFlowInstanceUtil.getFowIdByInsId(flowInstanceIds);
        if (CollectionUtils.isEmpty(instFlowMap)) {
            log.error("TaskFlowServiceHelper#canUnaudit approveBillId={}, instFlowMap is empty", (Object)approveBillId);
            return true;
        }
        Map<Long, TaskFlowGraph> taskFlowGraphMap = TaskFlowServiceHelper.getTaskFlowGraphs(instFlowMap.values(), true);
        if (CollectionUtils.isEmpty(taskFlowGraphMap)) {
            log.error("TaskFlowServiceHelper#canUnaudit approveBillId={}, taskFlowGraphMap is empty", (Object)approveBillId);
            return true;
        }
        HashMap<String, Set> nodeOrgMap = new HashMap<String, Set>(16);
        for (NodeInstance nodeInstance : nodeInstanceList) {
            Long flowInstanceId = nodeInstance.getFlowInstanceId();
            String nodeKey = nodeInstance.getNodeKey();
            Long orgId = nodeInstance.getTaskDimMember();
            Set orgIds = nodeOrgMap.computeIfAbsent(flowInstanceId + "!" + nodeKey, v -> new HashSet(16));
            orgIds.add(orgId);
        }
        for (Map.Entry entry : nodeOrgMap.entrySet()) {
            List taskFlowLineList;
            String nodeKey;
            TaskFlowNode currentNode;
            String[] keyArr = ((String)entry.getKey()).split("!");
            Long flowInstanceId = IDUtils.toLong((Object)keyArr[0]);
            Long flowGraphId = instFlowMap.get(flowInstanceId);
            TaskFlowGraph taskFlowGraph = taskFlowGraphMap.get(flowGraphId);
            if (taskFlowGraph == null || (currentNode = taskFlowGraph.getNode(nodeKey = keyArr[1])) == null || CollectionUtils.isEmpty((Collection)(taskFlowLineList = taskFlowGraph.getNextLineByNode(currentNode.getNumber())))) continue;
            Set submitOrgIds = (Set)entry.getValue();
            for (TaskFlowLine taskFlowLine : taskFlowLineList) {
                TaskFlowNode nextFlowNode = taskFlowGraph.getNode(taskFlowLine.getTargetNodeNum());
                if (nextFlowNode.isEndNode()) continue;
                TaskTransRelation relation = taskFlowLine.getTransRelation();
                List relationList = null;
                if (relation != null) {
                    relationList = relation.getDetailList();
                }
                if (CollectionUtils.isEmpty(relationList)) {
                    List<NodeInstance> nextNodeInstanceList = NodeInstanceUtil.getNodeInstanceByNode(flowInstanceId, Collections.singleton(taskFlowLine.getTargetNodeNum()));
                    Set orgIds = nextNodeInstanceList.stream().map(NodeInstance::getTaskDimMember).collect(Collectors.toSet());
                    boolean isProcessed = TaskFlowServiceHelper.isProcessedForOrgIds(flowInstanceId, taskFlowLine.getTargetNodeNum(), orgIds);
                    if (!isProcessed) continue;
                    log.error("TaskFlowServiceHelper#canUnaudit approveBillId={}, flowInstanceId={}, nodeKey={}, isProcessed is true, relation is null", new Object[]{approveBillId, flowInstanceId, nodeKey});
                    return false;
                }
                boolean isMatch = false;
                for (TaskTransRelationDetail detail : relationList) {
                    Set inputOrgIds = detail.getInputOrgIds();
                    Set intersection = inputOrgIds.stream().filter(item -> submitOrgIds.contains(item)).collect(Collectors.toSet());
                    if (!CollectionUtils.isNotEmpty(intersection)) continue;
                    isMatch = true;
                    Set outputOrgIds = detail.getOutputOrgIds();
                    boolean isProcessed = TaskFlowServiceHelper.isProcessedForOrgIds(flowInstanceId, taskFlowLine.getTargetNodeNum(), outputOrgIds);
                    if (!isProcessed) continue;
                    log.error("TaskFlowServiceHelper#canUnaudit approveBillId={}, flowInstanceId={}, nodeKey={}, isProcessed is true, isMatch=true", new Object[]{approveBillId, flowInstanceId, nodeKey});
                    return false;
                }
                if (isMatch) continue;
                List<NodeInstance> nextNodeInstanceList = NodeInstanceUtil.getNodeInstanceByNode(flowInstanceId, Collections.singleton(taskFlowLine.getTargetNodeNum()));
                Set<Long> orgIds = nextNodeInstanceList.stream().map(NodeInstance::getTaskDimMember).collect(Collectors.toSet());
                boolean isProcessed = TaskFlowServiceHelper.isProcessedForOrgIds(flowInstanceId, taskFlowLine.getTargetNodeNum(), orgIds);
                if (!isProcessed) continue;
                log.error("TaskFlowServiceHelper#canUnaudit approveBillId={}, flowInstanceId={}, nodeKey={}, isProcessed is true, isMatch=false", new Object[]{approveBillId, flowInstanceId, nodeKey});
                return false;
            }
        }
        log.info("TaskFlowServiceHelper#canUnaudit approveBillId={}, end", (Object)approveBillId);
        return true;
    }

    private static boolean isStartNodeForPreNode(List<TaskFlowLine> taskFlowLineList, TaskFlowGraph taskFlowGraph) {
        for (TaskFlowLine taskFlowLine : taskFlowLineList) {
            TaskFlowNode preFlowNode = taskFlowGraph.getNode(taskFlowLine.getSourceNodeNum());
            if (!preFlowNode.isStartNode()) continue;
            return true;
        }
        return false;
    }

    public static Set<Long> getOutputOrgIds(Long flowInstId, String nodeKey, List<TaskTransRelationDetail> relationDetailList, Set<Long> submitOrgIds) {
        if (CollectionUtils.isEmpty(submitOrgIds)) {
            log.error("TaskFlowServiceHelper#getOutputOrgIds submitOrgIds is empty");
            return Sets.newHashSet();
        }
        if (CollectionUtils.isEmpty(relationDetailList)) {
            log.error("TaskFlowServiceHelper#getOutputOrgIds detailList is empty");
            return Sets.newHashSet();
        }
        HashSet<Long> matchOutputOrgIds = new HashSet<Long>(16);
        for (TaskTransRelationDetail detail : relationDetailList) {
            boolean isAuditPass;
            Set inputOrgIds = detail.getInputOrgIds();
            Set intersection = submitOrgIds.stream().filter(item -> inputOrgIds.contains(item)).collect(Collectors.toSet());
            if (!CollectionUtils.isNotEmpty(intersection) || !(isAuditPass = TaskFlowServiceHelper.isAuditPassForOrgIds(flowInstId, nodeKey, inputOrgIds))) continue;
            Set outputOrgIds = detail.getOutputOrgIds();
            matchOutputOrgIds.addAll(outputOrgIds);
        }
        return matchOutputOrgIds;
    }

    private static boolean isProcessedForOrgIds(Long flowInstanceId, String nodeKey, Set<Long> orgIds) {
        List<NodeInstance> nodeInstances = NodeInstanceUtil.getNodeInstanceByOrg(flowInstanceId, orgIds, Collections.singletonList(nodeKey));
        if (CollectionUtils.isEmpty(nodeInstances)) {
            return false;
        }
        Set reportIds = nodeInstances.stream().map(NodeInstance::getRefObj).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "in", reportIds);
        DynamicObjectCollection reportList = QueryServiceHelper.query((String)"eb_reportprocess", (String)"id,status", (QFilter[])qFilter.toArray());
        for (DynamicObject report : reportList) {
            String reportStatus = report.getString("status");
            if (!BgTaskStateEnum.UNDERWAY.getNumber().equals(reportStatus) && !BgTaskStateEnum.COMPLETED.getNumber().equals(reportStatus)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAuditPassForOrgIds(Long flowInstanceId, String nodeKey, Set<Long> orgIds) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return false;
        }
        List<NodeInstance> nodeInstances = NodeInstanceUtil.getNodeInstanceByOrg(flowInstanceId, orgIds, Collections.singletonList(nodeKey));
        if (CollectionUtils.isEmpty(nodeInstances)) {
            return true;
        }
        Set reportIds = nodeInstances.stream().map(NodeInstance::getRefObj).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "in", reportIds);
        DynamicObjectCollection reportList = QueryServiceHelper.query((String)"eb_reportprocess", (String)"id,status", (QFilter[])qFilter.toArray());
        for (DynamicObject report : reportList) {
            String reportStatus = report.getString("status");
            if (BgTaskStateEnum.COMPLETED.getNumber().equals(reportStatus)) continue;
            return false;
        }
        return true;
    }

    public static Set<Long> getAuditPassedReportIds(Long flowInstanceId, String nodeKey, Set<Long> orgIds) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return Sets.newHashSet();
        }
        List<NodeInstance> nodeInstances = NodeInstanceUtil.getNodeInstanceByOrg(flowInstanceId, orgIds, Collections.singletonList(nodeKey));
        if (CollectionUtils.isEmpty(nodeInstances)) {
            return Sets.newHashSet();
        }
        HashSet<Long> auditPassedReportIds = new HashSet<Long>(16);
        Set reportIds = nodeInstances.stream().map(NodeInstance::getRefObj).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "in", reportIds);
        DynamicObjectCollection reportList = QueryServiceHelper.query((String)"eb_reportprocess", (String)"id,status", (QFilter[])qFilter.toArray());
        for (DynamicObject report : reportList) {
            Long reportId = report.getLong("id");
            String reportStatus = report.getString("status");
            if (!BgTaskStateEnum.COMPLETED.getNumber().equals(reportStatus)) continue;
            auditPassedReportIds.add(reportId);
        }
        return auditPassedReportIds;
    }

    public static TaskFlowGraph getTaskFlowGraph(Long taskFlowId) {
        DynamicObject object = BusinessDataServiceHelper.loadSingle((String)"eb_bgmtaskflow", (QFilter[])new QFilter("id", "=", (Object)taskFlowId).toArray());
        if (object != null) {
            return TaskFlowServiceHelper.getTaskFlowGraph(object);
        }
        return null;
    }

    public static Map<Long, TaskFlowGraph> getTaskFlowGraphs(Collection<Long> taskFlowIds) {
        return TaskFlowServiceHelper.getTaskFlowGraphs(taskFlowIds, false);
    }

    public static Map<Long, TaskFlowGraph> getTaskFlowGraphs(Collection<Long> taskFlowIds, boolean isQueryEnable) {
        Map objects;
        QFilter qFilter = new QFilter("id", "in", taskFlowIds);
        if (isQueryEnable) {
            qFilter.and("status", "=", (Object)"1");
        }
        if (!(objects = BusinessDataServiceHelper.loadFromCache((String)"eb_bgmtaskflow", (QFilter[])qFilter.toArray())).isEmpty()) {
            HashMap<Long, TaskFlowGraph> taskFlowGraphMap = new HashMap<Long, TaskFlowGraph>(16);
            for (DynamicObject object : objects.values()) {
                TaskFlowGraph taskFlowGraph = TaskFlowServiceHelper.getTaskFlowGraph(object);
                if (taskFlowGraph == null) continue;
                taskFlowGraphMap.put(taskFlowGraph.getId(), taskFlowGraph);
            }
            return taskFlowGraphMap;
        }
        return new HashMap<Long, TaskFlowGraph>(0);
    }

    public static TaskFlowGraph getTaskFlowGraph(DynamicObject object) {
        DynamicObjectCollection lineEntry;
        TaskFlowGraph taskFlowGraph = new TaskFlowGraph(Long.valueOf(object.getLong("id")));
        taskFlowGraph.setNumber(object.getString("number"));
        taskFlowGraph.setName(object.getString("name"));
        taskFlowGraph.setModelId(Long.valueOf(object.getLong("model.id")));
        taskFlowGraph.setOrgViewId(Long.valueOf(object.getLong("orgview.id")));
        taskFlowGraph.setYearId(Long.valueOf(object.getLong("year.id")));
        taskFlowGraph.setDataTypeId(Long.valueOf(object.getLong("datatype.id")));
        taskFlowGraph.setVersionId(Long.valueOf(object.getLong("version.id")));
        taskFlowGraph.setStatus(object.getBoolean("status"));
        DynamicObjectCollection nodeEntry = object.getDynamicObjectCollection("nodeentry");
        if (CollectionUtils.isNotEmpty((Collection)nodeEntry)) {
            for (DynamicObject ob : nodeEntry) {
                TaskFlowNode node = new TaskFlowNode(IDUtils.toLong((Object)ob.getPkValue()));
                node.setNumber(ob.getString("nodenumber"));
                node.setName(ob.getString("nodename"));
                node.setSubTaskIds(ob.getDynamicObjectCollection("subtasks").stream().map(e -> e.getLong("fbasedataid_id")).collect(Collectors.toList()));
                node.setNodeType(TaskFlowNodeType.APPROVE);
                node.setOrderSeq(ob.getInt("orderseq"));
                taskFlowGraph.addNode(node);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(lineEntry = object.getDynamicObjectCollection("lineentry")))) {
            List<Long> transRelationIds = lineEntry.stream().filter(e -> e.get("transrelation") != null).map(x -> x.getLong("transrelation.id")).collect(Collectors.toList());
            Map<Long, TaskTransRelation> taskTransRelationMap = TaskTransRelationServiceHelper.getTaskTransRelationMap(transRelationIds);
            for (DynamicObject ob : lineEntry) {
                TaskFlowLine nodeLine = new TaskFlowLine(IDUtils.toLong((Object)ob.getPkValue()));
                nodeLine.setNumber(ob.getString("linenumber"));
                nodeLine.setName(ob.getString("linename"));
                nodeLine.setSourceNodeNum(ob.getString("sourcenodenum"));
                nodeLine.setTargetNodeNum(ob.getString("targetnodenum"));
                nodeLine.setTransRelation(taskTransRelationMap.get(ob.getLong("transrelation.id")));
                taskFlowGraph.addLine(nodeLine);
            }
        }
        TaskFlowNode startNode = new TaskFlowNode(Long.valueOf(0L), "start", ResManager.loadKDString((String)"\u5f00\u59cb", (String)"TaskFlowServiceHelper_1", (String)"epm-eb-business", (Object[])new Object[0]));
        startNode.setNodeType(TaskFlowNodeType.START);
        startNode.setOrderSeq(0);
        TaskFlowNode endNode = new TaskFlowNode(Long.valueOf(0L), "end", ResManager.loadKDString((String)"\u7ed3\u675f", (String)"TaskFlowServiceHelper_2", (String)"epm-eb-business", (Object[])new Object[0]));
        endNode.setNodeType(TaskFlowNodeType.END);
        endNode.setOrderSeq(101);
        Collection nodes = taskFlowGraph.getNodeMap().values();
        Set collect = nodes.stream().map(TaskFlowNode::getOrderSeq).collect(Collectors.toSet());
        int minOrderSeq = collect.stream().min(Integer::compareTo).orElseGet(() -> 1);
        int maxOrderSeq = collect.stream().max(Integer::compareTo).orElseGet(() -> 100);
        for (TaskFlowNode node : nodes) {
            String nodeNum = node.getNumber();
            if (node.getOrderSeq() == minOrderSeq && CollectionUtils.isEmpty((Collection)taskFlowGraph.getNodePreRelLine(nodeNum))) {
                TaskFlowLine line = new TaskFlowLine(Long.valueOf(0L));
                line.setNumber(String.format("start-%s", node.getNumber()));
                line.setSourceNodeNum(startNode.getNumber());
                line.setTargetNodeNum(node.getNumber());
                taskFlowGraph.addLine(line);
            }
            List nextLineByNode = taskFlowGraph.getNextLineByNode(nodeNum);
            if (node.getOrderSeq() != maxOrderSeq || !CollectionUtils.isEmpty((Collection)nextLineByNode)) continue;
            TaskFlowLine line = new TaskFlowLine(Long.valueOf(0L));
            line.setNumber(String.format("end-%s", node.getNumber()));
            line.setSourceNodeNum(node.getNumber());
            line.setTargetNodeNum(endNode.getNumber());
            taskFlowGraph.addLine(line);
        }
        taskFlowGraph.addNode(startNode);
        taskFlowGraph.addNode(endNode);
        return taskFlowGraph;
    }

    public static int saveTaskFlowGraph(Collection<TaskFlowGraph> taskFlowGraphs) {
        ArrayList<DynamicObject> objects = new ArrayList<DynamicObject>(10);
        List<TaskTransRelation> relationList = TaskFlowServiceHelper.copyTaskFlowTransRelation(taskFlowGraphs);
        for (TaskFlowGraph taskFlowGraph : taskFlowGraphs) {
            DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"eb_bgmtaskflow");
            objects.add(object);
            object.set("number", (Object)taskFlowGraph.getNumber());
            object.set("name", (Object)taskFlowGraph.getName());
            object.set("model", (Object)taskFlowGraph.getModelId());
            object.set("orgview", (Object)taskFlowGraph.getOrgViewId());
            object.set("datatype", (Object)taskFlowGraph.getDataTypeId());
            object.set("version", (Object)taskFlowGraph.getVersionId());
            object.set("year", (Object)taskFlowGraph.getYearId());
            object.set("status", (Object)(taskFlowGraph.isStatus() ? "1" : "0"));
            DynamicObjectCollection nodeEntry = object.getDynamicObjectCollection("nodeentry");
            nodeEntry.clear();
            Map nodeMap = taskFlowGraph.getNodeMap();
            Collection taskFlowNodes = nodeMap.values();
            for (TaskFlowNode node : taskFlowNodes) {
                if (node.isStartNode() || node.isEndNode()) continue;
                DynamicObject newNode = nodeEntry.addNew();
                newNode.set("nodenumber", (Object)node.getNumber());
                newNode.set("nodename", (Object)node.getName());
                newNode.set("orderseq", (Object)node.getOrderSeq());
                newNode.set("nodetype", (Object)node.getNodeType().getValue());
                List subTaskIds = node.getSubTaskIds();
                if (!CollectionUtils.isNotEmpty((Collection)subTaskIds)) continue;
                DynamicObjectCollection subTaskObjects = newNode.getDynamicObjectCollection("subtasks");
                subTaskObjects.clear();
                for (Long subTaskId : subTaskIds) {
                    DynamicObject subTask = subTaskObjects.addNew();
                    subTask.set("fbasedataid", (Object)subTaskId);
                }
            }
            DynamicObjectCollection lineEntry = object.getDynamicObjectCollection("lineentry");
            lineEntry.clear();
            Map lineMap = taskFlowGraph.getLineMap();
            Collection taskFlowLines = lineMap.values();
            for (TaskFlowLine taskFlowLine : taskFlowLines) {
                String number = taskFlowLine.getNumber();
                if (number.startsWith("start-") || number.startsWith("end-")) continue;
                DynamicObject newLine = lineEntry.addNew();
                newLine.set("linenumber", (Object)number);
                newLine.set("linename", (Object)taskFlowLine.getName());
                newLine.set("sourcenodenum", (Object)taskFlowLine.getSourceNodeNum());
                newLine.set("targetnodenum", (Object)taskFlowLine.getTargetNodeNum());
                TaskTransRelation transRelation = taskFlowLine.getTransRelation();
                if (transRelation == null) continue;
                newLine.set("transrelation", (Object)transRelation.getId());
            }
        }
        try (TXHandle tx = TX.requiresNew((String)"saveTaskFlowGraph");){
            try {
                TaskTransRelationServiceHelper.saveTransRelations(relationList);
                SaveServiceHelper.save((DynamicObject[])objects.toArray(new DynamicObject[0]));
            }
            catch (Exception ex) {
                tx.markRollback();
                log.error("saveTaskFlowGraph-error:", (Throwable)ex);
                throw new KDBizException(CommonServiceHelper.getStackTraceStr((Throwable)ex));
            }
        }
        return objects.size();
    }

    private static List<TaskTransRelation> copyTaskFlowTransRelation(Collection<TaskFlowGraph> taskFlowGraphs) {
        ArrayList<TaskTransRelation> relations = new ArrayList<TaskTransRelation>(10);
        for (TaskFlowGraph taskFlowGraph : taskFlowGraphs) {
            Map lineMap = taskFlowGraph.getLineMap();
            for (TaskFlowLine value : lineMap.values()) {
                TaskTransRelation transRelation = value.getTransRelation();
                if (transRelation == null) continue;
                relations.add(transRelation);
            }
        }
        if (relations.size() > 0) {
            long[] ids = GlobalIdUtil.genGlobalLongIds((int)relations.size());
            int i = 0;
            for (TaskTransRelation relation : relations) {
                relation.setId(Long.valueOf(ids[i++]));
            }
        }
        return relations;
    }

    public static Set<String> getExistTaskFlowNumbers(Long modelId) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_bgmtaskflow", (String)"number", (QFilter[])new QFilter("model", "in", (Object)modelId).toArray());
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            return query.stream().map(e -> e.getString("number")).collect(Collectors.toSet());
        }
        return new HashSet<String>(0);
    }

    public static Map<Long, Map<Long, Set<Long>>> getTaskToOrgProcessMap(Collection<Long> subTaskIds, Long modelId, Long yearId, Long dataTypeId, Long versionId) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_taskprocess", (String)"task,org,template", (QFilter[])new QFilter("task", "in", subTaskIds).toArray());
        if (CollectionUtils.isEmpty((Collection)query)) {
            return new HashMap<Long, Map<Long, Set<Long>>>(0);
        }
        Map<String, Long> orgTemplateToProcessIdMap = TaskFlowServiceHelper.getOrgTemplateToProcessIdMap(modelId, yearId, dataTypeId, versionId);
        HashMap<Long, Map<Long, Set<Long>>> taskToOrgProcessMap = new HashMap<Long, Map<Long, Set<Long>>>();
        for (DynamicObject object : query) {
            String orgTemplate = object.getString("org") + "-" + object.getString("template");
            if (!orgTemplateToProcessIdMap.containsKey(orgTemplate)) continue;
            Map orgToProcessMap = taskToOrgProcessMap.computeIfAbsent(object.getLong("task"), e -> new HashMap(16));
            Set processIds = orgToProcessMap.computeIfAbsent(object.getLong("org"), e -> new HashSet(16));
            processIds.add(orgTemplateToProcessIdMap.get(orgTemplate));
        }
        return taskToOrgProcessMap;
    }

    public static Map<String, Long> getOrgTemplateToProcessIdMap(Long modelId, Long yearId, Long dataTypeId, Long versionId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("period", "=", (Object)yearId);
        qFilter.and("datatype", "=", (Object)dataTypeId);
        qFilter.and("version", "=", (Object)versionId);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_reportprocess", (String)"id,entity,template", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            return query.stream().collect(Collectors.toMap(e -> e.getString("entity") + "-" + e.getString("template"), e -> e.getLong("id")));
        }
        return new HashMap<String, Long>(0);
    }

    public static Map<String, List<NodeInstance>> getNodeInstancesMap(Map<Long, Map<Long, Set<Long>>> taskToOrgProcessMap, List<TaskFlowNode> nodeList) {
        HashMap<String, List<NodeInstance>> nodeInstancesMap = new HashMap<String, List<NodeInstance>>(nodeList.size());
        for (TaskFlowNode node : nodeList) {
            String nodeNum = node.getNumber();
            List taskIds = node.getSubTaskIds();
            if (CollectionUtils.isEmpty((Collection)taskIds)) continue;
            ArrayList<NodeInstance> nodeInstances = new ArrayList<NodeInstance>(10);
            for (Long taskId : taskIds) {
                Map<Long, Set<Long>> orgToProcessMap = taskToOrgProcessMap.get(taskId);
                if (CollectionUtils.isEmpty(orgToProcessMap)) continue;
                for (Map.Entry<Long, Set<Long>> orgToProcessEntry : orgToProcessMap.entrySet()) {
                    Long orgId = orgToProcessEntry.getKey();
                    Set<Long> processIds = orgToProcessEntry.getValue();
                    for (Long processId : processIds) {
                        NodeInstance nodeInstance = new NodeInstance();
                        nodeInstance.setNodeKey(nodeNum);
                        nodeInstance.setTaskDimMember(orgId);
                        nodeInstance.setRefObj(processId);
                        nodeInstances.add(nodeInstance);
                    }
                }
            }
            nodeInstancesMap.put(nodeNum, nodeInstances);
        }
        return nodeInstancesMap;
    }

    private static Map<TaskFlowGraph, List<TaskFlowNode>> getSubTaskRelTaskFlowNode(Collection<Long> subTaskIds) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_bgmtaskflow", (String)"id,nodeentry.nodenumber", (QFilter[])new QFilter("nodeentry.subtasks.fbasedataid", "in", subTaskIds).toArray());
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            HashMap<TaskFlowGraph, List<TaskFlowNode>> subTaskRelTaskFlowNodeMap = new HashMap<TaskFlowGraph, List<TaskFlowNode>>(16);
            Map<Long, TaskFlowGraph> taskFlowGraphMap = TaskFlowServiceHelper.getTaskFlowGraphs(query.stream().map(e -> e.getLong("id")).collect(Collectors.toSet()));
            for (DynamicObject object : query) {
                long taskFlowId = object.getLong("id");
                String nodeNum = object.getString("nodeentry.nodenumber");
                TaskFlowGraph taskFlowGraph = taskFlowGraphMap.get(taskFlowId);
                if (taskFlowGraph == null) continue;
                List taskFlowNodes = subTaskRelTaskFlowNodeMap.computeIfAbsent(taskFlowGraph, e -> new ArrayList(10));
                taskFlowNodes.add(taskFlowGraph.getNode(nodeNum));
            }
            return subTaskRelTaskFlowNodeMap;
        }
        return new HashMap<TaskFlowGraph, List<TaskFlowNode>>(0);
    }

    public static void executeTaskFlowNodeUpdate(Collection<Long> subTaskIds, Long modelId, Long yearId, Long versionId, Long dataTypeId) {
        if (subTaskIds.isEmpty()) {
            return;
        }
        Map<TaskFlowGraph, List<TaskFlowNode>> subTaskRelTaskFlowNode = TaskFlowServiceHelper.getSubTaskRelTaskFlowNode(subTaskIds);
        if (subTaskRelTaskFlowNode.isEmpty()) {
            return;
        }
        Map<Long, Map<Long, Set<Long>>> taskToOrgProcessMap = TaskFlowServiceHelper.getTaskToOrgProcessMap(subTaskIds, modelId, yearId, dataTypeId, versionId);
        for (Map.Entry<TaskFlowGraph, List<TaskFlowNode>> entry : subTaskRelTaskFlowNode.entrySet()) {
            TaskFlowGraph taskFlow = entry.getKey();
            List<TaskFlowNode> nodeList = entry.getValue();
            Map<String, List<NodeInstance>> nodeInstancesMap = TaskFlowServiceHelper.getNodeInstancesMap(taskToOrgProcessMap, nodeList);
            NodeUpdateEvent nodeUpdateEvent = new NodeUpdateEvent();
            nodeUpdateEvent.setFlowId(taskFlow.getId());
            nodeUpdateEvent.setUpNodeInstances(nodeInstancesMap);
            TaskFlowServiceHelper.executeTaskFlowNodeUpdate(nodeUpdateEvent);
        }
    }

    public static void startTaskFlow(TaskFlowGraph taskFlow) {
        if (taskFlow == null) {
            return;
        }
        HashSet<Long> subTaskIds = new HashSet<Long>(16);
        ArrayList<TaskFlowNode> taskFlowNodes = new ArrayList<TaskFlowNode>(taskFlow.getNodeMap().values());
        taskFlowNodes.removeIf(e -> e.isStartNode() || e.isEndNode());
        taskFlowNodes.forEach(e -> {
            if (e.getSubTaskIds() != null) {
                subTaskIds.addAll(e.getSubTaskIds());
            }
        });
        Map<Long, Map<Long, Set<Long>>> taskToOrgProcessMap = TaskFlowServiceHelper.getTaskToOrgProcessMap(subTaskIds, taskFlow.getModelId(), taskFlow.getYearId(), taskFlow.getDataTypeId(), taskFlow.getVersionId());
        Map<String, List<NodeInstance>> nodeInstancesMap = TaskFlowServiceHelper.getNodeInstancesMap(taskToOrgProcessMap, taskFlowNodes);
        NodeUpdateEvent nodeUpdateEvent = new NodeUpdateEvent();
        nodeUpdateEvent.setFlowId(taskFlow.getId());
        nodeUpdateEvent.setCheckInstance(true);
        nodeUpdateEvent.setUpNodeInstances(nodeInstancesMap);
        TaskFlowServiceHelper.executeTaskFlowNodeUpdate(nodeUpdateEvent);
    }

    public static void executeTaskFlowNodeUpdate(NodeUpdateEvent nodeUpdateEvent) {
        log.info("nodeUpdateEvent:" + SerializationUtils.toJsonString((Object)nodeUpdateEvent));
        BizFlowEventUtil.sendMessage(nodeUpdateEvent);
    }

    public static boolean isTaskFlow(IFormView formView) {
        String isTaskFlow;
        boolean result = false;
        if (formView != null && StringUtils.isNotEmpty((String)(isTaskFlow = (String)formView.getFormShowParameter().getCustomParam("isTaskFlow")))) {
            result = true;
        }
        return result;
    }

    public static Set<Long> getEnableFlowIds(Collection<Long> flowIds) {
        HashSet<Long> result = new HashSet<Long>(16);
        if (CollectionUtils.isNotEmpty(flowIds)) {
            QFBuilder qb = new QFBuilder();
            qb.add("id", "in", flowIds);
            qb.add("status", "=", (Object)"1");
            QueryServiceHelper.query((String)"eb_bgmtaskflow", (String)"id", (QFilter[])qb.toArrays()).forEach(obj -> result.add(obj.getLong("id")));
        }
        return result;
    }
}

