/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.taskflow;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.taskflow.TaskTransRelation;
import kd.epm.eb.common.taskflow.TaskTransRelationDetail;
import kd.epm.eb.common.utils.CollectionUtils;

public class TaskTransRelationServiceHelper {
    public static Map<Long, TaskTransRelation> getTaskTransRelationMap(Collection<Long> transRelationIds) {
        if (transRelationIds.isEmpty()) {
            return Maps.newHashMap();
        }
        Map relationMap = BusinessDataServiceHelper.loadFromCache((Object[])transRelationIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_tasktransrel"));
        if (CollectionUtils.isEmpty((Map)relationMap)) {
            return Maps.newHashMap();
        }
        HashMap<Long, TaskTransRelation> taskTransRelationMap = new HashMap<Long, TaskTransRelation>(relationMap.size());
        for (DynamicObject relation : relationMap.values()) {
            Long pkId = relation.getLong("id");
            TaskTransRelation taskTransRelation = new TaskTransRelation();
            taskTransRelation.setId(pkId);
            taskTransRelation.setNumber(relation.getString("number"));
            taskTransRelation.setName(relation.getString("name"));
            DynamicObjectCollection rowList = relation.getDynamicObjectCollection("entryentity");
            ArrayList<TaskTransRelationDetail> detailList = new ArrayList<TaskTransRelationDetail>(rowList.size());
            for (int i = 0; i < rowList.size(); ++i) {
                DynamicObject row = (DynamicObject)rowList.get(i);
                HashSet<Long> inputOrgIds = new HashSet<Long>(16);
                DynamicObjectCollection inputOrgList = row.getDynamicObjectCollection("taskinput");
                for (DynamicObject inputOrg : inputOrgList) {
                    Long orgId = inputOrg.getLong("fbasedataid_id");
                    inputOrgIds.add(orgId);
                }
                HashSet<Long> outOrgIds = new HashSet<Long>(16);
                DynamicObjectCollection outputOrgList = row.getDynamicObjectCollection("taskoutput");
                for (DynamicObject outputOrg : outputOrgList) {
                    Long orgId = outputOrg.getLong("fbasedataid_id");
                    outOrgIds.add(orgId);
                }
                TaskTransRelationDetail detail = new TaskTransRelationDetail();
                detail.setRow(i);
                detail.setName(row.getString("showname"));
                detail.setInputOrgIds(inputOrgIds);
                detail.setOutputOrgIds(outOrgIds);
                detailList.add(detail);
            }
            taskTransRelation.setDetailList(detailList);
            taskTransRelationMap.put(pkId, taskTransRelation);
        }
        return taskTransRelationMap;
    }

    public static void saveTransRelations(List<TaskTransRelation> relationList) {
        if (relationList.isEmpty()) {
            return;
        }
        ArrayList<DynamicObject> objects = new ArrayList<DynamicObject>(10);
        for (TaskTransRelation relation : relationList) {
            DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"eb_tasktransrel");
            object.set("id", (Object)relation.getId());
            object.set("number", (Object)relation.getNumber());
            object.set("name", (Object)relation.getName());
            object.set("model", (Object)relation.getModelId());
            object.set("orgviewid", (Object)relation.getOrgViewId());
            List detailList = relation.getDetailList();
            if (CollectionUtils.isNotEmpty((Collection)detailList)) {
                DynamicObjectCollection entryColl = object.getDynamicObjectCollection("entryentity");
                for (TaskTransRelationDetail detail : detailList) {
                    DynamicObject entry = entryColl.addNew();
                    entry.set("showname", (Object)detail.getName());
                    DynamicObjectCollection taskInputColl = entry.getDynamicObjectCollection("taskinput");
                    Set inputOrgIds = detail.getInputOrgIds();
                    for (Long inputOrgId : inputOrgIds) {
                        DynamicObject taskInput = taskInputColl.addNew();
                        taskInput.set("fbasedataid_id", (Object)inputOrgId);
                    }
                    DynamicObjectCollection taskOutputColl = entry.getDynamicObjectCollection("taskoutput");
                    Set outputOrgIds = detail.getOutputOrgIds();
                    for (Long outputOrgId : outputOrgIds) {
                        DynamicObject taskOutput = taskOutputColl.addNew();
                        taskOutput.set("fbasedataid_id", (Object)outputOrgId);
                    }
                    entry.set("remark", (Object)detail.getRemark());
                }
            }
            objects.add(object);
        }
        SaveServiceHelper.save((DynamicObject[])objects.toArray(new DynamicObject[0]));
    }
}

