/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.template;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.utils.StringUtils;

public class ApplyTemplateHelper {
    public static String createBillEntityTable(List<BaseColumn> columns, String tableEndName, String tableFullName, boolean isBiz) {
        String tableName;
        DBRoute dbRoute = new DBRoute("epm");
        StringBuilder str = new StringBuilder();
        if (StringUtils.isNotEmpty((String)tableFullName)) {
            tableName = tableFullName;
        } else if (StringUtils.isNotEmpty((String)tableEndName)) {
            tableName = "t_eb_rows" + tableEndName;
        } else {
            throw new KDBizException("tableName is empty!");
        }
        str.append("create table ").append(tableName).append('(');
        str.append("fid bigint default 0 not null, ");
        str.append("fbilltype nvarchar(100) default '', ");
        str.append("fbillnumber nvarchar(100) default '', ");
        str.append("fdatatype nvarchar(100) default '', ");
        str.append("fsubdata decimal(23,10) default 0 not null, ");
        str.append("fentryid bigint default 0 not null, ");
        str.append("ftemplateid bigint default 0 not null, ");
        str.append("frowindex int default 0 not null, ");
        str.append("fcombinedimension nvarchar(300) default '', ");
        str.append("fdetailid nvarchar(100) default '', ");
        str.append("fbusplandetail char(1) default '0',");
        if (isBiz) {
            str.append("fbizplantabkey nvarchar(100) default '',");
        }
        str.append("fcreator bigint default 0,");
        str.append("fcreatedate datetime,");
        str.append("fmodifier bigint default 0,");
        str.append("fmodifydate datetime,");
        for (BaseColumn column : columns) {
            str.append("f").append(column.getKey());
            String columnTypeSql = ApplyTemplateHelper.getColumnTypeSql(column);
            if (!StringUtils.isNotEmpty((String)columnTypeSql)) continue;
            str.append(columnTypeSql).append(',');
        }
        str.append("constraint eb_rows").append(tableName.substring(9)).append("pk primary key (fentryid))");
        if (DB.exitsTable((DBRoute)dbRoute, (String)tableName)) {
            DB.execute((DBRoute)dbRoute, (String)("drop table " + tableName));
        }
        DB.execute((DBRoute)dbRoute, (String)str.toString());
        return tableName;
    }

    public static String createBillEntityTable(List<BaseColumn> columns, String tableEndName, boolean isBiz) {
        return ApplyTemplateHelper.createBillEntityTable(columns, tableEndName, null, isBiz);
    }

    public static void addColumnsToEntryTable(List<BaseColumn> columns, String tableName) {
        DBRoute dbRoute = new DBRoute("epm");
        if (DB.exitsTable((DBRoute)dbRoute, (String)tableName)) {
            Map<String, String> fieldInfo = DB.getFieldInfo((DBRoute)dbRoute, (String)tableName).stream().collect(Collectors.toMap(field -> field.getFieldName(), field -> field.getDataType()));
            StringBuilder sb = new StringBuilder();
            for (BaseColumn column : columns) {
                String columnType = fieldInfo.get("f" + column.getKey());
                if (columnType != null) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u5b57\u6bb5(%1:%2)\u6807\u8bc6\u5df2\u5b58\u5728\uff0c\u8bf7\u5148\u5220\u9664\u8be5\u5217\uff0c\u7136\u540e\u91cd\u65b0\u914d\u7f6e\u3002", (String)"ApplyTemplateHelper_2", (String)"epm-eb-business", (Object[])new Object[]{column.getTitle(), column.getKey()}));
                }
                sb.append("alter table ").append(tableName).append(" add (f").append(column.getKey()).append(ApplyTemplateHelper.getColumnTypeSql(column)).append(");");
            }
            if (sb.length() > 0) {
                DB.execute((DBRoute)dbRoute, (String)sb.toString());
            }
        } else {
            throw new KDBizException(ResManager.loadResFormat((String)"\u6570\u636e\u8868\u201c%1\u201d\u4e0d\u5b58\u5728\u3002", (String)"ApplyTemplateHelper_1", (String)"epm-eb-business", (Object[])new Object[]{tableName}));
        }
    }

    private static String getColumnTypeSql(BaseColumn column) {
        String sql;
        switch (column.getFieldtype()) {
            case TextField: {
                sql = " nvarchar(600) default ''";
                break;
            }
            case EnumField: {
                sql = " nvarchar(100) default ''";
                break;
            }
            case LongText: {
                sql = " NCLOB";
                break;
            }
            case Boolean: {
                sql = " char(1) default '0'";
                break;
            }
            case IntField: {
                sql = " int default 0 not null";
                break;
            }
            case NumberField: {
                sql = " decimal(23,11) default 0 not null";
                break;
            }
            case BaseDataField: {
                sql = " bigint default 0 not null";
                break;
            }
            case Date: {
                sql = " datetime";
                break;
            }
            default: {
                sql = "";
            }
        }
        return sql;
    }
}

