/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.template;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.ebcommon.common.enums.MemberDisplayTypeEnum;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.template.FormulaTypeEnum;
import kd.epm.eb.common.utils.ExcelUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.Point;
import kd.epm.eb.common.utils.RangeModel;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.ebSpread.domain.view.SpreadSelector;
import kd.epm.eb.spread.command.rangedefined.CellArea;
import kd.epm.eb.spread.command.style.AreasStyle;
import kd.epm.eb.spread.command.style.CellStyleInfo;
import kd.epm.eb.spread.command.style.VerticalAlignEnum;
import kd.epm.eb.spread.control.ISpreadContainer;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.afix.multisetting.IMultiAreaSetting;
import kd.epm.eb.spread.template.partition.IPartitionSetting;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.utils.ReportHelper;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;

public class TemplateFormulaUtil {
    public static final String MODEL_ID = "MODEL_ID";
    public static final String DISPLAY_TYPE = "DISPLAY_TYPE";
    public static final String PROCESS_TYPE = "PROCESS_TYPE";
    public static final String PROCESS_ID = "PROCESS_ID";
    public static final String ENTITY_NUMBER = "ENTITY_NUMBER";
    public static final String ENTITY_VIEW_ID = "ENTITY_VIEW_ID";
    public static final String DATA_UNIT = "DATA_UNIT";
    public static final String ENTITY_PAGEVIEW = "ENTITY_PAGEVIEW";
    private static final TemplateFormulaUtil instance = new TemplateFormulaUtil();

    public static TemplateFormulaUtil getInstance() {
        return instance;
    }

    private boolean isClearFormula(Map<String, String> formulaMap) {
        if (formulaMap.size() == 0) {
            return true;
        }
        String clear = formulaMap.get("clear");
        return StringUtils.isNotEmpty((String)clear);
    }

    public void handleCellFormulaReturnValue(SpreadSelector spreadSelector, ISpreadContainer spreadContainer, Map<String, Map<String, String>> templateFormulaMap, Map<String, String> formulaMap) {
        if (spreadSelector == null || spreadContainer == null) {
            return;
        }
        if (this.isClearFormula(formulaMap)) {
            this.clearFormula(spreadSelector, spreadContainer, templateFormulaMap);
            return;
        }
        this.dealRetFormula(spreadSelector, spreadContainer, templateFormulaMap, formulaMap);
    }

    private void dealRetFormula(SpreadSelector spreadSelector, ISpreadContainer spreadContainer, Map<String, Map<String, String>> templateFormulaMap, Map<String, String> formulaMap) {
        List<String> formulaRecs = this.getCurAreaFormulasRec(spreadSelector, templateFormulaMap);
        if (formulaRecs.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u5b9a\u7684\u8303\u56f4\u591a\u4e2a\u5355\u5143\u683c\u5b58\u5728\u53d6\u6570\u51fd\u6570\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TemplateFormulaUtil_8", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        String rect = spreadSelector.getRect();
        if (formulaRecs.size() == 1) {
            templateFormulaMap.remove(formulaRecs.get(0));
        }
        templateFormulaMap.put(rect, formulaMap);
        ArrayList<CellArea> areas = new ArrayList<CellArea>(16);
        areas.add(new CellArea(spreadSelector.getRect()));
        spreadContainer.setSpan(areas);
        spreadContainer.setCellStyle(Collections.singletonList(this.getMergeCellStyle(areas)));
        spreadContainer.lockCells(areas);
        FormulaTypeEnum formulaType = FormulaTypeEnum.getTypeByNumber((String)formulaMap.get("formulaType"));
        String preText = formulaMap.get("preText");
        String value = (preText != null ? preText : "") + (formulaType != null ? formulaType.getDesc() : "");
        this.setCellValue(spreadContainer, spreadSelector.getRect(), value);
    }

    private AreasStyle getMergeCellStyle(List<CellArea> areas) {
        AreasStyle areasStyle = new AreasStyle();
        areasStyle.setRange(areas);
        CellStyleInfo cellStyleInfo = new CellStyleInfo();
        cellStyleInfo.setVa(VerticalAlignEnum.Center);
        areasStyle.setStyle(cellStyleInfo);
        areasStyle.setStyle(cellStyleInfo);
        return areasStyle;
    }

    private void clearFormula(SpreadSelector spreadSelector, ISpreadContainer spreadContainer, Map<String, Map<String, String>> templateFormulaMap) {
        List<String> formulaRecs = this.getCurAreaFormulasRec(spreadSelector, templateFormulaMap);
        if (formulaRecs.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u5b9a\u7684\u8303\u56f4\u591a\u4e2a\u5355\u5143\u683c\u5b58\u5728\u53d6\u6570\u51fd\u6570\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TemplateFormulaUtil_8", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        if (formulaRecs.size() == 1) {
            templateFormulaMap.remove(formulaRecs.get(0));
        }
        this.setCellValue(spreadContainer, spreadSelector.getRect(), null);
        this.clearFormulaCellStyle(spreadContainer, spreadSelector.getRect());
    }

    public List<String> getCurAreaFormulasRec(SpreadSelector spreadSelector, Map<String, Map<String, String>> templateFormulaMap) {
        String rect = spreadSelector.getRect();
        return templateFormulaMap.keySet().stream().filter(e -> ExcelUtils.isOverlap((String)rect, (String)e)).collect(Collectors.toList());
    }

    private void setCellValue(ISpreadContainer spreadContainer, String formulaRec, String value) {
        CellArea area = new CellArea(formulaRec);
        ArrayList<ECell> cells = new ArrayList<ECell>(16);
        ECell cell = new ECell();
        cell.setRowAndCol(area.getR(), area.getC());
        cell.setValue((Object)value);
        cells.add(cell);
        spreadContainer.updateCellValue2(cells);
    }

    private void clearFormulaCellStyle(ISpreadContainer spreadContainer, String formulaRec) {
        ArrayList<CellArea> areas = new ArrayList<CellArea>(16);
        areas.add(new CellArea(formulaRec));
        spreadContainer.clearCellsStyle(areas);
        spreadContainer.unlockCells(areas);
    }

    public boolean isInDynamicAreaRange(String selectorRec, String areaRec) {
        RangeModel a = new RangeModel(selectorRec);
        Point point = ExcelUtils.pos2Point((String)areaRec);
        return a.getXEnd() >= point.x && a.getYEnd() >= point.y;
    }

    private boolean isInFixAreaRange(String selectorRec, List<IMultiAreaSetting> areaRanges) {
        for (IMultiAreaSetting areaRange : areaRanges) {
            if (!ExcelUtils.isOverlap((String)selectorRec, (String)areaRange.getAreaRange())) continue;
            return true;
        }
        return false;
    }

    public void showFormulaPage(AbstractFormPlugin plugin, SpreadSelector spreadSelector, ITemplateModel templateModel, boolean isFix) {
        if (!this.formulaAreaCheck(plugin, spreadSelector, templateModel, isFix)) {
            return;
        }
        boolean showEntityPageView = !templateModel.getRowcolDims().contains(SysDimensionEnum.Entity.getNumber());
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCustomParam("showEntityPageView", (Object)showEntityPageView);
        formShowParameter.setFormId("eb_formulaparam");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        Map<String, String> notAreaFormulaCell = this.getNotAreaFormulaCell(spreadSelector, templateModel.getFormulaMap());
        if (notAreaFormulaCell.size() != 0) {
            notAreaFormulaCell.forEach((arg_0, arg_1) -> ((FormShowParameter)formShowParameter).setCustomParam(arg_0, arg_1));
        }
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "setFormula"));
        plugin.getView().showForm(formShowParameter);
    }

    private boolean formulaAreaCheck(AbstractFormPlugin plugin, SpreadSelector spreadSelector, ITemplateModel templateModel, boolean isFix) {
        if (spreadSelector == null) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u8bbe\u7f6e\u51fd\u6570\u7684\u8303\u56f4\u3002", (String)"TemplateFormulaUtil_0", (String)"epm-eb-business", (Object[])new Object[0]));
            return false;
        }
        boolean isInAreaRange = false;
        String rect = spreadSelector.getRect();
        if (isFix) {
            List areaRanges = templateModel.getAreaRanges();
            isInAreaRange = this.isInFixAreaRange(rect, areaRanges);
        } else {
            IPartitionSetting partitionSetting = templateModel.getPartitionSetting();
            if (partitionSetting == null) {
                return true;
            }
            String startPosition = partitionSetting.getPartitionInfo().getStartposition();
            isInAreaRange = this.isInDynamicAreaRange(rect, startPosition);
        }
        if (isInAreaRange) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u533a\u57df\u8303\u56f4\u5185\u4e0d\u5141\u8bb8\u5f15\u7528\u516c\u5f0f\u53d6\u6570\u3002", (String)"TemplateFormulaUtil_1", (String)"epm-eb-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private Map<String, String> getNotAreaFormulaCell(SpreadSelector spreadSelector, Map<String, Map<String, String>> formulaMap) {
        if (spreadSelector == null || formulaMap == null) {
            return new HashMap<String, String>(16);
        }
        List<String> formulaRecs = this.getCurAreaFormulasRec(spreadSelector, formulaMap);
        if (formulaRecs.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u5b9a\u7684\u8303\u56f4\u591a\u4e2a\u5355\u5143\u683c\u5b58\u5728\u53d6\u6570\u51fd\u6570\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TemplateFormulaUtil_2", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        return formulaRecs.size() == 0 ? new HashMap<String, String>(16) : formulaMap.get(formulaRecs.get(0));
    }

    public void refreshUnitFormulaCell(ISpreadContainer spreadContainer, Map<String, Map<String, String>> formulaMap, String unit) {
        ArrayList cells = new ArrayList(16);
        formulaMap.forEach((key, value) -> {
            String formulaType = (String)value.get("formulaType");
            FormulaTypeEnum typeByNumber = FormulaTypeEnum.getTypeByNumber((String)formulaType);
            if (FormulaTypeEnum.UNIT == typeByNumber) {
                RangeModel rangeModel = new RangeModel(key);
                int row = rangeModel.getYStart();
                int col = rangeModel.getXStart();
                String preText = (String)value.get("preText");
                ECell cell = new ECell();
                cell.setRowAndCol(row, col);
                cell.setValue((Object)((preText == null ? "" : preText) + this.getUnitName(unit)));
                cells.add(cell);
            }
        });
        if (cells.size() != 0) {
            spreadContainer.updateCellValue2(cells);
        }
    }

    public static Map<String, Object> ofDatasMap(String processType, Long processId, String entityNumber, String dataUnit, Long modelId, int displayTypeIndex, Long entityViewId, String entityPageView) {
        HashMap<String, Object> datas = new HashMap<String, Object>(16);
        datas.put(MODEL_ID, modelId);
        datas.put(PROCESS_TYPE, processType);
        datas.put(PROCESS_ID, processId);
        datas.put(ENTITY_NUMBER, entityNumber);
        datas.put(ENTITY_VIEW_ID, entityViewId);
        datas.put(DATA_UNIT, dataUnit);
        datas.put(DISPLAY_TYPE, displayTypeIndex);
        datas.put(ENTITY_PAGEVIEW, entityPageView);
        return datas;
    }

    public void replaceFormulaCellValue(ISpreadContainer spreadContainer, Map<String, Map<String, String>> formulaMap, Map<String, Object> datas) {
        if (spreadContainer == null || formulaMap == null || datas == null) {
            return;
        }
        ArrayList cells = new ArrayList(16);
        ArrayList<CellArea> areas = new ArrayList<CellArea>(16);
        Long modelId = IDUtils.toLong((Object)datas.get(MODEL_ID));
        String processType = datas.get(PROCESS_TYPE) == null ? "" : (String)datas.get(PROCESS_TYPE);
        Long processId = IDUtils.toLong((Object)datas.get(PROCESS_ID));
        int displayTypeIndex = datas.get(DISPLAY_TYPE) == null ? MemberDisplayTypeEnum.NAME.getIndex() : Integer.parseInt(datas.get(DISPLAY_TYPE) + "");
        String entityNumber = datas.get(ENTITY_NUMBER) == null ? "" : (String)datas.get(ENTITY_NUMBER);
        Long entityViewId = IDUtils.toLong((Object)datas.get(ENTITY_VIEW_ID));
        String dataUnit = datas.get(DATA_UNIT) == null ? "" : (String)datas.get(DATA_UNIT);
        String entityPageView = datas.get(ENTITY_PAGEVIEW) == null ? "" : (String)datas.get(ENTITY_PAGEVIEW);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        List longDisplayDimNums = ReportHelper.getLongDisplayDimNums((int)displayTypeIndex, (IModelCacheHelper)modelCacheHelper);
        boolean hasEntityLongDisplay = longDisplayDimNums.contains(SysDimensionEnum.Entity.getNumber());
        formulaMap.forEach((key, value) -> {
            RangeModel rangeModel = new RangeModel(key);
            int row = rangeModel.getYStart();
            int col = rangeModel.getXStart();
            ECell cell = new ECell();
            cell.setRowAndCol(row, col);
            if (FormulaTypeEnum.ENTITY_PAGEVIEW.getNumber().equals(value.get("formulaType"))) {
                String formulaValue;
                String preText = (String)value.get("preText");
                String string = formulaValue = StringUtils.isEmpty((String)processType) ? FormulaTypeEnum.ENTITY_PAGEVIEW.getDesc() : entityPageView;
                if (preText == null) {
                    cell.setValue((Object)formulaValue);
                } else {
                    cell.setValue((Object)(preText + formulaValue));
                }
            } else {
                cell.setValue((Object)this.getShowValue((Map<String, String>)value, processType, processId, entityNumber, dataUnit, modelId, displayTypeIndex, entityViewId, hasEntityLongDisplay));
            }
            cells.add(cell);
            areas.add(new CellArea(key));
        });
        if (cells.size() != 0) {
            spreadContainer.setSpan(areas);
            spreadContainer.setCellStyle(Collections.singletonList(this.getMergeCellStyle(areas)));
            spreadContainer.updateCellValue2(cells);
        }
    }

    private String getShowValue(Map<String, String> formulaInfo, String processType, Long processId, String entityNumber, String dataUnit, Long modelId, int displayTypeIndex, Long entityViewId, boolean hasEntityLongDisplay) {
        String preText = formulaInfo.get("preText");
        String formulaType = formulaInfo.get("formulaType");
        String formulaValue = this.getFormulaValue(dataUnit, formulaType, processType, processId, entityNumber, modelId, displayTypeIndex, entityViewId, hasEntityLongDisplay);
        return (preText == null ? "" : preText) + formulaValue;
    }

    public String getFormulaValue(String dataUnit, String formulaType, String processType, Long processId, String entityNumber, Long modelId, int displayTypeIndex, Long entityViewId, boolean hasEntityLongDisplay) {
        if (StringUtils.isEmpty((String)formulaType)) {
            return "";
        }
        if (StringUtils.isEmpty((String)processType)) {
            return this.getSelfDesc(formulaType);
        }
        FormulaTypeEnum typeByNumber = FormulaTypeEnum.getTypeByNumber((String)formulaType);
        if (FormulaTypeEnum.UNIT == typeByNumber) {
            return this.getUnitName(dataUnit);
        }
        if (FormulaTypeEnum.ENTITY == typeByNumber) {
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), entityViewId, entityNumber);
            String formulaValue = "";
            String simpleName = "";
            if (member != null) {
                if (MemberDisplayTypeEnum.NAME.getIndex() == displayTypeIndex) {
                    formulaValue = member.getName();
                } else if (MemberDisplayTypeEnum.NUMBER.getIndex() == displayTypeIndex) {
                    formulaValue = member.getNumber();
                } else if (MemberDisplayTypeEnum.NAMEANDNUMBER.getIndex() == displayTypeIndex) {
                    formulaValue = member.getName() + ":" + member.getNumber();
                } else if (MemberDisplayTypeEnum.SIMNAMENUMBER.getIndex() == displayTypeIndex) {
                    simpleName = StringUtils.isEmpty((String)member.getSimpleName()) ? member.getName() : member.getSimpleName();
                    formulaValue = simpleName + ":" + member.getNumber();
                } else if (MemberDisplayTypeEnum.SIMPLENAME.getIndex() == displayTypeIndex) {
                    formulaValue = StringUtils.isEmpty((String)member.getSimpleName()) ? member.getName() : member.getSimpleName();
                } else if (MemberDisplayTypeEnum.LONGNAME.getIndex() == displayTypeIndex) {
                    formulaValue = hasEntityLongDisplay ? member.getLongName(modelCacheHelper.getParentsByOrder(entityViewId, member, false)) : member.getName();
                } else if (MemberDisplayTypeEnum.LONGNUMBER.getIndex() == displayTypeIndex) {
                    formulaValue = hasEntityLongDisplay ? member.getLongNumber() : member.getNumber();
                } else if (MemberDisplayTypeEnum.LONGNAMENUMBER.getIndex() == displayTypeIndex) {
                    formulaValue = hasEntityLongDisplay ? member.getLongName(modelCacheHelper.getParentsByOrder(entityViewId, member, false)) + ":" + member.getLongNumber() : member.getName() + ":" + member.getNumber();
                }
            }
            return formulaValue;
        }
        if (ProcessTypeEnum.REPORT.getNumber().equals(processType)) {
            return this.getFormulaValueFromRptScheme(processId, typeByNumber);
        }
        return this.getFormulaValueFromTask(modelId, processId, typeByNumber);
    }

    private String getFormulaValueFromRptScheme(Long processId, FormulaTypeEnum typeByNumber) {
        DynamicObject schemeAssign = BusinessDataServiceHelper.loadSingleFromCache((Object)processId, (String)"eb_schemeassign");
        if (schemeAssign == null) {
            return null;
        }
        if (FormulaTypeEnum.BUDGET == typeByNumber) {
            return schemeAssign.getString("year.name");
        }
        return schemeAssign.getString("version.name");
    }

    private String getFormulaValueFromTask(Long modelId, Long processId, FormulaTypeEnum typeByNumber) {
        Collection taskListIds = ReportVarUtil.getTaskListFromTaskProcess((Long)modelId, (Long)processId);
        Long taskListId = (Long)taskListIds.iterator().next();
        DynamicObject query = QueryServiceHelper.queryOne((String)"eb_tasklist", (String)"year.name, version.name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taskListId)});
        if (FormulaTypeEnum.BUDGET == typeByNumber) {
            return query.getString("year.name");
        }
        return query.getString("version.name");
    }

    private String getSelfDesc(String formulaType) {
        FormulaTypeEnum typeByNumber = FormulaTypeEnum.getTypeByNumber((String)formulaType);
        if (typeByNumber == null) {
            return "";
        }
        return typeByNumber.getDesc();
    }

    private String getUnitName(String unit) {
        int dataUnit;
        try {
            dataUnit = Integer.parseInt(unit);
        }
        catch (Exception e) {
            dataUnit = 0;
        }
        return ReportHelper.getDataUnitName((int)dataUnit);
    }

    public void updateFormulaMap(Map<String, Map<String, String>> formulaMap, List<Integer> rowIndexes, List<Integer> colIndexes) {
        if (formulaMap.size() == 0) {
            return;
        }
        HashMap<String, String> replaceMap = new HashMap<String, String>(16);
        ArrayList deleteList = new ArrayList(16);
        formulaMap.forEach((key, value) -> {
            CellArea area = new CellArea(key);
            int row = area.getR();
            int col = area.getC();
            if (rowIndexes != null && rowIndexes.contains(row) || colIndexes != null && colIndexes.contains(col)) {
                deleteList.add(key);
            } else {
                int sums;
                if (rowIndexes != null && (sums = this.existLargerSums(row, rowIndexes)) != 0) {
                    replaceMap.put((String)key, this.getAfterRemoveRec(area, sums, true));
                }
                if (colIndexes != null && (sums = this.existLargerSums(col, colIndexes)) != 0) {
                    String rec = (String)replaceMap.get(key);
                    if (StringUtils.isNotEmpty((String)rec)) {
                        area = new CellArea(rec);
                    }
                    replaceMap.put((String)key, this.getAfterRemoveRec(area, sums, false));
                }
            }
        });
        deleteList.forEach(formulaMap::remove);
        HashMap<String, Map<String, String>> tmp = new HashMap<String, Map<String, String>>(formulaMap);
        HashMap<String, Map> newValue = new HashMap<String, Map>(formulaMap.size());
        ArrayList oldKey = new ArrayList(16);
        replaceMap.forEach((key, value) -> {
            Map formula = (Map)tmp.get(key);
            if (formula != null) {
                newValue.put((String)value, formula);
                oldKey.add(key);
            }
        });
        oldKey.forEach(formulaMap::remove);
        newValue.forEach((key, vaule) -> formulaMap.put((String)key, (Map<String, String>)vaule));
    }

    private String getAfterRemoveRec(CellArea area, int sums, boolean isRow) {
        int row = area.getR();
        int col = area.getC();
        String startPos = isRow ? ExcelUtils.xy2Pos((int)col, (int)(row - sums)) : ExcelUtils.xy2Pos((int)(col - sums), (int)row);
        String endPos = isRow ? ExcelUtils.xy2Pos((int)(col + area.getCc() - 1), (int)(row - sums + area.getRc() - 1)) : ExcelUtils.xy2Pos((int)(col + area.getCc() - sums - 1), (int)(row + area.getRc() - 1));
        return startPos + ":" + endPos;
    }

    private int existLargerSums(int index, List<Integer> indexes) {
        int sum = 0;
        for (Integer integer : indexes) {
            if (integer >= index) continue;
            ++sum;
        }
        return sum;
    }

    public List<ECell> getAllAreaCells(String rec, String formulaValue, boolean isDivideCell) {
        RangeModel rangeModel = new RangeModel(rec);
        int row = rangeModel.getYStart();
        int col = rangeModel.getXStart();
        ArrayList<ECell> cells = new ArrayList<ECell>(16);
        if (!isDivideCell) {
            ECell cell = new ECell();
            cell.setRowAndCol(row, col);
            cell.setValue((Object)formulaValue);
            cells.add(cell);
        } else {
            int rowEnd = rangeModel.getYEnd();
            int colEnd = rangeModel.getXEnd();
            for (int i = row; i <= rowEnd; ++i) {
                for (int j = col; j <= colEnd; ++j) {
                    ECell cell = new ECell();
                    cell.setRowAndCol(i, j);
                    cell.setValue((Object)formulaValue);
                    cells.add(cell);
                }
            }
        }
        return cells;
    }

    public void clearAllFormulas(ISpreadContainer spreadContainer, Map<String, Map<String, String>> templateFormulaMap, boolean isNeedRemoveTemplate) {
        Iterator<Map.Entry<String, Map<String, String>>> templateFormulaIterator = templateFormulaMap.entrySet().iterator();
        while (templateFormulaIterator.hasNext()) {
            Map.Entry<String, Map<String, String>> templateFormula = templateFormulaIterator.next();
            this.setCellValue(spreadContainer, templateFormula.getKey(), null);
            this.clearFormulaCellStyle(spreadContainer, templateFormula.getKey());
            if (!isNeedRemoveTemplate) continue;
            templateFormulaIterator.remove();
        }
    }

    public void clearFormulas(ISpreadContainer spreadContainer, Map<String, Map<String, String>> templateFormulaMap, Set<String> keys) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        for (String key : keys) {
            this.setCellValue(spreadContainer, key, null);
            this.clearFormulaCellStyle(spreadContainer, key);
            if (templateFormulaMap == null) continue;
            templateFormulaMap.remove(key);
        }
    }

    public void checkExistFormula(IFormView view, ISpreadContainer spreadContainer, String position, Map<String, Map<String, String>> templateFormulaMap) {
        if (templateFormulaMap == null || templateFormulaMap.size() == 0) {
            return;
        }
        for (Map.Entry<String, Map<String, String>> templateFormula : templateFormulaMap.entrySet()) {
            String rec = templateFormula.getKey();
            if (!ExcelUtils.isOverlap((String)rec, (String)position)) continue;
            this.setCellValue(spreadContainer, templateFormula.getKey(), this.getShowValue(templateFormula.getValue(), null, 0L, null, null, 0L, MemberDisplayTypeEnum.NAME.getIndex(), 0L, false));
            view.showErrorNotification(ResManager.loadKDString((String)"\u8be5\u533a\u57df\u5df2\u8bbe\u7f6e\u7f16\u5236\u5c5e\u6027\uff0c\u65e0\u6cd5\u6e05\u9664\u5185\u5bb9\u3002", (String)"TemplateFormulaUtil_11", (String)"epm-eb-business", (Object[])new Object[0]));
        }
    }

    public static boolean hasSetFormula(Map<String, Map<String, String>> formulaMap, String type) {
        if (formulaMap == null || type == null) {
            return false;
        }
        for (Map<String, String> map : formulaMap.values()) {
            if (!type.equals(map.get("formulaType"))) continue;
            return true;
        }
        return false;
    }

    public void replaceOutAreaLinkInfoCellValue(ISpreadContainer spreadContainer, Map<String, Map<String, String>> outAreaLinkInfo) {
        if (spreadContainer == null || outAreaLinkInfo == null) {
            return;
        }
        ArrayList cells = new ArrayList(16);
        ArrayList areas = new ArrayList(16);
        CellStyleInfo cellStyleInfo = new CellStyleInfo();
        cellStyleInfo.setFrc("#0000FF");
        outAreaLinkInfo.forEach((key, value) -> {
            RangeModel rangeModel = new RangeModel(key);
            int row = rangeModel.getYStart();
            int col = rangeModel.getXStart();
            ECell cell = new ECell();
            cell.setRowAndCol(row, col);
            String name = (String)value.get("name");
            cell.setValue((Object)name);
            cells.add(cell);
            areas.add(new CellArea(key));
        });
        if (cells.size() != 0) {
            AreasStyle areasStyle = new AreasStyle();
            areasStyle.setRange(areas);
            areasStyle.setStyle(cellStyleInfo);
            spreadContainer.setCellStyle(Collections.singletonList(areasStyle));
            spreadContainer.lockECells(cells);
            spreadContainer.updateCellValue2(cells);
        }
    }
}

