/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.template;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.template.entity.TemplateTaskDto;
import kd.epm.eb.common.applyTemplate.TempDimConfig;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.ColumnList;
import kd.epm.eb.common.applytemplatecolumn.DimensionDataColumn;
import kd.epm.eb.common.applytemplatecolumn.RowDimensionColumn;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.rule.relation.pojo.TemplateTaskMemberDto;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.base.DbUtils;
import kd.epm.eb.common.utils.base.ObjUtils;
import kd.epm.eb.common.utils.base.StrUtils;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateModelJSONUtil;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarCommonUtil;
import org.apache.commons.lang3.StringUtils;

public class TemplateTaskService {
    private static final Log log = LogFactory.getLog(TemplateTaskService.class);

    public static TemplateTaskService getInstance() {
        return InnerClass.instance;
    }

    private TemplateTaskService() {
    }

    public Map<Long, Set<Long>> listTaskIds(Set<Long> templateIds) {
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(templateIds)) {
            return Maps.newConcurrentMap();
        }
        ConcurrentMap taskIdMap = Maps.newConcurrentMap();
        long pageSize = 300L;
        int page = 1;
        while ((long)(page - 1) * pageSize < (long)templateIds.size()) {
            this.pageQueryToTaskMap(templateIds, taskIdMap, pageSize, page);
            ++page;
        }
        return taskIdMap;
    }

    private void pageQueryToTaskMap(Set<Long> templateIds, Map<Long, Set<Long>> taskIdMap, long pageSize, int page) {
        Set subSet = templateIds.stream().skip((long)(page - 1) * pageSize).limit(pageSize).collect(Collectors.toSet());
        String sql = "select t.ftasklistid,templ.ftemplateid from t_eb_taskreftemplate templ, t_eb_task t where templ.fid = t.fid and templ.ftemplateid in (" + StringUtils.join(subSet, (String)",") + ")";
        try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"epm"), (String)sql, (Object[])new Object[0]);){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long tasklistid = row.getLong("ftasklistid");
                Long templateid = row.getLong("ftemplateid");
                taskIdMap.computeIfAbsent(templateid, v -> Sets.newHashSet()).add(tasklistid);
            }
        }
    }

    public Map<Long, Set<Long>> listRptSchemaIds(Set<Long> templateIds) {
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(templateIds)) {
            return Maps.newConcurrentMap();
        }
        ConcurrentMap schemaIdMap = Maps.newConcurrentMap();
        long pageSize = 300L;
        int page = 1;
        while ((long)(page - 1) * pageSize < (long)templateIds.size()) {
            this.pageQueryToMap(templateIds, schemaIdMap, pageSize, page);
            ++page;
        }
        return schemaIdMap;
    }

    private void pageQueryToMap(Set<Long> templateIds, Map<Long, Set<Long>> schemaIdMap, long pageSize, int page) {
        Set subSet = templateIds.stream().skip((long)(page - 1) * pageSize).limit(pageSize).collect(Collectors.toSet());
        String sql = "select fschemeid,ftemplateid from t_eb_templateorg where ftemplateid in(" + StringUtils.join(subSet, (String)",") + ")";
        try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"epm"), (String)sql, (Object[])new Object[0]);){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long schemeid = row.getLong("fschemeid");
                Long templateid = row.getLong("ftemplateid");
                schemaIdMap.computeIfAbsent(templateid, v -> Sets.newHashSet()).add(schemeid);
            }
        }
    }

    public List<TemplateTaskDto> getApplyTemplateScope(Collection<DynamicObject> templates) {
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(templates)) {
            return Collections.emptyList();
        }
        long modelId = templates.iterator().next().getLong("model.id");
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Set<Long> tIds = templates.stream().map(t -> t.getLong("id")).collect(Collectors.toSet());
        Map<Long, Set<Long>> schemaIdMap = this.listRptSchemaIds(tIds);
        HashSet<Long> schemeIds = new HashSet<Long>(16);
        for (Set<Long> schemeIdSet : schemaIdMap.values()) {
            schemeIds.addAll(schemeIdSet);
        }
        Map<Long, Set<Long>> schemaAssignIdMap = this.listSchemaAssignIds(schemeIds);
        HashMap schemaAssignVarMap = Maps.newHashMap();
        ArrayList dtos = Lists.newArrayList();
        for (DynamicObject template : templates) {
            long templateId = template.getLong("id");
            String number = template.getString("number");
            String name = template.getString("name");
            long datasetId = template.getLong("dataset.id");
            Set schemaIds = schemaIdMap.computeIfAbsent(templateId, v -> Sets.newHashSet());
            Map viewMap = modelCache.getViewsByDataSet(Long.valueOf(datasetId));
            try {
                HashMap<String, Set<String>> memberMap = new HashMap<String, Set<String>>(16);
                String cachedataJson = template.getString("cachedata_tag");
                List allDimConfig = SerializationUtils.fromJsonStringToList((String)cachedataJson, TempDimConfig.class);
                List hidDims = allDimConfig.stream().filter(e -> StringUtils.startsWith((CharSequence)e.getKey(), (CharSequence)"hid")).collect(Collectors.toList());
                for (TempDimConfig hidDim : hidDims) {
                    memberMap.put(hidDim.getDimensionNumber(), Collections.singleton(hidDim.getMemberNumber()));
                }
                String entrycfgJson = template.getString("entrycfgjson_tag");
                ColumnList columnList = (ColumnList)SerializationUtils.fromJsonString((String)entrycfgJson, ColumnList.class);
                List columns = columnList.getColumns().stream().filter(e -> "h".equals(e.getCategory()) && (e instanceof RowDimensionColumn || e instanceof DimensionDataColumn)).collect(Collectors.toList());
                if (columns.stream().filter(e -> e instanceof DimensionDataColumn).count() < 1L) {
                    log.warn("\u65e0\u7ef4\u5ea6\u6570\u636e\u5217\uff0c\u4e0d\u505a\u7ed1\u5b9a:" + number);
                    continue;
                }
                for (BaseColumn col : columns) {
                    if (col instanceof RowDimensionColumn) {
                        RowDimensionColumn rowCol = (RowDimensionColumn)col;
                        String dimNumber = rowCol.getDimNumber();
                        rowCol.getDimensionMemberRanges().forEach(c -> {
                            Set memberSet = memberMap.computeIfAbsent(dimNumber, v -> Sets.newHashSet());
                            List members = modelCache.getMember(dimNumber, (Long)viewMap.get(dimNumber), c.getNumber(), RangeEnum.getRangeByVal((String)c.getScope()).getIndex());
                            memberSet.addAll(members.stream().map(BaseCache::getNumber).collect(Collectors.toSet()));
                        });
                        continue;
                    }
                    if (!(col instanceof DimensionDataColumn)) continue;
                    DimensionDataColumn dataCol = (DimensionDataColumn)col;
                    dataCol.getDataMapDimensions().forEach(c -> {
                        String dimNum = c.getDimNum();
                        Set memberSet = memberMap.computeIfAbsent(dimNum, v -> Sets.newHashSet());
                        memberSet.add(c.getMembNum());
                    });
                }
                for (Long schemeId : schemaIds) {
                    Set<Long> schemeAssignIds = schemaAssignIdMap.get(schemeId);
                    for (Long schemeAssignId : schemeAssignIds) {
                        Map varValues = schemaAssignVarMap.computeIfAbsent(schemeAssignId, v -> ReportVarUtil.getVarValues((String)ProcessTypeEnum.REPORT.getNumber(), (Long)modelId, (Long)schemeAssignId, (String)"1"));
                        for (Map.Entry entry : memberMap.entrySet()) {
                            String dimNumber = (String)entry.getKey();
                            Set memSet = (Set)entry.getValue();
                            HashSet newSet = Sets.newHashSet();
                            for (String member : memSet) {
                                if (TemplateVarCommonUtil.checkIsVar((String)member, (String)dimNumber).booleanValue()) {
                                    String realDimByVar = ReportVarUtil.getRealDimByVar((Long)modelId, (String)member, (String)dimNumber, (Map)varValues);
                                    newSet.add(realDimByVar);
                                    continue;
                                }
                                newSet.add(member);
                            }
                            memberMap.put(dimNumber, newSet);
                        }
                    }
                }
                TemplateTaskDto dto = new TemplateTaskDto(templateId, name, memberMap);
                dtos.add(dto);
            }
            catch (Exception ignore) {
                log.error("\u7533\u62a5\u6a21\u677f\u8303\u56f4\u89e3\u6790\u5931\u8d25\uff1a" + number, (Throwable)ignore);
            }
        }
        return dtos;
    }

    public List<TemplateTaskDto> getTemplateOrTaskScope(Collection<DynamicObject> templates, long businessModelId, boolean needAnalyzeVar) {
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(templates)) {
            return Collections.emptyList();
        }
        long modelId = templates.iterator().next().getLong("model.id");
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)modelId);
        CopyOnWriteArrayList<TemplateTaskDto> dtos = new CopyOnWriteArrayList<TemplateTaskDto>();
        ConcurrentMap entityChildCache = Maps.newConcurrentMap();
        ConcurrentMap taskScopeMap = Maps.newConcurrentMap();
        ConcurrentMap schemaScopeMap = Maps.newConcurrentMap();
        Set<Long> tIds = templates.stream().map(t -> t.getLong("id")).collect(Collectors.toSet());
        Map<Long, Set<Long>> taskIdMap = this.listTaskIds(tIds);
        Map<Long, Set<Long>> schemaIdMap = this.listRptSchemaIds(tIds);
        HashSet<Long> schemeIds = new HashSet<Long>(16);
        for (Set<Long> schemeIdSet : schemaIdMap.values()) {
            schemeIds.addAll(schemeIdSet);
        }
        Map<Long, Set<Long>> schemaAssignIdMap = this.listSchemaAssignIds(schemeIds);
        HashSet<Long> taskIds = new HashSet<Long>(16);
        for (Set<Long> taskIdSet : taskIdMap.values()) {
            taskIds.addAll(taskIdSet);
        }
        Map<Long, List<Map<String, Object>>> taskOrgMap = this.listTaskOrgs(taskIds);
        Map<Long, List<DynamicObject>> schemaOrgMap = this.listSchemaOrgs(schemeIds);
        ConcurrentMap schemaAssignVarMap = Maps.newConcurrentMap();
        CountDownLatch latch = new CountDownLatch(templates.size());
        for (DynamicObject template : templates) {
            EpmThreadPools.EVENT_POOL.execute(() -> {
                try {
                    long templateId = template.getLong("id");
                    String name = template.getString("name");
                    List taskOrgs = taskOrgMap.computeIfAbsent(templateId, v -> Lists.newArrayList());
                    List schemas = schemaOrgMap.computeIfAbsent(templateId, v -> Lists.newArrayList());
                    ITemplateModel templateModel = TemplateModelJSONUtil.parseITemplateModel((String)template.getString("data"));
                    if (templateModel == null) {
                        log.warn("\u6a21\u677f\u5bf9\u5e94\u7684templateModel\u4e3a\u7a7a:" + name);
                        return;
                    }
                    String varbaseforeb = template.getString("varbaseforeb");
                    if (!"1".equals(varbaseforeb)) {
                        List<Map<String, Set<TemplateTaskMemberDto>>> templateScopeList = this.getTemplateScope(template, memberPropCache);
                        Set<TemplateTaskMemberDto> entityMember = this.getTaskAndSchemeEntityMember(modelCache, taskOrgs, schemas, entityChildCache, templateModel);
                        dtos.add(new TemplateTaskDto((Long)templateId, name, templateScopeList, entityMember));
                        return;
                    }
                    List<Object> memberScopeList = new ArrayList(16);
                    Set<TemplateTaskMemberDto> entityMember = new HashSet<TemplateTaskMemberDto>(16);
                    if (needAnalyzeVar) {
                        Set taskListIds = taskIdMap.computeIfAbsent(templateId, v -> Sets.newHashSet());
                        for (Object taskListId : taskListIds) {
                            try {
                                Map varValues = taskScopeMap.computeIfAbsent(taskListId, arg_0 -> TemplateTaskService.lambda$null$16(modelId, (Long)taskListId, templateId, arg_0));
                                List memberMapList = templateModel.retrieveQuoteMembersWithChildrenByColumn(modelId, memberPropCache, varValues);
                                memberScopeList.addAll(memberMapList);
                            }
                            catch (Exception e) {
                                log.warn("taskListId not variable,id:" + taskListId, (Throwable)e);
                            }
                        }
                        Set set = schemaIdMap.computeIfAbsent(templateId, v -> Sets.newHashSet());
                        for (Long schemeId : set) {
                            Set schemeAssignIds = (Set)schemaAssignIdMap.get(schemeId);
                            if (org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)schemeAssignIds)) {
                                for (Long schemeAssignId : schemeAssignIds) {
                                    try {
                                        Map varValues = schemaAssignVarMap.computeIfAbsent(schemeAssignId, v -> ReportVarUtil.getVarValues((String)ProcessTypeEnum.REPORT.getNumber(), (Long)modelId, (Long)schemeAssignId, (String)"1"));
                                        Map memberMap = templateModel.retrieveQuoteMembersWithChildren(modelId, memberPropCache, varValues);
                                        List memberMapList = templateModel.retrieveQuoteMembersWithChildrenByColumn(modelId, memberPropCache, varValues);
                                        memberScopeList.addAll(memberMapList);
                                    }
                                    catch (Exception e) {
                                        log.warn("schemeAssign not variable,id:" + schemeAssignId, (Throwable)e);
                                    }
                                }
                            }
                            try {
                                Map varValues = schemaScopeMap.computeIfAbsent(schemeId, v -> ReportVarUtil.getVarValuesByScheme((Long)modelId, (Long)schemeId));
                                List memberMapList = templateModel.retrieveQuoteMembersWithChildrenByColumn(modelId, memberPropCache, varValues);
                                memberScopeList.addAll(memberMapList);
                            }
                            catch (Exception e) {
                                log.warn("scheme not variable,schemeId:" + schemeId, (Throwable)e);
                            }
                        }
                        entityMember = this.getTaskAndSchemeEntityMember(modelCache, taskOrgs, schemas, entityChildCache, templateModel);
                    } else {
                        memberScopeList = this.getTemplateScopeNoVar(template, memberPropCache);
                        for (Map map : memberScopeList) {
                            Set entityNumbers = (Set)map.get(SysDimensionEnum.Entity.getNumber());
                            if (entityNumbers == null || !entityNumbers.isEmpty()) continue;
                            map.remove(SysDimensionEnum.Entity.getNumber());
                        }
                    }
                    dtos.add(new TemplateTaskDto((Long)templateId, name, memberScopeList, entityMember));
                }
                finally {
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new KDBizException("error getTemplateOrTaskScope");
        }
        return dtos;
    }

    private Map<Long, List<Map<String, Object>>> listTaskOrgs(Set<Long> taskIds) {
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(taskIds)) {
            return Maps.newConcurrentMap();
        }
        Map<Object, Object> taskOrgs = Maps.newConcurrentMap();
        List rowMapList = DbUtils.getRowMapList((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"epm"), (String)StrUtils.format((String)"select forgid,forgviewid,ftemplateid from t_eb_taskprocess where ftaskid in (select fid from t_eb_task where ftasklistid in {})", (Object[])new Object[]{DbUtils.getInValueString(taskIds)}), null);
        if (org.apache.commons.collections4.CollectionUtils.isEmpty((Collection)rowMapList)) {
            return taskOrgs;
        }
        taskOrgs = rowMapList.stream().collect(Collectors.groupingBy(e -> ObjUtils.getLong(e.get("ftemplateid"))));
        return taskOrgs;
    }

    private Map<Long, List<DynamicObject>> listSchemaOrgs(Set<Long> schemeIds) {
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(schemeIds)) {
            return Maps.newConcurrentMap();
        }
        Map<Object, Object> schemaOrgs = Maps.newConcurrentMap();
        QFilter filter = new QFilter("scheme_id", "in", schemeIds);
        Map templateOrg = BusinessDataServiceHelper.loadFromCache((String)"eb_templateorg", (QFilter[])filter.toArray());
        if (templateOrg == null || templateOrg.size() == 0) {
            return schemaOrgs;
        }
        schemaOrgs = templateOrg.values().stream().filter(e -> e.getDynamicObject("template") != null).collect(Collectors.groupingBy(e -> e.getDynamicObject("template").getLong("id")));
        return schemaOrgs;
    }

    private Map<Long, Set<Long>> listSchemaAssignIds(Set<Long> schemeIds) {
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(schemeIds)) {
            return Maps.newConcurrentMap();
        }
        ConcurrentMap schemaAssignIdMap = Maps.newConcurrentMap();
        long pageSize = 300L;
        int page = 1;
        while ((long)(page - 1) * pageSize < (long)schemeIds.size()) {
            this.pageQuerySchemeAssignToMap(schemeIds, schemaAssignIdMap, pageSize, page);
            ++page;
        }
        return schemaAssignIdMap;
    }

    private void pageQuerySchemeAssignToMap(Set<Long> schemeIds, Map<Long, Set<Long>> schemaAssignIdMap, long pageSize, int page) {
        Set subSet = schemeIds.stream().skip((long)(page - 1) * pageSize).limit(pageSize).collect(Collectors.toSet());
        String sql = "select fid,fschemeid from t_eb_schemeassign where fschemeid in(" + StringUtils.join(subSet, (String)",") + ")";
        try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"epm"), (String)sql, (Object[])new Object[0]);){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long schemeAssignId = row.getLong("fid");
                Long schemeid = row.getLong("fschemeid");
                schemaAssignIdMap.computeIfAbsent(schemeid, v -> Sets.newHashSet()).add(schemeAssignId);
            }
        }
    }

    public List<Map<String, Set<TemplateTaskMemberDto>>> getTemplateScope(DynamicObject template, MemberPropCache memberPropCache) {
        String data = template.getString("data");
        if (StringUtils.isBlank((CharSequence)data)) {
            log.warn("\u8001\u7684\u56fa\u5b9a\u62a5\u8868\u4e0d\u5904\u7406");
            return Collections.emptyList();
        }
        ITemplateModel templateModel = TemplateModelJSONUtil.parseITemplateModel((String)data);
        if (templateModel == null) {
            log.warn("\u62a5\u8868\u6a21\u677f\u4e3a\u7a7a");
            return Collections.emptyList();
        }
        long modelId = template.getLong("model.id");
        List dimScopeList = templateModel.retrieveQuoteMembersWithChildrenByColumn(modelId, memberPropCache, null);
        if (dimScopeList == null || dimScopeList.isEmpty()) {
            log.warn("\u7ef4\u5ea6\u8303\u56f4\u4e3a\u7a7a");
            return Collections.emptyList();
        }
        return dimScopeList;
    }

    public List<Map<String, Set<TemplateTaskMemberDto>>> getTemplateScopeNoVar(DynamicObject template, MemberPropCache memberPropCache) {
        String data = template.getString("data");
        if (StringUtils.isBlank((CharSequence)data)) {
            log.warn("\u8001\u7684\u56fa\u5b9a\u62a5\u8868\u4e0d\u5904\u7406");
            return Collections.emptyList();
        }
        ITemplateModel templateModel = TemplateModelJSONUtil.parseITemplateModel((String)data);
        if (templateModel == null) {
            log.warn("\u62a5\u8868\u6a21\u677f\u4e3a\u7a7a");
            return Collections.emptyList();
        }
        long modelId = template.getLong("model.id");
        List dimScopeList = templateModel.retrieveQuoteMembersWithChildrenByColumn(modelId, memberPropCache, null);
        if (dimScopeList == null || dimScopeList.isEmpty()) {
            log.warn("\u7ef4\u5ea6\u8303\u56f4\u4e3a\u7a7a");
            return Collections.emptyList();
        }
        HashSet hasVarDim = Sets.newHashSetWithExpectedSize((int)10);
        Map quoteMembers = templateModel.retrieveQuoteMembers();
        block0: for (Map.Entry entry : quoteMembers.entrySet()) {
            String dimNumber = (String)entry.getKey();
            Collection members = (Collection)entry.getValue();
            for (String memNumber : members) {
                if (!TemplateVarCommonUtil.checkIsVar((String)memNumber, (String)dimNumber).booleanValue()) continue;
                hasVarDim.add(dimNumber);
                continue block0;
            }
        }
        ArrayList<Map<String, Set<TemplateTaskMemberDto>>> templateDimMapList = new ArrayList<Map<String, Set<TemplateTaskMemberDto>>>(16);
        for (Map map : dimScopeList) {
            HashMap templateDimMap = new HashMap(16);
            map.forEach((key, value) -> {
                if (!hasVarDim.contains(key)) {
                    templateDimMap.put(key, new HashSet(value));
                }
            });
            templateDimMapList.add(templateDimMap);
        }
        return templateDimMapList;
    }

    private Set<TemplateTaskMemberDto> getTaskAndSchemeEntityMember(IModelCacheHelper modelCache, List<Map<String, Object>> taskOrgs, List<DynamicObject> schemas, Map<String, Set<TemplateTaskMemberDto>> entityChildCache, ITemplateModel templateModel) {
        Set<TemplateTaskMemberDto> schemeOrg;
        Set<TemplateTaskMemberDto> taskOrg;
        Long modelId = modelCache.getModelobj().getId();
        HashSet<TemplateTaskMemberDto> entityMemberSet = new HashSet<TemplateTaskMemberDto>(16);
        if (templateModel == null || templateModel.getPagemembentry() == null || templateModel.getPagemembentry().stream().noneMatch(e -> SysDimensionEnum.Entity.getNumber().equals(e.getDimension().getNumber()))) {
            return entityMemberSet;
        }
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(taskOrgs) && org.apache.commons.collections4.CollectionUtils.isNotEmpty(taskOrg = this.getTaskOrg(modelId, taskOrgs, entityChildCache, modelCache))) {
            entityMemberSet.addAll(taskOrg);
        }
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(schemas) && org.apache.commons.collections4.CollectionUtils.isNotEmpty(schemeOrg = this.getSchemeOrg(modelCache, schemas, entityChildCache))) {
            entityMemberSet.addAll(schemeOrg);
        }
        return entityMemberSet;
    }

    private Set<TemplateTaskMemberDto> getTaskOrg(long modelId, List<Map<String, Object>> taskOrgs, Map<String, Set<TemplateTaskMemberDto>> entityChildCache, IModelCacheHelper modelCacheHelper) {
        LinkedHashSet orgNumberStringSet = Sets.newLinkedHashSet();
        HashMap memberMap = Maps.newHashMap();
        for (Map<String, Object> org : taskOrgs) {
            Long forgidLong = ConvertUtils.toLong((Object)org.get("forgid"));
            Long forgviewidLong = ConvertUtils.toLong((Object)org.get("forgviewid"));
            Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), forgviewidLong, forgidLong);
            if (member == null) continue;
            Set longNumberSets = memberMap.computeIfAbsent(forgviewidLong, f -> Sets.newLinkedHashSet());
            if (CollectionUtils.includeByStarts((String)(member.getLongNumber() + '!'), (Collection)longNumberSets)) continue;
            longNumberSets.add(member.getLongNumber() + '!');
            Set memberSet = entityChildCache.computeIfAbsent(forgviewidLong + "_" + member.getNumber(), v -> {
                List entityList = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), forgviewidLong, member.getNumber(), RangeEnum.ALL.getIndex());
                return entityList.stream().map(e -> new TemplateTaskMemberDto(forgviewidLong, e.getNumber())).collect(Collectors.toSet());
            });
            orgNumberStringSet.addAll(memberSet);
        }
        return orgNumberStringSet;
    }

    private Set<TemplateTaskMemberDto> getSchemeOrg(IModelCacheHelper modelCache, List<DynamicObject> schemas, Map<String, Set<TemplateTaskMemberDto>> entityChildCache) {
        Long modelId = modelCache.getModelobj().getId();
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue() || org.apache.commons.collections4.CollectionUtils.isEmpty(schemas)) {
            return Sets.newHashSet();
        }
        LinkedHashSet orgSet = Sets.newLinkedHashSet();
        for (DynamicObject object : schemas) {
            DynamicObject scheme = object.getDynamicObject("scheme");
            DynamicObject org = object.getDynamicObject("org");
            if (org == null) {
                log.info("scheme\u5bf9\u5e94\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff01\u5bf9\u5e94\u5bf9\u8c61\uff1a" + object);
                continue;
            }
            String orgNumber = org.getString("number");
            Long orgViewId = scheme.getLong("orgview.id");
            Set memberSet = entityChildCache.computeIfAbsent(orgViewId + "_" + orgNumber, v -> {
                List entityList = modelCache.getMember(SysDimensionEnum.Entity.getNumber(), orgViewId, orgNumber, RangeEnum.ALL.getIndex());
                return entityList.stream().map(e -> new TemplateTaskMemberDto(orgViewId, e.getNumber())).collect(Collectors.toSet());
            });
            orgSet.addAll(memberSet);
        }
        return orgSet;
    }

    private static /* synthetic */ Map lambda$null$16(long modelId, Long taskListId, long templateId, Long v) {
        return ReportVarUtil.getVarValueByTaskList((Long)modelId, (Long)taskListId, (Long)templateId);
    }

    private static class InnerClass {
        private static TemplateTaskService instance = new TemplateTaskService();

        private InnerClass() {
        }
    }
}

