/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.templateperm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.ViewMember;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.cache.threadlocal.EpmThreadLocalUtils;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.pojo.BasedataPojo;
import kd.epm.eb.common.templateperm.EntityTypeEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.IDUtils;

public class TemplatePermQueryUtil {
    public static RowMeta getRowMeta() {
        ArrayList<Field> fields = new ArrayList<Field>(8);
        fields.add(new Field("usertype", (DataType)DataType.StringType));
        fields.add(new Field("name", (DataType)DataType.StringType));
        fields.add(new Field("number", (DataType)DataType.StringType));
        fields.add(new Field("model", (DataType)DataType.StringType));
        fields.add(new Field("templatetype", (DataType)DataType.StringType));
        fields.add(new Field("templatename", (DataType)DataType.StringType));
        fields.add(new Field("templatenumber", (DataType)DataType.StringType));
        fields.add(new Field("entityname", (DataType)DataType.StringType));
        fields.add(new Field("entitynumber", (DataType)DataType.StringType));
        fields.add(new Field("entityrange", (DataType)DataType.StringType));
        fields.add(new Field("entity_viewgroup", (DataType)DataType.StringType));
        fields.add(new Field("entityexclude", (DataType)DataType.BooleanType));
        fields.add(new Field("permsource", (DataType)DataType.StringType));
        return new RowMeta(fields.toArray(new Field[0]));
    }

    public static void addAncestors(Set<Long> ancestors, Dimension dimension, List<Long> toQueryEntityIds, Map<Long, BasedataPojo> baseDataMap, Long memberId, Long entityViewId) {
        Long parentId;
        Member member = dimension.getMember(entityViewId, memberId);
        if (member == null) {
            return;
        }
        if (baseDataMap != null) {
            BasedataPojo basedataPojo = new BasedataPojo(memberId, member.getName(), member.getNumber());
            baseDataMap.put(memberId, basedataPojo);
        }
        if ((parentId = member.getParentId()) == null || parentId == 0L) {
            return;
        }
        if (ancestors.add(parentId)) {
            toQueryEntityIds.add(parentId);
            TemplatePermQueryUtil.addAncestors(ancestors, dimension, toQueryEntityIds, baseDataMap, parentId, entityViewId);
        }
    }

    public static Map<DynamicObject, Long> removeNotIncludeRecord(DynamicObjectCollection records, Map<Long, BasedataPojo> baseDataMap, Set<Long> selectedEntityIds, long modelId, Long entityViewId) {
        if (records.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<DynamicObject, Long> recordToViewIdMap = new HashMap<DynamicObject, Long>(16);
        ArrayList<DynamicObject> toRemoveRecords = new ArrayList<DynamicObject>(16);
        HashSet<Long> userIds = new HashSet<Long>(16);
        HashSet<Long> applyTemplates = new HashSet<Long>(16);
        HashSet<Long> templates = new HashSet<Long>(16);
        HashSet<Long> viewGroupIds = new HashSet<Long>(16);
        Map<Long, List<Long>> viewGroupToViewMap = TemplatePermQueryUtil.getViewGroupToViewMap(modelId);
        HashMap<String, Boolean> containCache = new HashMap<String, Boolean>(records.size());
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)modelId);
        String dimNumber = SysDimensionEnum.Entity.getNumber();
        Dimension dimension = modelCacheHelper.getDimension(dimNumber);
        for (DynamicObject record : records) {
            CustomPropertyValue propertyValue;
            Long entityId = record.getLong("entityid");
            Long viewGroupId = record.getLong("viewgroup");
            Member entityMember = TemplatePermQueryUtil.getViewMember(dimension, viewGroupToViewMap.get(viewGroupId), entityId);
            if (entityId != 0L && entityMember == null && memberPropCache.getPropertyValue("Entity", entityId) == null) {
                toRemoveRecords.add(record);
                continue;
            }
            boolean retain = true;
            String entityRange = record.getString("entity_range");
            String entityType = record.getString("entitytype");
            Long viewId = entityMember == null ? entityViewId : ((ViewMember)entityMember).getViewId();
            recordToViewIdMap.put(record, viewId);
            if (EntityTypeEnum.ENTITY.getCode().equals(entityType) && selectedEntityIds.size() != 0) {
                boolean contain = false;
                if (entityId != 0L && IDUtils.isNotEmptyLong((Long)viewId).booleanValue()) {
                    if (entityMember != null) {
                        String memNumber = entityMember.getNumber();
                        String containKey = '.' + dimNumber + '.' + viewId + '.' + memNumber + '.' + entityRange;
                        Boolean containTmp = (Boolean)containCache.get(containKey);
                        if (containTmp != null) {
                            contain = containTmp;
                        } else {
                            List members = EpmThreadLocalUtils.getMemberRange((long)modelId, (String)dimNumber, (long)viewId, (String)memNumber, (int)Integer.parseInt(entityRange));
                            for (Member mem : members) {
                                if (!selectedEntityIds.contains(mem.getId())) continue;
                                contain = true;
                                break;
                            }
                            containCache.put(containKey, contain);
                        }
                    }
                    if (!contain) {
                        retain = false;
                    }
                }
            }
            if (!retain) {
                toRemoveRecords.add(record);
                continue;
            }
            if (baseDataMap == null) continue;
            TemplatePermQueryUtil.addQuerySet(baseDataMap, record, userIds, "userid");
            TemplatePermQueryUtil.addQuerySet(baseDataMap, record, applyTemplates, "applytemplate");
            TemplatePermQueryUtil.addQuerySet(baseDataMap, record, templates, "templateid");
            TemplatePermQueryUtil.addQuerySet(baseDataMap, record, viewGroupIds, "viewgroup");
            if (baseDataMap.containsKey(entityId) || entityId == 0L) continue;
            if (EntityTypeEnum.ENTITY.getCode().equals(entityType)) {
                if (entityMember == null) continue;
                BasedataPojo basedataPojo = new BasedataPojo(entityId, entityMember.getName(), entityMember.getShowNumber());
                baseDataMap.put(entityId, basedataPojo);
                continue;
            }
            if (!EntityTypeEnum.DEFINED_PROPERTY.getCode().equals(entityType) || (propertyValue = memberPropCache.getPropertyValue("Entity", entityId)) == null) continue;
            BasedataPojo basedataPojo = new BasedataPojo(entityId, propertyValue.getName(), propertyValue.getNumber());
            baseDataMap.put(entityId, basedataPojo);
        }
        toRemoveRecords.forEach(arg_0 -> ((DynamicObjectCollection)records).remove(arg_0));
        if (baseDataMap != null) {
            TemplatePermQueryUtil.addBaseDataMap(baseDataMap, userIds, applyTemplates, templates, viewGroupIds);
        }
        return recordToViewIdMap;
    }

    private static Member getViewMember(Dimension dimension, List<Long> viewGroupViewIds, Long entityId) {
        if (CollectionUtils.isNotEmpty(viewGroupViewIds)) {
            for (Long viewId : viewGroupViewIds) {
                Member member = dimension.getMember(viewId, entityId);
                if (member == null) continue;
                return member;
            }
        }
        return null;
    }

    public static void addBaseDataMap(Map<Long, BasedataPojo> baseDataMap, Set<Long> userIds, Set<Long> applyTemplates, Set<Long> templates, Set<Long> viewGroupIds) {
        DynamicObjectCollection queryTemplates;
        QFilter qFilter;
        if (userIds.size() != 0) {
            ArrayList<Long> userID = new ArrayList<Long>(userIds);
            List userInfos = UserServiceHelper.getUserInfoByID(userID);
            for (Map userInfo : userInfos) {
                Long userId = ConvertUtils.toLong(userInfo.get("id"));
                BasedataPojo basedataPojo = new BasedataPojo(userId, userInfo.get("name").toString(), userInfo.get("number").toString());
                baseDataMap.put(userId, basedataPojo);
            }
            Map<Object, DynamicObject> usrGrpObjs = TemplatePermQueryUtil.getUsrGrpObjById(userID);
            for (Map.Entry<Object, DynamicObject> entry : usrGrpObjs.entrySet()) {
                Long userId = ConvertUtils.toLong((Object)entry.getKey());
                DynamicObject userGroup = entry.getValue();
                BasedataPojo basedataPojo = new BasedataPojo(userId, userGroup.getString("name"), userGroup.getString("number"));
                baseDataMap.put(userId, basedataPojo);
            }
        }
        if (applyTemplates.size() != 0) {
            qFilter = new QFilter("id", "in", applyTemplates);
            queryTemplates = QueryServiceHelper.query((String)"eb_applytemplate", (String)"id, name, number", (QFilter[])new QFilter[]{qFilter});
            TemplatePermQueryUtil.addToBaseDataMap(queryTemplates, baseDataMap, null);
        }
        if (templates.size() != 0) {
            qFilter = new QFilter("id", "in", templates);
            queryTemplates = QueryServiceHelper.query((String)"eb_templateentity", (String)"id, name, number", (QFilter[])new QFilter[]{qFilter});
            TemplatePermQueryUtil.addToBaseDataMap(queryTemplates, baseDataMap, null);
        }
        if (viewGroupIds.size() != 0) {
            qFilter = new QFilter("id", "in", viewGroupIds);
            DynamicObjectCollection viewGroups = QueryServiceHelper.query((String)"eb_dimensionview_group", (String)"id, name, number", (QFilter[])new QFilter[]{qFilter});
            TemplatePermQueryUtil.addToBaseDataMap(viewGroups, baseDataMap, null);
        }
    }

    private static void addQuerySet(Map<Long, BasedataPojo> baseDataMap, DynamicObject record, Set<Long> querySet, String fieldKey) {
        long userId = record.getLong(fieldKey);
        if (!baseDataMap.containsKey(userId) && userId != 0L) {
            querySet.add(userId);
        }
    }

    public static void addToBaseDataMap(DynamicObjectCollection baseDataCollection, Map<Long, BasedataPojo> baseDataMap, Set<Long> refValueIds) {
        baseDataCollection.forEach(e -> {
            long id = e.getLong("id");
            if (refValueIds != null) {
                refValueIds.add(id);
            }
            BasedataPojo basedataPojo = new BasedataPojo(Long.valueOf(id), e.getString("name"), e.getString("number"));
            baseDataMap.put(id, basedataPojo);
        });
    }

    public static Map<Object, DynamicObject> getUsrGrpObjById(List<Long> usrGrpIds) {
        return kd.bos.orm.util.CollectionUtils.isEmpty(usrGrpIds) ? new HashMap(1) : BusinessDataServiceHelper.loadFromCache((Object[])usrGrpIds.toArray(), (String)"bos_usrgrp");
    }

    public static Map<Object, DynamicObject> getUsrObjById(List<Long> usrIds) {
        return kd.bos.orm.util.CollectionUtils.isEmpty(usrIds) ? new HashMap(1) : BusinessDataServiceHelper.loadFromCache((Object[])usrIds.toArray(), (String)"bos_user");
    }

    public static Map<Long, Long> getViewToViewGroupMap(Long modelId) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_dimensionview", (String)"id,viewgroup,viewgroup.parent", (QFilter[])new QFilter("model", "=", (Object)modelId).and("dimension.number", "=", (Object)"Entity").toArray());
        if (kd.bos.orm.util.CollectionUtils.isEmpty((Collection)query)) {
            return new HashMap<Long, Long>(0);
        }
        HashMap<Long, Long> viewToViewGroupMap = new HashMap<Long, Long>(16);
        for (DynamicObject object : query) {
            Long viewGroupParentId = object.getLong("viewgroup.parent");
            Long viewGroupId = IDUtils.isNotEmptyLong((Long)viewGroupParentId) != false ? viewGroupParentId.longValue() : object.getLong("viewgroup");
            viewToViewGroupMap.put(object.getLong("id"), viewGroupId);
        }
        return viewToViewGroupMap;
    }

    public static Map<Long, List<Long>> getViewGroupToViewMap(Long modelId) {
        HashMap<Long, List<Long>> viewGroupToViewMap = new HashMap<Long, List<Long>>(16);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_dimensionview", (String)"id,viewgroup,viewgroup.parent", (QFilter[])new QFilter("model", "=", (Object)modelId).and("dimension.number", "=", (Object)"Entity").toArray());
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            for (DynamicObject object : query) {
                Long viewGroupParentId = object.getLong("viewgroup.parent");
                Long viewGroupId = IDUtils.isNotEmptyLong((Long)viewGroupParentId) != false ? viewGroupParentId.longValue() : object.getLong("viewgroup");
                List viewIds = viewGroupToViewMap.computeIfAbsent(viewGroupId, e -> new ArrayList(10));
                viewIds.add(object.getLong("id"));
            }
        }
        return viewGroupToViewMap;
    }

    public static Long getViewGroupId(Long viewId) {
        DynamicObject query = QueryServiceHelper.queryOne((String)"eb_dimensionview", (String)"viewgroup,viewgroup.parent", (QFilter[])new QFilter("id", "=", (Object)viewId).toArray());
        if (query != null) {
            Long viewGroupParentId = query.getLong("viewgroup.parent");
            if (IDUtils.isNotEmptyLong((Long)viewGroupParentId).booleanValue()) {
                return viewGroupParentId;
            }
            return query.getLong("viewgroup");
        }
        return 0L;
    }
}

