/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.templateperm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.templateperm.TemplatePermQueryUtil;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.templateperm.EntityTypeEnum;
import kd.epm.eb.common.templateperm.TemplateTypeEnum;
import kd.epm.eb.common.templateperm.TemplateUserVo;
import kd.epm.eb.common.templateperm.UserTypeEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;

public class TemplatePermUpgradeHelper {
    private static final Log log = LogFactory.getLog(TemplatePermUpgradeHelper.class);
    private static final String upgradeRecordForm = "eb_templateperm_uprecord";

    public static TemplatePermUpgradeHelper getInstance() {
        return new TemplatePermUpgradeHelper();
    }

    public void upgradeModelTemplatePermData(Long modelId) {
        boolean success;
        String info;
        if (!this.isNeedUpgrade(modelId)) {
            return;
        }
        long start = System.currentTimeMillis();
        QFilter qf = new QFilter("modelid", "=", (Object)modelId).and("entityid", "!=", (Object)0L).and("viewgroup", "=", (Object)0L);
        List<TemplateUserVo> templateUserVos = this.queryTemplateVos(qf);
        if (templateUserVos.isEmpty()) {
            return;
        }
        IModelCacheHelper cacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Dimension dimension = cacheHelper.getDimension("Entity");
        Map<Long, Long> viewGroupToViewMap = TemplatePermQueryUtil.getViewToViewGroupMap(modelId);
        List<View> views = dimension.getViewList().stream().map(arg_0 -> ((Dimension)dimension).getView(arg_0)).collect(Collectors.toList());
        try (TXHandle tx = TX.required((String)"upgradeModelTemplatePermData");){
            try {
                DeleteServiceHelper.delete((String)"eb_templateuser_entity", (QFilter[])qf.toArray());
                this.doUpgrade(modelId, templateUserVos, viewGroupToViewMap, views);
                info = System.currentTimeMillis() - start + "ms";
                success = true;
            }
            catch (Throwable e) {
                tx.markRollback();
                info = e.getMessage();
                success = false;
                log.error(String.format("upgradeModelTemplatePermData:%s", Arrays.toString(e.getStackTrace())));
            }
        }
        this.addLog(modelId, success, templateUserVos.size(), info);
    }

    private void doUpgrade(Long modelId, List<TemplateUserVo> templateUserVos, Map<Long, Long> viewGroupToViewMap, List<View> views) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        ArrayList<DynamicObject> objects = new ArrayList<DynamicObject>(10);
        for (TemplateUserVo templateUserVo : templateUserVos) {
            Long entityId = templateUserVo.getEntityId();
            HashSet<Long> viewGroupIds = new HashSet<Long>(16);
            for (View view : views) {
                Long viewGroupId = viewGroupToViewMap.get(view.getId());
                if (IDUtils.isEmptyLong((Long)viewGroupId).booleanValue() || viewGroupIds.contains(viewGroupId)) continue;
                if (templateUserVo.getEntityType() == EntityTypeEnum.DEFINED_PROPERTY) {
                    viewGroupIds.add(viewGroupId);
                    continue;
                }
                Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), view.getId(), entityId);
                if (member == null) continue;
                viewGroupIds.add(viewGroupId);
            }
            Long userId = UserUtils.getUserId();
            Date now = TimeServiceHelper.now();
            for (Long viewGroupId : viewGroupIds) {
                templateUserVo.setViewGroupId(viewGroupId);
                DynamicObject object = templateUserVo.toDynamicObject(modelId, userId, now);
                objects.add(object);
            }
            if (objects.size() <= 5000) continue;
            SaveServiceHelper.save((DynamicObject[])objects.toArray(new DynamicObject[0]));
            objects.clear();
        }
        if (!objects.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])objects.toArray(new DynamicObject[0]));
        }
    }

    private List<TemplateUserVo> queryTemplateVos(QFilter qFilter) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_templateuser_entity", (String)"id, templateid, userid, usertype, modelid, applytemplate, templatetype, entityid, entity_range, entity_exclude, entitytype, viewgroup", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)query)) {
            return new ArrayList<TemplateUserVo>(0);
        }
        ArrayList<TemplateUserVo> templateUserVos = new ArrayList<TemplateUserVo>(query.size());
        for (DynamicObject object : query) {
            TemplateUserVo templateUserVo = new TemplateUserVo();
            templateUserVo.setId(Long.valueOf(object.getLong("id")));
            TemplateTypeEnum templateTypeEnum = TemplateTypeEnum.getTemplateTypeEnumByCode((String)object.getString("templatetype"));
            templateUserVo.setTemplateId(Long.valueOf(object.getLong(TemplateTypeEnum.APPLY == templateTypeEnum ? "applytemplate" : "templateid")));
            templateUserVo.setTemplateType(templateTypeEnum);
            templateUserVo.setUserId(Long.valueOf(object.getLong("userid")));
            templateUserVo.setUserType(UserTypeEnum.getUserTypeByCode((String)object.getString("usertype")));
            long entityId = object.getLong("entityid");
            if (entityId != 0L) {
                templateUserVo.setEntityId(Long.valueOf(entityId));
                templateUserVo.setEntityType(EntityTypeEnum.getEnumByCode((String)object.getString("entitytype")));
                templateUserVo.setEntityRange(RangeEnum.getRangeByVal((int)Integer.parseInt(object.getString("entity_range"))));
                templateUserVo.setEntityExclude(object.getBoolean("entity_exclude"));
            }
            templateUserVos.add(templateUserVo);
        }
        return templateUserVos;
    }

    private boolean isNeedUpgrade(Long modelId) {
        if (!QueryServiceHelper.exists((String)"eb_dimensionview_group", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u5347\u7ea7\u5f53\u524d\u4f53\u7cfb\u3002", (String)"TemplatePermUpgradeHelper_1", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        if (QueryServiceHelper.exists((String)upgradeRecordForm, (QFilter[])new QFilter("model", "=", (Object)modelId).toArray())) {
            return false;
        }
        return QueryServiceHelper.exists((String)"eb_templateuser_entity", (QFilter[])new QFilter("modelid", "=", (Object)modelId).and("entityid", "is not null", (Object)"").toArray());
    }

    private void addLog(Long modelId, boolean success, int size, String log) {
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)upgradeRecordForm);
        object.set("model", (Object)modelId);
        object.set("issuccess", (Object)success);
        object.set("count", (Object)size);
        object.set("log", (Object)log);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
    }
}

