/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.tree;

import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.tree.EbTreeNode;
import kd.epm.eb.common.member.f7.F7TreeUtils;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.TreeNodeUtils;
import org.jetbrains.annotations.NotNull;

public abstract class BaseTreeBuilder {
    public static final Log log = LogFactory.getLog(BaseTreeBuilder.class);
    protected static final String DEFAULT_CANT_CHECK_PERM = "cp";
    private LogStats stats;
    private TreeView treeView = null;
    private IPageCache pageCache = null;
    private boolean showRoot = true;
    private Set<Long> showSelectedIds = null;
    @JSONField(serialize=false, deserialize=false)
    private List<TreeNode> selected = Lists.newLinkedList();
    private String treeKey = null;
    private boolean unLoadPermission = true;
    private Set<Long> permissions = null;

    public void setStats(LogStats stats) {
        this.stats = stats;
    }

    protected LogStats getStats() {
        if (this.stats == null) {
            this.stats = new LogStats("budget-log : ");
        }
        return this.stats;
    }

    protected void setTreeView(TreeView treeView) {
        this.treeView = treeView;
    }

    protected TreeView getTreeView() {
        return this.treeView;
    }

    protected void setPageCache(IPageCache pageCache) {
        this.pageCache = pageCache;
    }

    protected IPageCache getPageCache() {
        return this.pageCache;
    }

    public void setShowRoot(boolean showRoot) {
        this.showRoot = showRoot;
    }

    public boolean isShowRoot() {
        return this.showRoot;
    }

    public void setShowSelectedIds(Set<Long> showSelectedIds) {
        this.showSelectedIds = showSelectedIds;
    }

    public Set<Long> getShowSelectedIds() {
        return this.showSelectedIds;
    }

    @JSONField(serialize=false, deserialize=false)
    protected List<TreeNode> getSelected() {
        return this.selected;
    }

    protected List<TreeNode> getSelectedClone() {
        return TreeNodeUtils.getBaseClone(this.getSelected());
    }

    public static void registerNodeListener(@NotNull TreeView treeView, @NotNull TreeNodeClickListener listener) {
        treeView.addTreeNodeClickListener(listener);
    }

    public static void registerNodeCheckListener(@NotNull TreeView treeView, @NotNull TreeNodeCheckListener listener) {
        treeView.addTreeNodeCheckListener(listener);
    }

    public static void registerQueryListener(@NotNull TreeView treeView, @NotNull TreeNodeQueryListener listener) {
        treeView.addTreeNodeQueryListener(listener);
    }

    public TreeNode buildTree(@NotNull TreeView treeView, @NotNull IPageCache pageCache) {
        return this.buildTree(treeView, pageCache, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeNode buildTree(@NotNull TreeView treeView, @NotNull IPageCache pageCache, Set<Long> selectNodeIds) {
        TreeNode root;
        this.getStats().addInfo("begin-buildTree");
        this.setTreeView(treeView);
        this.setPageCache(pageCache);
        if (selectNodeIds != null && !selectNodeIds.isEmpty()) {
            this.setShowSelectedIds(selectNodeIds);
        }
        try {
            root = this.getRoot(pageCache);
            this.cacheNode(pageCache, this.getCacheTreeKey(), root);
            treeView.deleteAllNodes();
            treeView.setRootVisible(this.isShowRoot());
            treeView.addNode(root);
            TreeNode node = this.getFocusNode(root);
            treeView.expand(node.getId());
            this.focusNode(treeView, node);
            this.nodeClick(treeView, node);
            this.afterBuilderTree(treeView);
        }
        finally {
            this.getStats().addInfo("end-buildTree");
            log.info(this.getStats().toString());
        }
        return root;
    }

    protected TreeNode getFocusNode(TreeNode root) {
        return root;
    }

    protected void focusNode(TreeView treeView, TreeNode node) {
        if (treeView != null && node != null) {
            treeView.focusNode(TreeNodeUtils.getBaseClone((TreeNode)node));
            this.getPageCache().put("NODE_MEMBER_CACHE_SELECT", node.getId());
            Object _dataType = this.getNodeData(node, "dt");
            if (_dataType != null) {
                this.getPageCache().put("NODE_MEMBER_CACHE_SELECT_DT", (String)_dataType);
            }
        }
    }

    protected Object getNodeData(TreeNode node, String dataKey) {
        if (node == null) {
            return null;
        }
        Object result = null;
        if (node.getData() instanceof Map) {
            Map _nodeData = (Map)node.getData();
            result = _nodeData.get(dataKey);
        }
        return result;
    }

    protected void nodeClick(TreeView treeView, TreeNode node) {
    }

    public abstract String getCacheTreeKey();

    public BaseTreeBuilder setTreeKey(String treeKey) {
        this.treeKey = treeKey;
        return this;
    }

    public String getTreeKey() {
        return this.treeKey;
    }

    protected TreeNode getRoot(@NotNull IPageCache pageCache) {
        return this.createNode("", "root", "root");
    }

    protected TreeNode createNode(String parentId, String id, String text) {
        return new EbTreeNode(parentId, id, text);
    }

    protected void cacheNode(@NotNull IPageCache pageCache, String cacheKey, TreeNode root) {
        F7TreeUtils.cacheTreeNodeData((IPageCache)pageCache, (String)cacheKey, (TreeNode)root, (LogStats)this.getStats());
    }

    protected void cacheNodeData(@NotNull IPageCache pageCache, String cacheKey, List<TreeNode> nodes) {
        F7TreeUtils.cacheData((IPageCache)pageCache, (String)cacheKey, nodes, (LogStats)this.getStats());
    }

    protected void cacheData(@NotNull IPageCache pageCache, String cacheKey, Object object) {
        F7TreeUtils.cacheData((IPageCache)pageCache, (String)cacheKey, (Object)object, (LogStats)this.getStats());
    }

    protected TreeNode getCacheData(@NotNull IPageCache pageCache, @NotNull String cacheKey) {
        return F7TreeUtils.getCacheTreeNodeData((IPageCache)pageCache, (String)cacheKey, (LogStats)this.getStats());
    }

    protected void afterBuilderTree(@NotNull TreeView treeView) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stepLoadTree(@NotNull TreeView treeView, @NotNull List<String> nodeIds, @NotNull String cacheKey, String focusNodeId, Set<Long> selectNodeIds, @NotNull IPageCache pageCache) {
        this.getStats().addInfo("begin-stopLoad-tree");
        TreeNode root = this.getCacheData(pageCache, cacheKey);
        if (root == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6811\u8282\u70b9\u6570\u636e\u7f13\u5b58\u52a0\u8f7d\u4e3a\u7a7a", (String)"BaseTreeBuilder_1", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        if (selectNodeIds != null && !selectNodeIds.isEmpty()) {
            this.setShowSelectedIds(selectNodeIds);
        }
        ArrayList<TreeNode> checkedNodes = new ArrayList<TreeNode>();
        try {
            TreeNode focusNode;
            for (String _nodeId : nodeIds) {
                List<TreeNode> _checked;
                TreeNode node = root.getTreeNode(_nodeId);
                if (node == null || node.getChildren() == null || !node.getChildren().isEmpty()) continue;
                List<TreeNode> _children = this.getChildrenNode(node, root, pageCache);
                if (_children.isEmpty()) {
                    node.setChildren(null);
                    treeView.updateNode(node);
                } else {
                    node.addChildren(_children);
                    treeView.addNodes(_children);
                }
                if (!CollectionUtils.isNotEmpty(_checked = this.getCheckedChildrenNode(_children))) continue;
                checkedNodes.addAll(_checked);
            }
            if (CollectionUtils.isNotEmpty(checkedNodes)) {
                treeView.checkNodesWithoutChild(TreeNodeUtils.getBaseClone(checkedNodes));
            }
            F7TreeUtils.cacheTreeNodeData((IPageCache)pageCache, (String)cacheKey, (TreeNode)root, (LogStats)this.getStats());
            if (focusNodeId != null && (focusNode = root.getTreeNode(focusNodeId)) != null) {
                treeView.focusNode(focusNode);
            }
        }
        finally {
            this.getStats().addInfo("end-stopLoad-tree");
            log.info(this.getStats().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stepLoadTree(@NotNull TreeNode root, @NotNull List<String> nodeIds, @NotNull String cacheKey, Set<Long> selectNodeIds, @NotNull IPageCache pageCache) {
        this.getStats().addInfo("begin-stopLoad-tree");
        if (selectNodeIds != null && !selectNodeIds.isEmpty()) {
            this.setShowSelectedIds(selectNodeIds);
        }
        try {
            for (String _nodeId : nodeIds) {
                TreeNode node = root.getTreeNode(_nodeId);
                if (node == null || node.getChildren() == null || !node.getChildren().isEmpty()) continue;
                List<TreeNode> _children = this.getChildrenNode(node, root, pageCache);
                if (_children.isEmpty()) {
                    node.setChildren(null);
                    continue;
                }
                node.addChildren(_children);
            }
            F7TreeUtils.cacheTreeNodeData((IPageCache)pageCache, (String)cacheKey, (TreeNode)root, (LogStats)this.getStats());
        }
        finally {
            this.getStats().addInfo("end-stopLoad-tree");
            log.info(this.getStats().toString());
        }
    }

    protected abstract List<TreeNode> getChildrenNode(TreeNode var1, TreeNode var2, IPageCache var3);

    protected List<TreeNode> getCheckedChildrenNode(List<TreeNode> children) {
        return this.getSelected();
    }

    protected boolean hasVerifyPermission(@NotNull Map<String, Object> nodeData) {
        return !nodeData.containsKey(DEFAULT_CANT_CHECK_PERM);
    }

    protected boolean verifyPermission(@NotNull Long memberId) {
        if (this.isVerifyPermission()) {
            if (this.unLoadPermission) {
                this.permissions = this.loadPermission();
                this.unLoadPermission = false;
            }
            return this.permissions == null || this.permissions.contains(memberId);
        }
        return true;
    }

    protected abstract boolean isVerifyPermission();

    protected abstract Set<Long> loadPermission();
}

