/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.tree;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.servicehelper.DimensionPropertyServiceHelper;
import kd.epm.eb.business.tree.BaseTreeBuilder;
import kd.epm.eb.business.tree.EbTreeNode;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.ShowTypeEnum;
import kd.epm.eb.common.member.f7.F7TreeUtils;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class CusPropertyTreeBuilder
extends BaseTreeBuilder {
    private final MemberF7Parameter f7Parameter;
    private String[] showTypes = null;
    private boolean loadSelected = false;
    private Map<Long, Integer> selectIds = null;

    protected MemberF7Parameter getF7Parameter() {
        return this.f7Parameter;
    }

    public static CusPropertyTreeBuilder get(@NotNull MemberF7Parameter f7Parameter) {
        return new CusPropertyTreeBuilder(f7Parameter);
    }

    public static CusPropertyTreeBuilder get(@NotNull MemberF7Parameter f7Parameter, @NotNull LogStats stats) {
        CusPropertyTreeBuilder builder = CusPropertyTreeBuilder.get(f7Parameter);
        builder.setStats(stats);
        return builder;
    }

    protected CusPropertyTreeBuilder(@NotNull MemberF7Parameter f7Parameter) {
        this.f7Parameter = f7Parameter;
    }

    @Override
    public String getCacheTreeKey() {
        if (StringUtils.isNotEmpty((String)this.getTreeKey())) {
            return "CACHE_TREE_PROPERTY_NODE_DATA_" + this.getTreeKey();
        }
        return "CACHE_TREE_PROPERTY_NODE_DATA";
    }

    @Override
    public boolean isShowRoot() {
        return false;
    }

    @Override
    protected TreeNode getRoot(@NotNull IPageCache pageCache) {
        return this.builderPropertyTree(pageCache);
    }

    protected TreeNode builderPropertyTree(@NotNull IPageCache pageCache) {
        TreeNode root = this.createNode("", "root", "root");
        List<Map<String, Object>> properties = this.queryCustomProperty();
        if (!properties.isEmpty()) {
            for (Map<String, Object> property : properties) {
                property.put("parent.id", root.getId());
            }
        }
        List<TreeNode> memNodes = this.transTreeNodes(properties, true);
        root.addChildren(memNodes);
        return root;
    }

    protected List<Map<String, Object>> queryCustomProperty() {
        List propertyData;
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)this.getF7Parameter().getModelId());
        builder.add("dimension", "=", (Object)this.getF7Parameter().getDimensionId());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryCusProperty", (String)"eb_customproperty", (String)"id,number,name", (QFilter[])builder.toArray(), (String)"dseq");){
            propertyData = CommonServiceHelper.transDataSet((DataSet)ds);
        }
        return propertyData;
    }

    protected List<TreeNode> transTreeNodes(@NotNull List<Map<String, Object>> nodeDatas, boolean hasProperty) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(nodeDatas.size());
        LinkedHashSet noLeafIds = Sets.newLinkedHashSet();
        if (hasProperty) {
            LinkedHashSet pIds = Sets.newLinkedHashSet();
            for (Map<String, Object> nodeData : nodeDatas) {
                pIds.add(IDUtils.toLong((Object)nodeData.get("id")));
            }
            if (!pIds.isEmpty()) {
                SqlBuilder sql = new SqlBuilder();
                sql.append("select distinct fpropertyid from t_eb_custompropertyvalue where ", new Object[0]).appendIn("fpropertyid", pIds.toArray());
                try (DataSet ds = DB.queryDataSet((String)"queryPropertyValue", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
                    if (ds != null) {
                        for (Row row : ds) {
                            noLeafIds.add(row.getString("fpropertyid"));
                        }
                    }
                }
            }
        }
        for (Map<String, Object> nodeData : nodeDatas) {
            TreeNode node = this.transNode(nodeData, hasProperty);
            if (node == null) continue;
            if (!noLeafIds.contains(node.getId())) {
                node.setLeaf(true);
                node.setChildren(null);
            }
            nodes.add(node);
        }
        return nodes;
    }

    protected boolean isCheckedProperty() {
        return false;
    }

    public String[] getShowTypes() {
        if (this.showTypes == null) {
            this.showTypes = F7TreeUtils.getShowType((ShowTypeEnum)this.getF7Parameter().getShowType());
        }
        return this.showTypes;
    }

    protected TreeNode transNode(@NotNull Map<String, Object> nodeData, boolean hasProperty) {
        EbTreeNode node = new EbTreeNode();
        node.setId(IDUtils.toString((Object)nodeData.get("id")));
        node.setParentid(IDUtils.toString((Object)nodeData.get("parent.id")));
        node.setText(F7TreeUtils.nodeShowType(nodeData, (String[])this.getShowTypes()));
        Long propertyId = IDUtils.toLong((Object)nodeData.get("id"));
        if (this.checkHasSelect(propertyId)) {
            this.getSelected().add(node);
        }
        if (hasProperty) {
            node.addChildren(new ArrayList());
            node.setDisabled(!this.isCheckedProperty());
        }
        return node;
    }

    protected boolean checkHasSelect(@NotNull Long pk) {
        if (this.getF7Parameter().getFunctionType() == 1) {
            if (!this.loadSelected) {
                this.selectIds = this.getF7Parameter().getSelectedData();
                this.loadSelected = true;
            }
            return this.selectIds != null && this.selectIds.containsKey(pk) || this.getShowSelectedIds() != null && this.getShowSelectedIds().contains(pk);
        }
        return false;
    }

    @Override
    protected void afterBuilderTree(@NotNull TreeView treeView) {
        super.afterBuilderTree(treeView);
        if (this.getF7Parameter().getFunctionType() == 1 && CollectionUtils.isNotEmpty(this.getSelected())) {
            treeView.checkNodesWithoutChild(this.getSelectedClone());
        }
    }

    @Override
    protected List<TreeNode> getChildrenNode(TreeNode parent, TreeNode root, IPageCache pageCache) {
        if (parent == null) {
            return null;
        }
        String propertyId = parent.getId();
        QFBuilder builder = new QFBuilder();
        if (this.getF7Parameter().getSelectRangeIds() != null) {
            HashSet<Long> tmpIds = new HashSet<Long>(this.getF7Parameter().getSelectRangeIds());
            if (tmpIds.isEmpty()) {
                tmpIds.add(0L);
            }
            builder.add("id", "in", tmpIds);
        }
        this.getStats().addInfo("begin-query-stepData.");
        List<Map<String, Object>> treeDatas = DimensionPropertyServiceHelper.getInstance().queryDimensionPropertyValue(IDUtils.toLong((Object)propertyId), "id,number,name", builder);
        if (!treeDatas.isEmpty()) {
            for (Map<String, Object> treeData : treeDatas) {
                treeData.put("parent.id", propertyId);
            }
        }
        this.getStats().add("end-query-stepData.");
        return this.transTreeNodes(treeDatas, false);
    }

    @Override
    protected List<TreeNode> getCheckedChildrenNode(List<TreeNode> children) {
        if (kd.epm.eb.common.utils.CollectionUtils.isEmpty(children)) {
            return null;
        }
        ArrayList checkedNodes = Lists.newArrayListWithExpectedSize((int)children.size());
        for (TreeNode child : children) {
            if (!this.checkHasSelect(IDUtils.toLong((Object)child.getId()))) continue;
            checkedNodes.add(child);
        }
        return checkedNodes;
    }

    @Override
    protected boolean isVerifyPermission() {
        return false;
    }

    @Override
    protected Set<Long> loadPermission() {
        return null;
    }
}

