/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.tree;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.tree.BaseTreeBuilder;
import kd.epm.eb.business.tree.EbTreeNode;
import kd.epm.eb.business.tree.TreeUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.AbstractTree;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.cache.impl.ViewMember;
import kd.epm.eb.common.enums.ShowTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.F7Constant;
import kd.epm.eb.common.member.f7.F7TreeUtils;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class DynamicTreeBuilder
extends BaseTreeBuilder {
    private final MemberF7Parameter f7Parameter;
    private String initFields = null;
    private Set<Long> cusFilterIds = null;
    private String[] showTypes = null;
    private boolean loadSelected = false;
    private Map<Long, Integer> selectIds = null;

    public static DynamicTreeBuilder get(@NotNull MemberF7Parameter f7Parameter) {
        return new DynamicTreeBuilder(f7Parameter);
    }

    public static DynamicTreeBuilder get(@NotNull MemberF7Parameter f7Parameter, @NotNull LogStats stats) {
        DynamicTreeBuilder builder = DynamicTreeBuilder.get(f7Parameter);
        builder.setStats(stats);
        return builder;
    }

    protected DynamicTreeBuilder(@NotNull MemberF7Parameter f7Parameter) {
        this.f7Parameter = f7Parameter;
    }

    protected MemberF7Parameter getF7Parameter() {
        return this.f7Parameter;
    }

    @Override
    protected TreeNode getFocusNode(TreeNode root) {
        MemberF7Parameter _f7Param;
        Map selectedData;
        TreeNode _root = super.getFocusNode(root);
        if (this.getF7Parameter().isShowVariable() && _root.getId().equals("root")) {
            for (TreeNode _node : _root.getChildren()) {
                Long nodeId = IDUtils.toLong((Object)_node.getId());
                if (F7Constant.VAR_TYPE_ID.compareTo(nodeId) == 0 || F7Constant.MULTI_VAR_ID.compareTo(nodeId) == 0 || F7Constant.SINGLE_VAR_ID.compareTo(nodeId) == 0) continue;
                _root = _node;
            }
        }
        if ((selectedData = (_f7Param = this.getF7Parameter()).getSelectedData()) != null && !selectedData.isEmpty()) {
            IModelCacheHelper modelCache = _f7Param.getModelCacheHelper();
            Dimension dimension = modelCache.getDimension(_f7Param.getDimensionId());
            TreeNode _node = null;
            Member _selMember = null;
            block1: for (Long _selNodeId : selectedData.keySet()) {
                Member _member = dimension.getMember(_f7Param.getViewId(), _selNodeId);
                if (_member == null) continue;
                if (_selMember == null) {
                    _selMember = _member;
                    continue;
                }
                if (_member.getLongNumber().startsWith(_selMember.getLongNumber() + '!')) continue;
                if (_selMember.getLongNumber().startsWith(_member.getLongNumber() + '!')) {
                    _selMember = _member;
                    continue;
                }
                String[] tmp1 = _member.getLongNumber().split("!");
                String[] tmp2 = _selMember.getLongNumber().split("!");
                int maxLevel = Math.min(tmp1.length, tmp2.length);
                String _selMemNumber = null;
                for (int level = 0; level < maxLevel; ++level) {
                    if (!StringUtils.equals((String)tmp1[level], (String)tmp2[level])) {
                        Member _tmpMember;
                        if (_selMemNumber == null || (_tmpMember = dimension.getMember(_f7Param.getViewId(), _selMemNumber)) == null) continue block1;
                        _selMember = _tmpMember;
                        continue block1;
                    }
                    _selMemNumber = tmp1[level];
                }
            }
            if (_selMember != null) {
                _node = root.getTreeNode(_selMember.getId().toString());
                if (_node == null && _selMember.getParentId() != null) {
                    _node = _root.getTreeNode(_selMember.getParentId().toString());
                }
            } else if (this.getF7Parameter().isShowVariable() && _root != null) {
                _node = root.getTreeNode(IDUtils.toString(selectedData.keySet().iterator().next()));
            }
            if (_node != null) {
                _root = _node;
            }
        }
        return _root;
    }

    @Override
    protected void nodeClick(TreeView treeView, TreeNode node) {
        if (this.getF7Parameter().getFunctionType() == 0) {
            super.nodeClick(treeView, node);
        }
    }

    @Override
    public String getCacheTreeKey() {
        if (StringUtils.isNotEmpty((String)this.getTreeKey())) {
            return "CACHE_F7_TREE_MEMBER_NODE_DATA_" + this.getTreeKey();
        }
        return "CACHE_F7_TREE_MEMBER_NODE_DATA";
    }

    protected QFilter[] getInitRootFilters() {
        MemberF7Parameter f7Param = this.getF7Parameter();
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)f7Param.getModelId());
        builder.add("dimension", "=", (Object)f7Param.getDimensionId());
        String rootNumber = f7Param.getDimensionNumber();
        if (IDUtils.isNotNull((Long)f7Param.getViewId())) {
            builder.add("view", "=", (Object)f7Param.getViewId());
            DynamicObject view = f7Param.getView();
            if (view != null && !"1".equals(view.getString("source"))) {
                rootNumber = rootNumber + "_" + view.getString("number");
            }
        }
        builder.add("number", "=", (Object)rootNumber);
        builder.add("level", "<=", (Object)1);
        return builder.toArray();
    }

    protected String getInitFields() {
        if (this.initFields == null) {
            this.initFields = this.getF7Parameter().fields();
            String tmpStr = this.getInitOrder();
            if (StringUtils.isNotEmpty((String)tmpStr)) {
                String[] tmpStrs;
                for (String _field : tmpStrs = tmpStr.split(",")) {
                    if (this.initFields.contains(_field.trim())) continue;
                    this.initFields = this.initFields + "," + _field.trim();
                }
            }
            if (this.getF7Parameter().isView()) {
                this.initFields = this.initFields + ",showchildren";
            }
        }
        return this.initFields;
    }

    protected QFilter[] getInitFilters() {
        ArrayList<QFilter> _filters = new ArrayList<QFilter>(this.getF7Parameter().filters(true).getFilters());
        if (this.getF7Parameter().stepLoad()) {
            this.replaceFilter(_filters, new QFilter("level", "<=", (Object)this.getStopLevel()));
        }
        if (!this.getF7Parameter().isShowLeaf()) {
            this.replaceFilter(_filters, new QFilter("isleaf", "=", (Object)"0"));
        }
        return _filters.toArray(new QFilter[0]);
    }

    protected String getInitOrder() {
        if (StringUtils.equals((String)"BudgetPeriod", (String)this.getF7Parameter().getDimensionNumber())) {
            return "longnumber";
        }
        return "level,dseq,number";
    }

    protected QFilter[] getInitParentFilters() {
        QFBuilder builder = this.getF7Parameter().listFilter();
        builder.remove("isleaf");
        return builder.toArrays();
    }

    protected QFilter[] getStepFilters(TreeNode parent) {
        ArrayList<QFilter> _filters = new ArrayList<QFilter>(this.getF7Parameter().filters().getFilters());
        if (this.getF7Parameter().isView()) {
            Long nodeId = this.getNodeId((Map)parent.getData());
            this.replaceFilter(_filters, new QFilter("parent", "=", (Object)nodeId));
        } else {
            this.replaceFilter(_filters, new QFilter("parent", "=", (Object)IDUtils.toLong((Object)parent.getId())));
        }
        if (this.getF7Parameter().getFunctionType() == 0) {
            this.replaceFilter(_filters, new QFilter("isleaf", "=", (Object)"0"));
        }
        return _filters.toArray(new QFilter[0]);
    }

    protected void replaceFilter(List<QFilter> filters, QFilter filter) {
        if (filters == null || filter == null) {
            return;
        }
        QFilter _exitFilter = null;
        for (QFilter _filter : filters) {
            if (!_filter.getProperty().equals(filter.getProperty())) continue;
            _exitFilter = _filter;
            break;
        }
        if (_exitFilter != null) {
            _exitFilter.__setCP(filter.getCP());
            _exitFilter.__setValue(filter.getValue());
        } else {
            filters.add(filter);
        }
    }

    public int getStopLevel() {
        return this.getF7Parameter().getDefaultStopLevel();
    }

    @Override
    protected void afterBuilderTree(@NotNull TreeView treeView) {
        super.afterBuilderTree(treeView);
        this.afterBackShow(treeView);
    }

    protected void afterBackShow(@NotNull TreeView treeView) {
        if (this.hasBackShow()) {
            treeView.checkNodesWithoutChild(this.getSelectedClone());
        }
    }

    protected boolean hasBackShow() {
        return this.getF7Parameter().getFunctionType() == 1 && CollectionUtils.isNotEmpty(this.getSelected());
    }

    @Override
    protected TreeNode getRoot(@NotNull IPageCache pageCache) {
        TreeNode treeNode = this.buildRootTree(pageCache);
        MemberF7Parameter parameter = this.getF7Parameter();
        if (treeNode != null && parameter != null && parameter.getRootText() != null) {
            treeNode.setText(parameter.getRootText());
        }
        return treeNode;
    }

    protected TreeNode buildRootTree(@NotNull IPageCache pageCache) {
        TreeNode root;
        List<Map<String, Object>> varTreeData;
        MemberF7Parameter _f7Param = this.getF7Parameter();
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(16);
        if (_f7Param.isShowVariable() && CollectionUtils.isNotEmpty(varTreeData = this.queryVariableData())) {
            nodes.addAll(this.transVarTreeNodes(varTreeData));
        }
        List<Map<String, Object>> memberTreeData = this.queryInitData();
        Set<String> parentData = this.queryInitParentData(memberTreeData);
        List<TreeNode> memNodes = this.transTreeNodes(memberTreeData, parentData, pageCache);
        nodes.addAll(memNodes);
        this.afterTransTreeNodes(nodes);
        if (nodes.size() == 1) {
            TreeNode _root = (TreeNode)nodes.get(0);
            _root.setParentid("");
            return _root;
        }
        if (nodes.isEmpty()) {
            root = this.createRoot();
        } else {
            this.setShowRoot(false);
            root = super.getRoot(pageCache);
            for (TreeNode _child : nodes) {
                _child.setParentid(root.getId());
                root.addChild(_child);
            }
        }
        return root;
    }

    private List<TreeNode> transVarTreeNodes(List<Map<String, Object>> varTreeData) {
        TreeNode root = null;
        boolean hasView = this.getF7Parameter().isView();
        LinkedHashMap _tmpNodeMap = Maps.newLinkedHashMapWithExpectedSize((int)varTreeData.size());
        LinkedHashSet noPermission = Sets.newLinkedHashSet();
        for (Map<String, Object> _data : varTreeData) {
            Long nodeId;
            TreeNode node = this.transNode(_data);
            Long l = nodeId = hasView ? this.getNodeMemberId(_data) : this.getNodeId(_data);
            if (this.hasVerifyPermission(_data) && !this.verifyPermission(nodeId) && !this.isRootNode(node)) {
                noPermission.add(nodeId.toString());
            }
            _tmpNodeMap.put(node.getId(), node);
        }
        if (!noPermission.isEmpty()) {
            for (String _nodeId : noPermission) {
                _tmpNodeMap.remove(_nodeId);
            }
        }
        LinkedList nodes = Lists.newLinkedList();
        for (TreeNode _node : _tmpNodeMap.values()) {
            if (F7Constant.VAR_TYPE_ID.toString().equals(_node.getId())) {
                if (root == null) {
                    root = _node;
                }
                nodes.add(_node);
                continue;
            }
            TreeNode parent = (TreeNode)_tmpNodeMap.get(_node.getParentid());
            if (parent != null) {
                parent.addChild(_node);
                continue;
            }
            Map data = (Map)_node.getData();
            if ("2".equals(data.get("grouptype"))) continue;
            _node.setParentid(F7Constant.SINGLE_VAR_ID.toString());
            parent = (TreeNode)_tmpNodeMap.get(_node.getParentid());
            if (parent == null) continue;
            parent.addChild(_node);
        }
        return nodes;
    }

    @Override
    protected void cacheNode(@NotNull IPageCache pageCache, @NotNull String cacheKey, TreeNode root) {
        TreeNode varRoot;
        super.cacheNode(pageCache, cacheKey, root);
        if (this.getF7Parameter().isShowVariable() && (varRoot = root.getTreeNode(F7Constant.VAR_TYPE_ID.toString())) != null) {
            F7TreeUtils.cacheTreeNodeData((IPageCache)pageCache, (String)"CACHE_F7_TREE_VAR_NODE_DATA", (TreeNode)varRoot, (LogStats)this.getStats());
        }
    }

    protected TreeNode createRoot() {
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)this.getF7Parameter().getModelId());
        builder.add("dimension", "=", (Object)this.getF7Parameter().getDimensionId());
        builder.add("number", "=", (Object)this.getF7Parameter().getDimensionNumber());
        DynamicObject rootMember = BusinessDataServiceHelper.loadSingleFromCache((String)this.getF7Parameter().baseEntityNumber(), (String)"id,number,name", (QFilter[])builder.toArray());
        EbTreeNode root = new EbTreeNode("", rootMember.getString("id"), rootMember.getString("name"));
        if (!this.getF7Parameter().isCanSelectRoot()) {
            root.setDisabled(true);
        } else if (this.isDisabled(rootMember.getLong("id"))) {
            root.setDisabled(true);
        }
        return root;
    }

    private boolean isDisabled(Long memberId) {
        boolean isDisabled = false;
        if (this.getF7Parameter().getSelectRangeIds() != null) {
            if (!this.getF7Parameter().getSelectRangeIds().contains(memberId)) {
                isDisabled = true;
            }
        } else if (this.getF7Parameter().getCustomCommFilters() != null) {
            block24: {
                if (this.cusFilterIds == null) {
                    this.cusFilterIds = new HashSet<Long>();
                    try {
                        QFilter filter = this.getF7Parameter().customCommFilter();
                        if (filter == null) break block24;
                        filter.and("model", "=", (Object)this.getF7Parameter().getModelId()).and("dimension", "=", (Object)this.getF7Parameter().getDimensionId());
                        String entityNumber = this.getF7Parameter().entityNumber();
                        if ("eb_viewmember".equals(entityNumber)) {
                            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryMemberRangeIds", (String)this.getF7Parameter().entityNumber(), (String)"memberid", (QFilter[])filter.toArray(), null);){
                                if (ds != null) {
                                    for (Row row : ds) {
                                        this.cusFilterIds.add(row.getLong("memberid"));
                                    }
                                }
                                break block24;
                            }
                        }
                        List pks = QueryServiceHelper.queryPrimaryKeys((String)this.getF7Parameter().entityNumber(), (QFilter[])filter.toArray(), null, (int)100000);
                        if (pks != null) {
                            this.cusFilterIds.addAll(IDUtils.toLongs((List)pks));
                        }
                    }
                    catch (Throwable ex) {
                        log.error("load-cus-filter-error", ex);
                    }
                }
            }
            if (!this.cusFilterIds.contains(memberId)) {
                isDisabled = true;
            }
        }
        return isDisabled;
    }

    protected List<TreeNode> transTreeNodes(@NotNull List<Map<String, Object>> memberTreeData, Set<String> parentData, IPageCache pageCache) {
        TreeNode root = null;
        boolean hasView = this.getF7Parameter().isView();
        Map<Object, Object> _tmpNodeMap = Maps.newLinkedHashMapWithExpectedSize((int)memberTreeData.size());
        LinkedHashSet noPermission = Sets.newLinkedHashSet();
        IModelCacheHelper modelCacheHelper = this.getF7Parameter().getModelCacheHelper();
        Dimension dimension = modelCacheHelper.getDimension(this.getF7Parameter().getDimensionId());
        View dimTree = dimension.getView(this.getF7Parameter().getViewId());
        if (dimTree == null) {
            dimTree = dimension;
        }
        for (Map<String, Object> _data : memberTreeData) {
            Long nodeId;
            TreeNode node = this.transNode(_data);
            boolean isRoot = this.isRootNode(node);
            if (parentData != null && !parentData.contains(node.getId()) && !isRoot) continue;
            Long l = nodeId = hasView ? this.getNodeMemberId(_data) : this.getNodeId(_data);
            if (this.hasVerifyPermission(_data) && !this.verifyPermission(nodeId) && !isRoot) {
                noPermission.add(nodeId.toString());
            }
            _tmpNodeMap.put(node.getId(), node);
        }
        _tmpNodeMap = this.transNodeId((Map<String, TreeNode>)_tmpNodeMap);
        if (!noPermission.isEmpty()) {
            for (String _nodeId : noPermission) {
                _tmpNodeMap.remove(_nodeId);
            }
        }
        if (pageCache != null) {
            pageCache.put("CACHE_TREE_ALL", String.valueOf(_tmpNodeMap.size()));
        }
        LinkedList nodes = Lists.newLinkedList();
        LinkedList noParent = Lists.newLinkedList();
        for (TreeNode treeNode : _tmpNodeMap.values()) {
            if (this.isRootNode(treeNode)) {
                if (root == null) {
                    root = treeNode;
                }
                nodes.add(treeNode);
                continue;
            }
            TreeNode parent = this.getHasPermParentNode(treeNode, _tmpNodeMap, (AbstractTree)dimTree);
            if (parent != null) {
                parent.addChild(treeNode);
                continue;
            }
            noParent.add(treeNode);
        }
        if (!noParent.isEmpty()) {
            if (root != null) {
                for (TreeNode treeNode : noParent) {
                    treeNode.setParentid(root.getId());
                    root.addChild(treeNode);
                }
            } else {
                for (TreeNode treeNode : noParent) {
                    treeNode.setParentid("");
                    nodes.add(treeNode);
                }
            }
        }
        if (this.getF7Parameter().isShowAnalyseMember() && root != null) {
            TreeUtils.sortNodes(root, TreeUtils.getSortByMemberSource(this.getF7Parameter().isView()));
        }
        return nodes;
    }

    protected TreeNode getHasPermParentNode(TreeNode node, Map<String, TreeNode> nodeMap, AbstractTree dimTree) {
        Member member;
        if (node == null || nodeMap == null || dimTree == null) {
            return null;
        }
        TreeNode parent = nodeMap.get(node.getParentid());
        if (parent == null && node.getData() instanceof Map && (member = dimTree.getMember(IDUtils.toLong((Object)node.getId()))) != null) {
            String[] numbers = member.getLongNumber().split("!");
            for (int index = numbers.length - 3; index >= 0 && parent == null; --index) {
                member = dimTree.getMember(numbers[index]);
                if (member == null) continue;
                parent = nodeMap.get(member.getId().toString());
            }
        }
        return parent;
    }

    protected void afterTransTreeNodes(List<TreeNode> nodes) {
        this.checkNode(nodes);
    }

    protected boolean isRootNode(TreeNode node) {
        return StringUtils.isEmpty((String)node.getParentid()) || "0".equals(node.getParentid());
    }

    protected Map<String, TreeNode> transNodeId(Map<String, TreeNode> nodeMap) {
        if (!this.getF7Parameter().isView()) {
            return nodeMap;
        }
        LinkedHashMap<String, TreeNode> _tmpNodeMap = new LinkedHashMap<String, TreeNode>(nodeMap.size());
        for (TreeNode _node : nodeMap.values()) {
            Map _data = (Map)_node.getData();
            Long _memberId = (Long)_data.get("memberid");
            _node.setId(_memberId.toString());
            TreeNode _parent = nodeMap.get(_node.getParentid());
            if (_parent != null) {
                Long _pMemberId = (Long)this.getTreeNodeProperty(_parent, "memberid");
                _node.setParentid(_pMemberId.toString());
            }
            _tmpNodeMap.put(_node.getId(), _node);
        }
        return _tmpNodeMap;
    }

    protected void checkNode(List<TreeNode> nodes) {
        if (this.getF7Parameter().stepLoad()) {
            return;
        }
        nodes.forEach(this::$checkNode);
    }

    private void $checkNode(TreeNode node) {
        List _children;
        Map nodeData;
        if (node == null) {
            return;
        }
        if (node.getData() instanceof Map && this.hasClearNodeData(nodeData = (Map)node.getData())) {
            node.setData(null);
        }
        if ((_children = node.getChildren()) != null) {
            if (_children.isEmpty()) {
                node.setChildren(null);
            } else {
                for (TreeNode _child : _children) {
                    this.$checkNode(_child);
                }
            }
        }
    }

    protected boolean hasClearNodeData(Map<String, Object> nodeData) {
        return nodeData == null || !nodeData.containsKey("dt");
    }

    protected Object getTreeNodeProperty(TreeNode node, String propertyName) {
        if (node == null || propertyName == null) {
            return null;
        }
        if (node.getData() instanceof Map) {
            return ((Map)node.getData()).get(propertyName);
        }
        return null;
    }

    protected List<TreeNode> transTreeNodes(@NotNull TreeNode parent, TreeNode root, @NotNull List<Map<String, Object>> treeData) {
        LinkedList children = Lists.newLinkedList();
        for (Map<String, Object> _data : treeData) {
            Long nodeId;
            Long l = nodeId = this.getF7Parameter().isView() ? this.getNodeMemberId(_data) : this.getNodeId(_data);
            if (this.hasVerifyPermission(_data) && !this.verifyPermission(nodeId)) continue;
            TreeNode node = this.transNode(_data);
            node.setId(nodeId.toString());
            node.setParentid(parent.getId());
            children.add(node);
        }
        return children;
    }

    protected List<Map<String, Object>> queryInitData() {
        List filterData;
        LinkedList memberTreeDate = Lists.newLinkedList();
        this.getStats().addInfo("begin-query-initData.");
        MemberF7Parameter _f7Param = this.getF7Parameter();
        String entityNumber = _f7Param.entityNumber();
        Map root = null;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryTreeData", (String)entityNumber, (String)this.getInitFields(), (QFilter[])this.getInitFilters(), (String)this.getInitOrder());){
            filterData = CommonServiceHelper.transDataSet((DataSet)ds);
        }
        if (!filterData.isEmpty()) {
            Map data = (Map)filterData.get(0);
            if (_f7Param.getDimensionNumber().equals(data.get("number"))) {
                root = data;
            }
        }
        if (root == null) {
            List rootData;
            ds = QueryServiceHelper.queryDataSet((String)"queryTreeRootData", (String)entityNumber, (String)this.getInitFields(), (QFilter[])this.getInitRootFilters(), (String)this.getInitOrder(), (int)1);
            var9_6 = null;
            try {
                rootData = CommonServiceHelper.transDataSet((DataSet)ds);
            }
            catch (Throwable throwable) {
                var9_6 = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (var9_6 != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            var9_6.addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            memberTreeDate.addAll(rootData);
        }
        memberTreeDate.addAll(filterData);
        this.getStats().add("end-query-initData.");
        return memberTreeDate;
    }

    /*
     * Unable to fully structure code
     */
    protected Set<String> queryInitParentData(List<Map<String, Object>> memberTreeData) {
        _f7Param = this.getF7Parameter();
        if (!_f7Param.isCutTree()) {
            return null;
        }
        parentData = Sets.newLinkedHashSetWithExpectedSize((int)1024);
        entityNumber = _f7Param.entityNumber();
        parentNumberSet = Sets.newLinkedHashSet();
        this.getStats().add("begin-query-initParentData.");
        if (_f7Param.isShowLeaf()) {
            if (_f7Param.getSelectRangeIds() == null && _f7Param.getCustomFilters() == null && _f7Param.getCustomCommFilters() == null) {
                ds = QueryServiceHelper.queryDataSet((String)"queryTreeData", (String)entityNumber, (String)"id", (QFilter[])this.getInitParentFilters(), null);
                var9_9 = null;
                try {
                    if (ds == null) ** GOTO lbl101
                    for (Row row : ds) {
                        parentData.add(row.getString("id"));
                    }
                }
                catch (Throwable var10_14) {
                    var9_9 = var10_14;
                    throw var10_14;
                }
                finally {
                    if (ds != null) {
                        if (var9_9 != null) {
                            try {
                                ds.close();
                            }
                            catch (Throwable var10_13) {
                                var9_9.addSuppressed(var10_13);
                            }
                        } else {
                            ds.close();
                        }
                    }
                }
            } else {
                ds = QueryServiceHelper.queryDataSet((String)"queryTreeData", (String)entityNumber, (String)"id,parent,isleaf,longnumber", (QFilter[])this.getInitParentFilters(), null);
                var9_10 = null;
                try {
                    if (ds != null) {
                        for (Row row : ds) {
                            parentData.add(row.getString("id"));
                            if (_f7Param.isCutParentNode()) continue;
                            parentData.add(row.getString("parent"));
                            longNumber = row.getString("longnumber");
                            parentNumbers = longNumber.split("!");
                            parentNumbers[parentNumbers.length - 1] = null;
                            parentNumberSet.addAll(Arrays.asList(parentNumbers));
                        }
                    }
                }
                catch (Throwable var10_17) {
                    var9_10 = var10_17;
                    throw var10_17;
                }
                finally {
                    if (ds != null) {
                        if (var9_10 != null) {
                            try {
                                ds.close();
                            }
                            catch (Throwable var10_16) {
                                var9_10.addSuppressed(var10_16);
                            }
                        } else {
                            ds.close();
                        }
                    }
                }
                this.fillBackParentData(_f7Param, parentNumberSet, parentData, memberTreeData);
            }
        } else {
            ds = QueryServiceHelper.queryDataSet((String)"queryTreeData", (String)entityNumber, (String)"id,parent,isleaf,longnumber", (QFilter[])this.getInitParentFilters(), null);
            var9_11 = null;
            try {
                if (ds != null) {
                    for (Row row : ds) {
                        longNumber = row.getString("longnumber");
                        parentNumbers = longNumber.split("!");
                        if (row.getBoolean("isleaf").booleanValue()) {
                            parentData.add(row.getString("parent"));
                            parentNumbers[parentNumbers.length - 1] = null;
                        } else {
                            parentData.add(row.getString("id"));
                        }
                        parentNumberSet.addAll(Arrays.asList(parentNumbers));
                    }
                }
            }
            catch (Throwable var10_20) {
                var9_11 = var10_20;
                throw var10_20;
            }
            finally {
                if (ds != null) {
                    if (var9_11 != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable var10_19) {
                            var9_11.addSuppressed(var10_19);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            this.fillBackParentData(_f7Param, parentNumberSet, parentData, memberTreeData);
        }
lbl101:
        // 4 sources

        this.getStats().add("end-query-initParentData.");
        return parentData;
    }

    private void fillBackParentData(MemberF7Parameter f7Param, Set<String> parentNumberSet, Set<String> parentData, List<Map<String, Object>> memberTreeData) {
        Set permMemberIds;
        if (f7Param == null || parentNumberSet == null || parentNumberSet.isEmpty() || parentData == null || memberTreeData == null) {
            return;
        }
        IModelCacheHelper modelCache = f7Param.getModelCacheHelper();
        Dimension dimension = modelCache.getDimension(f7Param.getDimensionId());
        View view = dimension.getView(f7Param.getViewId());
        parentNumberSet.remove(null);
        Set set = permMemberIds = f7Param.isVerifyPermission() ? f7Param.getPermissionIds() : null;
        Set pMemberIds = view != null ? (permMemberIds != null ? view.getMember(parentNumberSet).stream().filter(Objects::nonNull).filter(m -> !m.isLeaf() && permMemberIds.contains(m.getId())).map(m -> ((ViewMember)m).getVid()).collect(Collectors.toSet()) : view.getMember(parentNumberSet).stream().filter(Objects::nonNull).filter(m -> !m.isLeaf()).map(m -> ((ViewMember)m).getVid()).collect(Collectors.toSet())) : (permMemberIds != null ? dimension.getMember(parentNumberSet).stream().filter(Objects::nonNull).filter(m -> !m.isLeaf() && permMemberIds.contains(m.getId())).map(m -> m.getId()).collect(Collectors.toSet()) : dimension.getMember(parentNumberSet).stream().filter(Objects::nonNull).filter(m -> !m.isLeaf()).map(m -> m.getId()).collect(Collectors.toSet()));
        parentData.addAll(IDUtils.toStringCollection(pMemberIds));
        this.getStats().addInfo("queryInitParentData-size=" + parentData.size());
        if (!parentData.isEmpty() && !memberTreeData.isEmpty()) {
            Set set2;
            HashMap parentMap = Maps.newHashMapWithExpectedSize((int)memberTreeData.size());
            for (Map<String, Object> map : memberTreeData) {
                parentMap.put(IDUtils.toString((Object)map.get("id")), IDUtils.toString((Object)map.get("parent.id")));
            }
            LinkedHashSet allParentIds = Sets.newLinkedHashSet();
            for (String _parentId : parentData) {
                this.findAllParents(_parentId, parentMap, allParentIds);
            }
            allParentIds.remove("0");
            parentData.addAll(allParentIds);
            if (!CollectionUtils.containsAll(parentMap.keySet(), parentData) && !(set2 = parentData.stream().filter(_id -> !parentMap.containsKey(_id)).collect(Collectors.toSet())).isEmpty()) {
                List _parentMembers;
                QFilter filter = new QFilter("id", "in", (Object)IDUtils.toLongs(set2));
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryTreeData", (String)f7Param.entityNumber(), (String)this.getInitFields(), (QFilter[])filter.toArray(), (String)this.getInitOrder());){
                    _parentMembers = CommonServiceHelper.transDataSet((DataSet)ds);
                }
                memberTreeData.addAll(_parentMembers);
                String order = this.getInitOrder();
                if (StringUtils.isNotEmpty((String)order)) {
                    String[] orders = order.split(",");
                    Comparator comparator = (m1, m2) -> {
                        int re = 0;
                        for (String _order : orders) {
                            Object value1 = m1.get(_order.trim());
                            Object value2 = m2.get(_order.trim());
                            if (value1 instanceof Comparable && value2 instanceof Comparable) {
                                re = ((Comparable)value1).compareTo(value2);
                            }
                            if (re != 0) break;
                        }
                        return re;
                    };
                    memberTreeData.sort(comparator);
                }
            }
        }
    }

    private void findAllParents(String memberId, Map<String, String> parentMap, Set<String> parentData) {
        if (memberId == null) {
            return;
        }
        parentData.add(memberId);
        String parentId = parentMap.get(memberId);
        if (parentId != null) {
            parentData.add(parentId);
            this.findAllParents(parentId, parentMap, parentData);
        }
    }

    protected List<Map<String, Object>> queryVariableData() {
        Set selectRangeIds;
        MemberF7Parameter _f7Param = this.getF7Parameter();
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)_f7Param.getModelId());
        builder.add("dimension", "=", (Object)_f7Param.getDimensionId());
        if (_f7Param.getVariableType() == 1) {
            builder.add("grouptype", "!=", (Object)"2");
        } else if (_f7Param.getVariableType() == 2) {
            builder.add("grouptype", "=", (Object)"2");
        }
        QFilter _varFilters = this.getF7Parameter().varFilters();
        if (_varFilters != null) {
            builder.add(_varFilters);
        }
        if ((selectRangeIds = this.getF7Parameter().getSelectRangeIds()) != null) {
            HashSet<Long> tmpIds = new HashSet<Long>(selectRangeIds);
            if (tmpIds.isEmpty()) {
                tmpIds.add(0L);
            }
            builder.add("id", "in", tmpIds);
        }
        Map vars = BusinessDataServiceHelper.loadFromCache((String)"eb_periodvariable", (String)"id,number,name,grouptype,parentid", (QFilter[])builder.toArray(), (String)"number");
        ArrayList varTypeData = Collections.emptyList();
        if (!vars.isEmpty()) {
            varTypeData = Lists.newArrayListWithExpectedSize((int)(vars.size() + 3));
            for (DynamicObject _var : vars.values()) {
                HashMap<String, Object> varData = new HashMap<String, Object>();
                varData.put("id", _var.get("id"));
                varData.put("number", _var.getString("number"));
                varData.put("name", _var.getString("name"));
                varData.put("grouptype", _var.getString("grouptype"));
                varData.put("parentid", _var.getString("parentid"));
                varTypeData.add(varData);
            }
            for (Map _varType : varTypeData) {
                String _parentId = (String)_varType.get("parentid");
                if (Objects.isNull(_parentId) || "0".equals(_parentId) || StringUtils.isEmpty((String)_parentId)) {
                    if (SysDimensionEnum.BudgetPeriod.getNumber().equals(_f7Param.getDimensionNumber())) {
                        if ("2".equals(_varType.get("grouptype"))) {
                            _varType.put("parent.id", F7Constant.MULTI_VAR_ID);
                        } else {
                            _varType.put("parent.id", F7Constant.SINGLE_VAR_ID);
                        }
                    } else {
                        _varType.put("parent.id", F7Constant.VAR_TYPE_ID);
                    }
                } else {
                    _varType.put("parent.id", _parentId);
                }
                _varType.put("dt", "v");
                _varType.put("cp", null);
            }
            HashMap<String, Object> varRoot = new HashMap<String, Object>();
            varRoot.put("id", F7Constant.VAR_TYPE_ID);
            varRoot.put(F7Constant.DEFAULT_SHOW_FIELDS[0], "Variable");
            varRoot.put(F7Constant.DEFAULT_SHOW_FIELDS[1], ResManager.loadKDString((String)"\u53d8\u91cf", (String)"DynamicTreeBuilder_0", (String)"epm-eb-business", (Object[])new Object[0]));
            varRoot.put("parent.id", 0L);
            varRoot.put("cp", null);
            varRoot.put("dt", "v");
            varRoot.put("chk", Boolean.TRUE);
            varTypeData.add(varRoot);
            if (_f7Param.getVariableType() != 1 && SysDimensionEnum.BudgetPeriod.getNumber().equals(_f7Param.getDimensionNumber())) {
                HashMap<String, Object> multiVar = new HashMap<String, Object>();
                multiVar.put("id", F7Constant.MULTI_VAR_ID);
                multiVar.put(F7Constant.DEFAULT_SHOW_FIELDS[0], "Year variables");
                multiVar.put(F7Constant.DEFAULT_SHOW_FIELDS[1], ResManager.loadKDString((String)"\u5e74\u53d8\u91cf", (String)"VariableManagerList_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                multiVar.put("parent.id", F7Constant.VAR_TYPE_ID);
                multiVar.put("cp", null);
                multiVar.put("dt", "v");
                multiVar.put("chk", Boolean.TRUE);
                varTypeData.add(multiVar);
            }
            if (_f7Param.getVariableType() != 2 && SysDimensionEnum.BudgetPeriod.getNumber().equals(_f7Param.getDimensionNumber())) {
                HashMap<String, Object> singleVar = new HashMap<String, Object>();
                singleVar.put("id", F7Constant.SINGLE_VAR_ID);
                singleVar.put(F7Constant.DEFAULT_SHOW_FIELDS[0], "Period variables");
                singleVar.put(F7Constant.DEFAULT_SHOW_FIELDS[1], ResManager.loadKDString((String)"\u671f\u95f4\u53d8\u91cf", (String)"VariableManagerList_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                singleVar.put("parent.id", F7Constant.VAR_TYPE_ID);
                singleVar.put("cp", null);
                singleVar.put("dt", "v");
                singleVar.put("chk", Boolean.TRUE);
                varTypeData.add(singleVar);
            }
        }
        return varTypeData;
    }

    public String[] getShowTypes() {
        if (this.showTypes == null) {
            this.showTypes = F7TreeUtils.getShowType((ShowTypeEnum)this.getF7Parameter().getShowType(), (boolean)this.getF7Parameter().isShowShowNumber(this.getF7Parameter().baseEntityNumber()));
        }
        return this.showTypes;
    }

    protected TreeNode transNode(@NotNull Map<String, Object> nodeData) {
        Long memberId;
        boolean isF8;
        EbTreeNode node = new EbTreeNode();
        node.setId(IDUtils.toString((Object)nodeData.get("id")));
        node.setParentid(IDUtils.toString((Object)nodeData.get("parent.id")));
        node.setText(F7TreeUtils.nodeShowType(nodeData, (String[])this.getShowTypes()));
        Object isLeaf = nodeData.get("isleaf");
        Object chk = nodeData.get("chk");
        Object dt = nodeData.get("dt");
        boolean hasVar = StringUtils.equals((String)"v", (String)((String)dt));
        boolean bl = isF8 = this.getF7Parameter().getFunctionType() == 1;
        if (isLeaf instanceof Boolean) {
            boolean _isLeaf = (Boolean)isLeaf;
            if (!_isLeaf) {
                boolean _showChildren;
                node.addChildren(new ArrayList());
                Object showChildren = nodeData.get("showchildren");
                if (showChildren instanceof Boolean && !(_showChildren = ((Boolean)showChildren).booleanValue())) {
                    node.setChildren(null);
                }
                if (isF8 && this.getF7Parameter().isOnlySelLeaf() && this.getF7Parameter().isView()) {
                    node.setDisabled(true);
                }
            }
            if (isF8 && (StringUtils.isEmpty((String)node.getParentid()) || "0".equals(node.getParentid()))) {
                if (!this.getF7Parameter().isCanSelectRoot()) {
                    node.setDisabled(true);
                }
                if (!hasVar && this.getF7Parameter().getPermissionIds() != null && !this.getF7Parameter().getPermissionIds().contains(IDUtils.toLong((Object)node.getId()))) {
                    node.setDisabled(true);
                }
            }
        }
        if (isF8 && chk != null) {
            node.setDisabled(true);
        }
        Long l = memberId = this.getF7Parameter().isView() ? IDUtils.toLong((Object)nodeData.get("memberid")) : IDUtils.toLong((Object)nodeData.get("id"));
        if (isF8 && !hasVar && !node.isDisabled() && this.isDisabled(memberId)) {
            node.setDisabled(true);
        }
        if (this.checkHasSelect(memberId)) {
            this.getSelected().add(node);
        }
        node.setData(nodeData);
        return node;
    }

    protected boolean checkHasSelect(@NotNull Long pk) {
        if (this.getF7Parameter().getFunctionType() == 1) {
            if (!this.loadSelected) {
                this.selectIds = this.getF7Parameter().getSelectedData();
                this.loadSelected = true;
            }
            return this.selectIds != null && this.selectIds.containsKey(pk) || this.getShowSelectedIds() != null && this.getShowSelectedIds().contains(pk);
        }
        return false;
    }

    protected Long getNodeId(@NotNull Map<String, Object> nodeData) {
        return (Long)nodeData.get("id");
    }

    protected Long getNodeMemberId(@NotNull Map<String, Object> nodeData) {
        return (Long)nodeData.get("memberid");
    }

    @Override
    protected List<TreeNode> getChildrenNode(TreeNode parent, TreeNode root, IPageCache pageCache) {
        List treeData;
        if (parent == null) {
            return null;
        }
        MemberF7Parameter _f7Param = this.getF7Parameter();
        this.getStats().addInfo("begin-query-stepData.");
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryTreeData", (String)_f7Param.entityNumber(), (String)_f7Param.fields(), (QFilter[])this.getStepFilters(parent), (String)"dseq");){
            treeData = CommonServiceHelper.transDataSet((DataSet)ds);
        }
        this.getStats().add("end-query-stepData.");
        return this.transTreeNodes(parent, root, treeData);
    }

    @Override
    protected boolean isVerifyPermission() {
        return this.getF7Parameter().isVerifyPermission();
    }

    @Override
    protected Set<Long> loadPermission() {
        return this.getF7Parameter().loadPermission(this.getStats());
    }
}

