/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.tree;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.tree.DynamicTreeBuilder;
import kd.epm.eb.business.tree.EbTreeNode;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.QFBuilder;
import org.jetbrains.annotations.NotNull;

public class MemberTreeBuilder
extends DynamicTreeBuilder {
    public static MemberTreeBuilder get(@NotNull MemberF7Parameter f7Parameter) {
        return new MemberTreeBuilder(f7Parameter);
    }

    public static MemberTreeBuilder get(@NotNull MemberF7Parameter f7Parameter, @NotNull LogStats stats) {
        MemberTreeBuilder builder = MemberTreeBuilder.get(f7Parameter);
        builder.setStats(stats);
        return builder;
    }

    protected MemberTreeBuilder(@NotNull MemberF7Parameter f7Parameter) {
        super(f7Parameter);
    }

    protected boolean hasAccountDim() {
        return SysDimensionEnum.Account.getNumber().equals(this.getF7Parameter().getDimensionNumber());
    }

    @Override
    protected List<TreeNode> transTreeNodes(@NotNull List<Map<String, Object>> treeData, Set<String> parentData, IPageCache pageCache) {
        TreeNode _root;
        Map<String, TreeNode> datasets;
        List<TreeNode> roots = super.transTreeNodes(treeData, parentData, pageCache);
        if (this.hasAccountDim() && !BizModel.isEBByModel((DynamicObject)this.getF7Parameter().getModel()) && !BizModel.isNewEBByModel((DynamicObject)this.getF7Parameter().getModel()) && roots.size() == 1 && !(datasets = this.queryDatasetNode(_root = roots.get(0))).isEmpty()) {
            List _children = _root.getChildren();
            _root.setChildren(new ArrayList<TreeNode>(datasets.values()));
            this.updateAccountByDataset(_root, _children, datasets);
        }
        return roots;
    }

    protected Map<String, TreeNode> queryDatasetNode(TreeNode root) {
        Map _datasets;
        LinkedHashMap datasets = Maps.newLinkedHashMap();
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)this.getF7Parameter().getModelId());
        if (IDUtils.isNotNull((Long)this.getF7Parameter().getBusModelId())) {
            builder.add("businessmodel", "=", (Object)this.getF7Parameter().getBusModelId());
        }
        if (this.getF7Parameter().getDatasetIds() != null) {
            if (this.getF7Parameter().getDatasetIds().isEmpty()) {
                builder.add("id", "=", (Object)0L);
            } else {
                builder.add("id", "in", (Object)this.getF7Parameter().getDatasetIds());
            }
        }
        if ((_datasets = BusinessDataServiceHelper.loadFromCache((String)"eb_dataset", (String)"id, name, number", (QFilter[])builder.toArray(), (String)"number")) != null) {
            boolean isRange = this.getF7Parameter().getFunctionType() == 1;
            for (DynamicObject _dataset : _datasets.values()) {
                TreeNode _node = this.transNode(_dataset);
                _node.setParentid(root.getId());
                if (isRange) {
                    _node.setDisabled(true);
                }
                datasets.put(_node.getId(), _node);
            }
        }
        return datasets;
    }

    protected TreeNode transNode(DynamicObject dataset) {
        EbTreeNode node = new EbTreeNode();
        node.setId(dataset.getString("id"));
        node.setText(ResManager.loadResFormat((String)"\u6570\u636e\u96c6:%1 %2", (String)"MemberTreeBuilder_0", (String)"epm-eb-business", (Object[])new Object[]{dataset.getString("name"), dataset.getString("number")}));
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("id", dataset.get("id"));
        dataMap.put("name", dataset.getString("name"));
        dataMap.put("number", dataset.getString("number"));
        node.setData(dataMap);
        return node;
    }

    protected void updateAccountByDataset(TreeNode root, List<TreeNode> children, Map<String, TreeNode> datasetMap) {
        if (root == null || children == null || datasetMap == null) {
            return;
        }
        for (TreeNode _child : children) {
            String datasetId = IDUtils.toString((Object)this.getTreeNodeProperty(_child, "dataset.id"));
            TreeNode datasetNode = datasetMap.get(datasetId);
            if (datasetNode != null) {
                _child.setParentid(datasetNode.getId());
                datasetNode.addChild(_child);
                continue;
            }
            root.addChild(_child);
        }
    }
}

