/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.tree;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import kd.bos.entity.tree.TreeNode;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.StringUtils;

public class TreeUtils {
    public static void sortNodes(TreeNode node, Comparator comparable) {
        if (node == null || CollectionUtils.isEmpty((Collection)node.getChildren()) || comparable == null) {
            return;
        }
        node.getChildren().sort(comparable);
    }

    public static Comparator<TreeNode> getSortByMemberSource(boolean isView) {
        return (n1, n2) -> {
            if (n1.getData() instanceof Map && n2.getData() instanceof Map) {
                Map n1Data = (Map)n1.getData();
                Map n2Data = (Map)n2.getData();
                if (n1Data != null && n2Data != null) {
                    boolean isViewMember2;
                    String n1Source = (String)n1Data.get("membersource");
                    String n2Source = (String)n2Data.get("membersource");
                    boolean isViewMember1 = TreeUtils.isViewMember(isView, n1Source);
                    if (isViewMember1 == (isViewMember2 = TreeUtils.isViewMember(isView, n2Source))) {
                        return 0;
                    }
                    return isViewMember1 ? 1 : -1;
                }
            }
            return 0;
        };
    }

    private static boolean isViewMember(boolean isView, String source) {
        boolean isViewMember = isView ? StringUtils.equals((String)source, (String)MemberSourceEnum.PRESET.getIndex()) : StringUtils.equals((String)source, (String)MemberSourceEnum.ANALYZE_VIEW.getIndex());
        return isViewMember;
    }
}

