/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.tree;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.epm.eb.business.tree.BaseTreeBuilder;
import kd.epm.eb.business.tree.EbTreeNode;
import kd.epm.eb.common.enums.ShowTypeEnum;
import kd.epm.eb.common.member.f7.F7TreeUtils;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.tree.TreeNodeUtils;
import org.jetbrains.annotations.NotNull;

public class VirtualTreeBuilder
extends BaseTreeBuilder {
    private final MemberF7Parameter f7Parameter;
    private boolean cacheVirtualData = false;
    private List<Map<String, Object>> memberTreeData = null;
    private final Map<String, String> treeParentMap = Maps.newLinkedHashMap();
    private String[] showTypes = null;
    private int minLevel = 999999;
    private List<String[]> virtualMembers = null;

    protected MemberF7Parameter getF7Parameter() {
        return this.f7Parameter;
    }

    public static VirtualTreeBuilder get(@NotNull MemberF7Parameter f7Parameter) {
        return new VirtualTreeBuilder(f7Parameter);
    }

    protected VirtualTreeBuilder(@NotNull MemberF7Parameter f7Parameter) {
        this.f7Parameter = f7Parameter;
    }

    @Override
    protected boolean isVerifyPermission() {
        return false;
    }

    @Override
    protected Set<Long> loadPermission() {
        return null;
    }

    public String getCacheAllDataKey() {
        return "VIRTUAL_F7_DATA";
    }

    public String getCacheAllDataSizeKey() {
        return "VIRTUAL_F7_DATA_COUNT";
    }

    @Override
    public String getCacheTreeKey() {
        if (StringUtils.isNotEmpty((String)this.getTreeKey())) {
            return "CACHE_VIRTUAL_NODE_DATA_" + this.getTreeKey();
        }
        return "CACHE_VIRTUAL_NODE_DATA";
    }

    public String getCacheTreeDataKey() {
        if (StringUtils.isNotEmpty((String)this.getTreeKey())) {
            return "CACHE_VIRTUAL_TREE_DATA_" + this.getTreeKey();
        }
        return "CACHE_VIRTUAL_TREE_DATA";
    }

    public String getCacheTreeParentDataKey() {
        return "CACHE_VIRTUAL_TREE_PARENT_DATA";
    }

    public String getCacheTreeChildDataKey() {
        return "CACHE_VIRTUAL_TREE_CHILD_DATA";
    }

    public VirtualTreeBuilder setCacheVirtualData(boolean cacheVirtualData) {
        this.cacheVirtualData = cacheVirtualData;
        return this;
    }

    public boolean isCacheVirtualData() {
        return this.cacheVirtualData;
    }

    public void setMemberTreeData(List<Map<String, Object>> memberTreeData) {
        this.memberTreeData = memberTreeData;
    }

    public List<Map<String, Object>> getMemberTreeData() {
        return this.memberTreeData;
    }

    @Override
    protected TreeNode getRoot(@NotNull IPageCache pageCache) {
        return this.buildRootTree(pageCache);
    }

    protected Map<String, String> getTreeParentMap() {
        return this.treeParentMap;
    }

    protected TreeNode buildRootTree(@NotNull IPageCache pageCache) {
        TreeNode root;
        LinkedHashMap treeNodeMap = Maps.newLinkedHashMap();
        LinkedHashMap treeChildMap = Maps.newLinkedHashMap();
        List<Map<String, Object>> memberTreeData = this.queryInitData();
        this.orderByData(memberTreeData, this.getTreeParentMap(), treeChildMap);
        List<TreeNode> nodes = this.transTreeNodes(memberTreeData);
        nodes = this.filterTreeNode(nodes, treeNodeMap);
        if (this.isCacheVirtualData()) {
            this.filterData(memberTreeData);
            this.cacheData(pageCache, this.getCacheAllDataKey(), memberTreeData);
            pageCache.put(this.getCacheAllDataSizeKey(), String.valueOf(memberTreeData.size()));
            this.cacheData(pageCache, this.getCacheTreeParentDataKey(), this.getTreeParentMap());
            this.cacheData(pageCache, this.getCacheTreeChildDataKey(), treeChildMap);
        }
        this.cacheNodeData(pageCache, this.getCacheTreeDataKey(), nodes);
        List<TreeNode> roots = this.buildTreeData(nodes, treeNodeMap);
        if (roots.size() == 1) {
            root = roots.get(0);
            root.setParentid("");
        } else {
            this.setShowRoot(false);
            root = super.getRoot(pageCache);
            for (TreeNode _child : roots) {
                _child.setParentid(root.getId());
                root.addChild(_child);
            }
        }
        return root;
    }

    protected List<Map<String, Object>> queryInitData() {
        if (this.getF7Parameter().getVirtualMembers() != null) {
            this.setMemberTreeData(this.getF7Parameter().getVirtualMembers());
        }
        return this.getMemberTreeData() != null ? this.getMemberTreeData() : Collections.emptyList();
    }

    protected void filterData(List<Map<String, Object>> memberTreeData) {
    }

    protected List<TreeNode> transTreeNodes(@NotNull List<Map<String, Object>> memberTreeData) {
        if (memberTreeData.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList nodes = Lists.newArrayListWithExpectedSize((int)memberTreeData.size());
        for (Map<String, Object> _treeData : memberTreeData) {
            if (_treeData == null) continue;
            nodes.add(this.transTreeNode(_treeData));
        }
        return nodes;
    }

    protected TreeNode transTreeNode(Map<String, Object> treeData) {
        EbTreeNode node = new EbTreeNode();
        node.setId(this.getNodeId(treeData));
        node.setParentid(this.getNodeParentId(treeData));
        node.setText(this.getNodeText(treeData));
        node.setData(this.getNodeData(treeData));
        return node;
    }

    protected void orderByData(List<Map<String, Object>> memberTreeData, @NotNull Map<String, String> treeParentMap, @NotNull Map<String, Set<String>> treeChildMap) {
        if (memberTreeData == null || memberTreeData.isEmpty()) {
            return;
        }
        HashMap treeNodeMap = Maps.newHashMapWithExpectedSize((int)memberTreeData.size());
        for (Map<String, Object> _member : memberTreeData) {
            String id = this.getNodeId(_member);
            String parentId = this.getNodeParentId(_member);
            treeParentMap.put(id, parentId);
            Set childIds = treeChildMap.computeIfAbsent(parentId, f -> Sets.newHashSet());
            childIds.add(id);
            treeNodeMap.put(id, _member);
        }
        this.orderBy(memberTreeData, treeNodeMap);
    }

    protected void orderBy(List<Map<String, Object>> members, @NotNull Map<String, Map<String, Object>> treeDataMap) {
        if (members == null || members.isEmpty()) {
            return;
        }
        members.forEach(member -> this.setOrderBy((Map<String, Object>)member, treeDataMap, (Map<String, Integer>)new LinkedHashMap<String, Integer>()));
        try {
            members.sort((o1, o2) -> {
                Integer[] order1 = (Integer[])this.getData((Map<String, Object>)o1, this.getAllOrderKey());
                Integer[] order2 = (Integer[])this.getData((Map<String, Object>)o2, this.getAllOrderKey());
                int count = Math.min(order1.length, order2.length);
                int re = 0;
                for (int index = 0; index < count; ++index) {
                    Integer v1 = order1[index];
                    Integer v2 = order2[index];
                    re = v1.compareTo(v2);
                    if (re == 0) continue;
                    return re;
                }
                re = order1.length - order2.length;
                if (re == 0) {
                    String number1 = (String)this.getData((Map<String, Object>)o1, "number");
                    String number2 = (String)this.getData((Map<String, Object>)o2, "number");
                    re = number1.compareTo(number2);
                }
                return re;
            });
        }
        catch (Throwable ex) {
            log.error(CommonServiceHelper.getStackTraceStr((Throwable)ex));
        }
    }

    private void setOrderBy(@NotNull Map<String, Object> member, @NotNull Map<String, Map<String, Object>> treeDataMap, @NotNull Map<String, Integer> orderMap) {
        Integer[] allOrder;
        String parentId = IDUtils.toString((Object)this.getData(member, this.getNodeParentIdKey()));
        String currOrderBy = (String)this.getData(member, this.getOrderKey());
        Integer currOrder = orderMap.computeIfAbsent(currOrderBy, f -> Integer.valueOf(currOrderBy));
        Map<String, Object> parent = treeDataMap.get(parentId);
        if (parent != null) {
            Integer[] parentOrder = (Integer[])this.getData(parent, this.getAllOrderKey());
            if (parentOrder == null) {
                this.setOrderBy(parent, treeDataMap, orderMap);
                parentOrder = (Integer[])this.getData(parent, this.getAllOrderKey());
            }
            allOrder = new Integer[parentOrder.length + 1];
            System.arraycopy(parentOrder, 0, allOrder, 0, parentOrder.length);
            allOrder[parentOrder.length] = currOrder;
        } else {
            allOrder = new Integer[]{currOrder};
        }
        member.put(this.getAllOrderKey(), allOrder);
    }

    protected String getNodeId(@NotNull Map<String, Object> treeData) {
        return (String)this.getData(treeData, this.getNodeIdKey());
    }

    protected Object getData(@NotNull Map<String, Object> treeData, @NotNull String propertyKey) {
        return treeData.get(propertyKey);
    }

    protected String getNodeIdKey() {
        return "id";
    }

    protected String getNodeParentId(Map<String, Object> treeData) {
        Object value = treeData.get(this.getNodeParentIdKey());
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return IDUtils.toString((Object)value);
        }
        return value.toString();
    }

    protected String getNodeParentIdKey() {
        return "parent.id";
    }

    public String[] getShowTypes() {
        if (this.showTypes == null) {
            this.showTypes = F7TreeUtils.getShowType((ShowTypeEnum)this.getF7Parameter().getShowType());
        }
        return this.showTypes;
    }

    protected String getNodeText(Map<String, Object> treeData) {
        return F7TreeUtils.nodeShowType(treeData, (String[])this.getShowTypes());
    }

    protected String getLeafKey() {
        return "isleaf";
    }

    protected String getLevelKey() {
        return "level";
    }

    protected String getOrderKey() {
        return "dseq";
    }

    protected String getAllOrderKey() {
        return "adseq";
    }

    protected Object getNodeMapData(TreeNode node, String property) {
        if (node != null && node.getData() instanceof Map) {
            return ((Map)node.getData()).get(property);
        }
        return null;
    }

    protected Map<String, Object> getNodeData(Map<String, Object> treeData) {
        if (treeData == null || treeData.isEmpty()) {
            return null;
        }
        return new HashMap<String, Object>(treeData);
    }

    public void setMinLevel(int minLevel) {
        if (minLevel < this.minLevel) {
            this.minLevel = minLevel;
        }
    }

    public int getMinLevel() {
        return this.minLevel;
    }

    protected List<TreeNode> filterTreeNode(List<TreeNode> nodes, @NotNull Map<String, TreeNode> treeNodeMap) {
        if (nodes == null) {
            return Collections.emptyList();
        }
        ArrayList filters = Lists.newArrayListWithExpectedSize((int)nodes.size());
        HashMap levelMap = Maps.newHashMapWithExpectedSize((int)32);
        LinkedHashSet parentIds = Sets.newLinkedHashSet();
        boolean notShowLeaf = !this.getF7Parameter().isShowLeaf();
        for (TreeNode node : nodes) {
            Object obj = this.getNodeMapData(node, this.getLeafKey());
            boolean isLeaf = "1".equals(obj);
            if (notShowLeaf && isLeaf) continue;
            obj = this.getNodeMapData(node, this.getLevelKey());
            if (obj instanceof String) {
                String levelStr = (String)obj;
                int level = levelMap.computeIfAbsent(levelStr, f -> Integer.parseInt(levelStr));
                this.setMinLevel(level);
            }
            filters.add(node);
            treeNodeMap.put(node.getId(), node);
            parentIds.add(node.getParentid());
        }
        this.children(filters, parentIds);
        return filters;
    }

    protected void children(List<TreeNode> nodes, @NotNull Set<String> parentIds) {
        if (nodes == null || nodes.isEmpty()) {
            return;
        }
        nodes.stream().filter(n -> parentIds.contains(n.getId())).forEach(n -> n.setChildren(new ArrayList()));
    }

    protected List<TreeNode> buildTreeData(List<TreeNode> nodes, @NotNull Map<String, TreeNode> treeNodeMap) {
        if (nodes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList roots = Lists.newArrayList();
        int showLevel = this.getMinLevel() + 1;
        for (TreeNode node : nodes) {
            TreeNode parent = treeNodeMap.get(node.getParentid());
            if (parent != null) {
                if (parent.getChildren() == null) {
                    parent.setChildren(new ArrayList());
                }
                if (Integer.parseInt((String)this.getNodeMapData(node, this.getLevelKey())) > showLevel) continue;
                parent.getChildren().add(node);
                continue;
            }
            roots.add(node);
        }
        return roots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<TreeNode> getChildrenNode(TreeNode parent, TreeNode root, IPageCache pageCache) {
        if (parent == null) {
            return null;
        }
        this.getStats().addInfo("begin-load-stepData.");
        try {
            List<TreeNode> list = this.loadStopTreeNode(this.getF7Parameter(), parent, root, pageCache);
            return list;
        }
        finally {
            this.getStats().add("end-load-stepData.");
            log.info(this.getStats().toString());
        }
    }

    protected List<TreeNode> loadStopTreeNode(MemberF7Parameter f7Param, TreeNode parent, TreeNode root, IPageCache pageCache) {
        if (parent == null) {
            return null;
        }
        String parentId = parent.getId();
        List allNodes = (List)F7TreeUtils.getCacheObjectData((IPageCache)pageCache, (String)this.getCacheTreeDataKey());
        if (allNodes != null) {
            return allNodes.stream().filter(n -> n != null && StringUtils.equals((String)parentId, (String)n.getParentid())).collect(Collectors.toList());
        }
        return null;
    }

    public void setVirtualMembers(List<String[]> virtualMembers) {
        this.virtualMembers = virtualMembers;
    }

    public List<String[]> getVirtualMembers() {
        return this.virtualMembers;
    }

    @Override
    protected void nodeClick(TreeView treeView, TreeNode node) {
    }

    @Override
    protected TreeNode getFocusNode(TreeNode root) {
        String _parentId;
        String[] _virtualMember;
        TreeNode node = super.getFocusNode(root);
        List<String[]> _virtualMembers = this.getVirtualMembers();
        if (_virtualMembers != null && !_virtualMembers.isEmpty() && StringUtils.isNotEmpty((String)(_virtualMember = _virtualMembers.get(0))[0]) && StringUtils.isNotEmpty((String)(_parentId = this.getTreeParentMap().get(_virtualMember[0])))) {
            TreeNode _parent = root.getTreeNode(_parentId);
            if (_parent == null) {
                List parentIds = TreeNodeUtils.getParentIds((String)_virtualMember[0], this.getTreeParentMap());
                Collections.reverse(parentIds);
                this.stepLoadTree(root, parentIds, this.getCacheTreeKey(), null, this.getPageCache());
                _parent = root.getTreeNode(_parentId);
            }
            if (_parent != null) {
                node = _parent;
            }
        }
        return node;
    }
}

