/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.userremember.dao;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.userremember.entity.UserRememberEntity;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.lang.StringUtils;

public class UserRememberDao {
    private static final UserRememberDao INSTANCE = new UserRememberDao();
    private static final String defaultKeyGroup = "defaultKeyGroup";

    public static UserRememberDao getINSTANCE() {
        return INSTANCE;
    }

    public DynamicObject[] getUserRememberDynamicObj(String key, String keyGroup) {
        QFilter filter = new QFilter("key", "=", (Object)key);
        filter.and("keygroup", "=", (Object)(StringUtils.isEmpty((String)keyGroup) ? defaultKeyGroup : keyGroup));
        return BusinessDataServiceHelper.load((String)"epm_userremember", (String)"id, keygroup, key, value, createdate, createuser, updatedate, updateuser", (QFilter[])filter.toArray());
    }

    public void insertUserRemember(String key, Object value, String keyGroup) {
        UserRememberEntity userRememberEntity = new UserRememberEntity();
        userRememberEntity.setCreateUser(this.getUserId());
        userRememberEntity.setCreateDate(this.getCurrentSysTime());
        userRememberEntity.setUpdateDate(this.getCurrentSysTime());
        userRememberEntity.setUpdateUser(this.getUserId());
        userRememberEntity.setKey(key);
        userRememberEntity.setValue(value.toString());
        userRememberEntity.setKeyGroup(StringUtils.isEmpty((String)keyGroup) ? defaultKeyGroup : keyGroup);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{userRememberEntity.convertToDynamicObject()});
    }

    public void updateUserRemember(DynamicObject dynamicObject, String key, Object value, String keyGroup) {
        dynamicObject.set("key", (Object)key);
        dynamicObject.set("value", value);
        dynamicObject.set("keygroup", (Object)(StringUtils.isEmpty((String)keyGroup) ? defaultKeyGroup : keyGroup));
        dynamicObject.set("updatedate", (Object)this.getCurrentSysTime());
        dynamicObject.set("updateuser", (Object)this.getUserId());
        SaveServiceHelper.update((DynamicObject)dynamicObject);
    }

    public void deleteUserRemember(String key, String keyGroup) {
        QFilter qFilter = null;
        if (StringUtils.isNotEmpty((String)key) && StringUtils.isNotEmpty((String)keyGroup)) {
            qFilter = new QFilter("key", "=", (Object)key).and(new QFilter("keygroup", "=", (Object)keyGroup));
        } else if (StringUtils.isNotEmpty((String)key)) {
            qFilter = new QFilter("key", "=", (Object)key);
        } else if (StringUtils.isNotEmpty((String)keyGroup)) {
            qFilter = new QFilter("keygroup", "=", (Object)keyGroup);
        }
        if (qFilter != null) {
            DeleteServiceHelper.delete((String)"epm_userremember", (QFilter[])new QFilter[]{qFilter});
        }
    }

    public Date getCurrentSysTime() {
        return TimeServiceHelper.now();
    }

    private Long getUserId() {
        return IDUtils.toLong((Object)RequestContext.get().getUserId());
    }
}

