/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.userremember.service;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.userremember.dao.UserRememberDao;
import kd.epm.eb.business.userremember.entity.UserRememberEntity;
import org.apache.commons.lang.StringUtils;

public class UserRememberService {
    private static final Log log = LogFactory.getLog(UserRememberService.class);
    private UserRememberDao userRememberDao = UserRememberDao.getINSTANCE();
    private static final UserRememberService INSTANCE = new UserRememberService();

    public static UserRememberService getInstance() {
        return INSTANCE;
    }

    private UserRememberService() {
    }

    public boolean saveRemember(String key, Object value, String keyGroup) {
        if (StringUtils.isEmpty((String)key) || value == null) {
            return false;
        }
        try {
            DynamicObject[] userRememberDynamicObj = this.userRememberDao.getUserRememberDynamicObj(key, keyGroup);
            if (userRememberDynamicObj == null || userRememberDynamicObj.length == 0) {
                this.userRememberDao.insertUserRemember(key, value, keyGroup);
            } else {
                this.userRememberDao.updateUserRemember(userRememberDynamicObj[0], key, value, keyGroup);
            }
            return true;
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
            return false;
        }
    }

    public UserRememberEntity getUserRemember(String key, String keyGroup) {
        UserRememberEntity userRememberEntity = new UserRememberEntity();
        DynamicObject[] userRememberDynamicObj = this.userRememberDao.getUserRememberDynamicObj(key, keyGroup);
        if (userRememberDynamicObj == null || userRememberDynamicObj.length == 0) {
            return userRememberEntity;
        }
        return userRememberEntity.convertDynamicToEntity(userRememberDynamicObj[0]);
    }

    public void deleteUserRemember(String key, String keyGroup) {
        this.userRememberDao.deleteUserRemember(key, keyGroup);
    }
}

