/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.userselect;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.userremember.entity.UserRememberEntity;
import kd.epm.eb.business.userremember.service.UserRememberService;
import kd.epm.eb.business.userselect.WholeUserSelect;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.permission.FunPermissionHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.model.permission.MemberPermHelper;
import kd.epm.eb.model.utils.ModelUtil;

public class UserSelectUtils {
    public static long getUserSelectModelId(IFormView formView) {
        Set<Long> permIds;
        long modelId = 0L;
        ApplicationTypeEnum app = ModelUtil.queryApp(formView);
        ArrayList indexList = null;
        indexList = ApplicationTypeEnum.BGMD == app || ApplicationTypeEnum.BGM == app ? Lists.newArrayList((Object[])new String[]{ApplicationTypeEnum.BGMD.getIndex(), ApplicationTypeEnum.BGM.getIndex(), ApplicationTypeEnum.BGC.getIndex()}) : (ApplicationTypeEnum.EB == app ? Lists.newArrayList((Object[])new String[]{ApplicationTypeEnum.EB.getIndex(), ApplicationTypeEnum.BGC.getIndex()}) : (ApplicationTypeEnum.BGC == app ? Lists.newArrayList((Object[])new String[]{ApplicationTypeEnum.BGMD.getIndex(), ApplicationTypeEnum.BGM.getIndex(), ApplicationTypeEnum.EB.getIndex(), ApplicationTypeEnum.BGC.getIndex()}) : (ApplicationTypeEnum.BG == app ? Lists.newArrayList((Object[])new String[]{ApplicationTypeEnum.BG.getIndex(), ApplicationTypeEnum.BGC.getIndex()}) : (ApplicationTypeEnum.BGBD == app ? Lists.newArrayList((Object[])new String[]{ApplicationTypeEnum.BGBD.getIndex()}) : Lists.newArrayList((Object[])new String[]{ModelUtil.getOtherAppNum(formView)})))));
        QFilter qFilter = new QFilter("application", "in", (Object)indexList);
        qFilter.and("modifier", "=", (Object)UserUtils.getUserId());
        qFilter.and("date", "is not null", (Object)"");
        Object query = QueryServiceHelper.query((String)"epm_userselect", (String)"model,model.reporttype", (QFilter[])qFilter.toArray(), (String)"date desc", (int)1);
        if (query != null && !query.isEmpty()) {
            if (ApplicationTypeEnum.EB == app || ApplicationTypeEnum.BG == app) {
                query = query.stream().filter(doj -> app.getIndex().equals(doj.getString("model.reporttype"))).collect(Collectors.toList());
            } else if (ApplicationTypeEnum.BGMD == app || ApplicationTypeEnum.BGM == app) {
                query = query.stream().filter(doj -> ApplicationTypeEnum.BGMD.getIndex().equals(doj.getString("model.reporttype"))).collect(Collectors.toList());
            }
            if (!query.isEmpty()) {
                modelId = ((DynamicObject)query.get(0)).getLong("model");
            }
        }
        if (!(permIds = ModelUtil.getModelIds(formView, false)).isEmpty()) {
            if (!permIds.contains(modelId) || !QueryServiceHelper.exists((String)"epm_model", (Object)modelId)) {
                return 0L;
            }
        } else {
            return 0L;
        }
        return modelId;
    }

    public static long getUserSelectModelId(IFormView formView, String modelType) {
        long modelId = 0L;
        ApplicationTypeEnum app = ModelUtil.queryApp(formView);
        ArrayList indexList = null;
        indexList = ApplicationTypeEnum.BGMD == app || ApplicationTypeEnum.BGM == app ? Lists.newArrayList((Object[])new String[]{ApplicationTypeEnum.BGMD.getIndex(), ApplicationTypeEnum.BGM.getIndex(), ApplicationTypeEnum.BGC.getIndex()}) : (ApplicationTypeEnum.EB == app ? Lists.newArrayList((Object[])new String[]{ApplicationTypeEnum.EB.getIndex(), ApplicationTypeEnum.BGC.getIndex()}) : (ApplicationTypeEnum.BGC == app ? Lists.newArrayList((Object[])new String[]{ApplicationTypeEnum.BGMD.getIndex(), ApplicationTypeEnum.BGM.getIndex(), ApplicationTypeEnum.EB.getIndex(), ApplicationTypeEnum.BGC.getIndex()}) : (ApplicationTypeEnum.BG == app ? Lists.newArrayList((Object[])new String[]{ApplicationTypeEnum.BG.getIndex(), ApplicationTypeEnum.BGC.getIndex()}) : (ApplicationTypeEnum.BGBD == app ? Lists.newArrayList((Object[])new String[]{ApplicationTypeEnum.BGBD.getIndex()}) : Lists.newArrayList((Object[])new String[]{ModelUtil.getOtherAppNum(formView)})))));
        QFilter qFilter = new QFilter("application", "in", (Object)indexList);
        qFilter.and("modifier", "=", (Object)UserUtils.getUserId());
        if (StringUtils.isNotEmpty((String)modelType)) {
            qFilter.and("modeltype", "=", (Object)modelType);
        }
        qFilter.and("date", "is not null", (Object)"");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"epm_userselect", (String)"model,model.reporttype", (QFilter[])qFilter.toArray(), (String)"date desc", (int)1);
        if (query != null && !query.isEmpty()) {
            modelId = ((DynamicObject)query.get(0)).getLong("model");
        }
        HashSet<Long> permIds = new HashSet<Long>(16);
        Set effectives = FunPermissionHelper.getEffectiveByPermModel((String)"eb_report_list", (ApplicationTypeEnum)app);
        Set<Long> manageModelIds = MemberPermHelper.getLimitedModelListByUser(app);
        Set perRoleids = FunPermissionHelper.getRoleModel((Long)UserUtils.getUserId(), (String)"epm_model", (ApplicationTypeEnum)app, (String)"eb_report_list", (String)"47150e89000000ac");
        permIds.addAll(effectives);
        permIds.addAll(manageModelIds);
        permIds.addAll(perRoleids);
        if (!permIds.isEmpty()) {
            if (!permIds.contains(modelId) || !QueryServiceHelper.exists((String)"epm_model", (Object)modelId)) {
                return 0L;
            }
        } else {
            return 0L;
        }
        return modelId;
    }

    public static void saveUserSelectModelId(IFormView formView, long modelId) {
        ApplicationTypeEnum app = ModelUtil.queryApp(formView);
        Long userId = UserUtils.getUserId();
        String appIndex = app == null ? ModelUtil.getOtherAppNum(formView) : app.getIndex();
        QFilter qFilter = new QFilter("application", "=", (Object)appIndex);
        qFilter.and("modifier", "=", (Object)userId);
        qFilter.and("modeltype", "=", (Object)UserSelectUtils.getModelType(modelId));
        DynamicObject[] userselects = BusinessDataServiceHelper.load((String)"epm_userselect", (String)"model,date", (QFilter[])qFilter.toArray(), (String)"date desc", (int)1);
        if (userselects == null || userselects.length < 1) {
            DynamicObject userSelectDoj = BusinessDataServiceHelper.newDynamicObject((String)"epm_userselect");
            userSelectDoj.set("model", (Object)modelId);
            userSelectDoj.set("application", (Object)appIndex);
            userSelectDoj.set("modifier", (Object)userId);
            userSelectDoj.set("date", (Object)TimeServiceHelper.now());
            userSelectDoj.set("modeltype", (Object)UserSelectUtils.getModelType(modelId));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{userSelectDoj});
        } else {
            DynamicObject userSelectDoj = userselects[0];
            userSelectDoj.set("model", (Object)modelId);
            userSelectDoj.set("date", (Object)TimeServiceHelper.now());
            SaveServiceHelper.update((DynamicObject)userSelectDoj);
        }
    }

    private static String getModelType(Long modelId) {
        try {
            DynamicObject model_new = ModelUtils.getModel((Long)modelId);
            String reporttype = model_new.getString("reporttype");
            if (ApplicationTypeEnum.EB.getIndex().equals(reporttype)) {
                return ApplicationTypeEnum.EB.getAppnum();
            }
            return ApplicationTypeEnum.BGM.getAppnum();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static long getUserSelectBusinessModelId(IFormView formView, long modelId) {
        if (formView == null || modelId == 0L) {
            return 0L;
        }
        ApplicationTypeEnum app = ModelUtil.queryApp(formView);
        String formId = formView.getEntityId();
        String appIndex = app == null ? ModelUtil.getOtherAppNum(formView) : app.getIndex();
        String keyGroup = appIndex + '`' + formId + "`" + modelId;
        UserRememberEntity userRememberEntity = UserRememberService.getInstance().getUserRemember(UserUtils.getUserId() + "businessModelId", keyGroup);
        if (userRememberEntity != null && StringUtils.isNotEmpty((String)userRememberEntity.getValue())) {
            return Long.parseLong(userRememberEntity.getValue());
        }
        return 0L;
    }

    public static void saveUserSelectBusinessModelId(IFormView formView, long modelId, long businessModelId) {
        if (formView == null || modelId == 0L || businessModelId == 0L) {
            return;
        }
        ApplicationTypeEnum app = ModelUtil.queryApp(formView);
        String formId = formView.getEntityId();
        String appIndex = app == null ? ModelUtil.getOtherAppNum(formView) : app.getIndex();
        String keyGroup = appIndex + '`' + formId + "`" + modelId;
        UserRememberService.getInstance().saveRemember(UserUtils.getUserId() + "businessModelId", String.valueOf(businessModelId), keyGroup);
    }

    public static long getUserSelectDatasetId(IFormView formView, long modelId) {
        if (formView == null || modelId == 0L) {
            return 0L;
        }
        ApplicationTypeEnum app = ModelUtil.queryApp(formView);
        String formId = formView.getEntityId();
        String appIndex = app == null ? ModelUtil.getOtherAppNum(formView) : app.getIndex();
        String keyGroup = appIndex + '`' + formId + "`" + modelId;
        UserRememberEntity userRememberEntity = UserRememberService.getInstance().getUserRemember(UserUtils.getUserId() + "dataSetId", keyGroup);
        if (userRememberEntity != null && StringUtils.isNotEmpty((String)userRememberEntity.getValue())) {
            return Long.parseLong(userRememberEntity.getValue());
        }
        return 0L;
    }

    public static void saveUserSelectDataSetId(IFormView formView, long modelId, long dataSetId) {
        if (formView == null || modelId == 0L || dataSetId == 0L) {
            return;
        }
        ApplicationTypeEnum app = ModelUtil.queryApp(formView);
        String formId = formView.getEntityId();
        String appIndex = app == null ? ModelUtil.getOtherAppNum(formView) : app.getIndex();
        String keyGroup = appIndex + '`' + formId + "`" + modelId;
        UserRememberService.getInstance().saveRemember(UserUtils.getUserId() + "dataSetId", String.valueOf(dataSetId), keyGroup);
    }

    public static WholeUserSelect getWholeUserSelect(IFormView formView) {
        return (WholeUserSelect)UserSelectUtils.getWholeUserSelect(formView, WholeUserSelect.class);
    }

    public static <T> T getWholeUserSelect(IFormView formView, Class<?> valueType) {
        long modelId = UserSelectUtils.getUserSelectModelId(formView);
        if (modelId == 0L) {
            return null;
        }
        ApplicationTypeEnum app = ModelUtil.queryApp(formView);
        String formId = formView.getEntityId();
        String appIndex = app == null ? ModelUtil.getOtherAppNum(formView) : app.getIndex();
        String keyGroup = appIndex + '`' + formId + "`" + modelId;
        UserRememberEntity userRememberEntity = UserRememberService.getInstance().getUserRemember(UserUtils.getUserId() + "WholeUserSelect", keyGroup);
        if (userRememberEntity != null && StringUtils.isNotEmpty((String)userRememberEntity.getValue())) {
            return (T)SerializationUtils.fromJsonString((String)userRememberEntity.getValue(), valueType);
        }
        return null;
    }

    public static <T> void saveWholeUserSelect(IFormView formView, long modelId, T wholeUserSelect) {
        if (modelId == 0L) {
            return;
        }
        ApplicationTypeEnum app = ModelUtil.queryApp(formView);
        String formId = formView.getEntityId();
        String appIndex = app == null ? ModelUtil.getOtherAppNum(formView) : app.getIndex();
        String keyGroup = appIndex + '`' + formId + "`" + modelId;
        String value = SerializationUtils.toJsonString(wholeUserSelect);
        UserRememberService.getInstance().saveRemember(UserUtils.getUserId() + "WholeUserSelect", value, keyGroup);
    }

    public static void saveWholeUserSelect(IFormView formView, WholeUserSelect wholeUserSelect) {
        ApplicationTypeEnum app = ModelUtil.queryApp(formView);
        String formId = formView.getEntityId();
        Long modelId = wholeUserSelect.getModel();
        if (modelId == null || modelId == 0L) {
            return;
        }
        String appIndex = app == null ? ModelUtil.getOtherAppNum(formView) : app.getIndex();
        String keyGroup = appIndex + '`' + formId + "`" + modelId;
        String value = SerializationUtils.toJsonString((Object)wholeUserSelect);
        UserRememberService.getInstance().saveRemember(UserUtils.getUserId() + "WholeUserSelect", value, keyGroup);
    }

    public static <T> T getWholeUserSelectByBusinessModelId(IFormView formView, Long businessModelId, Class<?> valueType) {
        if (formView == null || IDUtils.isEmptyLong((Long)businessModelId).booleanValue()) {
            return null;
        }
        ApplicationTypeEnum app = ModelUtil.queryApp(formView);
        String formId = formView.getEntityId();
        String appIndex = app == null ? ModelUtil.getOtherAppNum(formView) : app.getIndex();
        String keyGroup = appIndex + '`' + formId + "`" + businessModelId;
        UserRememberEntity userRememberEntity = UserRememberService.getInstance().getUserRemember(UserUtils.getUserId() + "WholeUserSelect", keyGroup);
        if (userRememberEntity != null && StringUtils.isNotEmpty((String)userRememberEntity.getValue())) {
            return (T)SerializationUtils.fromJsonString((String)userRememberEntity.getValue(), valueType);
        }
        return null;
    }

    public static <T> void saveWholeUserSelectByBusinessModelId(IFormView formView, Long businessModelId, T wholeUserSelect) {
        if (formView == null || IDUtils.isEmptyLong((Long)businessModelId).booleanValue()) {
            return;
        }
        ApplicationTypeEnum app = ModelUtil.queryApp(formView);
        String formId = formView.getEntityId();
        String appIndex = app == null ? ModelUtil.getOtherAppNum(formView) : app.getIndex();
        String keyGroup = appIndex + '`' + formId + "`" + businessModelId;
        String value = SerializationUtils.toJsonString(wholeUserSelect);
        UserRememberService.getInstance().saveRemember(UserUtils.getUserId() + "WholeUserSelect", value, keyGroup);
    }

    public static int clearUserSelect(Long userId) {
        String whole = userId + "WholeUserSelect";
        String busin = userId + "businessModelId";
        ArrayList keyfilterList = Lists.newArrayList((Object[])new String[]{whole, busin});
        QFilter keyfilter = new QFilter("key", "in", (Object)keyfilterList);
        int delete = DeleteServiceHelper.delete((String)"epm_userremember", (QFilter[])keyfilter.toArray());
        QFilter modifyFilter = new QFilter("modifier", "=", (Object)userId);
        int delete1 = DeleteServiceHelper.delete((String)"epm_userselect", (QFilter[])modifyFilter.toArray());
        return delete + delete1;
    }

    public static void clearUserSelectByModel(IFormView formView, Long modelId) {
        ApplicationTypeEnum app = ModelUtil.queryApp(formView);
        String formId = formView.getEntityId();
        String appIndex = app == null ? ModelUtil.getOtherAppNum(formView) : app.getIndex();
        String keyGroup = appIndex + '`' + formId + "`" + modelId;
        QFilter qFilter = new QFilter("keygroup", "=", (Object)keyGroup);
        DeleteServiceHelper.delete((String)"epm_userremember", (QFilter[])qFilter.toArray());
    }
}

