/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.expr.business.AccountExpr;
import kd.epm.eb.common.dao.formula.UserCreateFelExpress;
import kd.epm.eb.common.dao.formula.service.FelExpress;
import kd.epm.eb.common.enums.status.BizRuleStatusEnum;

public final class ExprServiceHelper {
    public static AccountExpr loadFromReportAccExpr(Long templateId, Map<String, Set<String>> calcParams, QFilter otherQfilter) {
        AccountExpr expr = null;
        if (templateId == null || templateId == 0L || calcParams == null || calcParams.isEmpty()) {
            return expr;
        }
        QFilter q1 = new QFilter("template", "=", (Object)templateId);
        DynamicObjectCollection catalog = QueryServiceHelper.query((String)"eb_brallocateentity", (String)"id,catalog.name,catalog.id catalogId", (QFilter[])new QFilter[]{q1, otherQfilter}, (String)"execseq");
        if (catalog == null || catalog.size() < 1) {
            return expr;
        }
        ArrayList<Long> catalogIds = new ArrayList<Long>(16);
        for (DynamicObject doj : catalog) {
            catalogIds.add(doj.getLong("catalogId"));
        }
        QFilter statusQfilter1 = new QFilter("status", "=", (Object)"1");
        QFilter catalogQfilter = new QFilter("catalog", "in", catalogIds);
        DynamicObjectCollection result = QueryServiceHelper.query((String)"eb_bizruleentity", (String)"id,name,catalog.id catalogId ,generate,executeseq", (QFilter[])new QFilter[]{statusQfilter1, catalogQfilter}, (String)"catalog.id,executeseq");
        LinkedList<String> ids = new LinkedList<String>();
        ArrayList<Object> userCreateIds = new ArrayList<Object>(16);
        for (Long catalogId : catalogIds) {
            for (DynamicObject doj : result) {
                if (!catalogId.equals(doj.getLong("catalogId"))) continue;
                Long id = doj.getLong("id");
                if (!BizRuleStatusEnum.ACCOUNT_RULE_FORMULA.index.equals(doj.getString("generate"))) {
                    userCreateIds.add(id);
                }
                ids.add(String.valueOf(id));
            }
        }
        DynamicObjectCollection bizRules = null;
        QFilter statusQfilter = new QFilter("status", "=", (Object)"1");
        if (userCreateIds.size() > 0) {
            QFilter userCreateIdQfilter = new QFilter("id", "in", userCreateIds);
            bizRules = QueryServiceHelper.query((String)"eb_bizruleentity", (String)"id, name, number, model.id,model.number,content", (QFilter[])new QFilter[]{userCreateIdQfilter, statusQfilter});
        }
        HashMap<String, UserCreateFelExpress> expresz = new HashMap<String, UserCreateFelExpress>(16);
        if (bizRules != null) {
            for (DynamicObject bizRule : bizRules) {
                String script = bizRule.getString("content");
                script = ExprServiceHelper.replaceBlank(script);
                String[] formulas = script.split(";");
                Long id = bizRule.getLong("id");
                String name = bizRule.getString("name");
                int index = ids.indexOf(id.toString());
                int m = 1;
                int len = formulas.length;
                for (int i = 0; i < len; ++i) {
                    String idNew;
                    script = formulas[i];
                    if ((script = script.trim()).length() < 1 || script.startsWith("agg(")) continue;
                    if (formulas.length < 2) {
                        idNew = String.valueOf(id);
                    } else {
                        idNew = String.valueOf(id) + "_p" + m;
                        ids.add(index + m, idNew);
                        ++m;
                    }
                    expresz.put(idNew, new UserCreateFelExpress(idNew, name, Boolean.valueOf(true), Long.valueOf(bizRule.getLong("model.id")), bizRule.getString("model.number"), script, true));
                }
                if (formulas.length <= 1) continue;
                ids.remove(index);
            }
        }
        LinkedList<FelExpress> felExpresses = new LinkedList<FelExpress>();
        for (String s : ids) {
            if (expresz.get(s) == null) continue;
            felExpresses.add((FelExpress)expresz.get(s));
        }
        if (felExpresses.size() < 1) {
            return expr;
        }
        expr = new AccountExpr();
        expr.addMembers(calcParams);
        expr.setFormulas(felExpresses);
        return expr;
    }

    private static String replaceBlank(String str) {
        String dest = "";
        if (str != null) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }

    public static AccountExpr loadFromReportAccExpr(List<Long> bizRuleId, Map<String, Set<String>> calcParams) {
        AccountExpr expr = null;
        if (bizRuleId == null || bizRuleId.isEmpty()) {
            return expr;
        }
        QFilter q1 = new QFilter("id", "in", bizRuleId);
        QFilter statusQfilter = new QFilter("status", "=", (Object)"1");
        DynamicObjectCollection bizRules = QueryServiceHelper.query((String)"eb_bizruleentity", (String)"id, name, number, model.id,model.number,content", (QFilter[])new QFilter[]{q1, statusQfilter});
        LinkedList<FelExpress> felExpresses = new LinkedList<FelExpress>();
        if (bizRules != null) {
            for (DynamicObject bizRule : bizRules) {
                String script2 = bizRule.getString("content");
                script2 = ExprServiceHelper.replaceBlank(script2);
                String[] formulas = script2.split(";");
                String name = bizRule.getString("name");
                String id = bizRule.getString("id");
                for (String script2 : formulas) {
                    if ((script2 = script2.trim()).length() < 1 || script2.startsWith("agg(")) continue;
                    UserCreateFelExpress userCreateFelExpress = new UserCreateFelExpress(id, name, Boolean.valueOf(true), Long.valueOf(bizRule.getLong("model.id")), bizRule.getString("model.number"), script2, false);
                    felExpresses.add((FelExpress)userCreateFelExpress);
                }
            }
        }
        if (felExpresses.size() < 1) {
            return expr;
        }
        expr = new AccountExpr();
        expr.addMembers(calcParams);
        expr.setFormulas(felExpresses);
        return expr;
    }
}

