/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.utils;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.RangeF7PropertyCataEnum;
import kd.epm.eb.common.examine.request.ReportRelation;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.olapdao.FloatRows;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.MemberServiceHelper;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.olap.service.OlapReportService;
import kd.epm.eb.olap.service.request.FloatQueryRequest;
import kd.epm.eb.spread.adaptor.OlapQuerySync;
import kd.epm.eb.spread.baseplugin.AbstractReportPlugin;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.afix.FixTemplateModel;
import kd.epm.eb.spread.template.afix.multisetting.IMultiAreaSetting;
import kd.epm.eb.spread.template.afix.multisetting.MultiAreaSetting;
import kd.epm.eb.spread.template.arearangedim.IRowColDimensionEntry;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.partition.RowColPartition;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.template.viewpointdim.IViewPointDimensionEntry;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class FixReportUtils {
    private String currentOrgNumber = null;
    private String currentOrgLongNumber = null;
    private List<FloatRows> flowRowsList = null;
    private static Log log = LogFactory.getLog(FixReportUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Set<String>> getMemberByTemplateScope(Long reportId, @NotNull ITemplateModel templateModel, MemberPropCache memberPropCache, @NotNull Map<String, Collection<String>> pageMembers, Map<String, Map<String, String>> varValues, Boolean includeNotLeaf) {
        LogStats stats = new LogStats("budget-examine_log:");
        stats.addInfo("begin-float-data.");
        Map<String, Set<String>> floatMembers = null;
        try {
            if (templateModel instanceof FixTemplateModel) {
                floatMembers = this.getFloatData(reportId, (FixTemplateModel)templateModel, memberPropCache, pageMembers, varValues, includeNotLeaf);
                log.info("getMemberByTemplateScope=" + JSON.toJSONString(floatMembers));
            } else {
                floatMembers = Collections.emptyMap();
            }
        }
        finally {
            stats.addInfo("end-float-data.");
            log.info(stats.toString());
        }
        return floatMembers;
    }

    private Map<String, Set<String>> getFloatData(Long reportId, @NotNull FixTemplateModel templateModel, MemberPropCache memberPropCache, @NotNull Map<String, Collection<String>> pageMembers, Map<String, Map<String, String>> varValues, Boolean includeNotLeaf) {
        Set _members;
        LinkedHashMap areaIndexMap = Maps.newLinkedHashMap();
        LinkedHashMap areaFloatRowDims = Maps.newLinkedHashMap();
        LinkedHashMap areaFloatColDims = Maps.newLinkedHashMap();
        LinkedHashMap areaFloatColSections = Maps.newLinkedHashMap();
        templateModel.getAreaRanges().forEach(e -> areaIndexMap.put(e.getAreaRange().split(":")[0], e));
        LinkedHashMap noFixMemberMap = Maps.newLinkedHashMap();
        Long modelId = templateModel.getModelId();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Long datasetId = templateModel.getTemplateBaseInfo().getDatasetID();
        AbstractReportPlugin.checkDimensionisAll((ITemplateModel)templateModel);
        for (IMultiAreaSetting multiAreaSetting : templateModel.getAreaRanges()) {
            String areaIndex = multiAreaSetting.getAreaRangeStart();
            if (multiAreaSetting.getFloatOnWhere() == 0) {
                List<Member[]> list = this.getFloatColSection(templateModel.getModelId(), (IMultiAreaSetting)areaIndexMap.get(areaIndex), varValues, includeNotLeaf, modelCacheHelper, templateModel);
                if (list == null || list.isEmpty()) continue;
                LinkedList floatDimensions = new LinkedList();
                multiAreaSetting.getFloatInfos().forEach(floatInfo -> {
                    RowColPartition rowColPartition = floatInfo.getPartition();
                    List rowColDimensionEntries = rowColPartition.getRowColDimensionEntries();
                    Dimension[] oneFloatRowDims = new Dimension[rowColPartition.getRowColDimensionEntries().size()];
                    for (int i = 0; i < rowColDimensionEntries.size(); ++i) {
                        Dimension dimension = new Dimension();
                        dimension.setNumber(((IRowColDimensionEntry)rowColDimensionEntries.get(i)).getDimension().getNumber());
                        Long viewId = DimensionViewServiceHelper.getViewId((Map)templateModel.getDimemsionViews(), (String)dimension.getNumber(), (String)multiAreaSetting.getAreaRangeStart());
                        for (IDimensionMember dimensionMember : ((IRowColDimensionEntry)rowColDimensionEntries.get(i)).getMembers()) {
                            if (RangeF7PropertyCataEnum.Property.getIndex().equals(dimensionMember.getType())) {
                                Set refMembers = memberPropCache.getRefMembersByLongNumber(dimension.getNumber(), dimensionMember.getLongNumber());
                                if (!CollectionUtils.isNotEmpty((Collection)refMembers)) continue;
                                for (String refMember : refMembers) {
                                    Member member;
                                    if (SysDimensionEnum.Account.getNumber().equals(dimension.getNumber())) {
                                        member = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, refMember);
                                        if (datasetId.longValue() != member.getDatasetId().longValue()) continue;
                                    }
                                    member = new Member(dimension);
                                    member.setNumber(refMember);
                                    member.setRange(RangeEnum.ONLY.getIndex());
                                    dimension.add(member);
                                }
                                continue;
                            }
                            Member member = new Member(dimension);
                            member.setNumber(dimensionMember.getNumber());
                            String realDimByVar = ReportVarUtil.getRealDimByVar((Long)templateModel.getModelId(), (String)member.getNumber(), (String)dimension.getNumber(), (Map)varValues);
                            member.setNumber(realDimByVar);
                            member.setRange(dimensionMember.getScope());
                            if (includeNotLeaf.booleanValue()) {
                                dimension.add(member);
                                continue;
                            }
                            kd.epm.eb.common.cache.impl.Member member1 = modelCacheHelper.getMember(dimensionMember.getNumber(), viewId, realDimByVar);
                            if (member1 == null || !member1.isLeaf()) continue;
                            dimension.add(member);
                        }
                        oneFloatRowDims[i] = dimension;
                    }
                    floatDimensions.add(oneFloatRowDims);
                });
                areaFloatRowDims.put(areaIndex, floatDimensions);
                areaFloatColDims.put(areaIndex, this.getFloatColDims(areaIndex, floatDimensions, templateModel, (IMultiAreaSetting)areaIndexMap.get(areaIndex), pageMembers, memberPropCache, varValues, includeNotLeaf, modelCacheHelper));
                areaFloatColSections.put(areaIndex, list);
                multiAreaSetting.getAreaSheet().iteratorECells(cell -> {
                    Object _dimNumber = cell.getUserObject("dimnumber");
                    Object _memberNumber = cell.getUserObject("number");
                    if (_dimNumber != null && _memberNumber != null) {
                        String dimNumber = String.valueOf(_dimNumber);
                        Long viewId = DimensionViewServiceHelper.getViewId((Map)templateModel.getDimemsionViews(), (String)dimNumber, (String)multiAreaSetting.getAreaRangeStart());
                        String memberNumber = String.valueOf(_memberNumber);
                        if (multiAreaSetting.getRowdims().contains(dimNumber)) {
                            Set fixMembers = noFixMemberMap.computeIfAbsent(dimNumber, f -> Sets.newLinkedHashSet());
                            memberNumber = ReportVarUtil.getRealDimByVar((Long)modelId, (String)memberNumber, (String)dimNumber, (Map)varValues);
                            if (includeNotLeaf.booleanValue()) {
                                fixMembers.add(memberNumber);
                            } else {
                                kd.epm.eb.common.cache.impl.Member member = modelCacheHelper.getMember(dimNumber, viewId, memberNumber);
                                if (member != null && member.isLeaf()) {
                                    fixMembers.add(memberNumber);
                                }
                            }
                        }
                    }
                });
                continue;
            }
            Map map = templateModel.retrieveRowColMembersWithScope(areaIndex);
            if (map == null) continue;
            for (Map.Entry entry : map.entrySet()) {
                Long viewId = DimensionViewServiceHelper.getViewId((Map)templateModel.getDimemsionViews(), (String)((String)entry.getKey()), (String)areaIndex);
                Set noFixMember = noFixMemberMap.computeIfAbsent(entry.getKey(), f -> Sets.newLinkedHashSet());
                for (Member member : (Collection)entry.getValue()) {
                    String realDimByVar = ReportVarUtil.getRealDimByVar((Long)templateModel.getModelId(), (String)member.getNumber(), (String)((String)entry.getKey()), varValues);
                    if (includeNotLeaf.booleanValue()) {
                        noFixMember.add(realDimByVar);
                        continue;
                    }
                    kd.epm.eb.common.cache.impl.Member member1 = modelCacheHelper.getMember((String)entry.getKey(), viewId, realDimByVar);
                    if (member1 == null || !member1.isLeaf()) continue;
                    noFixMember.add(realDimByVar);
                }
            }
        }
        LinkedHashMap floatMember = Maps.newLinkedHashMap();
        this.flowRowsList = this.getFloatData(reportId, (ITemplateModel)templateModel, areaFloatRowDims, areaFloatColDims, areaFloatColSections, varValues);
        if (this.flowRowsList != null && !this.flowRowsList.isEmpty()) {
            for (FloatRows floatRows : this.flowRowsList) {
                List floatDims = floatRows.getFloatDims();
                for (int i = 0; i < floatDims.size(); ++i) {
                    String dimNumber = (String)floatDims.get(i);
                    _members = floatMember.computeIfAbsent(dimNumber, f -> Sets.newLinkedHashSet());
                    for (FloatRows.FloatRow floatRow : floatRows.getFloatRows()) {
                        _members.add(floatRow.getColItems().get(i));
                    }
                }
            }
        }
        for (List list : areaFloatColDims.values()) {
            for (Dimension dimension : list) {
                _members = floatMember.computeIfAbsent(dimension.getNumber(), f -> Sets.newLinkedHashSet());
                for (Member member : dimension.getMembers()) {
                    _members.add(member.getNumber());
                }
            }
        }
        if (!noFixMemberMap.isEmpty()) {
            for (Map.Entry entry : noFixMemberMap.entrySet()) {
                _members = (Set)floatMember.get(entry.getKey());
                if (_members != null) {
                    _members.addAll((Collection)entry.getValue());
                    continue;
                }
                floatMember.put(entry.getKey(), entry.getValue());
            }
        }
        return floatMember;
    }

    private List<FloatRows> getFloatData(Long reportId, @NotNull ITemplateModel templateModel, Map<String, List<Dimension[]>> areaFloatRowDims, Map<String, List<Dimension>> areaFloatColDims, Map<String, List<Member[]>> areaFloatColSection, Map<String, Map<String, String>> varValues) {
        if (areaFloatRowDims.isEmpty() || areaFloatColSection == null || areaFloatColSection.isEmpty()) {
            return null;
        }
        Long modelId = templateModel.getModelId();
        Long datasetId = templateModel.getTemplateBaseInfo().getDatasetID();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        LinkedList<FloatQueryRequest> requests = new LinkedList<FloatQueryRequest>();
        for (IMultiAreaSetting multiAreaSetting : templateModel.getAreaRanges()) {
            if (multiAreaSetting.getFloatOnWhere() != 0) continue;
            int partitionSeq = 0;
            String areaIndex = multiAreaSetting.getAreaRangeStart();
            List<Dimension[]> floatRowDims = areaFloatRowDims.get(areaIndex);
            List<Dimension> floatColDims = areaFloatColDims.get(areaIndex);
            for (MultiAreaSetting.FloatInfo floatInfo : multiAreaSetting.getFloatInfos()) {
                Dimension[] dimensionArray;
                String dimNumber;
                FloatQueryRequest request = new FloatQueryRequest();
                request.setModelId(modelId);
                request.setDatasetId(datasetId);
                request.setNumber(areaIndex);
                request.setSeq(partitionSeq++);
                request.setRangeType(floatInfo.getRangeType());
                request.setFilterTopItems(floatInfo.isFilterTopItems());
                LinkedList<String> floatDims = new LinkedList<String>();
                FloatQueryRequest.FixedDim fixedDim = new FloatQueryRequest.FixedDim();
                fixedDim.setDimNumbers(new LinkedList());
                fixedDim.setMemberNumbers(new LinkedList());
                Map<String, PageViewDimMember> apv = this.getAreaPageViewDims(multiAreaSetting, modelCacheHelper, templateModel.getDimemsionViews(), templateModel.getTemplateBaseInfo().getNumber());
                LinkedList<String> apvMems = new LinkedList<String>();
                if (apv != null && apv.size() > 0) {
                    for (Map.Entry<String, PageViewDimMember> entry : apv.entrySet()) {
                        if (entry.getKey() == null || entry.getValue() == null) continue;
                        fixedDim.getDimNumbers().add(entry.getKey());
                        apvMems.add(entry.getValue().getNumber());
                    }
                }
                List colDims = multiAreaSetting.getColdims();
                fixedDim.getDimNumbers().addAll(colDims);
                List<List<CellDimMember>> colPartitionDimMems = this.getColpartitionDimMems(areaFloatColSection.get(areaIndex));
                for (List<CellDimMember> cellDimMembers : colPartitionDimMems) {
                    if (cellDimMembers != null && !cellDimMembers.contains(null)) {
                        List mems = cellDimMembers.stream().filter(e -> !e.isProperty()).map(CellDimMember::getDimMemberNumber).collect(Collectors.toList());
                        if (apvMems.size() > 0) {
                            LinkedList fixMems = new LinkedList(apvMems);
                            fixMems.addAll(mems);
                            fixedDim.getMemberNumbers().add(fixMems);
                            continue;
                        }
                        fixedDim.getMemberNumbers().add(mems);
                        continue;
                    }
                    throw new KDBizException(ResManager.loadResFormat((String)"\u62a5\u8868\u6a21\u677f\u5728\u6d6e\u52a8\u6570\u636e\u533a\u57df%1\u4e2d\u5217\u7ef4\u6210\u5458\u8bbe\u7f6e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u8bbe\u7f6e\u5e76\u91cd\u65b0\u53d1\u5e03\u3002", (String)"OlapQuerySync_8", (String)"epm-eb-spread", (Object[])new Object[]{areaIndex}));
                }
                if (fixedDim.getMemberNumbers().isEmpty()) continue;
                request.setFixedDim(fixedDim);
                HashMap<String, Long> dimViews = new HashMap<String, Long>(16);
                HashMap<String, Set> memberInfo = new HashMap<String, Set>(16);
                if (floatColDims != null) {
                    floatColDims.forEach(e -> memberInfo.put(e.getNumber(), e.getMembers().stream().map(Member::getNumber).collect(Collectors.toSet())));
                }
                if (!apv.isEmpty()) {
                    apv.forEach((k, v) -> {
                        Set cfr_ignored_0 = memberInfo.put((String)k, Sets.newHashSet((Object[])new String[]{v.getNumber()}));
                    });
                }
                for (int i = 0; i < colDims.size(); ++i) {
                    dimNumber = (String)colDims.get(i);
                    for (int j = 0; j < colPartitionDimMems.size(); ++j) {
                        CellDimMember cellDimMember;
                        Set memNumbers = memberInfo.computeIfAbsent(dimNumber, f -> new HashSet());
                        List<CellDimMember> cellDimMembers = colPartitionDimMems.get(j);
                        CellDimMember cellDimMember2 = cellDimMember = cellDimMembers.size() > i ? cellDimMembers.get(i) : null;
                        if (cellDimMember == null) continue;
                        memNumbers.add(cellDimMember.getDimMemberNumber());
                    }
                }
                if (floatRowDims != null && floatRowDims.size() > request.getSeq() && (dimensionArray = floatRowDims.get(request.getSeq())) != null) {
                    for (Dimension dimension : dimensionArray) {
                        dimNumber = dimension.getNumber();
                        Long viewId = DimensionViewServiceHelper.getViewId((Map)templateModel.getDimemsionViews(), (String)dimNumber, (String)areaIndex);
                        dimViews.put(dimNumber, viewId);
                        if (dimNumber == null || dimension.getMembers() == null || dimension.getMembers().size() <= 0) continue;
                        floatDims.add(dimNumber);
                        Set memNumbers = memberInfo.computeIfAbsent(dimNumber, f -> new HashSet());
                        for (Member member : dimension.getMembers()) {
                            List cacheMems = modelCacheHelper.getMember(dimNumber, viewId, member.getNumber(), member.getRange());
                            if (cacheMems == null) continue;
                            if (floatInfo.getRangeType() == 0) {
                                cacheMems = cacheMems.stream().filter(e -> e.isLeaf()).collect(Collectors.toList());
                            }
                            List collect = null;
                            collect = this.getCurrentOrgLongNumber() != null && SysDimensionEnum.Entity.getNumber().equals(dimNumber) ? cacheMems.stream().filter(e -> e.getNumber() != null && e.getNumber().equals(this.getCurrentOrgNumber()) || e.getLongNumber() != null && e.getLongNumber().startsWith(this.getCurrentOrgLongNumber() + "!")).map(BaseCache::getNumber).collect(Collectors.toList()) : cacheMems.stream().map(BaseCache::getNumber).collect(Collectors.toList());
                            memNumbers.addAll(collect);
                        }
                    }
                }
                request.setFloatDims(floatDims);
                request.setMemberInfo(memberInfo);
                memberInfo.keySet().forEach(d -> dimViews.put((String)d, DimensionViewServiceHelper.getViewId((Map)templateModel.getDimemsionViews(), (String)d, (String)areaIndex)));
                request.setViewMap(dimViews);
                if (request.getRangeType() == 1 && request.isFilterTopItems() && !ModelServiceHelper.isUserHasRootPermByModel((long)UserUtils.getUserId(), (Long)request.getModelId())) {
                    OlapQuerySync.filterTopItems((IModelCacheHelper)modelCacheHelper, floatDims, memberInfo, dimViews);
                }
                log.info("request:{}", (Object)request.toString());
                requests.add(request);
            }
        }
        Iterator iterator = requests.iterator();
        while (iterator.hasNext()) {
            FloatQueryRequest request = (FloatQueryRequest)iterator.next();
            Map memberInfo = request.getMemberInfo();
            memberInfo.forEach((k, v) -> v.removeIf(StringUtils::isEmpty));
            boolean hasEmptyMembers = memberInfo.values().stream().anyMatch(v -> CollectionUtils.isEmpty((Collection)v));
            if (!hasEmptyMembers) continue;
            iterator.remove();
        }
        try {
            return OlapReportService.getInstance().getFloatMember(templateModel.getTemplateBaseInfo().getId().longValue(), requests, templateModel.getTemplateBaseInfo().getFloatcalculate());
        }
        catch (Exception ex) {
            log.error("budget-olap-log : ", (Throwable)ex);
            throw new KDBizException(ResManager.loadResFormat((String)"olap\u67e5\u8be2\u6d6e\u52a8\u6210\u5458\u5931\u8d25\uff0c%1", (String)"OlapQuerySync_5", (String)"epm-eb-spread", (Object[])new Object[]{ThrowableHelper.getMessage((Exception)ex)}));
        }
    }

    private List<List<CellDimMember>> getColpartitionDimMems(List<Member[]> members) {
        LinkedList<List<CellDimMember>> cellDimMems = new LinkedList<List<CellDimMember>>();
        if (members != null) {
            for (Member[] memArray : members) {
                if (memArray == null) continue;
                ArrayList<CellDimMember> cellDimMembers = new ArrayList<CellDimMember>(memArray.length);
                for (int i = 0; i < memArray.length; ++i) {
                    Member member = memArray[i];
                    if (member == null) continue;
                    CellDimMember cellDimMember = new CellDimMember(member.getNumber());
                    if (member.isProperty().booleanValue()) {
                        cellDimMember.setProperty(true);
                    }
                    cellDimMembers.add(cellDimMember);
                }
                cellDimMems.add(cellDimMembers);
            }
        }
        return cellDimMems;
    }

    private Map<String, PageViewDimMember> getAreaPageViewDims(IMultiAreaSetting multiAreaSetting, IModelCacheHelper modelCacheHelper, Map<String, Long> dimViews, String templateNum) {
        HashMap<String, PageViewDimMember> areaPageViewDims = new HashMap<String, PageViewDimMember>(16);
        if (multiAreaSetting != null) {
            List hidedims = multiAreaSetting.getAreaViewpointmembentry();
            String areaIndex = multiAreaSetting.getAreaRangeStart();
            for (IViewPointDimensionEntry hidedim : hidedims) {
                String dimNumber = hidedim.getDimension().getNumber();
                String memNumber = hidedim.getMember().getNumber();
                Long viewId = DimensionViewServiceHelper.getViewId(dimViews, (String)dimNumber, (String)areaIndex);
                kd.epm.eb.common.cache.impl.Member member = modelCacheHelper.getMember(dimNumber, viewId, memNumber);
                if (member != null) {
                    PageViewDimMember pageViewDimMember = new PageViewDimMember(memNumber, member.isLeaf());
                    areaPageViewDims.put(hidedim.getDimension().getNumber(), pageViewDimMember);
                    continue;
                }
                MemberServiceHelper.memberNotExist((String)dimNumber, (String)memNumber, (Long)viewId, (String)templateNum);
            }
        }
        return areaPageViewDims;
    }

    private List<Dimension> getFloatColDims(String areaIndex, List<Dimension[]> floatRowDims, FixTemplateModel templateModel, IMultiAreaSetting multiAreaSetting, @NotNull Map<String, Collection<String>> pageMembers, MemberPropCache memberPropCache, Map<String, Map<String, String>> varValues, Boolean includeNotLeaf, IModelCacheHelper modelCacheHelper) {
        List viewDims;
        Collection members;
        LinkedList<Dimension> result = new LinkedList<Dimension>();
        Map allDimMembers = templateModel.retrieveRowColMembersWithScope(areaIndex);
        if (pageMembers != null) {
            for (Map.Entry<String, Collection<String>> entry : pageMembers.entrySet()) {
                Long viewId = DimensionViewServiceHelper.getViewId((Map)templateModel.getDimemsionViews(), (String)entry.getKey(), (String)areaIndex);
                members = allDimMembers.computeIfAbsent(entry.getKey(), f -> new ArrayList());
                for (String memberNum : entry.getValue()) {
                    String _memberNum = ReportVarUtil.getRealDimByVar((Long)templateModel.getModelId(), (String)memberNum, (String)entry.getKey(), varValues);
                    if (includeNotLeaf.booleanValue()) {
                        members.add(new Member(null, _memberNum, _memberNum));
                        continue;
                    }
                    kd.epm.eb.common.cache.impl.Member member = modelCacheHelper.getMember(entry.getKey(), viewId, _memberNum);
                    if (member == null || !member.isLeaf()) continue;
                    members.add(new Member(null, _memberNum, _memberNum));
                }
            }
        }
        if ((viewDims = templateModel.getViewpointmembentry()) != null && !viewDims.isEmpty()) {
            for (IViewPointDimensionEntry entry : viewDims) {
                members = allDimMembers.computeIfAbsent(entry.getDimension().getNumber(), f -> new ArrayList());
                IDimensionMember _member = entry.getMember();
                Member member = new Member(_member.getId());
                String realDimByVar = ReportVarUtil.getRealDimByVar((Long)templateModel.getModelId(), (String)_member.getNumber(), (String)entry.getDimension().getNumber(), varValues);
                member.setNumber(realDimByVar);
                member.setName(_member.getName());
                if (includeNotLeaf.booleanValue()) {
                    members.add(member);
                    continue;
                }
                Long viewId = DimensionViewServiceHelper.getViewId((Map)templateModel.getDimemsionViews(), (String)entry.getDimension().getNumber(), (String)areaIndex);
                kd.epm.eb.common.cache.impl.Member member1 = modelCacheHelper.getMember(entry.getDimension().getNumber(), viewId, realDimByVar);
                if (member1 == null || !member1.isLeaf()) continue;
                members.add(member);
            }
        }
        if (floatRowDims != null && floatRowDims.size() > 0) {
            Set set = Arrays.stream((Object[])floatRowDims.get(0)).map(d -> d.getNumber()).collect(Collectors.toSet());
            for (Map.Entry entry : allDimMembers.entrySet()) {
                String dimNumber = (String)entry.getKey();
                if (set.contains(dimNumber)) continue;
                Dimension dimension = new Dimension();
                dimension.setNumber(dimNumber);
                ((Collection)entry.getValue()).forEach(m -> {
                    if (RangeF7PropertyCataEnum.Property.getIndex().equals(m.getType())) {
                        Set refMembers = memberPropCache.getRefMembersByLongNumber(dimension.getNumber(), m.getLongNumber());
                        if (CollectionUtils.isNotEmpty((Collection)refMembers)) {
                            for (String refMember : refMembers) {
                                Member member = new Member(dimension);
                                member.setNumber(refMember);
                                member.setRange(RangeEnum.ONLY.getIndex());
                                dimension.add(member);
                            }
                        }
                    } else {
                        Member member = new Member(dimension);
                        String realDimByVar = ReportVarUtil.getRealDimByVar((Long)templateModel.getModelId(), (String)m.getNumber(), (String)dimension.getNumber(), (Map)varValues);
                        member.setNumber(realDimByVar);
                        member.setRange(RangeEnum.ONLY.getIndex());
                        if (includeNotLeaf.booleanValue()) {
                            dimension.add(member);
                        } else {
                            Long viewId = DimensionViewServiceHelper.getViewId((Map)templateModel.getDimemsionViews(), (String)dimension.getNumber(), (String)areaIndex);
                            kd.epm.eb.common.cache.impl.Member member1 = modelCacheHelper.getMember(dimension.getNumber(), viewId, realDimByVar);
                            if (member1 != null && member1.isLeaf()) {
                                dimension.add(member);
                            }
                        }
                    }
                });
                result.add(dimension);
            }
        }
        return result;
    }

    public List<Member[]> getFloatColSection(Long modelId, IMultiAreaSetting multiAreaSetting, Map<String, Map<String, String>> varValues, Boolean includeNotLeaf, @NotNull IModelCacheHelper modelCacheHelper, @NotNull FixTemplateModel templateModel) {
        if (multiAreaSetting == null) {
            return null;
        }
        LinkedList<Member[]> result = new LinkedList<Member[]>();
        List colDims = multiAreaSetting.getColdims();
        if (colDims != null && !colDims.isEmpty()) {
            ISheet sheet = multiAreaSetting.getAreaSheet();
            LinkedList allColMemCells = new LinkedList();
            int colCount = sheet.getRealMaxCols();
            for (int c = 0; c < colCount; ++c) {
                LinkedList<ECell> colMemCells = new LinkedList<ECell>();
                int n = sheet.getRealMaxRows();
                for (int r = 0; r < n; ++r) {
                    ECell eCell = sheet.getECellNotAdd(r, c);
                    if (eCell == null || !colDims.contains(eCell.getUserObject("dimnumber"))) continue;
                    colMemCells.add(eCell);
                }
                if (colMemCells.size() <= 0) continue;
                allColMemCells.add(colMemCells);
            }
            if (allColMemCells.size() > 0) {
                LinkedHashMap dimensionMap = Maps.newLinkedHashMap();
                for (String string : colDims) {
                    Dimension dimension = new Dimension();
                    dimension.setNumber(string);
                    dimensionMap.put(string, dimension);
                }
                for (List list : allColMemCells) {
                    Member[] mems;
                    if (includeNotLeaf.booleanValue()) {
                        mems = new Member[list.size()];
                        result.add(mems);
                        for (int i = 0; i < list.size(); ++i) {
                            String dimNumber = String.valueOf(((ECell)list.get(i)).getUserObject("dimnumber"));
                            String memNumber = String.valueOf(((ECell)list.get(i)).getUserObject("number"));
                            Member member = new Member((Dimension)dimensionMap.get(dimNumber));
                            member.setNumber(ReportVarUtil.getRealDimByVar((Long)modelId, (String)memNumber, (String)dimNumber, varValues));
                            mems[i] = member;
                        }
                        continue;
                    }
                    mems = new Member[list.size()];
                    boolean isLeafCol = true;
                    for (int i = 0; i < list.size(); ++i) {
                        String dimNumber = String.valueOf(((ECell)list.get(i)).getUserObject("dimnumber"));
                        String memNumber = String.valueOf(((ECell)list.get(i)).getUserObject("number"));
                        Member member = new Member((Dimension)dimensionMap.get(dimNumber));
                        String realDimByVar = ReportVarUtil.getRealDimByVar((Long)modelId, (String)memNumber, (String)dimNumber, varValues);
                        Long viewId = DimensionViewServiceHelper.getViewId((Map)templateModel.getDimemsionViews(), (String)dimNumber, (String)multiAreaSetting.getAreaRangeStart());
                        kd.epm.eb.common.cache.impl.Member member1 = modelCacheHelper.getMember(dimNumber, viewId, realDimByVar);
                        if (member1 == null || !member1.isLeaf()) {
                            isLeafCol = false;
                            break;
                        }
                        member.setNumber(realDimByVar);
                        mems[i] = member;
                    }
                    if (!isLeafCol) continue;
                    result.add(mems);
                }
            }
        }
        return result;
    }

    public void addFloatRelationList(Long reportId, FixTemplateModel templateModel, Map<String, List<ReportRelation>> reportRelationMap, Set<String> entityNumberSet) {
        if (this.flowRowsList != null && !this.flowRowsList.isEmpty() && templateModel != null && entityNumberSet != null) {
            for (FloatRows floatRows : this.flowRowsList) {
                String number = floatRows.getNumber();
                Optional<IMultiAreaSetting> first = templateModel.getAreaRanges().stream().filter(areaSetting -> areaSetting.getAreaRange().contains(number)).findFirst();
                List floatDims = floatRows.getFloatDims();
                if (!first.isPresent()) continue;
                IMultiAreaSetting multiAreaSetting = first.get();
                List relationList = reportRelationMap.computeIfAbsent(multiAreaSetting.getAreaRange(), v -> new ArrayList());
                ReportRelation rowRelation = null;
                if (CollectionUtils.isEmpty((Collection)relationList)) {
                    rowRelation = new ReportRelation();
                    rowRelation.setDimNumbers(floatDims.toArray(new String[0]));
                    relationList.add(rowRelation);
                } else {
                    rowRelation = (ReportRelation)relationList.get(0);
                }
                List floatRowList = floatRows.getFloatRows();
                for (FloatRows.FloatRow floatRow : floatRowList) {
                    List colItems = floatRow.getColItems();
                    boolean needAdd = true;
                    for (int i = 0; i < colItems.size(); ++i) {
                        String memberNumber;
                        String dimensionNumber = (String)floatDims.get(i);
                        if (!SysDimensionEnum.Entity.getNumber().equals(dimensionNumber) || entityNumberSet.contains(memberNumber = (String)colItems.get(i))) continue;
                        needAdd = false;
                    }
                    if (!needAdd) continue;
                    rowRelation.addMemberRelation(colItems.toArray(new String[0]));
                }
            }
        }
    }

    public String getCurrentOrgNumber() {
        return this.currentOrgNumber;
    }

    public void setCurrentOrgNumber(String currentOrgNumber) {
        this.currentOrgNumber = currentOrgNumber;
    }

    public String getCurrentOrgLongNumber() {
        return this.currentOrgLongNumber;
    }

    public void setCurrentOrgLongNumber(String currentOrgLongNumber) {
        this.currentOrgLongNumber = currentOrgLongNumber;
    }
}

