/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.UrlUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.billimpexp.BillColGroup;
import kd.epm.eb.business.billimpexp.BillImpExpUtils;
import kd.epm.eb.business.billimpexp.col.ComboCol;
import kd.epm.eb.business.billimpexp.col.DateCol;
import kd.epm.eb.business.billimpexp.col.ExcelCol;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.entity.impExp.ExportSheetInfo;
import kd.epm.eb.common.entity.impExp.TitleGroup;
import kd.epm.eb.common.impexp.ZipFileData;
import kd.epm.eb.common.impexp.ZipFileType;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.excel.WriteExcelUtil;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ImportAndExportUtil {
    private static DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy(true, true));
    private static final Log log = LogFactory.getLog(ImportAndExportUtil.class);
    private static final String EXCEL_XLS = "xls";
    private static final String EXCEL_XLSX = "xlsx";

    public static String export(String fileName, ExportSheetInfo ... sheets) {
        XSSFWorkbook workBook = new XSSFWorkbook();
        CellStyle titleCellStyle = WriteExcelUtil.createCellStyle((Workbook)workBook, (short)IndexedColors.GREY_25_PERCENT.getIndex(), (short)IndexedColors.BLACK.getIndex());
        titleCellStyle.setBorderBottom(BorderStyle.THIN);
        titleCellStyle.setBorderTop(BorderStyle.THIN);
        titleCellStyle.setBorderLeft(BorderStyle.THIN);
        titleCellStyle.setBorderRight(BorderStyle.THIN);
        for (ExportSheetInfo sheet : sheets) {
            XSSFSheet xssfSheet = workBook.createSheet(sheet.getSheetName());
            int rIndex = 0;
            List titleGroups = sheet.getTitleGroups();
            String[] columnNames = sheet.getTitles();
            if (CollectionUtils.isNotEmpty((Collection)titleGroups)) {
                XSSFRow groupRow = xssfSheet.createRow(rIndex);
                Iterator iterator = titleGroups.iterator();
                TitleGroup group = (TitleGroup)iterator.next();
                for (int i = 0; i < columnNames.length; ++i) {
                    XSSFCell cell = groupRow.createCell(i, CellType.STRING);
                    if (i > group.getEndIndex() && iterator.hasNext()) {
                        group = (TitleGroup)iterator.next();
                    }
                    if (i >= group.getBeginIndex() && i <= group.getEndIndex()) {
                        cell.setCellValue(group.getGroupName());
                    }
                    cell.setCellStyle(titleCellStyle);
                }
                for (TitleGroup titleGroup : titleGroups) {
                    xssfSheet.addMergedRegion(new CellRangeAddress(rIndex, rIndex, titleGroup.getBeginIndex(), titleGroup.getEndIndex()));
                }
            }
            int n = ++rIndex;
            ++rIndex;
            XSSFRow headerRow = xssfSheet.createRow(n);
            for (int i = 0; i < columnNames.length; ++i) {
                XSSFCell cell = headerRow.createCell(i, CellType.STRING);
                cell.setCellValue(columnNames[i]);
                cell.setCellStyle(titleCellStyle);
            }
            List datas = sheet.getRowsData();
            for (int i = 0; i < datas.size(); ++i) {
                String[] row = (String[])datas.get(i);
                int rowIndex = i + rIndex;
                XSSFRow xssfRow = xssfSheet.createRow(rowIndex);
                for (int j = 0; j < row.length; ++j) {
                    XSSFCell cell = xssfRow.createCell(j, CellType.STRING);
                    cell.setCellValue(row[j]);
                }
            }
        }
        try {
            return ImportAndExportUtil.writeFile((Workbook)workBook, fileName);
        }
        catch (IOException ex) {
            throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[0]);
        }
    }

    @SafeVarargs
    public static String export(String fileName, ThreeTuple<String, String[], List<String[]>> ... sheets) {
        ExportSheetInfo[] sheetInfos = new ExportSheetInfo[sheets.length];
        for (int i = 0; i < sheets.length; ++i) {
            sheetInfos[i] = new ExportSheetInfo((String)sheets[i].item1, (String[])sheets[i].item2, (List)sheets[i].item3);
        }
        return ImportAndExportUtil.export(fileName, sheetInfos);
    }

    public static String writeFile(Workbook wb, String fileName) throws IOException {
        return ImportAndExportUtil.writeFile(wb, fileName, 10000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeFile(Workbook wb, String fileName, int timeout) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".xlsx", (InputStream)inStream, timeout);
            return string;
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
    }

    public static void addTempFileCheck(String url, String entityNum, String appId, int timeoutSeconds) {
        String tempFileId = UrlUtil.getParam((String)url, (String)"id");
        HashMap<String, String> refEntitiyMap = new HashMap<String, String>(2);
        refEntitiyMap.put("entityNum", entityNum);
        refEntitiyMap.put("appId", appId);
        redisCache.put("TempFileCheckId:" + tempFileId, (Object)SerializationUtils.toJsonString(refEntitiyMap), timeoutSeconds);
    }

    private static void addTempFileCheck(IFormView formView, String url, int timeoutSeconds) {
        String entityNum = formView.getEntityId();
        if (formView instanceof ListView && "bos_list".equals(entityNum)) {
            entityNum = ((ListView)formView).getBillFormId();
        }
        ImportAndExportUtil.addTempFileCheck(url, entityNum, formView.getFormShowParameter().getAppId(), timeoutSeconds);
    }

    public static void exportEntryData(String fileName, String entryKey, IFormView formView, Set<String> ignoreCols, Consumer<BillColGroup> colGroupConsumer) {
        EntryGrid entryGrid = (EntryGrid)formView.getControl(entryKey);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c\u7684\u884c", (String)"ImportAndExportUtil_2", (String)"epm-eb-business", (Object[])new Object[0]));
            return;
        }
        IDataModel dataModel = formView.getModel();
        ArrayList<DynamicObject> selRows = new ArrayList<DynamicObject>(selectRows.length);
        for (int index : selectRows) {
            selRows.add(dataModel.getEntryRowEntity(entryKey, index));
        }
        ImportAndExportUtil.exportEntryData(fileName, entryKey, selRows, formView, ignoreCols, colGroupConsumer);
    }

    public static void exportEntryData(String fileName, String entryKey, List<DynamicObject> entryRows, IFormView formView, Set<String> ignoreCols, Consumer<BillColGroup> colGroupConsumer) {
        if (CollectionUtils.isNotEmpty(entryRows)) {
            Collection<ExcelCol> baseCols;
            BillColGroup entryColGroup = BillImpExpUtils.getColConfig(entryKey, (IDataEntityType)formView.getModel().getDataEntityType().getAllEntities().get(entryKey), true, formView, true, true, ignoreCols);
            if (colGroupConsumer != null) {
                colGroupConsumer.accept(entryColGroup);
            }
            if ((baseCols = entryColGroup.getBaseCols().values()).isEmpty()) {
                return;
            }
            LinkedList<TitleGroup> titleGroups = new LinkedList<TitleGroup>();
            int seq = 0;
            int beginIndex = 0;
            String currentGroupKey = null;
            for (ExcelCol col : baseCols) {
                if (col instanceof ComboCol) {
                    ((ComboCol)col).setShowTitle(true);
                } else if (col instanceof DateCol) {
                    ((DateCol)col).setFormat(true);
                }
                String colGroupKey = col.getColGroupKey();
                if (currentGroupKey != null && !currentGroupKey.equals(colGroupKey) || currentGroupKey == null && colGroupKey != null) {
                    if (currentGroupKey != null) {
                        titleGroups.add(new TitleGroup(entryColGroup.getColGroupInfo().get(currentGroupKey), beginIndex, seq - 1));
                    }
                    currentGroupKey = colGroupKey;
                    beginIndex = seq;
                }
                ++seq;
            }
            if (currentGroupKey != null) {
                titleGroups.add(new TitleGroup(entryColGroup.getColGroupInfo().get(currentGroupKey), beginIndex, seq - 1));
            }
            String[] titles = baseCols.stream().map(ExcelCol::getTitle).collect(Collectors.toList()).toArray(new String[1]);
            ArrayList<String[]> rowsVal = new ArrayList<String[]>(entryRows.size());
            for (DynamicObject row : entryRows) {
                String[] rowVal = new String[baseCols.size()];
                seq = 0;
                for (ExcelCol col : baseCols) {
                    Object val = col.getVal(row);
                    if (val instanceof Pair) {
                        Pair baseDataVal = (Pair)val;
                        val = baseDataVal.p2;
                    }
                    rowVal[seq++] = val == null ? "" : val.toString();
                }
                rowsVal.add(rowVal);
            }
            ExportSheetInfo sheetInfo = new ExportSheetInfo("sheet", titles, rowsVal);
            sheetInfo.setTitleGroups(titleGroups);
            String exportUrl = ImportAndExportUtil.export(fileName, sheetInfo);
            if (StringUtils.isNotEmpty((String)exportUrl)) {
                ImportAndExportUtil.addTempFileCheck(formView, exportUrl, 10000);
                ((IClientViewProxy)formView.getService(IClientViewProxy.class)).addAction("download", (Object)exportUrl);
                formView.showSuccessNotification(ResManager.loadKDString((String)"\u6210\u529f\u5bfc\u51fa%s\u884c\u6570\u636e\u3002", (String)"ImportAndExportUtil_1", (String)"epm-eb-business", (Object[])new Object[]{rowsVal.size()}));
            }
        }
    }

    public static String downloadJsonFile(Object jsonData, String fileName) {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            if (jsonData instanceof byte[]) {
                outStream.write((byte[])jsonData);
            } else {
                outStream.write(jsonData.toString().getBytes("UTF-8"));
            }
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".json", (InputStream)inStream, 43200);
        return url;
    }

    public static void zipDownloadFields(IFormView formView, List<ZipFileData> dataList, String fileName) {
        if (CollectionUtils.isEmpty(dataList)) {
            return;
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ZipOutputStream zipOutputStream = new ZipOutputStream(outStream);
        try {
            FileService fileService = null;
            for (ZipFileData data : dataList) {
                if (data.getFileType() == ZipFileType.WORKBOOK) {
                    Workbook workbook = (Workbook)data.getData();
                    ImportAndExportUtil.zipWorkBook(zipOutputStream, workbook, workbook.getSheetName(0));
                    continue;
                }
                if (data.getFileType() == ZipFileType.JSON) {
                    String jsonData = (String)data.getData();
                    ImportAndExportUtil.zipJsonFile(zipOutputStream, jsonData, data.getFileName());
                    continue;
                }
                if (data.getFileType() != ZipFileType.URL) continue;
                String url = (String)data.getData();
                fileService = ImportAndExportUtil.zipFileByUrl(zipOutputStream, url, data.getFileName(), fileService);
            }
        }
        catch (Exception exception) {
            log.error("epm-eb:exportdata");
            log.error((Throwable)exception);
            throw new KDBizException("system is error, please call manager." + exception.getMessage());
        }
        finally {
            try {
                outStream.close();
                zipOutputStream.close();
            }
            catch (IOException e) {
                log.error("epm-eb:exportdata");
                log.error((Throwable)e);
            }
        }
        ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".zip", (InputStream)inStream, 10000);
        ((IClientViewProxy)formView.getService(IClientViewProxy.class)).addAction("download", (Object)url);
    }

    public static FileService zipFileByUrl(ZipOutputStream zipOutputStream, String url, String fileName, FileService fileService) {
        if (fileService == null) {
            fileService = FileServiceFactory.getAttachmentFileService();
        }
        InputStream inputStream = fileService.getInputStream(url);
        ImportAndExportUtil.zipFile(zipOutputStream, fileName, outputStream -> {
            byte[] buffer = new byte[1024];
            try {
                int bytesRead;
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
                inputStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        return fileService;
    }

    public static void zipJsonFile(ZipOutputStream zipOutputStream, String jsonData, String fileName) {
        if (Objects.isNull(jsonData)) {
            return;
        }
        ImportAndExportUtil.zipFile(zipOutputStream, fileName + ".json", outputStream -> {
            try {
                outputStream.write(jsonData.getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static void zipWorkBook(ZipOutputStream zipOutputStream, Workbook workbook, String excelFileName) {
        if (workbook == null) {
            log.info("zipWorkBook workbook is null.");
            return;
        }
        ImportAndExportUtil.zipFile(zipOutputStream, excelFileName + ".xlsx", outputStream -> {
            try {
                workbook.write((OutputStream)outputStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static void zipFile(ZipOutputStream zipOutputStream, String excelFileName, Consumer<ByteArrayOutputStream> outputStreamConsumer) {
        try {
            int len;
            byte[] buf = new byte[1024];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            outputStreamConsumer.accept(out);
            out.flush();
            zipOutputStream.putNextEntry(new ZipEntry(excelFileName));
            ByteArrayInputStream inStream = new ByteArrayInputStream(out.toByteArray());
            while ((len = inStream.read(buf)) > 0) {
                zipOutputStream.write(buf, 0, len);
            }
            zipOutputStream.closeEntry();
            inStream.close();
            out.close();
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    public static DynamicObject[] loadObjs(BillColGroup colGroup, QFilter filter) {
        String entryFormKey = colGroup.getGroupKey();
        LinkedList fieldKeys = new LinkedList();
        colGroup.getBaseCols().values().forEach(col -> fieldKeys.add(col.getRealKey()));
        colGroup.getChildEntrys().forEach((key, group) -> group.getBaseCols().values().forEach(childCol -> fieldKeys.add(key + "." + childCol.getRealKey())));
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)entryFormKey, (String)String.join((CharSequence)",", fieldKeys), (QFilter[])filter.toArray());
        return objects;
    }

    public static void downFile(IFormView formView, Workbook wb, String fileName) {
        if (fileName != null) {
            if (wb instanceof XSSFWorkbook && fileName.endsWith(EXCEL_XLS)) {
                fileName = fileName.replace(EXCEL_XLS, EXCEL_XLSX);
            } else if (wb instanceof HSSFWorkbook && fileName.endsWith(EXCEL_XLSX)) {
                fileName = fileName.replace(EXCEL_XLSX, EXCEL_XLS);
            }
        }
        try {
            String fileUrl = ImportAndExportUtil.writeFile(wb, fileName);
            ImportAndExportUtil.addTempFileCheck(formView, fileUrl, 10000);
            ((IClientViewProxy)formView.getService(IClientViewProxy.class)).addAction("download", (Object)fileUrl);
        }
        catch (IOException ex) {
            throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[0]);
        }
    }
}

