/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.servicehelper.DimensionServiceHelper;
import kd.epm.eb.common.cache.DimMembPermVerHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.eventbus.EventBusUtil;
import kd.epm.eb.common.eventbus.event.FactoryChangeEvent;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.service.ShrekConfigServiceHelper;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;

public class MemberAddServiceHelper {
    private static final MemberAddServiceHelper instance = new MemberAddServiceHelper();
    public static ThreadLocal<List<Long>> threadLocalId = new ThreadLocal();

    private MemberAddServiceHelper() {
    }

    public static MemberAddServiceHelper getInstance() {
        return instance;
    }

    public void batchAddMembers(Map<DynamicObject, List<String[]>> members, Long modelId) {
        if (members == null || members.size() == 0) {
            return;
        }
        ArrayList<Long> dimIds = new ArrayList<Long>();
        Map<DynamicObject, List<String[]>> viewMembers = this.batchAddDefineMember(modelId, members, dimIds);
        DynamicObject object = members.keySet().iterator().next();
        String name = object.getDynamicObjectType().getName();
        boolean hasView = "eb_viewmember".equals(name);
        if (hasView) {
            List<DynamicObject> addMembers = this.batchAddViewMember(object.getLong("model.id"), viewMembers);
            this.batchAddViewMemberSelected(addMembers);
        }
        CubeUtils.get().checkDimension(modelId, dimIds.toArray(new Long[0]));
        DimMembPermVerHelper.updateVer4BatDimension(dimIds, (Long)modelId, (boolean)false);
        Long dimensionId = object.getLong("dimension_id");
        Long userId = UserUtils.getUserId();
        String traceId = RequestContext.get().getTraceId();
        Set memberIds = hasView ? members.keySet().stream().map(d -> d.getLong("memberid")).collect(Collectors.toSet()) : members.keySet().stream().map(d -> d.getLong("id")).collect(Collectors.toSet());
        EventBusUtil.asyncPost((Object)new FactoryChangeEvent(modelId, dimensionId, memberIds, userId, traceId));
    }

    private List<DynamicObject> batchAddViewMember(Long modelId, Map<DynamicObject, List<String[]>> nodeInfo) {
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(16);
        if (modelId == null || nodeInfo == null) {
            return dynamicObjectList;
        }
        Long userId = UserUtils.getUserId();
        Date createTime = TimeServiceHelper.now();
        HashSet<Long> dimIds = new HashSet<Long>(16);
        HashMap<String, Long> viewIds = new HashMap<String, Long>(16);
        HashMap<String, List> dim2Member = new HashMap<String, List>(16);
        for (Map.Entry<DynamicObject, List<String[]>> entry : nodeInfo.entrySet()) {
            DynamicObject parent = entry.getKey();
            List<String[]> childs = entry.getValue();
            Long l = parent.getLong("dimension.id");
            String dimensionNumber = parent.getString("dimension.number");
            dimIds.add(l);
            List dynamicObjects = dim2Member.computeIfAbsent(dimensionNumber, v -> new ArrayList(16));
            Long viewId = parent.getLong("view.id");
            if (IDUtils.isNotNull((Long)viewId)) {
                viewIds.put(dimensionNumber, viewId);
            }
            int dseq = this.getMemberMaxDseq(parent.getLong("id"));
            for (String[] child : childs) {
                String number = child[0];
                String name = child[1];
                String memberId = child[2];
                DynamicObject member = BusinessDataServiceHelper.newDynamicObject((String)"eb_viewmember");
                member.set("parent", (Object)parent.getLong("id"));
                member.set("longnumber", (Object)(parent.getString("longnumber") + "!" + number));
                member.set("name", (Object)name);
                member.set("number", (Object)number);
                member.set("aggoprt", (Object)"1");
                member.set("enable", (Object)"1");
                member.set("status", (Object)"C");
                member.set("memberid", (Object)Long.valueOf(memberId));
                member.set("isleaf", (Object)true);
                member.set("dseq", (Object)(++dseq));
                member.set("level", (Object)(parent.getInt("level") + 1));
                member.set("membersource", (Object)"0");
                member.set("model", (Object)modelId);
                member.set("dimension", (Object)l);
                member.set("view", (Object)parent.getLong("view.id"));
                member.set("modifier", (Object)userId);
                member.set("modifydate", (Object)createTime);
                member.set("mergernode", (Object)"0");
                member.set("isinnerorg", (Object)"0");
                member.set("isouterorg", (Object)"0");
                dynamicObjectList.add(member);
                dynamicObjects.add(member);
            }
        }
        ArrayList<DynamicObject> returnData = new ArrayList<DynamicObject>(16);
        returnData.addAll(dynamicObjectList);
        Map<Long, List<DynamicObject>> collect = dynamicObjectList.stream().collect(Collectors.groupingBy(c -> c.getLong("parent")));
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])collect.keySet().toArray(new Object[0]), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"eb_viewmember").getDynamicObjectType());
        if (load != null && load.length > 0) {
            for (DynamicObject object : load) {
                object.set("isleaf", (Object)false);
                dynamicObjectList.add(object);
            }
        }
        if (dynamicObjectList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])dynamicObjectList.toArray(new DynamicObject[0]));
        }
        if (!dimIds.isEmpty()) {
            dimIds.forEach(_dimensionId -> CubeUtils.updateDimensionVersion((Long)modelId, (Long)_dimensionId));
        }
        for (Map.Entry entry : dim2Member.entrySet()) {
            this.syncOlapData(modelId, (String)entry.getKey(), (List)entry.getValue(), (Long)viewIds.get(entry.getKey()));
        }
        return returnData;
    }

    private void batchAddViewMemberSelected(List<DynamicObject> addMembers) {
        if (addMembers == null) {
            return;
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(addMembers.size());
        DynamicObject selectMember = null;
        for (DynamicObject addMember : addMembers) {
            selectMember = BusinessDataServiceHelper.newDynamicObject((String)"eb_membersaveselect");
            selectMember.set("memberid", (Object)addMember.getString("memberid"));
            selectMember.set("dimension", (Object)addMember.getString("dimension"));
            selectMember.set("range", (Object)"0");
            selectMember.set("levelcount", (Object)"");
            selectMember.set("curlevel", (Object)addMember.getInt("level"));
            selectMember.set("source", (Object)"0");
            selectMember.set("view", (Object)addMember.getString("view"));
            list.add(selectMember);
        }
        if (list.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
        }
    }

    private int getMemberMaxDseq(Long parentId) {
        QFilter qFilter = new QFilter("parent", "=", (Object)parentId);
        DynamicObjectCollection maxDseq = QueryServiceHelper.query((String)"eb_viewmember", (String)"dseq", (QFilter[])new QFilter[]{qFilter}, (String)"dseq desc", (int)1);
        if (maxDseq != null && maxDseq.size() > 0) {
            return ((DynamicObject)maxDseq.get(0)).getInt("dseq");
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public Map<DynamicObject, List<String[]>> batchAddDefineMember(Long modelId, Map<DynamicObject, List<String[]>> members, List<Long> dimIds) {
        HashMap<DynamicObject, List<String[]>> returnData = new HashMap<DynamicObject, List<String[]>>(members.size());
        ArrayList<DynamicObject> saveData = new ArrayList<DynamicObject>(10);
        HashMap<String, List> dim2Member = new HashMap<String, List>(16);
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Map.Entry<DynamicObject, List<String[]>> entry : members.entrySet()) {
            void var11_11;
            ArrayList<String[]> childen = new ArrayList<String[]>(10);
            DynamicObject dynamicObject = entry.getKey();
            if ("eb_viewmember".equals(dynamicObject.getDataEntityType().getName())) {
                DynamicObject dynamicObject2 = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getString("memberid"), (String)"epm_userdefinedmembertree");
            }
            Long parentid = var11_11.getLong("id");
            Long modelid = var11_11.getLong("model.id");
            Long dimensionId = var11_11.getLong("dimension.id");
            String dimensionNumber = var11_11.getString("dimension.number");
            if (!dimIds.contains(dimensionId)) {
                dimIds.add(dimensionId);
            }
            List dynamicObjects = dim2Member.computeIfAbsent(dimensionNumber, v -> new ArrayList(16));
            String longnumber = var11_11.getString("longnumber");
            int level = var11_11.getInt("level") + 1;
            int maxDseq = DimensionServiceHelper.getDSeq(parentid, "epm_userdefinedmembertree");
            Map<String, List<String>> existNumbers = this.queryExistMembers(modelid, dimensionId, entry.getValue());
            for (String[] addChild : entry.getValue()) {
                String number = addChild[0];
                String name = addChild[1];
                List<String> exist = existNumbers.get(number);
                if (exist != null) {
                    if (!exist.get(1).equals(parentid.toString())) continue;
                    childen.add(new String[]{number, name, exist.get(0)});
                    continue;
                }
                DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"epm_userdefinedmembertree");
                Long id = DBServiceHelper.genGlobalLongId();
                this.dimMemberCommonProperties(object);
                object.set("id", (Object)id);
                object.set("number", (Object)number);
                object.set("name", (Object)name);
                object.set("parent", (Object)parentid);
                object.set("model", (Object)modelid);
                object.set("dimension", (Object)dimensionId);
                object.set("longnumber", (Object)(longnumber + "!" + number));
                object.set("datatype", (Object)"0");
                object.set("level", (Object)level);
                object.set("dseq", (Object)maxDseq);
                ids.add(id);
                ++maxDseq;
                childen.add(new String[]{number, name, id.toString()});
                dynamicObjects.add(object);
                saveData.add(object);
            }
            returnData.put(entry.getKey(), childen);
        }
        threadLocalId.set(ids);
        Map<Long, List<DynamicObject>> collect = saveData.stream().collect(Collectors.groupingBy(c -> c.getLong("parent")));
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"epm_userdefinedmembertree", (String)"isleaf", (QFilter[])new QFilter[]{new QFilter("id", "in", collect.keySet())});
        if (load != null && load.length > 0) {
            for (DynamicObject object : load) {
                object.set("isleaf", (Object)"0");
            }
        }
        SaveServiceHelper.save((DynamicObject[])saveData.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])load);
        if (!dimIds.isEmpty()) {
            dimIds.forEach(_dimensionId -> CubeUtils.updateDimensionVersion((Long)modelId, (Long)_dimensionId));
        }
        for (Map.Entry entry : dim2Member.entrySet()) {
            this.syncOlapData(modelId, (String)entry.getKey(), (List)entry.getValue(), null);
        }
        return returnData;
    }

    private void syncOlapData(long modelId, String dimensionNumber, List<DynamicObject> objs, Long viewId) {
        DynamicObject model = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"epm_model");
        if (ShrekOlapServiceHelper.isStartShrek()) {
            List datasets = IDUtils.isNotNull((Long)viewId) ? DatasetServiceHelper.getDatasets((DynamicObject)model, (Long)viewId) : DatasetServiceHelper.getDatasets((DynamicObject)model, (String)dimensionNumber);
            if (datasets.size() == 0) {
                return;
            }
            ShrekConfig config = ShrekConfigServiceHelper.getDefaultConfig((DynamicObject)model);
            ShrekOlapServiceHelper.addCubeMembers((Model)Model.of((DynamicObject)model), (List)datasets, (String)dimensionNumber, (List)Member.of(objs, (boolean)false), (ShrekConfig)config);
        }
    }

    private void dimMemberCommonProperties(DynamicObject object) {
        Long userId = UserUtils.getUserId();
        Date now = TimeServiceHelper.now();
        object.set("modifier", (Object)userId);
        object.set("modifytime", (Object)now);
        object.set("status", (Object)"C");
        object.set("creator", (Object)userId);
        object.set("createtime", (Object)now);
        object.set("enable", (Object)"1");
        object.set("membersource", (Object)"4");
        object.set("isleaf", (Object)"1");
        object.set("aggoprt", (Object)"1");
    }

    private Map<String, List<String>> queryExistMembers(Long modelId, Long dimensionId, List<String[]> addChilden) {
        ArrayList<String> numbers = new ArrayList<String>(10);
        for (String[] addChild : addChilden) {
            numbers.add(addChild[0]);
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        qFilters.add(new QFilter("dimension", "=", (Object)dimensionId));
        qFilters.add(new QFilter("number", "in", numbers));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"epm_userdefinedmembertree", (String)"id,parent,number", (QFilter[])qFilters.toArray(new QFilter[0]));
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(10);
        for (DynamicObject object : query) {
            ArrayList<String> properties = new ArrayList<String>(4);
            properties.add(object.getString("id"));
            properties.add(object.getString("parent"));
            map.put(object.getString("number"), properties);
        }
        return map;
    }

    public DynamicObject createCommonMemberObject(Long modelId, Long dimensionId, String memberKey) {
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)memberKey);
        object.set("model", (Object)modelId);
        object.set("dimension", (Object)dimensionId);
        this.dimMemberCommonProperties(object);
        return object;
    }
}

