/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.utils;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.ebcommon.common.enums.dimension.SysDimensionEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.utils.StringUtils;

public class PermControlDimUtil {
    private static final String SIGN_01 = "!";

    public static List<Dimension> getPermControlDim(Long modelId) {
        return DimMembPermUtil.getPermControlDim((Long)modelId);
    }

    public static void savePermControlDim(Long modelId, String permControlDimNums) {
        DynamicObject permControlDim = BusinessDataServiceHelper.loadSingle((String)"eb_permcontroldim", (String)"permcontroldim", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray());
        if (permControlDim == null) {
            permControlDim = PermControlDimUtil.getNewDynamicObject("eb_permcontroldim");
            permControlDim.set("id", (Object)DB.genGlobalLongId());
            permControlDim.set("model", (Object)modelId);
        }
        permControlDim.set("permcontroldim", (Object)permControlDimNums);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{permControlDim});
        PermControlDimUtil.updateQuote(modelId, permControlDim.getLong("id"), permControlDimNums);
    }

    private static void updateQuote(Long modelId, Long id, String permControlDimNums) {
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)modelId);
        if (StringUtils.isEmpty((String)permControlDimNums)) {
            return;
        }
        String[] dimNumbers = permControlDimNums.split(SIGN_01);
        if (dimNumbers.length < 1) {
            return;
        }
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>(10);
        for (String dimNumber : dimNumbers) {
            Dimension dimension = orCreate.getDimension(dimNumber);
            if (dimension == null) continue;
            dimensions.add(dimension);
        }
        List<MemberQuoteDao> quotes = PermControlDimUtil.getQuotes(dimensions, modelId, id);
        if (quotes.size() > 0) {
            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"save", (Object[])new Object[]{quotes});
        }
    }

    private static List<MemberQuoteDao> getQuotes(List<Dimension> dimensions, Long modelId, Long resourceId) {
        ArrayList<MemberQuoteDao> quotes = new ArrayList<MemberQuoteDao>(16);
        for (Dimension dimension : dimensions) {
            Long dimensionId = dimension.getId();
            Member member = dimension.getMember(Long.valueOf(0L), dimension.getNumber());
            if (member == null) continue;
            quotes.add(new MemberQuoteDao(modelId, Long.valueOf(0L), dimensionId, member.getId(), MemberQuoteResourceEnum.PermControlDim, resourceId));
        }
        return quotes;
    }

    public static void prePermControlDim(Long modelId) {
        PermControlDimUtil.savePermControlDim(modelId, SysDimensionEnum.Entity.getNumber());
    }

    private static DynamicObject getNewDynamicObject(String entity) {
        return BusinessDataServiceHelper.newDynamicObject((String)entity);
    }
}

