/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.utils.IDUtils;

public class TreeEntryEntityUtils {
    public static final String treeentryentity = "treeentryentity";
    public static final String NUMBER = "number";
    public static final String NAME = "name";

    public static DynamicObject buildMemberTree(IDataModel model, DynamicObject[] members, String[] properties, boolean isVirtual, Long viewid) {
        if (members == null || members.length == 0) {
            return null;
        }
        model.batchCreateNewEntryRow(treeentryentity, members.length);
        HashSet<Long> memberIds = new HashSet<Long>(members.length);
        LinkedHashMap<Long, List<DynamicObject>> childrenMap = new LinkedHashMap<Long, List<DynamicObject>>();
        for (DynamicObject member : members) {
            memberIds.add(member.getLong("id"));
            List children = childrenMap.computeIfAbsent(member.getLong("parent"), f -> Lists.newLinkedList());
            children.add(member);
        }
        Comparator comparator = TreeEntryEntityUtils.getMembDseqComparator();
        for (List entry : childrenMap.values()) {
            entry.sort(comparator);
        }
        DynamicObject root = (DynamicObject)((List)childrenMap.get(0L)).get(0);
        for (DynamicObject member : members) {
            List noParentMembers;
            Long parentId = member.getLong("parent");
            if (IDUtils.isNull((Long)parentId) || memberIds.contains(parentId) || (noParentMembers = (List)childrenMap.get(parentId)) == null) continue;
            childrenMap.remove(parentId);
            List oneLevel = childrenMap.computeIfAbsent(root.getLong("id"), f -> new ArrayList(noParentMembers.size()));
            oneLevel.addAll(noParentMembers);
        }
        DynamicObject row = model.getEntryRowEntity(treeentryentity, 0);
        row.set(NUMBER, (Object)root.getString(NUMBER));
        if (Arrays.stream(properties).anyMatch(e -> "shownumber1".equals(e))) {
            row.set("shownumber1", (Object)root.getString("shownumber"));
        }
        row.set(NAME, (Object)root.getString(NAME));
        row.set("id", (Object)root.getLong("id"));
        row.set("pid", (Object)0);
        DataEntityPropertyCollection rowProperties = row.getDataEntityType().getProperties();
        if (Arrays.stream(properties).anyMatch(x -> "memberref1".equals(x)) && rowProperties.containsKey((Object)"memberref1")) {
            row.set("memberref1", (Object)ResManager.loadKDString((String)"\u67e5\u770b", (String)"DimensionManagerList_90", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        List twolevel = (List)childrenMap.get(root.getLong("id"));
        if (isVirtual && twolevel != null && twolevel.size() > 0) {
            row.set("isgroupnode", (Object)true);
        }
        TreeEntryEntityUtils.expendOneLevel(model, properties, 1, root.getLong("id"), childrenMap, isVirtual, viewid);
        return root;
    }

    private static int expendOneLevel(IDataModel model, String[] properties, int row, Long parentId, Map<Long, List<DynamicObject>> parentMap, boolean isVirtual, Long viewId) {
        List<DynamicObject> children = parentMap.get(parentId);
        if (children == null || children.size() == 0) {
            return row;
        }
        DataEntityPropertyCollection rowProperties = null;
        for (DynamicObject child : children) {
            DynamicObject rowObject = model.getEntryRowEntity(treeentryentity, row);
            if (rowProperties == null) {
                rowProperties = rowObject.getDataEntityType().getProperties();
            }
            for (String property : properties) {
                if ("formulaname".equals(property)) continue;
                if ("modifier".equals(property)) {
                    rowObject.set(property, (Object)child.getString("modifier.name"));
                    continue;
                }
                if ("creator".equals(property) && rowProperties.containsKey((Object)property)) {
                    rowObject.set(property, (Object)child.getString("creator.name"));
                    continue;
                }
                if ("description".equals(property)) {
                    rowObject.set(property, (Object)child.getString("description"));
                    continue;
                }
                if ("type".equals(property)) {
                    rowObject.set(property, child.get("datatype"));
                    continue;
                }
                if ("orgcata".equals(property)) {
                    String orgcata = "0";
                    if (child.getBoolean("isinnerorg")) {
                        orgcata = "1";
                    } else if (child.getBoolean("isouterorg")) {
                        orgcata = "2";
                    }
                    rowObject.set(property, (Object)orgcata);
                    continue;
                }
                if ("currency".equals(property) && rowProperties.containsKey((Object)property)) {
                    rowObject.set(property, (Object)child.getString("currency.name"));
                    continue;
                }
                if (NUMBER.equals(property) && rowProperties.containsKey((Object)property)) {
                    rowObject.set(property, (Object)child.getString(NUMBER));
                    continue;
                }
                if ("shownumber1".equals(property) && rowProperties.containsKey((Object)property)) {
                    rowObject.set(property, (Object)child.getString("shownumber"));
                    continue;
                }
                if ("view".equals(property) && rowProperties.containsKey((Object)property)) {
                    if (StringUtils.isNotEmpty((String)child.getString("refview.name"))) {
                        rowObject.set(property, (Object)child.getString("refview.name"));
                        continue;
                    }
                    rowObject.set(property, (Object)child.getString("view.name"));
                    continue;
                }
                if ("isleaf1".equals(property) && rowProperties.containsKey((Object)property)) {
                    rowObject.set(property, (Object)child.getString("isleaf"));
                    continue;
                }
                if ("memberref1".equals(property) && rowProperties.containsKey((Object)property)) {
                    rowObject.set(property, (Object)ResManager.loadKDString((String)"\u67e5\u770b", (String)"DimensionManagerList_90", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    continue;
                }
                if ("showchildren".equals(property)) {
                    if (!rowProperties.containsKey((Object)property) || child.getBoolean("isleaf")) continue;
                    rowObject.set(property, (Object)child.getBoolean(property));
                    continue;
                }
                if (!rowProperties.containsKey((Object)property)) continue;
                rowObject.set(property, child.get(property));
            }
            rowObject.set("id", (Object)child.getLong("id"));
            rowObject.set("pid", (Object)parentId);
            if (child.containsProperty("syncstatus") && !"1".equals(child.getString("syncstatus"))) {
                rowObject.set("syncstatus", (Object)child.getString("syncstatus"));
            }
            if (isVirtual && !child.getBoolean("isleaf")) {
                rowObject.set("isgroupnode", (Object)true);
            }
            ++row;
            row = TreeEntryEntityUtils.expendOneLevel(model, properties, row, child.getLong("id"), parentMap, isVirtual, viewId);
        }
        return row;
    }

    public static void batchInsertTreeEntryRows(IDataModel model, DynamicObject[] members, String[] properties, int row, Long pid) {
        if (members == null || members.length == 0) {
            return;
        }
        model.getDataEntity(true);
        model.beginInit();
        model.batchInsertEntryRow(treeentryentity, row, members.length);
        model.endInit();
        HashMap<Long, List<DynamicObject>> parentKeyMap = new HashMap<Long, List<DynamicObject>>();
        parentKeyMap.put(pid, Arrays.stream(members).collect(Collectors.toList()));
        TreeEntryEntityUtils.expendOneLevel(model, properties, ++row, pid, parentKeyMap, true, 0L);
    }

    public static void fillTreeEntryEntityUserSeq(IDataModel model, DynamicObjectCollection memberColls, List<String> propertyList, boolean checkIsLeaf) {
        TreeEntryEntityUtils.fillTreeEntryEntityUserSeq(model, memberColls, propertyList, checkIsLeaf, 0L);
    }

    public static void fillTreeEntryEntityUserSeq(IDataModel model, DynamicObjectCollection memberColls, List<String> propertyList, boolean checkIsLeaf, Long parentid) {
        if (memberColls == null || memberColls.size() == 0) {
            return;
        }
        model.getDataEntity(true);
        model.batchCreateNewEntryRow(treeentryentity, memberColls.size());
        DynamicObject root = null;
        String parentKey = "parent";
        if (!(((DynamicObject)memberColls.get(memberColls.size() - 1)).get("parent") instanceof Long)) {
            parentKey = "parent.id";
        }
        LinkedHashSet<Long> allMembIds = new LinkedHashSet<Long>();
        for (DynamicObject memb : memberColls) {
            if (root == null && memb.getLong(parentKey) == parentid.longValue()) {
                root = memb;
            }
            allMembIds.add(memb.getLong("id"));
        }
        if (root == null) {
            return;
        }
        HashMap<Long, TreeSet<DynamicObject>> searchChild = new HashMap<Long, TreeSet<DynamicObject>>();
        if (memberColls != null && memberColls.size() > 0) {
            Comparator comparator = TreeEntryEntityUtils.getMembDseqComparator();
            for (int i = 0; i < memberColls.size(); ++i) {
                DynamicObject memberObject = (DynamicObject)memberColls.get(i);
                long parent = memberObject.getLong(parentKey);
                if (parent == parentid) continue;
                if (!allMembIds.contains(parent)) {
                    parent = root.getLong("id");
                }
                if (searchChild.containsKey(parent)) {
                    ((TreeSet)searchChild.get(parent)).add(memberObject);
                    continue;
                }
                TreeSet<DynamicObject> children = new TreeSet<DynamicObject>(comparator);
                children.add(memberObject);
                searchChild.put(parent, children);
            }
        }
        DynamicObject rowObj = model.getEntryRowEntity(treeentryentity, 0);
        rowObj.set(NUMBER, (Object)root.getString(NUMBER));
        rowObj.set("shownumber", (Object)root.getString("shownumber"));
        rowObj.set(NAME, (Object)root.getString(NAME));
        rowObj.set("id", (Object)root.getLong("id"));
        rowObj.set("pid", (Object)0);
        if (checkIsLeaf && searchChild.size() > 1) {
            rowObj.set("isgroupnode", (Object)true);
        }
        TreeEntryEntityUtils.expandNextLevel(model, propertyList, 0, root, searchChild, checkIsLeaf);
    }

    private static int expandNextLevel(IDataModel model, List<String> propertyList, int row, DynamicObject parent, Map<Long, TreeSet<DynamicObject>> searchChild, boolean checkIsLeaf) {
        if (searchChild.containsKey(parent.getLong("id"))) {
            TreeSet<DynamicObject> childrenMap = searchChild.get(parent.getLong("id"));
            for (DynamicObject child : childrenMap) {
                DynamicObject rowObj = model.getEntryRowEntity(treeentryentity, ++row);
                for (int k = 0; k < propertyList.size(); ++k) {
                    String property = propertyList.get(k);
                    if ("type".equals(property)) {
                        rowObj.set("type", child.get("datatype"));
                    }
                    if ("shownumber".equals(property)) {
                        rowObj.set("shownumber", child.get("shownumber"));
                        continue;
                    }
                    if ("orgcata".equals(property)) {
                        if (child.getBoolean("isinnerorg")) {
                            rowObj.set("orgcata", (Object)"1");
                            continue;
                        }
                        if (child.getBoolean("isouterorg")) {
                            rowObj.set("orgcata", (Object)"2");
                            continue;
                        }
                        rowObj.set("orgcata", (Object)"0");
                        continue;
                    }
                    rowObj.set(property, child.get(property));
                }
                rowObj.set("id", (Object)child.getLong("id"));
                rowObj.set("pid", (Object)parent.getLong("id"));
                if (rowObj.containsProperty("syncdate")) {
                    rowObj.set("syncdate", child.get("syncdate"));
                    if (!"1".equals(child.getString("syncstatus"))) {
                        rowObj.set("syncstatus", child.get("syncstatus"));
                    }
                }
                if (checkIsLeaf && !child.getBoolean("isleaf")) {
                    rowObj.set("isgroupnode", (Object)true);
                }
                row = TreeEntryEntityUtils.expandNextLevel(model, propertyList, row, child, searchChild, checkIsLeaf);
            }
        }
        return row;
    }

    public static Comparator getMembDseqComparator() {
        Comparator comparator = (o1, o2) -> {
            int dseq = o1.getInt("dseq") - o2.getInt("dseq");
            if (dseq == 0) {
                String number1 = o1.getString(NUMBER);
                String number2 = o2.getString(NUMBER);
                return number1.compareTo(number2);
            }
            return dseq;
        };
        return comparator;
    }

    public static int[] focus(IDataModel model, int row) {
        ArrayList<Integer> pids = new ArrayList<Integer>(16);
        DynamicObjectCollection objs = model.getEntryEntity(treeentryentity);
        ArrayList<String> ids = new ArrayList<String>(objs.size());
        for (int i = 0; i < objs.size(); ++i) {
            ids.add(((DynamicObject)objs.get(i)).getString("id"));
        }
        DynamicObject oo = (DynamicObject)objs.get(row);
        String pid = oo.getString("pid");
        while (StringUtils.isNotEmpty((String)pid)) {
            int i = -1;
            if (ids.contains(pid)) {
                i = ids.indexOf(pid);
                pids.add(i);
            }
            if (i != -1) {
                pid = ((DynamicObject)objs.get(i)).getString("pid");
                continue;
            }
            pid = "";
        }
        Collections.sort(pids);
        int[] exids = new int[pids.size()];
        for (int i = 0; i < exids.length; ++i) {
            exids[i] = (Integer)pids.get(i);
        }
        return exids;
    }
}

