/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.utils;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.bos.workflow.engine.dynprocess.freeflow.WFDecisionOption;
import kd.bos.workflow.engine.dynprocess.freeflow.WFFlowElement;
import kd.bos.workflow.engine.dynprocess.freeflow.WFFlowNode;
import kd.bos.workflow.engine.dynprocess.freeflow.WFRejectNodesModel;
import kd.bos.workflow.engine.dynprocess.freeflow.WFUserTask;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityImpl;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.exception.WFEngineException;
import kd.epm.eb.business.centralapproval.CentralAppThreadManager;
import kd.epm.eb.common.approveBill.Entity.RejectNodeInfo;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;

public class WorkFlowUtil {
    private static final Log log = LogFactory.getLog(WorkFlowUtil.class);

    public static WFRejectNodesModel getFirstRejectNode(Long billId) {
        WFRejectNodesModel firstNode;
        block1: {
            WFFlowElement node;
            List<WFFlowElement> wFlowNodes;
            List<WFRejectNodesModel> rejectNodes = WorkFlowUtil.getRejectNodes(billId);
            firstNode = null;
            if (!CollectionUtils.isNotEmpty(rejectNodes) || !CollectionUtils.isNotEmpty(wFlowNodes = WorkFlowUtil.getWFlowNodes("eb_approvebill", billId))) break block1;
            Map<String, WFRejectNodesModel> wfRejectNodesModelMap = rejectNodes.stream().collect(Collectors.toMap(WFRejectNodesModel::getItemId, obj -> obj));
            Iterator<WFFlowElement> iterator = wFlowNodes.iterator();
            while (iterator.hasNext() && (firstNode = wfRejectNodesModelMap.get((node = iterator.next()).getId())) == null) {
            }
        }
        return firstNode;
    }

    public static List<WFFlowElement> getWFlowNodes(String formKey, Long billId) {
        ArrayList<WFFlowElement> allNodes = new ArrayList<WFFlowElement>();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)billId, (String)formKey);
        List elements = WorkflowServiceHelper.getProcessElements((DynamicObject)dynamicObject, (String)"submit");
        WFFlowElement submitNode = null;
        if (elements != null) {
            for (WFFlowElement element : elements) {
                if (!(element instanceof WFUserTask)) continue;
                submitNode = element;
                break;
            }
        }
        if (submitNode != null) {
            HashMap<String, List<WFFlowElement>> parentMap = new HashMap<String, List<WFFlowElement>>();
            HashSet<String> nodeIds = new HashSet<String>(16);
            WorkFlowUtil.selParentMap(parentMap, nodeIds, submitNode);
            allNodes.add(submitNode);
            nodeIds.add(submitNode.getId());
            nodeIds.clear();
            for (int index = 0; index < allNodes.size(); ++index) {
                submitNode = (WFFlowElement)allNodes.get(index);
                List nextNodes = submitNode.getNextNodes();
                if (nextNodes == null) continue;
                for (WFFlowElement childNode : nextNodes) {
                    if (!nodeIds.add(childNode.getId())) continue;
                    WorkFlowUtil.addParentNode(parentMap, allNodes, nodeIds, childNode, 1);
                    allNodes.add(childNode);
                }
            }
        }
        return allNodes;
    }

    private static void addParentNode(Map<String, List<WFFlowElement>> parentMap, List<WFFlowElement> allNodes, Set<String> nodeIds, WFFlowElement node, int checkSign) {
        List<WFFlowElement> parentNodes = parentMap.get(node.getId());
        if (parentNodes != null && parentNodes.size() > checkSign) {
            for (WFFlowElement pNode : parentNodes) {
                if (!nodeIds.add(pNode.getId())) continue;
                WorkFlowUtil.addParentNode(parentMap, allNodes, nodeIds, pNode, 0);
                allNodes.add(pNode);
            }
        }
    }

    private static void selParentMap(Map<String, List<WFFlowElement>> parentMap, Set<String> nodeIds, WFFlowElement parentNode) {
        List nextNodes;
        if (parentNode != null && CollectionUtils.isNotEmpty((Collection)(nextNodes = parentNode.getNextNodes()))) {
            for (WFFlowNode childNode : nextNodes) {
                parentMap.computeIfAbsent(childNode.getId(), key -> new ArrayList()).add(parentNode);
                if (!nodeIds.add(childNode.getId())) continue;
                WorkFlowUtil.selParentMap(parentMap, nodeIds, (WFFlowElement)childNode);
            }
        }
    }

    public static List<WFRejectNodesModel> getRejectNodes(Long billId) {
        String businessKey = String.valueOf(billId);
        Long taskId = WorkflowServiceHelper.getTaskIdByBusinessKeyAndUserId((String)businessKey, (Long)UserUtils.getUserId());
        if (taskId == null || taskId == 0L) {
            return new ArrayList<WFRejectNodesModel>(1);
        }
        String rejectOptionNumber = WorkFlowUtil.getRejectOptionNumber(taskId);
        if (StringUtils.isEmpty((String)rejectOptionNumber)) {
            return new ArrayList<WFRejectNodesModel>(1);
        }
        return WorkFlowUtil.getRejectNodes(taskId, rejectOptionNumber);
    }

    public static String getRejectOptionNumber(Long taskId) {
        List options = (List)WorkFlowUtil.invokeWFService("getApprovalDecisionOptions", taskId);
        if (options.size() == 0) {
            return "Reject";
        }
        for (WFDecisionOption option : options) {
            String auditType = option.getAuditType();
            if (!"reject".equals(auditType)) continue;
            return option.getNumber();
        }
        return null;
    }

    public static void reject2FirstEnableNode(Long billId) {
        RejectNodeInfo firstRejectNodeInfo = WorkFlowUtil.getFirstRejectNodeInfo(billId);
        WorkFlowUtil.reject2FirstEnableNode(firstRejectNodeInfo);
    }

    public static void reject2FirstEnableNode(RejectNodeInfo firstRejectNodeInfo) {
        HashMap<String, Object> variables = new HashMap<String, Object>(16);
        if (firstRejectNodeInfo == null || !firstRejectNodeInfo.isAvailable()) {
            return;
        }
        variables.put("nextNodeId", firstRejectNodeInfo.getRejectNode().getItemId());
        variables.put("dynType", "dynReject");
        try {
            WorkFlowUtil.completeTask(firstRejectNodeInfo.getBusinessKey(), WorkFlowUtil.getCurNodeId(firstRejectNodeInfo.getTaskId()), firstRejectNodeInfo.getUserId(), firstRejectNodeInfo.getRejectOptionNumber(), ResManager.loadKDString((String)"\u9a73\u56de", (String)"WorkFlowUtil_0", (String)"epm-eb-business", (Object[])new Object[0]), false, variables);
        }
        catch (Throwable e) {
            log.error("reject2FirstEnableNode", e);
        }
    }

    public static RejectNodeInfo getFirstRejectNodeInfo(Long billId) {
        WFRejectNodesModel firstRejectNode;
        RejectNodeInfo nodeInfo = new RejectNodeInfo();
        String businessKey = String.valueOf(billId);
        Long userId = UserUtils.getUserId();
        Long taskId = WorkflowServiceHelper.getTaskIdByBusinessKeyAndUserId((String)businessKey, (Long)userId);
        nodeInfo.setUserId(userId);
        nodeInfo.setTaskId(taskId);
        nodeInfo.setBusinessKey(businessKey);
        String rejectOptionNumber = WorkFlowUtil.getRejectOptionNumber(taskId);
        if (StringUtils.isNotEmpty((String)rejectOptionNumber)) {
            nodeInfo.setRejectOptionNumber(rejectOptionNumber);
        }
        if ((firstRejectNode = WorkFlowUtil.getFirstRejectNode(billId)) != null) {
            nodeInfo.setRejectNode(firstRejectNode);
        }
        return nodeInfo;
    }

    public static String getCurNodeId(Long taskId) {
        if (taskId == null || taskId == 0L) {
            return "";
        }
        TaskInfo taskInfo = WorkflowServiceHelper.findTaskById((Long)taskId);
        return WorkFlowUtil.getCurNodeId(taskInfo);
    }

    public static String getCurNodeId(TaskInfo taskInfo) {
        String curNodeId = "";
        if (taskInfo instanceof TaskEntityImpl) {
            TaskEntityImpl taskEntity = (TaskEntityImpl)taskInfo;
            DynamicObject dynamicObject = taskEntity.getDynamicObject();
            curNodeId = dynamicObject.getString("taskdefinitionkey");
        }
        return curNodeId;
    }

    public static void stopWorkFlowProcess(Collection<String> businessKeys) {
        if (businessKeys == null || businessKeys.size() == 0) {
            return;
        }
        for (String businessKey : businessKeys) {
            Long processId = WorkflowServiceHelper.getProcessInstanceIdByBusinessKey((String)businessKey);
            if (processId == null || processId == 0L || !WorkflowServiceHelper.inProcess((String)businessKey)) continue;
            try {
                WorkflowServiceHelper.abandonByBusienssKey((String)businessKey);
            }
            catch (WFEngineException e) {
                log.info(" --- stop workflow process(businessKey): " + businessKey);
                WorkFlowUtil.createCancelWorkFlowProcessThread(businessKey);
            }
        }
    }

    private static void createCancelWorkFlowProcessThread(String businessKey) {
        RequestContext context = RequestContextCreator.createForThreadPool();
        ExecutorService centralAppProPool = CentralAppThreadManager.getCentralAppProPool();
        CancelWorkFlow cancelWorkFlow = new CancelWorkFlow(context, businessKey);
        centralAppProPool.submit(cancelWorkFlow);
    }

    public static List<WFRejectNodesModel> getRejectNodes(Long taskId, String decisionOptionNumber) {
        return (List)WorkFlowUtil.invokeWFService("getRejectNodes", taskId, decisionOptionNumber);
    }

    public static void completeTask(String businessKey, String nodeId, Long userId, String decOptionNumber, String auditMessage, boolean checkUser, Map<String, Object> variables) {
        WorkFlowUtil.invokeWFService("completeTask", businessKey, nodeId, userId, decOptionNumber, auditMessage, checkUser, variables);
    }

    public static String batchAgreeTaskWithUserId(String taskIds, ILocaleString opinion, Long userId) {
        return (String)WorkFlowUtil.invokeWFService("batchAgreeTaskWithUserId", taskIds, opinion, userId);
    }

    public static <T> T invokeWFService(String method, Object ... paramsVal) {
        return (T)DispatchServiceHelper.invokeBOSService((String)"wf", (String)"IWorkflowService", (String)method, (Object[])paramsVal);
    }

    public static void selFlowSignNodes(String formKey, Long billId, String currentNodeNumber, boolean addCurrNode2Next, Set<String> preNodeNumbers, Set<String> nextNodeNumbers) {
        if (StringUtils.isEmpty((String)currentNodeNumber) || preNodeNumbers == null && nextNodeNumbers == null) {
            return;
        }
        List<WFFlowElement> wFlowNodes = WorkFlowUtil.getWFlowNodes(formKey, billId);
        boolean begin = false;
        for (WFFlowElement flowElement : wFlowNodes) {
            if (!begin) {
                if (flowElement.getNumber().equals(currentNodeNumber)) {
                    begin = true;
                    if (!addCurrNode2Next || nextNodeNumbers == null) continue;
                    nextNodeNumbers.add(flowElement.getNumber());
                    continue;
                }
                if (preNodeNumbers == null) continue;
                preNodeNumbers.add(flowElement.getNumber());
                continue;
            }
            if (nextNodeNumbers == null) continue;
            nextNodeNumbers.add(flowElement.getNumber());
        }
        if (!begin && preNodeNumbers != null) {
            preNodeNumbers.clear();
        }
        CommonServiceHelper.handleLogBySign((Log)log, (String)"selFlowSignNodes", () -> SerializationUtils.toJsonString((Object)wFlowNodes), (String)"WorkFlowUtil", (String)"selFlowSignNodes");
    }

    public static void dumpToSubmitOrEnd(String formKey, Long billId, boolean toEnd) {
        String businessKey = String.valueOf(billId);
        Long userId = UserUtils.getUserId();
        List<WFFlowElement> wFlowNodes = WorkFlowUtil.getWFlowNodes(formKey, billId);
        if (CollectionUtils.isEmpty(wFlowNodes)) {
            return;
        }
        Long taskId = WorkflowServiceHelper.getTaskIdByBusinessKeyAndUserId((String)businessKey, (Long)userId);
        String targetNodeId = toEnd ? wFlowNodes.get(wFlowNodes.size() - 1).getId() : wFlowNodes.get(0).getId();
        TaskInfo taskInfo = WorkflowServiceHelper.findTaskById((Long)taskId);
        if (taskInfo == null) {
            return;
        }
        String curNodeId = WorkFlowUtil.getCurNodeId(taskInfo);
        Long flowProcessId = taskInfo.getProcessInstanceId();
        WorkFlowUtil.invokeWFService("jumpToNode", flowProcessId, targetNodeId, curNodeId);
    }

    public static List<IApprovalRecordGroup> getAllApprovalRecord(String businessKey) {
        if (StringUtils.isEmpty((String)businessKey) || "0".equals(businessKey)) {
            return Lists.newArrayList();
        }
        return WorkflowServiceHelper.getAllApprovalRecord((String)businessKey);
    }

    public static List<IApprovalRecordGroup> getApprovalRecords(String entityNumber, String businessKey, boolean allRecord) {
        List result = Collections.emptyList();
        try {
            Class<?> _class = Class.forName("kd.bos.servicehelper.workflow.WorkflowServiceHelper");
            Method _method = _class.getMethod("getApprovalRecords", String.class, String.class, Boolean.TYPE);
            Object _object = _method.invoke(null, entityNumber, businessKey, allRecord);
            if (_object instanceof List) {
                result = (List)_object;
            }
        }
        catch (Exception ex) {
            log.error(CommonServiceHelper.getStackTraceStr((Throwable)ex));
        }
        return result;
    }

    static class CancelWorkFlow
    implements Runnable {
        private RequestContext context = null;
        private String key = null;

        public CancelWorkFlow(RequestContext context, String key) {
            this.context = context;
            this.key = key;
        }

        @Override
        public void run() {
            if (StringUtils.isEmpty((String)this.key)) {
                return;
            }
            log.info(" --- workflow cancel process start: Thread ---> " + Thread.currentThread().getId() + " businessKey ---> " + this.key);
            int index = 0;
            RequestContextCreator.restoreForThreadPool((RequestContext)this.context);
            boolean continueAbandon = true;
            while (continueAbandon) {
                try {
                    Thread.sleep(60000L);
                    ++index;
                    WorkflowServiceHelper.abandonByBusienssKey((String)this.key);
                    continueAbandon = false;
                    log.info(" --- cancel workflow process successful(businessKey): " + this.key);
                }
                catch (InterruptedException | WFEngineException e) {
                    if (e instanceof WFEngineException) {
                        if (index >= 15) {
                            continueAbandon = false;
                        }
                        log.info(" --- continue to cancel workflow process(businessKey): " + this.key);
                        continue;
                    }
                    continueAbandon = false;
                    log.info(e.getMessage());
                }
            }
        }
    }
}

