/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.word;

import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.word.BorderStyleInfo;
import kd.epm.eb.business.word.CellBorderInfo;
import kd.epm.eb.common.impexp.ExcelConstants;
import kd.epm.eb.common.utils.GlobalIdUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBookmark;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTMarkupRange;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcBorders;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STMerge;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TableConvert {
    private static final Log log = LogFactory.getLog(TableConvert.class);
    private static final String defBorColor = "d9d9d9";
    private static final STBorder.Enum defBorType = STBorder.Enum.forString((String)"single");

    public static void copyTable(XWPFTable xwpfTable, Sheet sheet) {
        int index;
        List rows = xwpfTable.getRows();
        for (int rowIndex = rows.size() - 1; rowIndex > -1; --rowIndex) {
            xwpfTable.removeRow(rowIndex);
        }
        int lastRowNum = sheet.getLastRowNum();
        int rowIndex = 0;
        int maxColIndex = 0;
        int maxRowIndex = 0;
        HashMap<Integer, Integer> rowIndexMap = new HashMap<Integer, Integer>(16);
        int firstRowIndex = -1;
        int firstColIndex = -1;
        HashMap<String, DecimalFormat> formatMap = new HashMap<String, DecimalFormat>(16);
        XWPFTableRow xwpfTableRow = null;
        HashMap<String, CellBorderInfo> allCellBorder = new HashMap<String, CellBorderInfo>(16);
        for (index = 0; index <= lastRowNum; ++index) {
            Row row = sheet.getRow(index);
            if (row != null && row.getHeight() == 0) continue;
            xwpfTableRow = xwpfTable.createRow();
            if (row != null) {
                int lastCellNum = row.getLastCellNum();
                for (int colIndex = 0; colIndex < lastCellNum; ++colIndex) {
                    Cell cell = row.getCell(colIndex);
                    XWPFTableCell cell1 = xwpfTableRow.getCell(colIndex);
                    if (cell1 == null) {
                        cell1 = xwpfTableRow.createCell();
                    }
                    if (cell == null) continue;
                    if (cell.getCellType() == CellType.STRING) {
                        cell1.setText(cell.getStringCellValue());
                    } else if (cell.getCellType() == CellType.NUMERIC) {
                        String dataFormatString = cell.getCellStyle().getDataFormatString();
                        String val = StringUtils.isNotEmpty((CharSequence)dataFormatString) && !"General".equals(dataFormatString) ? formatMap.computeIfAbsent(dataFormatString, DecimalFormat::new).format(cell.getNumericCellValue()) : String.valueOf(cell.getNumericCellValue());
                        cell1.setText(val);
                    }
                    TableConvert.setCellStyle(cell, cell1, allCellBorder, rowIndex, colIndex);
                    if (!StringUtils.isNotEmpty((CharSequence)cell1.getText()) || CellType.BLANK == cell.getCellType()) continue;
                    if (colIndex > maxColIndex) {
                        maxColIndex = colIndex;
                    }
                    maxRowIndex = rowIndex;
                    if (firstRowIndex == -1) {
                        firstRowIndex = rowIndex;
                    }
                    if (firstColIndex != -1 && firstColIndex <= colIndex) continue;
                    firstColIndex = colIndex;
                }
                TableConvert.setRowStyle(xwpfTableRow, row);
            }
            rowIndexMap.put(index, rowIndex);
            ++rowIndex;
        }
        for (index = rowIndex - 1; index > maxRowIndex; --index) {
            xwpfTable.removeRow(index);
        }
        for (index = firstRowIndex - 1; index > -1; --index) {
            xwpfTable.removeRow(index);
        }
        HashMap<Integer, Integer> colWidthMap = new HashMap<Integer, Integer>(16);
        for (int colIndex = firstColIndex; colIndex <= maxColIndex; ++colIndex) {
            colWidthMap.put(colIndex - firstColIndex, (int)sheet.getColumnWidthInPixels(colIndex) * 20);
        }
        int _rowIndex = firstRowIndex;
        for (XWPFTableRow xwpfTableRow1 : xwpfTable.getRows()) {
            int index2;
            int colIndex = maxColIndex + 1;
            while (xwpfTableRow1.getCell(colIndex) != null) {
                xwpfTableRow1.removeCell(colIndex);
            }
            for (int _colIndex = xwpfTableRow1.getTableCells().size(); _colIndex <= maxColIndex; ++_colIndex) {
                xwpfTableRow1.createCell();
            }
            for (index2 = firstColIndex - 1; index2 > -1; --index2) {
                xwpfTableRow1.removeCell(index2);
            }
            for (index2 = 0; index2 <= maxColIndex - firstColIndex; ++index2) {
                XWPFTableCell cell = xwpfTableRow1.getCell(index2);
                if (cell == null) continue;
                Integer width = (Integer)colWidthMap.get(index2);
                if (width != null) {
                    cell.setWidth(String.valueOf(width));
                }
                TableConvert.setCellBorder(cell, allCellBorder, _rowIndex, index2 + firstColIndex);
            }
            ++_rowIndex;
        }
        TableConvert.mergeCell(rowIndexMap, xwpfTable, sheet, firstRowIndex, maxRowIndex, firstColIndex, maxColIndex);
        ArrayList<Integer> hideCols = new ArrayList<Integer>(16);
        for (int colIndex = 0; colIndex <= maxColIndex; ++colIndex) {
            if (!sheet.isColumnHidden(colIndex)) continue;
            hideCols.add(colIndex);
        }
        if (hideCols.size() > 0) {
            Collections.reverse(hideCols);
            for (XWPFTableRow xwpfTableRow1 : xwpfTable.getRows()) {
                int maxCol = maxColIndex - firstColIndex;
                Iterator iterator = hideCols.iterator();
                while (iterator.hasNext()) {
                    int colIndex = (Integer)iterator.next();
                    int index3 = colIndex - firstColIndex;
                    if (index3 <= -1 || index3 > maxCol) continue;
                    xwpfTableRow1.removeCell(index3);
                }
            }
        }
        log.info("TableConvert--s:" + sheet.getSheetName() + ",r:" + maxRowIndex + ",c:" + maxColIndex + ",fr:" + firstRowIndex + ",fc:" + firstColIndex);
    }

    private static void setCellBorder(XWPFTableCell cell, Map<String, CellBorderInfo> allCellBorderInfo, int rowIndex, int colIndex) {
        CellBorderInfo cBorderInfo = allCellBorderInfo.get(rowIndex + "-" + colIndex);
        CellBorderInfo lBorderInfo = allCellBorderInfo.get(rowIndex + "-" + (colIndex - 1));
        CellBorderInfo tBorderInfo = allCellBorderInfo.get(rowIndex - 1 + "-" + colIndex);
        CellBorderInfo bBorderInfo = allCellBorderInfo.get(rowIndex + 1 + "-" + colIndex);
        CellBorderInfo rBorderInfo = allCellBorderInfo.get(rowIndex + "-" + (colIndex + 1));
        CTTc ctTc = cell.getCTTc();
        if (ctTc != null) {
            CTTcBorders ctTcBorders;
            CTTcPr ctTcPr = ctTc.getTcPr();
            if (ctTcPr == null) {
                ctTcPr = ctTc.addNewTcPr();
            }
            if ((ctTcBorders = ctTcPr.getTcBorders()) == null) {
                ctTcBorders = ctTcPr.addNewTcBorders();
            }
            TableConvert.setBorder(ctTcBorders.addNewLeft(), lBorderInfo == null ? null : lBorderInfo.getRightB(), cBorderInfo == null ? null : cBorderInfo.getLeftB());
            TableConvert.setBorder(ctTcBorders.addNewRight(), cBorderInfo == null ? null : cBorderInfo.getRightB(), rBorderInfo == null ? null : rBorderInfo.getLeftB());
            TableConvert.setBorder(ctTcBorders.addNewTop(), tBorderInfo == null ? null : tBorderInfo.getBottomB(), cBorderInfo == null ? null : cBorderInfo.getTopB());
            TableConvert.setBorder(ctTcBorders.addNewBottom(), cBorderInfo == null ? null : cBorderInfo.getBottomB(), bBorderInfo == null ? null : bBorderInfo.getTopB());
        }
    }

    private static void setBorder(CTBorder ctBorder, BorderStyleInfo info1, BorderStyleInfo info2) {
        STBorder.Enum type2;
        String color1 = info1 == null ? null : info1.getColor();
        String color2 = info2 == null ? null : info2.getColor();
        STBorder.Enum type1 = info1 == null ? null : info1.getType();
        STBorder.Enum enum_ = type2 = info2 == null ? null : info2.getType();
        if (type2 == null && type1 == null) {
            ctBorder.setColor((Object)defBorColor);
            ctBorder.setVal(defBorType);
        } else if (type1 != null && type2 == null) {
            ctBorder.setColor((Object)color1);
            ctBorder.setVal(type1);
        } else if (type1 == null) {
            ctBorder.setColor((Object)color2);
            ctBorder.setVal(type2);
        } else if (type1.intValue() > type2.intValue()) {
            ctBorder.setColor((Object)color1);
            ctBorder.setVal(type1);
        } else if (type1.intValue() < type2.intValue()) {
            ctBorder.setColor((Object)color2);
            ctBorder.setVal(type2);
        } else {
            ctBorder.setColor((Object)color1);
            ctBorder.setVal(type2);
        }
    }

    public static void setRowStyle(XWPFTableRow xwpfTableRow, Row row) {
        xwpfTableRow.setHeight((int)(row.getZeroHeight() ? 0.0f : row.getHeightInPoints() * 28.0f));
    }

    public static boolean setCellStyle(Cell sourceCell, XWPFTableCell targetCell, Map<String, CellBorderInfo> allCellBorder, int rowIndex, int colIndex) {
        XSSFFont font;
        CellBorderInfo cellBorderInfo;
        XWPFTableCell.XWPFVertAlign vAlignment;
        boolean hasStyle = false;
        XSSFCellStyle cellStyle = (XSSFCellStyle)sourceCell.getCellStyle();
        CellType cellType = sourceCell.getCellType();
        String backColor = TableConvert.convertColor(cellStyle.getFillForegroundColorColor());
        if (StringUtils.isNotEmpty((CharSequence)backColor)) {
            targetCell.setColor(backColor);
            hasStyle = true;
        }
        if ((vAlignment = TableConvert.getVAlignment(cellStyle.getVerticalAlignment())) != null) {
            targetCell.setVerticalAlignment(vAlignment);
        }
        if ((cellBorderInfo = TableConvert.toTableCellBorders(cellStyle)) != null) {
            hasStyle = true;
            allCellBorder.put(rowIndex + "-" + colIndex, cellBorderInfo);
        }
        if ((font = cellStyle.getFont()) != null) {
            String foreColor = TableConvert.convertColor(font.getXSSFColor());
            targetCell.getParagraphs().forEach(xwpfParagraph -> {
                xwpfParagraph.setAlignment(TableConvert.getHAlignment(cellType, cellStyle.getAlignment()));
                xwpfParagraph.getRuns().forEach(run -> {
                    if (StringUtils.isNotEmpty((CharSequence)foreColor)) {
                        run.setColor(foreColor);
                    }
                    run.setFontSize((double)font.getFontHeightInPoints() * 0.8);
                    run.setBold(font.getBold());
                    run.setItalic(font.getItalic());
                    if (font.getUnderline() != 0) {
                        run.setUnderline(UnderlinePatterns.valueOf((int)font.getUnderline()));
                    }
                });
            });
        }
        return hasStyle;
    }

    public static CellBorderInfo toTableCellBorders(XSSFCellStyle cellStyle) {
        CellBorderInfo cellBorderInfo = null;
        BorderStyle borderTop = cellStyle.getBorderTop();
        BorderStyle borderLeft = cellStyle.getBorderLeft();
        BorderStyle borderRight = cellStyle.getBorderRight();
        BorderStyle borderBottom = cellStyle.getBorderBottom();
        if (!(borderTop != null && BorderStyle.NONE != borderTop || borderLeft != null && BorderStyle.NONE != borderLeft || borderRight != null && BorderStyle.NONE != borderRight || borderBottom != null && BorderStyle.NONE != borderBottom)) {
            return null;
        }
        cellBorderInfo = new CellBorderInfo();
        cellBorderInfo.setLeftB(TableConvert.toTableCellBorderSingle(borderLeft, cellStyle.getLeftBorderXSSFColor()));
        cellBorderInfo.setRightB(TableConvert.toTableCellBorderSingle(borderRight, cellStyle.getRightBorderXSSFColor()));
        cellBorderInfo.setTopB(TableConvert.toTableCellBorderSingle(borderTop, cellStyle.getTopBorderXSSFColor()));
        cellBorderInfo.setBottomB(TableConvert.toTableCellBorderSingle(borderBottom, cellStyle.getBottomBorderXSSFColor()));
        return cellBorderInfo;
    }

    public static BorderStyleInfo toTableCellBorderSingle(BorderStyle borderStyle, XSSFColor borderColor) {
        STBorder.Enum borderType = borderStyle == BorderStyle.NONE ? STBorder.Enum.forString((String)"none") : (borderStyle == BorderStyle.MEDIUM ? STBorder.Enum.forString((String)"single") : (borderStyle == BorderStyle.THICK ? STBorder.Enum.forString((String)"thick") : (borderStyle == BorderStyle.DOUBLE ? STBorder.Enum.forString((String)"double") : (borderStyle == BorderStyle.DOTTED ? STBorder.Enum.forString((String)"dotted") : (borderStyle == BorderStyle.DASH_DOT ? STBorder.Enum.forString((String)"dotDash") : (borderStyle == BorderStyle.DASH_DOT_DOT ? STBorder.Enum.forString((String)"dotDotDash") : (borderStyle == BorderStyle.HAIR || borderStyle == BorderStyle.DASHED ? STBorder.Enum.forString((String)"dashed") : STBorder.Enum.forString((String)"single"))))))));
        String color = null;
        if (borderColor != null) {
            color = TableConvert.convertColor(borderColor);
        }
        return new BorderStyleInfo(color, borderType);
    }

    public static XWPFTableCell.XWPFVertAlign getVAlignment(VerticalAlignment verticalAlignment) {
        XWPFTableCell.XWPFVertAlign vertAlign;
        switch (verticalAlignment) {
            case CENTER: {
                vertAlign = XWPFTableCell.XWPFVertAlign.CENTER;
                break;
            }
            case BOTTOM: {
                vertAlign = XWPFTableCell.XWPFVertAlign.BOTTOM;
                break;
            }
            case TOP: {
                vertAlign = XWPFTableCell.XWPFVertAlign.TOP;
                break;
            }
            case JUSTIFY: {
                vertAlign = XWPFTableCell.XWPFVertAlign.BOTH;
                break;
            }
            default: {
                vertAlign = null;
            }
        }
        return vertAlign;
    }

    public static ParagraphAlignment getHAlignment(CellType cellType, HorizontalAlignment horizontalAlignment) {
        ParagraphAlignment alignment = ParagraphAlignment.LEFT;
        switch (horizontalAlignment) {
            case CENTER: 
            case CENTER_SELECTION: {
                alignment = ParagraphAlignment.CENTER;
                break;
            }
            case RIGHT: {
                alignment = ParagraphAlignment.RIGHT;
                break;
            }
            case JUSTIFY: 
            case FILL: {
                alignment = ParagraphAlignment.BOTH;
                break;
            }
            case DISTRIBUTED: {
                alignment = ParagraphAlignment.DISTRIBUTE;
                break;
            }
            case GENERAL: {
                if (!cellType.equals((Object)CellType.NUMERIC)) break;
                alignment = ParagraphAlignment.RIGHT;
            }
        }
        return alignment;
    }

    public static String convertColor(XSSFColor xssColor) {
        String result = "";
        if (xssColor != null) {
            byte[] rgb = xssColor.getRGB();
            if (rgb == null) {
                short colorId = xssColor.getIndexed();
                if (colorId > 0 && (result = (String)ExcelConstants.IndexedColorsMap.get(colorId)) == null) {
                    result = "";
                }
            } else {
                result = String.format("#%02X%02X%02X", rgb[0], rgb[1], rgb[2]);
            }
        }
        return result.replace("#", "");
    }

    public static void mergeCell(Map<Integer, Integer> rowIndexMap, XWPFTable xwpfTable, Sheet sheet, int firstRowIndex, int maxRowIndex, int firstColIndex, int maxColIndex) {
        List mergedRegions = sheet.getMergedRegions();
        if (mergedRegions.isEmpty()) {
            return;
        }
        List rows = xwpfTable.getRows();
        for (CellRangeAddress cellRange : mergedRegions) {
            int startCol = cellRange.getFirstColumn();
            int startRow = cellRange.getFirstRow();
            int endCol = cellRange.getLastColumn();
            int endRow = cellRange.getLastRow();
            Integer matchStartRow = null;
            for (int rowIndex = startRow; rowIndex <= endRow && (matchStartRow = rowIndexMap.get(rowIndex)) == null; ++rowIndex) {
            }
            Integer matchEndRow = null;
            for (int rowIndex = endRow; rowIndex >= endRow && (matchEndRow = rowIndexMap.get(rowIndex)) == null; --rowIndex) {
            }
            if (matchEndRow == null || matchStartRow == null) continue;
            boolean mergeRow = !matchEndRow.equals(matchStartRow);
            boolean mergeCol = startCol != endCol;
            for (int colIndex = startCol; colIndex <= endCol && colIndex <= maxColIndex; ++colIndex) {
                int _colIndex = colIndex - firstColIndex;
                boolean isFirstCol = colIndex == startCol;
                for (int rowIndex = matchStartRow.intValue(); rowIndex <= maxRowIndex && rowIndex <= matchEndRow; ++rowIndex) {
                    XWPFTableCell cell = ((XWPFTableRow)rows.get(rowIndex - firstRowIndex)).getCell(_colIndex);
                    CTTcPr ctTcPr = TableConvert.getTableCellCTTcPr(cell);
                    if (mergeRow) {
                        if (rowIndex == matchStartRow) {
                            ctTcPr.addNewVMerge().setVal(STMerge.RESTART);
                        } else {
                            ctTcPr.addNewVMerge().setVal(STMerge.CONTINUE);
                        }
                    }
                    if (!mergeCol) continue;
                    if (isFirstCol) {
                        ctTcPr.addNewHMerge().setVal(STMerge.RESTART);
                        continue;
                    }
                    ctTcPr.addNewHMerge().setVal(STMerge.CONTINUE);
                }
            }
        }
    }

    public static CTTcPr getTableCellCTTcPr(XWPFTableCell cell) {
        CTTcPr ctTcPr = cell.getCTTc().getTcPr();
        if (ctTcPr == null) {
            ctTcPr = cell.getCTTc().addNewTcPr();
        }
        return ctTcPr;
    }

    public static void replaceTable(XWPFDocument doc, Map<String, Sheet> allTable, Map<String, String> markKeyNameMap) {
        Sheet sheet;
        HashMap<XWPFTable, String> newTables = new HashMap<XWPFTable, String>(16);
        for (XWPFParagraph xWPFParagraph : doc.getParagraphs()) {
            CTP ctp = xWPFParagraph.getCTP();
            List bookmarkStartList = ctp.getBookmarkStartList();
            ArrayList<CTBookmark> matchBookMark = new ArrayList<CTBookmark>(16);
            for (CTBookmark ctBookmark : bookmarkStartList) {
                sheet = allTable.get(ctBookmark.getName());
                if (sheet == null) continue;
                matchBookMark.add(ctBookmark);
                XmlCursor cursor = ctp.newCursor();
                XWPFTable xwpfTable = doc.insertNewTbl(cursor);
                TableConvert.copyTable(xwpfTable, sheet);
                newTables.put(xwpfTable, ctBookmark.getName());
                cursor.dispose();
            }
            TableConvert.removeBookMark(ctp, matchBookMark);
        }
        for (Map.Entry entry : newTables.entrySet()) {
            TableConvert.insertNewMark2Table((XWPFTable)entry.getKey(), (String)entry.getValue());
        }
        HashMap<String, XWPFTable> emptyTables = new HashMap<String, XWPFTable>(16);
        HashMap<String, XWPFTable> hashMap = new HashMap<String, XWPFTable>(16);
        block3: for (XWPFTable table2 : doc.getTables()) {
            List rows = table2.getRows();
            if (rows.isEmpty() || newTables.containsKey(table2)) continue;
            XWPFTableRow firstRow = (XWPFTableRow)rows.get(0);
            for (XWPFParagraph paragraph : firstRow.getCell(0).getParagraphs()) {
                CTBookmark[] bookmarkStartArray;
                for (CTBookmark bookmark : bookmarkStartArray = paragraph.getCTP().getBookmarkStartArray()) {
                    String mark = bookmark.getName();
                    sheet = allTable.get(mark);
                    if (sheet != null) {
                        hashMap.put(mark, table2);
                        continue block3;
                    }
                    if (!markKeyNameMap.containsKey(mark)) continue;
                    emptyTables.put(mark, table2);
                }
            }
        }
        hashMap.forEach((markKey, table) -> {
            XmlCursor xmlCursor = table.getCTTbl().newCursor();
            XWPFTable newTable = doc.insertNewTbl(xmlCursor);
            xmlCursor.dispose();
            int posOfTable = doc.getPosOfTable(table);
            doc.removeBodyElement(posOfTable);
            TableConvert.copyTable(newTable, (Sheet)allTable.get(markKey));
            TableConvert.insertNewMark2Table(newTable, markKey);
        });
        emptyTables.forEach((markKey, table) -> {
            String markName = (String)markKeyNameMap.get(markKey);
            XmlCursor xmlCursor = table.getCTTbl().newCursor();
            XWPFParagraph paragraph = doc.insertNewParagraph(xmlCursor);
            xmlCursor.dispose();
            CTP ctp = paragraph.getCTP();
            long id = GlobalIdUtil.genGlobalLongId();
            CTBookmark newBookMark = ctp.addNewBookmarkStart();
            newBookMark.setName(markKey);
            newBookMark.setId(BigInteger.valueOf(id));
            XWPFRun run = paragraph.createRun();
            run.setText(markName);
            CTMarkupRange ctMarkupRange = ctp.addNewBookmarkEnd();
            ctMarkupRange.setId(BigInteger.valueOf(id));
            int posOfTable = doc.getPosOfTable(table);
            doc.removeBodyElement(posOfTable);
        });
    }

    public static void insertNewMark2Table(XWPFTable table, String markKey) {
        List rows = table.getRows();
        if (rows.isEmpty()) {
            table.addNewCol();
        }
        if (rows.size() > 0) {
            XWPFTableRow firstRow = (XWPFTableRow)rows.get(0);
            XWPFTableCell firstCell = firstRow.getCell(0);
            long id = GlobalIdUtil.genGlobalLongId();
            List paragraphs = firstCell.getParagraphs();
            CTP ctp1 = paragraphs.isEmpty() ? firstCell.addParagraph().getCTP() : ((XWPFParagraph)paragraphs.get(0)).getCTP();
            CTBookmark newBookMark = ctp1.addNewBookmarkStart();
            newBookMark.setName(markKey);
            newBookMark.setId(BigInteger.valueOf(id));
            CTMarkupRange ctMarkupRange = ctp1.addNewBookmarkEnd();
            ctMarkupRange.setId(BigInteger.valueOf(id));
        }
    }

    public static void removeBookMark(CTP ctp, List<CTBookmark> matchBookMark) {
        String allBookKey = matchBookMark.stream().map(CTBookmark::getName).collect(Collectors.joining(","));
        try {
            Node parentNode = ctp.getDomNode();
            for (CTBookmark ctBookmark : matchBookMark) {
                Node domNode = ctBookmark.getDomNode();
                if (domNode == null) continue;
                String nextNodeName = null;
                for (Node nextNode = domNode.getNextSibling(); nextNode != null && !"w:bookmarkEnd".equals(nextNodeName); nextNode = nextNode.getNextSibling()) {
                    Node toDelNode = nextNode;
                    nextNodeName = nextNode.getNodeName();
                    parentNode.removeChild(toDelNode);
                }
                parentNode.removeChild(domNode);
            }
            NodeList childNodes = parentNode.getChildNodes();
            if (childNodes.getLength() == 0) {
                parentNode.getParentNode().removeChild(parentNode);
            }
        }
        catch (Exception e) {
            log.error("removeBookMarkError:" + allBookKey, (Throwable)e);
        }
    }
}

