/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.servicehelper.DBServiceHelper;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.resource.ControlException;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.IBgControlCaller;
import kd.epm.eb.control.face.IControlParameter;

public abstract class AbstractBgControlCaller
implements IBgControlCaller {
    protected void checkBizParam(String entityNumber, String bizId) {
        if (StringUtils.isEmpty((String)entityNumber)) {
            ControlException.errorBizEntityNumber();
        }
        if (StringUtils.isEmpty((String)bizId)) {
            ControlException.errorBizId();
        }
    }

    protected void checkBizParam(DynamicObject bizObj) {
        if (bizObj == null || bizObj.getDataEntityType() == null) {
            ControlException.errorDynamicObject();
        }
    }

    protected void checkBizParam(DynamicObject[] bizObjs) {
        if (bizObjs == null || bizObjs.length == 0) {
            ControlException.errorDynamicObject();
        }
        for (DynamicObject bizObj : bizObjs) {
            this.checkBizParam(bizObj);
        }
    }

    protected void checkBizParam(String operation) {
        if (StringUtils.isEmpty((String)operation)) {
            ControlException.errorOperation();
        }
    }

    protected void checkBizParam(List<Map<String, Object>> bizObjMaps) {
        if (bizObjMaps == null || bizObjMaps.isEmpty()) {
            ControlException.errorDynamicObject();
        }
        for (Map<String, Object> bizObjMap : bizObjMaps) {
            if (!bizObjMap.containsKey("id")) {
                ControlException.errorBizId();
            }
            if (!bizObjMap.containsKey("number") && !bizObjMap.containsKey("billno")) {
                ControlException.errorBizNumber();
            }
            if (bizObjMap.containsKey("bostype")) continue;
            ControlException.errorBizEntityNumber();
        }
    }

    protected Boolean isReleaseByEntry(List<Map<String, Object>> bizObjMaps) {
        this.checkBizParam(bizObjMaps);
        Map<String, Object> bizObj = bizObjMaps.get(0);
        if (bizObj.get("entryId") != null && "".equals(bizObj.get("entryId").toString().trim())) {
            ControlException.errorParamEntryId();
        }
        return bizObj.containsKey("entryId") && bizObj.get("entryId") != null && !"".equals(bizObj.get("entryId").toString());
    }

    protected long writeControlLog(IControlParameter parameter, String operation) {
        if (parameter == null) {
            return 0L;
        }
        String entityNumber = parameter.getEntityNumber();
        String bizId = parameter.getBizId();
        String billNumber = parameter.getBizNumber();
        if (operation == null) {
            operation = parameter.getOperation();
        }
        return this.writeControlLog(parameter, entityNumber, bizId, billNumber, operation);
    }

    protected long writeControlLog(IControlParameter parameter, List<Map<String, Object>> bizObjMaps, String operation) {
        if (bizObjMaps == null || bizObjMaps.isEmpty()) {
            ControlException.errorDynamicObject();
            return 0L;
        }
        Map<String, Object> bizObjMap = bizObjMaps.get(0);
        String entityNumber = (String)bizObjMap.get("bostype");
        String bizId = (String)bizObjMap.get("id");
        String billNumber = (String)bizObjMap.get("number");
        if (StringUtils.isEmpty((String)billNumber)) {
            billNumber = (String)bizObjMap.get("billno");
        }
        return this.writeControlLog(parameter, entityNumber, bizId, billNumber, operation);
    }

    private long writeControlLog(IControlParameter parameter, String entityNumber, String bizId, String billNumber, String operation) {
        boolean hasControlLog;
        Throwable throwable;
        long globalId = 0L;
        if (StringUtils.isEmpty((String)entityNumber) || StringUtils.isEmpty((String)bizId)) {
            ControlException.errorDynamicObject();
            return 0L;
        }
        if (StringUtils.isEmpty((String)operation)) {
            return 0L;
        }
        if (StringUtils.isEmpty((String)billNumber)) {
            SqlBuilder sql = new SqlBuilder();
            sql.append("select fbillnumber from t_eb_bgcontroloperlog ", new Object[0]);
            sql.append("where fentitynumber = ? and fbillid = ? and fbillid <> fbillnumber order by fcreatedate desc", new Object[]{entityNumber, bizId});
            throwable = null;
            try (DataSet ds = DB.queryDataSet((String)"querybillnumber", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
                if (ds.hasNext()) {
                    billNumber = ds.next().getString("fbillnumber");
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        if (StringUtils.isEmpty((String)billNumber)) {
            billNumber = bizId;
        }
        if (hasControlLog = DB.exitsTable((DBRoute)BgBaseConstant.epm, (String)"t_eb_bgcontroloperlog")) {
            globalId = DBServiceHelper.genGlobalLongId();
            throwable = null;
            try (TXHandle tx = TX.requiresNew((String)"eb/AbstractBgControlCaller/writeControlLog");){
                try {
                    DB.execute((DBRoute)BgBaseConstant.epm, (String)"insert into t_eb_bgcontroloperlog (fid, fentitynumber, fbillid, fbillnumber, fcreatedate, foperation, fparams, fisshow) values (?,?,?,?,?,?,?,?)", (Object[])new Object[]{globalId, entityNumber, bizId, billNumber, new Date(System.currentTimeMillis()), operation, Character.valueOf('0'), Character.valueOf('1')});
                    if (parameter != null) {
                        parameter.setGlobalId(globalId);
                    }
                }
                catch (Exception ex) {
                    tx.markRollback();
                    throw ex;
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        return globalId;
    }
}

