/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.resource.ControlException;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.AbstractBgControlCaller;
import kd.epm.eb.control.face.IBudgetBalance;
import kd.epm.eb.control.face.IControlParam;
import kd.epm.eb.control.face.IControlParameter;
import kd.epm.eb.control.face.IControlResult;
import kd.epm.eb.control.impl.BatchControlParameter;
import kd.epm.eb.control.impl.BeyondBalanceImpl;
import kd.epm.eb.control.impl.BudgetTransactionImpl;
import kd.epm.eb.control.impl.CalcBizIdParameter;
import kd.epm.eb.control.impl.CalcBizIdSetParameter;
import kd.epm.eb.control.impl.CalcEntryIdParameter;
import kd.epm.eb.control.impl.CalcMemberParameter;
import kd.epm.eb.control.impl.CalcObjectParameter;
import kd.epm.eb.control.impl.CloseBudgetImpl;
import kd.epm.eb.control.impl.ControlParameter;
import kd.epm.eb.control.impl.QueryBalanceImpl;
import kd.epm.eb.control.impl.QueryMappingsImpl;
import kd.epm.eb.control.impl.ReopenBudgetImpl;
import kd.epm.eb.control.impl.RequestBudgetImpl;
import kd.epm.eb.control.impl.ReturnBudgetImpl;
import kd.epm.eb.control.utils.QueryFieldByBill;

public class BgControlCallerImpl
extends AbstractBgControlCaller {
    private static final Log log = LogFactory.getLog(BgControlCallerImpl.class);

    @Override
    public IControlResult requestBudget(String entityNumber, String bizId, String operation) {
        this.checkBizParam(entityNumber, bizId);
        this.checkBizParam(operation);
        ControlParameter parameter = new ControlParameter();
        parameter.setCalcParameter(new CalcBizIdParameter(entityNumber, bizId, operation));
        this.writeControlLog(parameter, operation);
        return new RequestBudgetImpl(parameter).requestBudget();
    }

    @Override
    public IControlResult requestBudgetUser(DynamicObject bizObj, String operation) {
        this.checkBizParam(bizObj);
        this.checkBizParam(operation);
        ControlParameter parameter = new ControlParameter();
        parameter.getControlManager().setUserRequest(true);
        parameter.setCalcParameter(new CalcObjectParameter(bizObj, operation));
        this.writeControlLog(parameter, operation);
        return new RequestBudgetImpl(parameter).requestBudget();
    }

    @Override
    public IControlResult requestBudget(DynamicObject bizObj, String operation) {
        this.checkBizParam(bizObj);
        this.checkBizParam(operation);
        ControlParameter parameter = new ControlParameter();
        parameter.setCalcParameter(new CalcObjectParameter(bizObj, operation));
        this.writeControlLog(parameter, operation);
        return new RequestBudgetImpl(parameter).requestBudget();
    }

    @Override
    public IControlResult requestBudget(DynamicObject[] bizObjects, String operation) {
        this.checkBizParam(bizObjects);
        this.checkBizParam(operation);
        return null;
    }

    @Override
    public IControlResult requestBudget(DynamicObject bizObj, String operation, String upstreamId) {
        this.checkBizParam(bizObj);
        this.checkBizParam(operation);
        ControlParameter parameter = new ControlParameter();
        parameter.setCalcParameter(new CalcObjectParameter(bizObj, operation));
        if (StringUtils.isNotEmpty((String)upstreamId)) {
            parameter.getDataManager().setUpstreamId(upstreamId);
        }
        this.writeControlLog(parameter, operation);
        return new RequestBudgetImpl(parameter).requestBudget();
    }

    @Override
    public IControlResult negativeBudget(String entityNumber, String bizId, String operation) {
        this.checkBizParam(entityNumber, bizId);
        this.checkBizParam(operation);
        ControlParameter parameter = new ControlParameter();
        parameter.getControlManager().setNegativeOcc(true);
        parameter.setCalcParameter(new CalcBizIdParameter(entityNumber, bizId, operation));
        this.writeControlLog(parameter, operation);
        return new RequestBudgetImpl(parameter).requestBudget();
    }

    @Override
    public IControlResult negativeBudget(DynamicObject bizObj, String operation) {
        this.checkBizParam(bizObj);
        this.checkBizParam(operation);
        ControlParameter parameter = new ControlParameter();
        parameter.getControlManager().setNegativeOcc(true);
        parameter.setCalcParameter(new CalcObjectParameter(bizObj, operation));
        this.writeControlLog(parameter, operation);
        return new RequestBudgetImpl(parameter).requestBudget();
    }

    @Override
    public IControlResult occupationBudget(List<Map<String, Object>> bizObjMaps, String upstreamId, Boolean isdelEntry) {
        return this.occupationBudget(bizObjMaps, upstreamId, isdelEntry, null);
    }

    @Override
    public IControlResult occupationBudget(List<Map<String, Object>> bizObjMaps, String upstreamId, Boolean isdelEntry, List<Map<String, Object>> writeoffMaps) {
        return this.occupationBudget(bizObjMaps, upstreamId, isdelEntry, writeoffMaps, null, false);
    }

    @Override
    public IControlResult occupationBudget(List<Map<String, Object>> bizObjMaps, String upstreamId, Boolean isdelEntry, List<Map<String, Object>> writeoffMaps, String budgetappliernumber, boolean isNegativeOcc) {
        IControlParameter parameter = this.getControlParameter(bizObjMaps, "occupationBudget", upstreamId, isdelEntry, writeoffMaps, budgetappliernumber);
        parameter.getControlManager().setNegativeOcc(isNegativeOcc);
        return new RequestBudgetImpl(parameter).requestBudget();
    }

    @Override
    public IControlResult executeBudget(List<Map<String, Object>> bizObjMaps, String upstreamId, Boolean isdelEntry) {
        return this.executeBudget(bizObjMaps, upstreamId, isdelEntry, null);
    }

    @Override
    public IControlResult executeBudget(List<Map<String, Object>> bizObjMaps, String upstreamId, Boolean isdelEntry, List<Map<String, Object>> writeoffMaps) {
        return this.executeBudget(bizObjMaps, upstreamId, isdelEntry, writeoffMaps, null);
    }

    @Override
    public IControlResult executeBudget(List<Map<String, Object>> bizObjMaps, String upstreamId, Boolean isdelEntry, List<Map<String, Object>> writeoffMaps, String budgetappliernumber) {
        IControlParameter parameter = this.getControlParameter(bizObjMaps, "executeBudget", upstreamId, isdelEntry, writeoffMaps, budgetappliernumber);
        return new RequestBudgetImpl(parameter).requestBudget();
    }

    @Override
    public IControlResult specialBudget(DynamicObject bizObj, String operation) {
        this.checkBizParam(bizObj);
        this.checkBizParam(operation);
        ControlParameter parameter = new ControlParameter();
        parameter.setCalcParameter(new CalcObjectParameter(bizObj, operation));
        parameter.getControlManager().setCalcBalance(false);
        this.writeControlLog(parameter, operation);
        return new RequestBudgetImpl(parameter).requestBudget();
    }

    @Override
    public void returnBudget(String entityNumber, String bizId, String operation) {
        this.checkBizParam(entityNumber, bizId);
        this.checkBizParam(operation);
        ControlParameter parameter = new ControlParameter();
        parameter.setQueryCentralized(false);
        parameter.setCalcParameter(new CalcBizIdParameter(entityNumber, bizId, operation));
        this.writeControlLog(parameter, operation);
        new ReturnBudgetImpl(parameter).returnBudget();
    }

    @Override
    public void returnBudget(List<Map<String, Object>> bizObjMaps) {
        if (this.isReleaseByEntry(bizObjMaps).booleanValue()) {
            Map<String, Object> bizObject = bizObjMaps.get(0);
            String bizId = (String)bizObject.get("id");
            String entityNumber = (String)bizObject.get("bostype");
            String entryId = (String)bizObject.get("entryId");
            ControlParameter parameter = new ControlParameter();
            parameter.setCalcParameter(new CalcEntryIdParameter(entityNumber, bizId, entryId));
            parameter.getControlManager().setStandard(false);
            this.writeControlLog(parameter, "returnEntryBudget");
            new ReturnBudgetImpl(parameter).returnBudget();
            return;
        }
        ControlParameter parameter = new ControlParameter();
        this.writeControlLog(parameter, bizObjMaps, "returnBudget");
        parameter.setQueryCentralized(false);
        parameter.getControlManager().setStandard(false);
        parameter.setCalcParameter(new CalcObjectParameter(bizObjMaps));
        parameter.setOperation("delete");
        new ReturnBudgetImpl(parameter).returnBudget();
    }

    @Override
    public void closeBudget(String entityNumber, String bizId, String operation) {
        this.checkBizParam(entityNumber, bizId);
        this.checkBizParam(operation);
        ControlParameter parameter = new ControlParameter();
        parameter.setCalcParameter(new CalcBizIdParameter(entityNumber, bizId, operation));
        this.writeControlLog(parameter, operation);
        new CloseBudgetImpl(parameter).closeBudget();
    }

    @Override
    public void closeBudget(List<Map<String, Object>> bizObjMaps) {
        this.closeBudget(bizObjMaps, null);
    }

    @Override
    public void closeBudget(List<Map<String, Object>> bizObjMaps, String budgetappliernumber) {
        if (this.isReleaseByEntry(bizObjMaps).booleanValue()) {
            Map<String, Object> bizObject = bizObjMaps.get(0);
            String bizId = (String)bizObject.get("id");
            String entityNumber = (String)bizObject.get("bostype");
            String entryId = (String)bizObject.get("entryId");
            ControlParameter parameter = new ControlParameter();
            parameter.setCalcParameter(new CalcEntryIdParameter(entityNumber, bizId, entryId));
            parameter.getControlManager().setStandard(false);
            this.writeControlLog(parameter, "releaseEntryBudget");
            new CloseBudgetImpl(parameter).closeBudget();
            return;
        }
        ControlParameter parameter = new ControlParameter();
        this.writeControlLog(parameter, bizObjMaps, "closeBudget");
        parameter.setApplier(budgetappliernumber);
        parameter.getControlManager().setStandard(false);
        parameter.setCalcParameter(new CalcObjectParameter(bizObjMaps));
        parameter.setOperation("close");
        new CloseBudgetImpl(parameter).closeBudget();
    }

    @Override
    public void reopenBudget(String entityNumber, String bizId, String operation) {
        this.checkBizParam(entityNumber, bizId);
        ControlParameter parameter = new ControlParameter();
        parameter.setQueryCentralized(false);
        parameter.setCalcParameter(new CalcBizIdParameter(entityNumber, bizId, operation));
        this.writeControlLog(parameter, operation);
        new ReopenBudgetImpl(parameter).reopenBudget();
    }

    @Override
    public void reopenBudget(List<Map<String, Object>> bizObjMaps) {
        if (this.isReleaseByEntry(bizObjMaps).booleanValue()) {
            Map<String, Object> bizObject = bizObjMaps.get(0);
            String bizId = (String)bizObject.get("id");
            String entityNumber = (String)bizObject.get("bostype");
            String entryId = (String)bizObject.get("entryId");
            ControlParameter parameter = new ControlParameter();
            parameter.setCalcParameter(new CalcEntryIdParameter(entityNumber, bizId, entryId));
            parameter.getControlManager().setStandard(false);
            this.writeControlLog(parameter, "reopenEntryBudget");
            new ReopenBudgetImpl(parameter).reopenBudget();
            return;
        }
        this.checkBizParam(bizObjMaps);
        ControlParameter parameter = new ControlParameter();
        this.writeControlLog(parameter, bizObjMaps, "reopenBudget");
        parameter.setQueryCentralized(false);
        parameter.getControlManager().setStandard(false);
        parameter.setCalcParameter(new CalcObjectParameter(bizObjMaps));
        parameter.setOperation("reopenBudget");
        new ReopenBudgetImpl(parameter).reopenBudget();
    }

    @Override
    public Collection<IBudgetBalance> queryBalance(String entityNumber, String bizId) {
        this.checkBizParam(entityNumber, bizId);
        ControlParameter parameter = new ControlParameter();
        parameter.setCalcParameter(new CalcBizIdParameter(entityNumber, bizId, null));
        parameter.getControlManager().setQueryBalance(true);
        return new QueryBalanceImpl(parameter).queryBalance();
    }

    public Map<String, List<IBudgetBalance>> queryMapping(String entityNumber, Set<String> bizIds, Long bizModelId) {
        return this.queryMapping(entityNumber, bizIds, bizModelId, null);
    }

    public Map<String, List<IBudgetBalance>> queryMapping(String entityNumber, Set<String> bizIds, Long bizModelId, Long bussModelId) {
        if (bizIds == null || bizIds.isEmpty()) {
            return new HashMap<String, List<IBudgetBalance>>(1);
        }
        if (bussModelId == null) {
            bussModelId = 0L;
        }
        String bizId = bizIds.iterator().next();
        this.checkBizParam(entityNumber, bizId);
        BatchControlParameter parameter = new BatchControlParameter();
        parameter.setNeedMappingData(true);
        parameter.setBizModelId(bizModelId);
        parameter.setBussModelId(bussModelId);
        parameter.setBizIds(bizIds);
        parameter.setCalcParameter(new CalcBizIdParameter(entityNumber, bizId, null));
        parameter.getControlManager().setQueryBalance(true);
        return new QueryMappingsImpl(parameter).queryMappings();
    }

    @Override
    public Collection<IBudgetBalance> queryBalance(DynamicObject bizObj) {
        if (bizObj == null || bizObj.getDataEntityType() == null) {
            ControlException.errorDynamicObject();
        }
        ControlParameter parameter = new ControlParameter();
        parameter.setCalcParameter(new CalcObjectParameter(bizObj, null));
        parameter.getControlManager().setQueryBalance(true);
        return new QueryBalanceImpl(parameter).queryBalance();
    }

    public Collection<IControlParam> queryDimensionMember(DynamicObject bizObj) {
        if (bizObj == null || bizObj.getDataEntityType() == null) {
            ControlException.errorDynamicObject();
        }
        ControlParameter parameter = new ControlParameter();
        parameter.setCalcParameter(new CalcObjectParameter(bizObj, null));
        parameter.getControlManager().setQueryBalance(true);
        return new QueryBalanceImpl(parameter).queryDimenMember();
    }

    public Collection<IControlParam> queryDimensionMemberBySetFiled(DynamicObject bizObj, Set<String> appilyValue) {
        if (bizObj == null || bizObj.getDataEntityType() == null) {
            ControlException.errorDynamicObject();
        }
        ControlParameter parameter = new ControlParameter();
        parameter.setCalcParameter(new CalcObjectParameter(bizObj, null));
        parameter.getDataManager().getApplyFields().addAll(appilyValue);
        parameter.getControlManager().setQueryBalance(true);
        return new QueryBalanceImpl(parameter).queryDimenMember();
    }

    public Map<String, Map<String, Map<String, String>>> queryOrgNumbers(DynamicObject bizObj) {
        if (bizObj == null || bizObj.getDataEntityType() == null) {
            ControlException.errorDynamicObject();
        }
        ControlParameter parameter = new ControlParameter();
        parameter.setCalcParameter(new CalcObjectParameter(bizObj, null));
        parameter.getControlManager().setQueryBalance(true);
        Map<String, Map<String, Map<String, String>>> map = new QueryBalanceImpl(parameter).queryOrgNumbers();
        return map;
    }

    public Map<String, String> queryOrgNumber(DynamicObject bizObj) {
        Map<String, Map<String, Map<String, String>>> map;
        if (bizObj == null || bizObj.getDataEntityType() == null) {
            ControlException.errorDynamicObject();
        }
        if ((map = this.queryOrgNumbers(bizObj)) != null && !map.isEmpty()) {
            for (Map<String, Map<String, String>> subMap : map.values()) {
                if (subMap == null) continue;
                for (Map<String, String> rMap : subMap.values()) {
                    if (rMap == null || rMap.isEmpty()) continue;
                    return rMap;
                }
            }
            return new HashMap<String, String>(1);
        }
        return new HashMap<String, String>(1);
    }

    @Override
    public Collection<IBudgetBalance> queryBalance(List<Map<String, Object>> bizObjMaps) {
        if (bizObjMaps == null || bizObjMaps.isEmpty()) {
            ControlException.errorDynamicObject();
        }
        ControlParameter parameter = new ControlParameter();
        parameter.getControlManager().setStandard(false);
        parameter.setCalcParameter(new CalcObjectParameter(bizObjMaps));
        parameter.getControlManager().setQueryBalance(true);
        return new QueryBalanceImpl(parameter).queryBalance();
    }

    @Override
    public Collection<IBudgetBalance> queryBalance(Long modelId, List<Map<String, String>> members, Collection<String> types) {
        return this.queryBalance(modelId, members, types, false);
    }

    public Collection<IBudgetBalance> queryBalance(Long modelId, List<Map<String, String>> members, Collection<String> types, boolean hasQuerySetRule) {
        ArrayList<IBudgetBalance> balances = new ArrayList<IBudgetBalance>();
        if (modelId == 0L || members == null || members.isEmpty()) {
            return balances;
        }
        ControlParameter parameter = new ControlParameter();
        parameter.setQueryCentralized(false);
        parameter.setCalcParameter(new CalcMemberParameter(modelId, members, types, hasQuerySetRule));
        return new QueryBalanceImpl(parameter).queryMemberBalance();
    }

    public Collection<IBudgetBalance> queryBalance(Long modelId, List<Map<String, String>> members, Collection<String> types, boolean hasQuerySetRule, Long businessModelId) {
        ArrayList<IBudgetBalance> balances = new ArrayList<IBudgetBalance>();
        if (modelId == 0L || members == null || members.isEmpty()) {
            return balances;
        }
        ControlParameter parameter = new ControlParameter();
        parameter.setQueryCentralized(false);
        parameter.setCalcParameter(new CalcMemberParameter(modelId, members, types, hasQuerySetRule, businessModelId));
        return new QueryBalanceImpl(parameter).queryMemberBalance();
    }

    @Override
    public IControlResult isBeyond(DynamicObject bizObj, String operation) {
        this.checkBizParam(bizObj);
        this.checkBizParam(operation);
        ControlParameter parameter = new ControlParameter();
        parameter.setCalcParameter(new CalcObjectParameter(bizObj, operation));
        parameter.getControlManager().setValidBalance(true);
        return new BeyondBalanceImpl(parameter).isBeyond();
    }

    public Collection<IBudgetBalance> queryBalance(Long modelId, List<Map<String, String>> members, Collection<String> types, boolean hasQuerySetRule, Long businessModelId, Map<String, BigDecimal> adjustValueMap, Map<String, BigDecimal> submitValueMap) {
        ArrayList<IBudgetBalance> balances = new ArrayList<IBudgetBalance>();
        try {
            if (modelId == 0L || members == null || members.isEmpty()) {
                return balances;
            }
            log.info("adjustCheck adjustValueMap " + JSONUtils.toString(adjustValueMap) + " submitValueMap " + JSONUtils.toString(submitValueMap));
            this.sortMembersByPeriod(modelId, members);
            ControlParameter parameter = new ControlParameter();
            parameter.setHasAdjustCheck(true);
            parameter.setQueryCentralized(false);
            parameter.setAdjustValueMap(adjustValueMap);
            parameter.setSubmitValueMap(submitValueMap);
            parameter.setCalcParameter(new CalcMemberParameter(modelId, members, types, hasQuerySetRule, businessModelId));
            return new QueryBalanceImpl(parameter).queryMemberBalance();
        }
        catch (KDBizException e) {
            if ("EB090002".equals(e.getErrorCode().getCode())) {
                throw new KDBizException(e.getMessage());
            }
            log.error("adjustment check error", (Throwable)e);
            return balances;
        }
        catch (Exception e) {
            log.error("adjustment check error", (Throwable)e);
            return balances;
        }
    }

    private void sortMembersByPeriod(Long modelId, List<Map<String, String>> members) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        boolean modelByEB = modelCacheHelper.getModelobj().isModelByEB();
        Collections.sort(members, (map1, map2) -> {
            String billNumber2;
            int result = 0;
            String billNumber1 = (String)map1.get("billNumber");
            if (StringUtils.equals((String)billNumber1, (String)(billNumber2 = (String)map2.get("billNumber")))) {
                if (modelByEB) {
                    String year1 = (String)map1.get(SysDimensionEnum.Year.getNumber());
                    String year2 = (String)map2.get(SysDimensionEnum.Year.getNumber());
                    String period1 = (String)map1.get(SysDimensionEnum.Period.getNumber());
                    String period2 = (String)map2.get(SysDimensionEnum.Period.getNumber());
                    if (StringUtils.isNotEmpty((String)year1) && StringUtils.isNotEmpty((String)year2)) {
                        result = year1.compareTo(year2);
                        if (result == 0 && StringUtils.isNotEmpty((String)period1) && StringUtils.isNotEmpty((String)period2)) {
                            result = period1.compareTo(period2);
                        }
                    } else if (StringUtils.isNotEmpty((String)period1) && StringUtils.isNotEmpty((String)period2)) {
                        result = period1.compareTo(period2);
                    }
                } else {
                    String budgetPeriod1 = (String)map1.get(SysDimensionEnum.BudgetPeriod.getNumber());
                    String budgetPeriod2 = (String)map2.get(SysDimensionEnum.BudgetPeriod.getNumber());
                    if (StringUtils.isNotEmpty((String)budgetPeriod1) && StringUtils.isNotEmpty((String)budgetPeriod2)) {
                        result = budgetPeriod1.compareTo(budgetPeriod2);
                    }
                }
            } else {
                result = billNumber1.compareTo(billNumber2);
            }
            return result;
        });
    }

    public Collection<IBudgetBalance> queryBalance(Long modelId, List<Map<String, String>> members, Collection<String> types, boolean hasQuerySetRule, boolean hasQueryActControlRule) {
        ArrayList<IBudgetBalance> balances = new ArrayList<IBudgetBalance>();
        try {
            if (modelId == 0L || members == null || members.isEmpty()) {
                return balances;
            }
            ControlParameter parameter = new ControlParameter();
            parameter.setQueryCentralized(false);
            parameter.setHasQueryActControlRule(hasQueryActControlRule);
            parameter.setCalcParameter(new CalcMemberParameter(modelId, members, types, hasQuerySetRule));
            return new QueryBalanceImpl(parameter).queryMemberBalance();
        }
        catch (KDBizException e) {
            if ("EB090002".equals(e.getErrorCode().getCode())) {
                throw new KDBizException(e.getMessage());
            }
            log.error("query members balance by control rule error", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u53ef\u7528\u9884\u7b97\u4f59\u989d\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BgControlCallerImpl_0", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        catch (Exception e) {
            log.error("query members balance by control rule error", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u53ef\u7528\u9884\u7b97\u4f59\u989d\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BgControlCallerImpl_0", (String)"epm-eb-business", (Object[])new Object[0]));
        }
    }

    public Collection<IBudgetBalance> queryBalance(Long modelId, List<Map<String, String>> members, Collection<String> types, boolean hasQuerySetRule, boolean hasQueryActControlRule, Long businessModelId) {
        return this.queryBalance(modelId, members, types, hasQuerySetRule, hasQueryActControlRule, false, businessModelId);
    }

    public Collection<IBudgetBalance> queryBalance(Long modelId, List<Map<String, String>> members, Collection<String> types, boolean hasQuerySetRule, boolean hasQueryActControlRule, boolean isNotFillPeriod, Long businessModelId) {
        return this.queryBalance(modelId, members, types, hasQuerySetRule, hasQueryActControlRule, isNotFillPeriod, businessModelId, true);
    }

    public Collection<IBudgetBalance> queryBalance(Long modelId, List<Map<String, String>> members, Collection<String> types, boolean hasQuerySetRule, boolean hasQueryActControlRule, boolean isNotFillPeriod, Long businessModelId, boolean isDefaultZero) {
        ArrayList<IBudgetBalance> balances = new ArrayList<IBudgetBalance>();
        try {
            if (modelId == 0L || members == null || members.isEmpty()) {
                return balances;
            }
            ControlParameter parameter = new ControlParameter();
            parameter.setDefaultZero(isDefaultZero);
            parameter.setQueryCentralized(false);
            parameter.setHasQueryActControlRule(hasQueryActControlRule);
            parameter.setNotFillPeriod(isNotFillPeriod);
            parameter.setCalcParameter(new CalcMemberParameter(modelId, members, types, hasQuerySetRule, businessModelId));
            return new QueryBalanceImpl(parameter).queryMemberBalance();
        }
        catch (KDBizException e) {
            if ("EB090002".equals(e.getErrorCode().getCode())) {
                throw new KDBizException(e.getMessage());
            }
            log.error("query members balance by control rule error", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u53ef\u7528\u9884\u7b97\u4f59\u989d\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BgControlCallerImpl_0", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        catch (Exception e) {
            log.error("query members balance by control rule error", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u53ef\u7528\u9884\u7b97\u4f59\u989d\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BgControlCallerImpl_0", (String)"epm-eb-business", (Object[])new Object[0]));
        }
    }

    public Collection<IBudgetBalance> queryBalance(Long modelId, List<Map<String, String>> members, Collection<String> types, boolean hasQuerySetRule, boolean hasQueryActControlRule, Map<String, BigDecimal> submitValueMap) {
        ArrayList<IBudgetBalance> balances = new ArrayList<IBudgetBalance>();
        try {
            if (modelId == 0L || members == null || members.isEmpty()) {
                return balances;
            }
            log.info("query members balance by control rule and budget occupation submitValueMap " + JSONUtils.toString(submitValueMap));
            ControlParameter parameter = new ControlParameter();
            parameter.setQueryCentralized(false);
            parameter.setHasQueryActControlRule(hasQueryActControlRule);
            parameter.setHasQueryActControlRuleByBudOcc(true);
            parameter.setSubmitValueMap(submitValueMap);
            parameter.setCalcParameter(new CalcMemberParameter(modelId, members, types, hasQuerySetRule));
            return new QueryBalanceImpl(parameter).queryMemberBalance();
        }
        catch (KDBizException e) {
            if ("EB090002".equals(e.getErrorCode().getCode())) {
                throw new KDBizException(e.getMessage());
            }
            log.error("query members balance by control rule and budget occupation error", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u53ef\u7528\u9884\u7b97\u4f59\u989d\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BgControlCallerImpl_0", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        catch (Exception e) {
            log.error("query members balance by control rule and budget occupation error", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u53ef\u7528\u9884\u7b97\u4f59\u989d\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BgControlCallerImpl_0", (String)"epm-eb-business", (Object[])new Object[0]));
        }
    }

    public Collection<IBudgetBalance> queryBalance(Long modelId, List<Map<String, String>> members, Collection<String> types, boolean hasQuerySetRule, boolean hasQueryActControlRule, Long businessModelId, Map<String, BigDecimal> submitValueMap) {
        ArrayList<IBudgetBalance> balances = new ArrayList<IBudgetBalance>();
        try {
            if (modelId == 0L || members == null || members.isEmpty()) {
                return balances;
            }
            log.info("query members balance by control rule and budget occupation submitValueMap " + JSONUtils.toString(submitValueMap));
            ControlParameter parameter = new ControlParameter();
            parameter.setQueryCentralized(false);
            parameter.setHasQueryActControlRule(hasQueryActControlRule);
            parameter.setHasQueryActControlRuleByBudOcc(true);
            parameter.setSubmitValueMap(submitValueMap);
            parameter.setCalcParameter(new CalcMemberParameter(modelId, members, types, hasQuerySetRule, businessModelId));
            return new QueryBalanceImpl(parameter).queryMemberBalance();
        }
        catch (KDBizException e) {
            if ("EB090002".equals(e.getErrorCode().getCode())) {
                throw new KDBizException(e.getMessage());
            }
            log.error("query members balance by control rule and budget occupation error", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u53ef\u7528\u9884\u7b97\u4f59\u989d\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BgControlCallerImpl_0", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        catch (Exception e) {
            log.error("query members balance by control rule and budget occupation error", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u53ef\u7528\u9884\u7b97\u4f59\u989d\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BgControlCallerImpl_0", (String)"epm-eb-business", (Object[])new Object[0]));
        }
    }

    @Override
    public void releaseEntryBudget(String entityNumber, String bizId, String entryId) {
        ControlParameter parameter = new ControlParameter();
        parameter.setCalcParameter(new CalcEntryIdParameter(entityNumber, bizId, entryId));
        this.writeControlLog(parameter, "releaseEntryBudget");
        new CloseBudgetImpl(parameter).closeBudget();
    }

    @Override
    public void budgetRollBack(String entityNumber, Set<String> bizIds, String requestId) {
        ControlParameter parameter = new ControlParameter();
        if (requestId == null) {
            requestId = RequestContext.get().getTraceId();
        }
        parameter.setCalcParameter(new CalcBizIdSetParameter(entityNumber, bizIds, requestId));
        new BudgetTransactionImpl(parameter).rollBack();
    }

    @Override
    public void requestSuccess(String entityNumber, Set<String> bizIds, String requestId) {
        ControlParameter parameter = new ControlParameter();
        if (requestId == null) {
            requestId = RequestContext.get().getTraceId();
        }
        parameter.setCalcParameter(new CalcBizIdSetParameter(entityNumber, bizIds, requestId));
        new BudgetTransactionImpl(parameter).requestSuccess();
    }

    private IControlParameter getControlParameter(List<Map<String, Object>> bizObjMaps, String operation, String upstreamId, Boolean isdelEntry, List<Map<String, Object>> writeoffMaps, String budgetappliernumber) {
        this.checkBizParam(bizObjMaps);
        ControlParameter parameter = new ControlParameter();
        this.writeControlLog(parameter, bizObjMaps, operation);
        parameter.getControlManager().setStandard(false);
        if ("occupationBudget".equals(operation)) {
            parameter.getControlManager().setOccupation(true);
        } else {
            parameter.getControlManager().setExecute(true);
        }
        parameter.setCalcParameter(new CalcObjectParameter(bizObjMaps, writeoffMaps));
        parameter.setOperation(operation);
        if (upstreamId != null) {
            parameter.getDataManager().setUpstreamId(upstreamId);
        }
        parameter.getControlManager().setDelEntry(isdelEntry);
        parameter.setApplier(budgetappliernumber);
        return parameter;
    }

    @Override
    public Set<String> getQueryField(String entityNumber) {
        return QueryFieldByBill.queryFieldByDefault(entityNumber, true, false);
    }
}

