/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.calc.face;

import java.math.BigDecimal;
import kd.epm.eb.control.face.IBudgetBalance;

public interface ICalculator {
    public Object calc(IBudgetBalance var1);

    default public BigDecimal add(BigDecimal value1, BigDecimal value2) {
        if (value2 != null) {
            if (value1 == null) {
                return value2;
            }
            return value1.add(value2);
        }
        return value1;
    }

    default public BigDecimal getActualOld(IBudgetBalance balance, String type) {
        if (balance != null && balance.getActualValues() != null && balance.getActualValues().get(type) != null) {
            return balance.getActualValues().get(type).get(balance.getFullPeriodNumber(true));
        }
        return null;
    }

    default public Object calcRate(BigDecimal budget, BigDecimal actual) {
        if (actual == null && budget == null) {
            return null;
        }
        if (actual == null || budget == null || BigDecimal.ZERO.compareTo(budget) == 0) {
            return BigDecimal.ZERO;
        }
        return actual.divide(budget, 8, 4);
    }
}

