/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.calc.impl;

import java.math.BigDecimal;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.control.face.IBudgetBalance;

public class LimitBalance {
    public BigDecimal calc(IBudgetBalance balance, Object _budgetValue) {
        if (balance == null) {
            return null;
        }
        BigDecimal limitBalance = this.getLimitBalance(balance);
        BigDecimal budgetValue = Convert.toBigDecimal((Object)_budgetValue);
        return LimitBalance.getMinValue(limitBalance, budgetValue);
    }

    public static BigDecimal getMinValue(BigDecimal limitBalance, BigDecimal budgetValue) {
        if (limitBalance == null && budgetValue == null) {
            return null;
        }
        if (limitBalance == null) {
            if (budgetValue.compareTo(BigDecimal.ZERO) > 0) {
                return null;
            }
            return budgetValue;
        }
        if (budgetValue == null) {
            if (limitBalance.compareTo(BigDecimal.ZERO) > 0) {
                return null;
            }
            return limitBalance;
        }
        if (limitBalance.compareTo(budgetValue) > 0) {
            return budgetValue;
        }
        return limitBalance;
    }

    public BigDecimal getLimitBalance(IBudgetBalance balance) {
        if (balance == null) {
            return null;
        }
        BigDecimal limitBalance = balance.getLimitBalance();
        if (limitBalance != null && balance.getSetting() != null && balance.getSetting().getCoefficient() != null) {
            limitBalance = limitBalance.divide(balance.getSetting().getCoefficient(), 4);
        }
        return limitBalance;
    }
}

