/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.calc.impl;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import kd.epm.eb.common.enums.BgControlSettingTypeEnum;
import kd.epm.eb.control.calc.face.ICalculator;
import kd.epm.eb.control.face.IBudgetBalance;

public class Time_Plan
implements ICalculator {
    @Override
    public Object calc(IBudgetBalance balance) {
        if (balance == null) {
            return null;
        }
        BgControlSettingTypeEnum periodType = balance.getSetting() == null ? BgControlSettingTypeEnum.MONTH : balance.getSetting().getSettingType();
        return this.calc(periodType);
    }

    private Object calc(BgControlSettingTypeEnum periodType) {
        int thisDay = 0;
        int totalDay = 0;
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        switch (periodType) {
            case MONTH: {
                thisDay = cal.get(5);
                totalDay = cal.getActualMaximum(5);
                break;
            }
            case QUARTER: {
                thisDay = this.calc(cal, BgControlSettingTypeEnum.QUARTER, false, false);
                totalDay = this.calc(cal, BgControlSettingTypeEnum.QUARTER, true, false);
                break;
            }
            case HALFYEAR: {
                thisDay = this.calc(cal, BgControlSettingTypeEnum.HALFYEAR, false, false);
                totalDay = this.calc(cal, BgControlSettingTypeEnum.HALFYEAR, true, false);
                break;
            }
            case YEAR: {
                thisDay = cal.get(6);
                totalDay = cal.getActualMaximum(6);
                break;
            }
            case MONTH_ADDUP: {
                thisDay = this.calc(cal, BgControlSettingTypeEnum.MONTH, false, true);
                totalDay = this.calc(cal, BgControlSettingTypeEnum.MONTH, true, true);
                break;
            }
            case QUARTER_ADDUP: {
                thisDay = this.calc(cal, BgControlSettingTypeEnum.QUARTER, false, true);
                totalDay = this.calc(cal, BgControlSettingTypeEnum.QUARTER, true, true);
                break;
            }
            default: {
                thisDay = cal.get(5);
                totalDay = cal.getActualMaximum(5);
            }
        }
        BigDecimal value = new BigDecimal(String.valueOf((double)thisDay / (double)totalDay));
        return value;
    }

    private int getMaxDays(Calendar cal, int month) {
        Calendar c = (Calendar)cal.clone();
        c.set(2, month);
        return c.getActualMaximum(5);
    }

    private int calc(Calendar cal, BgControlSettingTypeEnum periodType, boolean isTotal, boolean isAddup) {
        int month = cal.get(2);
        int minMonth = 0;
        int maxMonth = 0;
        if (BgControlSettingTypeEnum.MONTH == periodType) {
            minMonth = 0;
            maxMonth = month;
        } else if (BgControlSettingTypeEnum.QUARTER == periodType) {
            minMonth = month / 3 * 3;
            maxMonth = minMonth + 2;
        } else if (BgControlSettingTypeEnum.HALFYEAR == periodType) {
            minMonth = month / 6 * 6;
            maxMonth = minMonth + 5;
        }
        if (isAddup) {
            minMonth = 0;
        }
        if (!isTotal) {
            maxMonth = month;
        }
        int days = 0;
        for (int m = minMonth; m <= maxMonth; ++m) {
            if (m == month && !isTotal) {
                days += cal.get(5);
                continue;
            }
            days += this.getMaxDays(cal, m);
        }
        return days;
    }
}

