/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.impl;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.ControlMessageTypeEnum;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.model.BizOrgUnit;
import kd.epm.eb.common.resource.ControlException;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.control.BgContParamUtils;
import kd.epm.eb.common.utils.lock.Lock;
import kd.epm.eb.common.utils.lock.LockHandler;
import kd.epm.eb.control.eums.ControlLogTypeEnum;
import kd.epm.eb.control.eums.ControlResultEnum;
import kd.epm.eb.control.face.IControlParameter;
import kd.epm.eb.control.face.IResultCause;
import kd.epm.eb.control.impl.ControlParameter;
import kd.epm.eb.control.impl.model.BgControlData;
import kd.epm.eb.control.utils.BgControlLogUtils;
import kd.epm.eb.control.utils.BgControlRelationUtils;
import kd.epm.eb.control.utils.BgControlUtils;

public abstract class AbstractControlImpl {
    private static final Log log = LogFactory.getLog(AbstractControlImpl.class);
    private static final DBRoute db_ai = DBRoute.of((String)"ai");
    private IControlParameter parameter = null;
    private LogStats stats = null;

    protected IControlParameter getParameter() {
        if (this.parameter == null) {
            this.parameter = new ControlParameter();
        }
        return this.parameter;
    }

    public LogStats getStats() {
        if (this.stats == null) {
            this.stats = new LogStats("budget-control-log : ");
        }
        return this.stats;
    }

    public AbstractControlImpl(IControlParameter parameter) {
        this.parameter = parameter;
    }

    protected void checkParameter() {
        if (this.getParameter() == null) {
            ControlException.errorControlParameter();
        }
    }

    protected Set<Long> getParentOrgIds(BgControlData controlData) {
        return controlData != null ? controlData.getParentIds() : null;
    }

    protected boolean[] getManagerParam(BizOrgUnit bizOrgUnit) {
        return BgContParamUtils.getManagerParam((String)this.getParameter().getEntityNumber(), (Long)bizOrgUnit.getOrgId());
    }

    protected boolean isControl(boolean[] param) {
        return BgContParamUtils.isControl((boolean[])param);
    }

    protected boolean isShowBeyondMessage(boolean[] param) {
        return BgContParamUtils.isShowBeyondMessage((boolean[])param);
    }

    public Map<String, HashSet<Long>> getSourceBillsV2(Collection<BizModel> models, final IControlParameter parameter, LogStats stats) {
        LinkedHashMap<String, HashSet<Long>> param = new LinkedHashMap<String, HashSet<Long>>();
        Map<String, HashSet<Long>> lkmap = null;
        if (parameter.getBizObj() != null) {
            String entityNumber = parameter.getEntityNumber();
            final Long bizId = IDUtils.toLong((Object)parameter.getBizId());
            param.put(entityNumber, new HashSet(){
                {
                    this.add(bizId);
                }
            });
            try {
                lkmap = this.getRelationSource(parameter);
                stats.add("lk get upstreamId");
            }
            catch (Exception e) {
                stats.add("lk get exception");
            }
            if (lkmap != null && !lkmap.isEmpty()) {
                Set value = lkmap.entrySet().iterator().next().getValue();
                Set<String> idStrs = value.stream().map(v -> String.valueOf(v)).collect(Collectors.toSet());
                Set<String> _ctrlIds = this.queryControlRecord(models, idStrs);
                if (_ctrlIds != null && !_ctrlIds.isEmpty()) {
                    stats.add("lk get upstreamId record");
                    return lkmap;
                }
                this.computIfAbsent(param, lkmap);
            }
        } else if (parameter.getBizId() != null && parameter.getEntityNumber() != null) {
            param.put(parameter.getEntityNumber(), new HashSet(){
                {
                    this.add(IDUtils.toLong((Object)parameter.getBizId()));
                }
            });
        } else {
            return new HashMap<String, HashSet<Long>>();
        }
        HashSet<String> queryIds = new HashSet<String>(16);
        try {
            HashMap<String, HashSet<Long>> relateParam = new HashMap<String, HashSet<Long>>(param);
            while (relateParam.entrySet().iterator().hasNext()) {
                Map<String, HashSet<Long>> sourceRelated = this.getSourceRelated(relateParam);
                log.info("getSourceRelatedlog>>" + JSONUtils.toString(sourceRelated));
                relateParam.clear();
                if (sourceRelated.isEmpty()) continue;
                Iterator<Map.Entry<String, HashSet<Long>>> iterator = sourceRelated.entrySet().iterator();
                HashSet<String> idStrs = new HashSet<String>(16);
                while (iterator.hasNext()) {
                    Set value = iterator.next().getValue().stream().map(hs -> String.valueOf(hs)).collect(Collectors.toSet());
                    idStrs.addAll(value);
                }
                if (!queryIds.containsAll(idStrs)) {
                    Set<String> _ctrlIds = this.queryControlRecord(models, idStrs);
                    queryIds.addAll(idStrs);
                    if (_ctrlIds != null && !_ctrlIds.isEmpty()) {
                        stats.add("relation get upstream");
                        return sourceRelated;
                    }
                    this.computIfAbsent(relateParam, sourceRelated);
                    this.computIfAbsent(param, sourceRelated);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            log.error("search-upstrem-relation-error", (Throwable)e);
        }
        Iterator paramIterator = param.entrySet().iterator();
        Boolean hasRecord = Boolean.FALSE;
        Map<String, HashSet<Long>> sourceIdMap = new HashMap<String, HashSet<Long>>();
        while (paramIterator.hasNext() && !hasRecord.booleanValue()) {
            Map.Entry<String, HashSet<Long>> next = paramIterator.next();
            List<BFRowLinkUpNode> nodes = this.loadLinkUpNodes(next);
            if (nodes == null || nodes.isEmpty()) continue;
            stats.add("botp get upstreamId record");
            LinkedHashMap sourceIds = Maps.newLinkedHashMap();
            for (BFRowLinkUpNode node : nodes) {
                this.buildSourceIds(sourceIds, (Set<Long>)next.getValue(), node, 0);
            }
            sourceIdMap = this.getSourceIds(sourceIds, models);
            hasRecord = sourceIdMap != null && !sourceIdMap.isEmpty();
        }
        return sourceIdMap;
    }

    protected List<BFRowLinkUpNode> loadLinkUpNodes(Map.Entry<String, HashSet<Long>> next) {
        return BFTrackerServiceHelper.loadLinkUpNodes((String)next.getKey(), (String)"", (Long[])next.getValue().toArray(new Long[0]));
    }

    protected Map<String, HashSet<Long>> getRelationSource(IControlParameter parameter) {
        return BgControlRelationUtils.get().getSource(parameter.getBizObj());
    }

    private void buildSourceIds(Map<Integer, Map<String, Set<Long>>> sourceIds, Set<Long> currBillIds, BFRowLinkUpNode node, int level) {
        if (sourceIds == null || currBillIds == null || node == null) {
            return;
        }
        if (!currBillIds.contains(node.getRowId().getBillId())) {
            Map sourceIdMap = sourceIds.computeIfAbsent(level, f -> Maps.newLinkedHashMap());
            TableDefine tableDefine = EntityMetadataCache.loadTableDefine((Long)node.getRowId().getTableId());
            if (tableDefine != null) {
                Set ids = sourceIdMap.computeIfAbsent(tableDefine.getEntityNumber(), f -> Sets.newHashSet());
                ids.add(node.getRowId().getBillId());
            }
        }
        if (node.getSNodes() != null) {
            for (Map.Entry entry : node.getSNodes().entrySet()) {
                this.buildSourceIds(sourceIds, currBillIds, (BFRowLinkUpNode)entry.getValue(), level + 1);
            }
        }
    }

    private Map<String, HashSet<Long>> getSourceIds(Map<Integer, Map<String, Set<Long>>> sourceIds, Collection<BizModel> models) {
        if (sourceIds == null || sourceIds.isEmpty() || models == null || models.isEmpty()) {
            return null;
        }
        LinkedHashSet tmpIds = Sets.newLinkedHashSet();
        for (Map<String, Set<Long>> bizBill : sourceIds.values()) {
            for (Set<Long> billIds : bizBill.values()) {
                for (Long billId : billIds) {
                    tmpIds.add(billId.toString());
                }
            }
        }
        Set<String> hasRecord = this.queryControlRecord(models, tmpIds);
        LinkedHashMap _sourceIds = Maps.newLinkedHashMap();
        if (!hasRecord.isEmpty()) {
            int count = sourceIds.size();
            for (int level = 1; level <= count; ++level) {
                Map<String, Set<Long>> tmpMap = sourceIds.get(level);
                if (tmpMap == null) continue;
                for (Map.Entry<String, Set<Long>> bills : tmpMap.entrySet()) {
                    for (Long billId : bills.getValue()) {
                        if (!hasRecord.contains(billId.toString())) continue;
                        HashSet _sourceId = _sourceIds.computeIfAbsent(bills.getKey(), f -> new HashSet());
                        _sourceId.add(billId);
                    }
                }
                if (!_sourceIds.isEmpty()) break;
            }
        }
        return _sourceIds;
    }

    private Set<String> queryControlRecord(Collection<BizModel> models, Set<String> bizBillIds) {
        if (models == null || models.isEmpty() || bizBillIds == null || bizBillIds.isEmpty()) {
            return null;
        }
        log.info("bgControlData.size=" + models.size());
        HashSet hasRecord = Sets.newHashSetWithExpectedSize((int)bizBillIds.size());
        for (BizModel bizModel : models) {
            this.queryControlRecord(bizBillIds, hasRecord, bizModel);
        }
        return hasRecord;
    }

    private void queryControlRecord(Set<String> bizBillIds, Set<String> hasRecord, BizModel bizModel) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select distinct fbizid from ", new Object[0]);
        sql.append(bizModel.getBgControlRecordTable(), new Object[0]);
        sql.append(" where ", new Object[0]);
        sql.appendIn("fbizid", bizBillIds.toArray());
        try (DataSet ds = DB.queryDataSet((String)"querySourceIds", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    hasRecord.add(row.getString("fbizid"));
                }
            }
        }
    }

    public void checkSource() {
        if (this.getParameter() == null || this.getParameter().getBizObj() == null) {
            return;
        }
        if (this.getParameter().getDataManager().getSourceBizUnit() != null && !this.getParameter().getDataManager().getSourceBizUnit().isEmpty()) {
            return;
        }
        switch (this.getParameter().getEntityNumber()) {
            case "er_dailyreimbursebill": 
            case "er_publicreimbursebill": {
                this.checkBillEntry({"writeoffapply"}, {"writeoffmoney"});
                break;
            }
            case "er_tripreimbursebill": {
                this.checkBillEntry(new String[][]{{"clearloanentry"}});
            }
        }
    }

    private void checkBillEntry(String[] ... entries) {
        if (entries == null || entries.length == 0) {
            return;
        }
        for (String[] entry : entries) {
            Object obj = this.getParameter().getBizObj().get(entry[0]);
            if (!(obj instanceof DynamicObjectCollection) || ((DynamicObjectCollection)obj).isEmpty() || this.getParameter().getDataManager().getSourceBizUnit() == null) continue;
            HashSet<Long> sourceIds = null;
            for (int i = 1; i < entry.length; ++i) {
                if (sourceIds != null && !sourceIds.isEmpty()) continue;
                sourceIds = this.getParameter().getDataManager().getSourceBizUnit().get(entry[i]);
            }
            if (sourceIds != null && !sourceIds.isEmpty()) continue;
            ControlException.errorErLoanBill();
        }
    }

    protected void lock(LockHandler handler) {
        if (handler == null) {
            return;
        }
        handler.setNeedLock(true);
        Lock.doLock((LockHandler)handler);
    }

    protected Map<String, HashSet<Long>> getSourceRelated(Map<String, HashSet<Long>> billMap) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String classPath = "kd.bos.ext.fi.bill.RelatedBillHelper";
        Class<?> clazz = Class.forName(classPath);
        Method method = clazz.getMethod("relatedBill", Map.class);
        Map invokeResult = (Map)method.invoke(null, billMap);
        return invokeResult;
    }

    private void computIfAbsent(Map<String, HashSet<Long>> m1, Map<String, HashSet<Long>> m2) {
        for (Map.Entry<String, HashSet<Long>> next : m2.entrySet()) {
            if (m1.containsKey(next.getKey())) continue;
            m1.put(next.getKey(), next.getValue());
        }
    }

    protected void checkResult(IControlParameter parameter) {
        if (parameter == null || parameter.getResult() == null) {
            throw new NullPointerException("not control result.");
        }
        if (!parameter.getControlManager().isCalcBalance()) {
            return;
        }
        if (parameter.getResult().getResult().getNumber().equals(ControlResultEnum.BEYOND.getNumber())) {
            List<IResultCause> causeList = parameter.getResult().getCause();
            String entityNumber = parameter.getEntityNumber();
            Boolean showBeyondMessage = parameter.getResult().getShowBeyondMessage();
            String typeNumber = ControlMessageTypeEnum.BUDGET_NOT_ENOUGH.getNumber();
            String controlMessage = BgControlUtils.getControlMessage(causeList, entityNumber, showBeyondMessage, typeNumber);
            this.getStats().addInfo(controlMessage);
            BgControlLogUtils.addDetail(this.getStats(), ControlLogTypeEnum.CONTROLRESULT, 2, null, controlMessage, null, false);
            ControlException.errorOutOfBalance((String)controlMessage);
        } else {
            String bizno = this.getParameter().getBizNo();
            if (bizno == null) {
                try {
                    bizno = this.getParameter().getBizNumber();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (bizno == null) {
                bizno = "";
            }
            BgControlLogUtils.addDetail(this.getStats(), ControlLogTypeEnum.CONTROLRESULT, 0, parameter.getResult().getCode(), ControlException.requestBudget((String)bizno), null, false);
            this.getStats().addInfo(ControlException.requestBudget((String)this.getParameter().getBizNo()));
        }
    }
}

