/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.impl;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.model.BizOrgUnit;
import kd.epm.eb.common.resource.ControlException;
import kd.epm.eb.control.eums.ControlResultEnum;
import kd.epm.eb.control.face.IControlParameter;
import kd.epm.eb.control.face.IControlResult;
import kd.epm.eb.control.impl.AbstractControlImpl;
import kd.epm.eb.control.impl.calc.CalcControl;
import kd.epm.eb.control.impl.model.BgControlData;
import kd.epm.eb.control.utils.BgControlProcessUtils;
import kd.epm.eb.control.utils.BgRegisterUtils;

public class BeyondBalanceImpl
extends AbstractControlImpl {
    private static final Log log = LogFactory.getLog(BeyondBalanceImpl.class);

    public BeyondBalanceImpl(IControlParameter parameter) {
        super(parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IControlResult isBeyond() {
        this.getStats().addInfo("begin queryBeyondBalance");
        try {
            IControlParameter parameter = this.getParameter();
            if (parameter == null) {
                ControlException.errorControlParameter();
                IControlResult iControlResult = this.getParameter().getResult();
                return iControlResult;
            }
            if (parameter.getCalcParameter() == null || !parameter.getCalcParameter().check()) {
                ControlException.errorControlParameter();
                IControlResult iControlResult = this.getParameter().getResult();
                return iControlResult;
            }
            String[] props = BgRegisterUtils.queryRegisterBizUnit(this.getParameter().getEntityNumber());
            Object[] objProps = BgRegisterUtils.getBizUnit(this.getStats(), this.getParameter(), props);
            BgRegisterUtils.checkDefaultProps(this.getStats(), objProps, props);
            BizOrgUnit bizOrgUnit = (BizOrgUnit)objProps[0];
            Date bizTime = (Date)objProps[1];
            BgControlData controlData = new BgControlData(BgRegisterUtils.isMultiControl(props), bizOrgUnit, bizTime, this.getStats());
            Collection<BizModel> models = this.getParameter().getBizUtils().queryModel(bizTime, false);
            models = this.getParameter().getBizUtils().filterModel(models, controlData);
            if (models != null && !models.isEmpty()) {
                if (models.size() > 1 && !controlData.isMultiControl()) {
                    ControlException.existMoreModel(models);
                } else {
                    controlData.setBizModels(models);
                }
            }
            if (this.isShowBeyondMessage(this.getManagerParam(bizOrgUnit))) {
                this.getParameter().getResult().setShowBeyondMessage(true);
            }
            BgControlProcessUtils.queryProcessSet(this.getParameter(), controlData, this.getParentOrgIds(controlData), this.getStats());
            if (this.getParameter().getDataManager().getApplyFields().isEmpty()) {
                this.getParameter().getResult().setResult(ControlResultEnum.DONTCONTROL);
                this.getParameter().getResult().setCode("dont-control-process-scheme");
                IControlResult iControlResult = this.getParameter().getResult();
                return iControlResult;
            }
            if (!this.isControl(this.getManagerParam(bizOrgUnit))) {
                this.getParameter().getResult().setResult(ControlResultEnum.DONTCONTROL);
                this.getParameter().getResult().setCode("dont-control-process-scheme");
                IControlResult iControlResult = this.getParameter().getResult();
                return iControlResult;
            }
            if (this.getParameter().getDataManager().getSourceBizUnit() == null) {
                Map<String, HashSet<Long>> sourceBills = this.getSourceBillsV2(models, this.getParameter(), controlData.getStats());
                if (sourceBills != null && !sourceBills.isEmpty()) {
                    this.getParameter().getDataManager().setSourceBizUnit(sourceBills);
                } else {
                    this.getStats().addInfo("not find source bizId.");
                }
            }
            CalcControl calc = CalcControl.getInterface(controlData);
            calc.setParameter(this.getParameter());
            calc.setModels(models);
            calc.handler();
        }
        finally {
            this.getStats().addInfo("end queryBeyondBalance");
            log.info(this.getStats().toString());
        }
        return this.getParameter().getResult();
    }
}

