/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.face.IControlParameter;
import kd.epm.eb.control.impl.CalcBizIdSetParameter;
import kd.epm.eb.control.impl.model.AbstractBgControlRecord;
import kd.epm.eb.control.impl.model.BgControlRecord;
import kd.epm.eb.control.utils.BgControlRecordUtils;
import kd.epm.eb.control.utils.BgReturnBudgetUtils;

public class BudgetTransactionImpl {
    private static final Log log = LogFactory.getLog(BudgetTransactionImpl.class);
    private IControlParameter parameter;

    public BudgetTransactionImpl(IControlParameter parameter) {
        this.parameter = parameter;
    }

    public void rollBack() {
        CalcBizIdSetParameter calcParameter = (CalcBizIdSetParameter)this.parameter.getCalcParameter();
        String requestId = calcParameter.getRequestId();
        if (calcParameter.getEntityNumber() == null || calcParameter.getBizIds() == null || calcParameter.getBizIds().isEmpty() || requestId == null) {
            return;
        }
        List<BgControlRecord> records = BgControlRecordUtils.query(calcParameter.getBizIds());
        if (records.isEmpty() || records.stream().noneMatch(k -> requestId.equals(k.getRequestId()))) {
            return;
        }
        List recordList = records.stream().filter(k -> requestId.equals(k.getRequestId()) && "2".equals(k.getStatus())).collect(Collectors.toList());
        Map<String, List<BgControlRecord>> groupBizIds = recordList.stream().collect(Collectors.groupingBy(AbstractBgControlRecord::getBizId));
        for (Map.Entry<String, List<BgControlRecord>> entrySet : groupBizIds.entrySet()) {
            if (!entrySet.getValue().stream().anyMatch(k -> requestId.equals(k.getRequestId()) && "2".equals(k.getStatus()))) continue;
            BgReturnBudgetUtils.returnBudget(calcParameter.getEntityNumber(), entrySet.getKey(), entrySet.getValue());
        }
    }

    public void requestSuccess() {
        CalcBizIdSetParameter calcParameter = (CalcBizIdSetParameter)this.parameter.getCalcParameter();
        String requestId = calcParameter.getRequestId();
        if (calcParameter.getEntityNumber() == null || calcParameter.getBizIds() == null || calcParameter.getBizIds().isEmpty() || requestId == null) {
            return;
        }
        ArrayList<Object[]> updates = new ArrayList<Object[]>(16);
        String bizIdStr = calcParameter.getBizIds().stream().map(k -> "'" + k + "'").collect(Collectors.joining(","));
        String sql = "select distinct ftable from t_eb_bgcontrolindex where fbizid in (" + bizIdStr + ")";
        try (DataSet ds = DB.queryDataSet((String)"queryIndex", (DBRoute)BgBaseConstant.epm, (String)sql);){
            for (Row row : ds) {
                String table = row.getString("ftable");
                if (StringUtils.isEmpty((String)table)) {
                    table = "t_eb_bgcontrolrecord";
                }
                updates.add(new Object[]{requestId});
                this.excuteSql("update " + table + " set fstatus = '1' where fbizid in (" + bizIdStr + ") and frequestId = ?", updates);
            }
        }
    }

    private void excuteSql(String sql, List<Object[]> updates) {
        try (TXHandle tx = TX.requiresNew((String)"updateRecordStatus");){
            try {
                DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)sql, updates);
            }
            catch (Exception e) {
                tx.markRollback();
            }
        }
    }
}

