/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.epm.eb.common.resource.ControlException;
import kd.epm.eb.common.utils.EntityUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.face.ICalcParameter;

public class CalcObjectParameter
implements ICalcParameter {
    private String entityNumber = null;
    private String bizId = null;
    private DynamicObject bizObj = null;
    private String operation = null;
    private List<Map<String, Object>> bizObjMaps = null;
    private LinkedHashMap<String, List<Map<String, Object>>> writeoffMaps = null;

    public void setEntityNumber(String entityNumber) {
        this.entityNumber = entityNumber;
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    @Override
    public String getBizId() {
        return this.bizId;
    }

    public void setBizObj(DynamicObject bizObj) {
        this.bizObj = bizObj;
    }

    public DynamicObject getBizObj() {
        return this.bizObj;
    }

    @Override
    public String getBizNumber() {
        Map<String, Object> bizObjMap;
        String billNumber = null;
        if (this.bizObj != null) {
            String billNumProp = null;
            if (this.bizObj.getDataEntityType().getProperties().containsKey((Object)"billno")) {
                billNumProp = "billno";
            } else if (this.bizObj.getDataEntityType().getProperties().containsKey((Object)"number")) {
                billNumProp = "number";
            }
            billNumber = billNumProp != null ? this.bizObj.getString(billNumProp) : null;
        } else if (this.bizObjMaps != null && !this.bizObjMaps.isEmpty() && StringUtils.isEmpty((String)(billNumber = (String)(bizObjMap = this.bizObjMaps.get(0)).get("number")))) {
            billNumber = (String)bizObjMap.get("billno");
        }
        return billNumber;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getOperation() {
        return this.operation;
    }

    public List<Map<String, Object>> getBizObjMaps() {
        return this.bizObjMaps;
    }

    public void setBizObjMaps(List<Map<String, Object>> bizObjMaps) {
        this.bizObjMaps = bizObjMaps;
    }

    public void setWriteoffMaps(LinkedHashMap<String, List<Map<String, Object>>> writeoffMaps) {
        this.writeoffMaps = writeoffMaps;
    }

    public LinkedHashMap<String, List<Map<String, Object>>> getWriteoffMaps() {
        return this.writeoffMaps;
    }

    public CalcObjectParameter(DynamicObject bizObj, String operation) {
        this.bizObj = bizObj;
        if (bizObj != null && bizObj.getDataEntityType() != null) {
            this.entityNumber = EntityUtils.getEntityNumber((DynamicObject)bizObj);
        }
        if (bizObj != null) {
            this.bizId = bizObj.getString("id");
        }
        this.operation = operation;
    }

    public CalcObjectParameter(List<Map<String, Object>> bizObjMaps, List<Map<String, Object>> writeoffMaps) {
        this(bizObjMaps);
        this.writeoffMaps = this.buildWriteOffMaps(writeoffMaps);
    }

    private LinkedHashMap<String, List<Map<String, Object>>> buildWriteOffMaps(List<Map<String, Object>> writeoffMaps) {
        if (writeoffMaps == null || writeoffMaps.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, List<Map<String, Object>>> result = new LinkedHashMap<String, List<Map<String, Object>>>(10);
        String entitynumber = null;
        String id = null;
        for (Map<String, Object> bizObjMap : writeoffMaps) {
            id = StringUtils.toNoEmptyString((Object)bizObjMap.get("id"));
            if (StringUtils.isEmpty((String)id)) {
                ControlException.errorBizId();
            }
            if (StringUtils.isEmpty((String)(entitynumber = StringUtils.toNoEmptyString((Object)bizObjMap.get("bostype"))))) {
                ControlException.errorBizEntityNumber();
            }
            result.computeIfAbsent(entitynumber, f -> new ArrayList(10)).add(bizObjMap);
        }
        return result;
    }

    public CalcObjectParameter(List<Map<String, Object>> bizObjMaps) {
        this.bizObjMaps = bizObjMaps;
        if (bizObjMaps != null && !bizObjMaps.isEmpty()) {
            Map<String, Object> bizObjMaa = bizObjMaps.get(0);
            this.bizId = (String)bizObjMaa.get("id");
            this.entityNumber = (String)bizObjMaa.get("bostype");
        }
    }

    @Override
    public boolean check() {
        if (this.getBizObj() == null && this.getBizObjMaps() == null) {
            ControlException.errorDynamicObject();
        }
        if (StringUtils.isEmpty((String)this.getBizId())) {
            ControlException.errorBizId();
        }
        return true;
    }
}

