/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.resource.ControlException;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.eums.ControlTypeEnum;
import kd.epm.eb.control.face.IControlParam;
import kd.epm.eb.control.face.IControlParameter;
import kd.epm.eb.control.impl.AbstractCloseBudgetImpl;
import kd.epm.eb.control.impl.calc.CalcBalance;
import kd.epm.eb.control.impl.calc.CloseBudgetCalc;
import kd.epm.eb.control.impl.model.AbstractBgControlRecord;
import kd.epm.eb.control.impl.model.BgControlData;
import kd.epm.eb.control.impl.model.BgControlRecord;
import kd.epm.eb.control.impl.model.ControlOccRecord;
import kd.epm.eb.control.impl.model.ControlOccValue;
import kd.epm.eb.control.utils.BgControlParamUtils;
import kd.epm.eb.control.utils.BgControlRecordUtils;
import kd.epm.eb.control.utils.BgControlRuleUtils;
import kd.epm.eb.control.utils.BgControlUtils;

public class CloseBudgetImpl
extends AbstractCloseBudgetImpl {
    private static final Log log = LogFactory.getLog(CloseBudgetImpl.class);
    private Set<String> bizIds = new HashSet<String>();

    public CloseBudgetImpl(IControlParameter parameter) {
        super(parameter);
    }

    /*
     * WARNING - void declaration
     */
    public void closeBudget() {
        void var5_17;
        List<Map<String, Object>> objMaps;
        LogStats stats = new LogStats("budget-control-log : ");
        stats.addInfo("begin closeBudget.");
        stats.addInfo(this.getParameter().getEntityNumber());
        stats.addInfo(this.getParameter().getBizId());
        stats.addInfo(this.getParameter().getEntryId());
        this.checkParameter();
        this.bizIds.add(this.getParameter().getBizId());
        try {
            Set<String> tables;
            Map targetBills = null;
            if (this.getParameter().getControlManager().isStandard()) {
                targetBills = BFTrackerServiceHelper.findTargetBills((String)this.getParameter().getEntityNumber(), (Long[])new Long[]{Long.valueOf(this.getParameter().getBizId())});
            }
            if (targetBills != null && !targetBills.isEmpty()) {
                log.info("botp-bills:" + JSONObject.toJSONString((Object)targetBills));
                for (Object _bills : targetBills.values()) {
                    _bills.forEach(_billId -> this.bizIds.add(String.valueOf(_billId)));
                }
            }
            if (!(tables = BgControlUtils.getCRTable(this.getParameter().getEntityNumber(), this.getParameter().getBizId())).isEmpty()) {
                for (String string : tables) {
                    this.bizIds.addAll(BgControlUtils.getBizIds(string, this.getParameter().getBizId()));
                }
            }
        }
        catch (Exception ex) {
            log.error("close budget findDirtTargetBills error.", (Throwable)ex);
            ControlException.errorQueryTarget();
        }
        if (!"gl_voucher".equals(this.getParameter().getEntityNumber())) {
            String sql = "select fvoucherid from t_ai_daptracker where fsourcebillid = ?";
            try {
                Object _bills;
                DataSet ds = DB.queryDataSet((String)"query-GL-REF", (DBRoute)DBRoute.of((String)"ai"), (String)sql, (Object[])new Object[]{IDUtils.toLong((Object)this.getParameter().getBizId())});
                _bills = null;
                try {
                    if (ds != null) {
                        for (Row row : ds) {
                            this.bizIds.add(row.getString("fvoucherid"));
                        }
                    }
                }
                catch (Throwable throwable) {
                    _bills = throwable;
                    throw throwable;
                }
                finally {
                    if (ds != null) {
                        if (_bills != null) {
                            try {
                                ds.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)_bills).addSuppressed(throwable);
                            }
                        } else {
                            ds.close();
                        }
                    }
                }
            }
            catch (Throwable ex) {
                log.warn("query-gl-dap-error", ex);
            }
        }
        Boolean isCloseByEntry = Boolean.FALSE;
        String entryId = this.getParameter().getEntryId();
        if (StringUtils.isNotEmpty((String)entryId) && !this.getParameter().getControlManager().isStandard()) {
            isCloseByEntry = Boolean.TRUE;
        }
        if ((objMaps = this.getParameter().getBizObjMaps()) != null) {
            for (Map<String, Object> entry : objMaps) {
                String string = (String)entry.get("lowerid");
                if (!StringUtils.isNotEmpty((String)string)) continue;
                if (string.indexOf(",") > 0) {
                    String[] tmpStr = string.split(",");
                    if (tmpStr == null) continue;
                    for (String tmpLowerId : tmpStr) {
                        if (!StringUtils.isNotEmpty((String)tmpLowerId)) continue;
                        this.bizIds.add(tmpLowerId.trim());
                    }
                    continue;
                }
                this.bizIds.add(string);
            }
        }
        List<BgControlRecord> list = BgControlRecordUtils.query(this.bizIds);
        if (isCloseByEntry.booleanValue()) {
            if (list.stream().anyMatch(k -> this.getParameter().getBizId().equals(k.getBizId()) && StringUtils.isEmpty((String)k.getRefBizId()) && StringUtils.isEmpty((String)k.getEntryId()))) {
                ControlException.errorWriteOffInfoError1((String)ResManager.loadKDString((String)"\u5173\u95ed\u9884\u7b97", (String)"CloseBudgetImpl_2", (String)"epm-eb-business", (Object[])new Object[0]));
            }
            if (list.stream().anyMatch(k -> StringUtils.isNotEmpty((String)k.getRefBizId()) && this.getParameter().getBizId().equals(k.getRefBizId()) && StringUtils.isEmpty((String)k.getRefEntryId()))) {
                ControlException.errorWriteOffInfoError1((String)ResManager.loadKDString((String)"\u5173\u95ed\u9884\u7b97", (String)"CloseBudgetImpl_2", (String)"epm-eb-business", (Object[])new Object[0]));
            }
            if (list == null) {
                return;
            }
            List list2 = list.stream().filter(k -> this.getParameter().getBizId().equals(k.getBizId()) && StringUtils.isEmpty((String)k.getRefBizId()) && StringUtils.isNotEmpty((String)k.getEntryId()) && this.getParameter().getEntryIdArr().contains(k.getEntryId()) || StringUtils.isNotEmpty((String)k.getRefBizId()) && k.getRefBizId().equals(this.getParameter().getBizId()) && this.getParameter().getEntryIdArr().contains(k.getRefEntryId())).collect(Collectors.toList());
        }
        if (var5_17 != null && !var5_17.isEmpty()) {
            Map<Long, BizModel> bizModelMap = var5_17.stream().filter(k -> this.getParameter().getBizId().equals(k.getBizId())).collect(Collectors.toMap(key -> key.getBizModel().getKey(), value -> value.getBizModel(), (k1, k2) -> k1));
            List<Object> reBgRecords = new ArrayList();
            if (StringUtils.isNotEmpty((String)this.getParameter().getEntryId())) {
                List<String> entryIds = this.getParameter().getEntryIdArr();
                if (entryIds != null && !entryIds.isEmpty()) {
                    for (String string : entryIds) {
                        List<BgControlRecord> rds = var5_17.stream().filter(k -> this.getParameter().getBizId().equals(k.getBizId()) && eryId.equals(k.getEntryId()) || this.getParameter().getBizId().equals(k.getRefBizId()) && eryId.equals(k.getRefEntryId())).collect(Collectors.toList());
                        if (rds == null || rds.isEmpty()) continue;
                        reBgRecords.addAll(this.closeRecords(rds, string));
                    }
                }
            } else {
                reBgRecords = this.closeRecords((List<BgControlRecord>)var5_17, null);
            }
            if (reBgRecords != null && !reBgRecords.isEmpty()) {
                boolean hasNegativeOcc = false;
                for (BgControlRecord bgControlRecord : reBgRecords) {
                    if (bgControlRecord.getAmount() == null || bgControlRecord.getAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
                    hasNegativeOcc = true;
                    break;
                }
                if (hasNegativeOcc) {
                    List<IControlParam> controlParams = BgControlRecord.createControlParam(this.getParameter(), reBgRecords);
                    if (controlParams == null || controlParams.isEmpty()) {
                        return;
                    }
                    controlParams.forEach(f -> f.setControlType(ControlTypeEnum.OCCUPATION));
                    bizModelMap = BgControlUtils.buildBizModelMap(controlParams);
                    BgControlData bgControlData = new BgControlData(true, null, null, stats);
                    bgControlData.setBizModels(bizModelMap);
                    Map<Long, List<IControlParam>> paramMap = BgControlUtils.buildParamMap(controlParams);
                    for (List list3 : paramMap.values()) {
                        BgControlParamUtils.get().setParameter(this.getParameter()).fillMembers(bgControlData, list3);
                    }
                    BgControlRuleUtils.getInterface().queryControlRule(bgControlData, controlParams);
                    CalcBalance calcbalance = new CalcBalance(this.getParameter(), bgControlData, null);
                    calcbalance.getControlParams().addAll(controlParams);
                    calcbalance.builderMembersForReturn(bizModelMap, controlParams);
                    CloseBudgetCalc closeBudgetCalc = new CloseBudgetCalc(calcbalance, reBgRecords, new HashSet<BgControlRecord>(), bizModelMap);
                    closeBudgetCalc.setParameter(this.getParameter());
                    closeBudgetCalc.setStats(stats);
                    if (!bizModelMap.isEmpty() && !reBgRecords.isEmpty()) {
                        this.lock(closeBudgetCalc);
                    } else {
                        stats.addInfo("no-negativeocc.size=" + reBgRecords.size());
                    }
                    this.checkResult(this.getParameter());
                    stats.addInfo("end-checkbalance.");
                    log.info(stats.toString());
                } else {
                    Throwable throwable = null;
                    try (TXHandle tx = TX.requiresNew((String)"eb/CloseBudgetImpl/closeBudget");){
                        try {
                            BgControlRecordUtils.batchSaveOlap(bizModelMap.values(), reBgRecords, this.getParameter().getBizNumber());
                            BgControlRecordUtils.save(reBgRecords, this.getParameter().getApplier());
                        }
                        catch (Exception ex) {
                            log.error("budget-control-log : closeBudget - save bgRecord error :", (Throwable)ex);
                            tx.markRollback();
                            BgControlRecordUtils.backOlap(bizModelMap.values(), reBgRecords);
                            throw ex;
                        }
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        throw throwable2;
                    }
                }
            }
        }
        stats.add("end closeBudget.");
        log.info(stats.toString());
    }

    private String getMemberKey(boolean hasOccPeriod, BgControlRecord record) {
        String memberKey = record.getMemberKeyByIgnChangeType();
        if (hasOccPeriod) {
            memberKey = record.getOccPeriod() != null ? memberKey + "!" + record.getOccPeriodNumber() : (record.getBizModel().isEBByModel() ? memberKey + "!" + record.getMemberNumber(SysDimensionEnum.Period.getNumber()) : memberKey + "!" + record.getMemberNumber(SysDimensionEnum.BudgetPeriod.getNumber()));
        }
        return memberKey;
    }

    private List<BgControlRecord> closeRecords(List<BgControlRecord> records, String entryId) {
        List bgRecords;
        HashMap<String, List> bgRecordMap = new HashMap<String, List>();
        ArrayList<BgControlRecord> reBgRecords = new ArrayList<BgControlRecord>();
        boolean hasOccPeriod = false;
        for (BgControlRecord record : records) {
            bgRecords = bgRecordMap.computeIfAbsent(record.getBizId(), f -> new ArrayList());
            bgRecords.add(record);
            if (record == null || record.getOccPeriodId() == null || record.getOccPeriodId() == 0L) continue;
            hasOccPeriod = true;
        }
        if (records.stream().noneMatch(k -> this.getParameter().getBizId().equals(k.getRefBizId()))) {
            hasOccPeriod = true;
        }
        if ((bgRecords = (List)bgRecordMap.get(this.getParameter().getBizId())) != null && !bgRecords.isEmpty()) {
            HashMap<String, Map> bgRecordValueMap = new HashMap<String, Map>();
            HashMap<String, Map> tarRecordValueMap = new HashMap<String, Map>();
            HashMap<String, List> recordMap = new HashMap<String, List>(bgRecords.size());
            Map dataKeyMap = null;
            String ctNumber = null;
            BigDecimal sumValue = null;
            String memberKey = null;
            for (BgControlRecord record : bgRecords) {
                if (StringUtils.isNotEmpty((String)record.getRefBizId()) && !this.getParameter().getBizId().equals(record.getRefBizId())) continue;
                memberKey = this.getMemberKey(hasOccPeriod, record);
                dataKeyMap = bgRecordValueMap.computeIfAbsent(memberKey, f -> Maps.newLinkedHashMap());
                List bgControlRecords = recordMap.computeIfAbsent(memberKey, f -> Lists.newArrayList());
                bgControlRecords.add(record);
                ctNumber = record.getMemberNumber(SysDimensionEnum.ChangeType.getNumber());
                sumValue = dataKeyMap.computeIfAbsent(ctNumber, f -> BigDecimal.ZERO);
                sumValue = sumValue.add(record.getAmount());
                dataKeyMap.put(ctNumber, sumValue);
            }
            Map.Entry entry22 = null;
            for (Map.Entry entry22 : bgRecordMap.entrySet()) {
                if (this.getParameter().getBizId().equals(entry22.getKey())) continue;
                bgRecords = (List)entry22.getValue();
                for (BgControlRecord record : bgRecords) {
                    if (!StringUtils.isNotEmpty((String)record.getRefBizId()) || !this.getParameter().getBizId().equals(record.getRefBizId())) continue;
                    memberKey = this.getMemberKey(hasOccPeriod, record);
                    dataKeyMap = tarRecordValueMap.computeIfAbsent(memberKey, f -> Maps.newLinkedHashMap());
                    ctNumber = record.getMemberNumber(SysDimensionEnum.ChangeType.getNumber());
                    sumValue = dataKeyMap.computeIfAbsent(ctNumber, f -> BigDecimal.ZERO);
                    sumValue = sumValue.add(record.getAmount());
                    dataKeyMap.put(ctNumber, sumValue);
                }
            }
            Date createTime = new Date();
            BigDecimal occValue = null;
            Object exeValue = null;
            BigDecimal _occValue = null;
            Object _exeValue = null;
            Map _changeTypeMap = null;
            Map<String, Map<String, Map<String, ControlOccValue>>> periodMap = new HashMap<String, Map<String, Map<String, ControlOccValue>>>(10);
            ArrayList<BgControlRecord> addnewRecords = new ArrayList<BgControlRecord>(10);
            ArrayList<ControlOccRecord> occRecords = new ArrayList<ControlOccRecord>(10);
            Map.Entry vEntry22 = null;
            for (Map.Entry vEntry22 : bgRecordValueMap.entrySet()) {
                BgControlRecord record;
                _changeTypeMap = (Map)vEntry22.getValue();
                _occValue = (BigDecimal)_changeTypeMap.get("Occupation");
                occValue = _occValue != null ? _occValue : BigDecimal.ZERO;
                _changeTypeMap = (Map)tarRecordValueMap.get(vEntry22.getKey());
                if (_changeTypeMap != null && (_occValue = (BigDecimal)_changeTypeMap.get("Occupation")) != null) {
                    occValue = occValue.add(_occValue);
                }
                if (occValue.compareTo(BigDecimal.ZERO) == 0) continue;
                addnewRecords.clear();
                List bgControlRecords = (List)recordMap.get(vEntry22.getKey());
                if (this.getParameter().getEntryId() != null) {
                    List collect = bgControlRecords.stream().filter(rd -> this.getParameter().getEntryIdArr().contains(rd.getEntryId())).collect(Collectors.toList());
                    if (collect == null || collect.size() < 1) continue;
                    record = (BgControlRecord)collect.get(0);
                    BigDecimal bigDecimal = bgControlRecords.stream().map(AbstractBgControlRecord::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (occValue.compareTo(bigDecimal) <= 0) {
                        record.setAmount(occValue.negate());
                    } else {
                        record.setAmount(record.getAmount().negate());
                    }
                    addnewRecords.add(record);
                } else {
                    periodMap.clear();
                    periodMap = BgControlUtils.getRecordPeriod(bgControlRecords, null, false, this.bizIds, this.getParameter().getBizId(), periodMap, false, false, false);
                    if (periodMap.get(this.getParameter().getBizId()) != null) {
                        for (Map map : periodMap.get(this.getParameter().getBizId()).values()) {
                            block6: for (ControlOccValue controlOcc : map.values()) {
                                occRecords.clear();
                                if (occValue.compareTo(BigDecimal.ZERO) > 0) {
                                    controlOcc.occupation(occRecords, occValue, null);
                                } else {
                                    controlOcc.negativeOcc(occRecords, occValue);
                                }
                                for (ControlOccRecord r : occRecords) {
                                    if (BigDecimal.ZERO.compareTo(occValue) == 0) continue block6;
                                    if (BigDecimal.ZERO.compareTo(r.getCanOccValue()) == 0) continue;
                                    _occValue = occValue.compareTo(r.getCanOccValue()) > 0 ? r.getCanOccValue() : occValue;
                                    occValue = occValue.subtract(_occValue);
                                    record = (BgControlRecord)r.getAmount();
                                    record.setAmount(_occValue.negate());
                                    addnewRecords.add(record);
                                }
                            }
                        }
                    } else {
                        record = (BgControlRecord)bgControlRecords.get(0);
                        record.setAmount(occValue.negate());
                        addnewRecords.add(record);
                    }
                }
                for (int i = 0; i < addnewRecords.size(); ++i) {
                    record = (BgControlRecord)addnewRecords.get(i);
                    BgControlRecord bgControlRecord = BgControlRecord.createFromControlParam(record, createTime, this.getParameter().getOperation());
                    if (StringUtils.isNotEmpty((String)entryId)) {
                        bgControlRecord.setEntryId(entryId);
                        bgControlRecord.setRefEntryId(entryId);
                    }
                    bgControlRecord.setOccType(BgControlRecord.OccupationType.CLSOCC.getNumber());
                    bgControlRecord.setStatus("2");
                    bgControlRecord.setRequestId(RequestContext.get().getTraceId());
                    reBgRecords.add(bgControlRecord);
                }
            }
        }
        return reBgRecords;
    }
}

