/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.impl;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.model.BizOrgUnit;
import kd.epm.eb.common.resource.ControlException;
import kd.epm.eb.common.utils.DateTimeUtils;
import kd.epm.eb.common.utils.ModelUtils;
import kd.epm.eb.control.eums.ControlResultEnum;
import kd.epm.eb.control.face.IBudgetBalance;
import kd.epm.eb.control.face.IControlParam;
import kd.epm.eb.control.face.IControlParameter;
import kd.epm.eb.control.impl.AbstractControlImpl;
import kd.epm.eb.control.impl.CalcMemberParameter;
import kd.epm.eb.control.impl.calc.BalanceCheck;
import kd.epm.eb.control.impl.calc.CalcBalance;
import kd.epm.eb.control.impl.calc.CalcControl;
import kd.epm.eb.control.impl.model.BgControlData;
import kd.epm.eb.control.utils.BgControlLogUtils;
import kd.epm.eb.control.utils.BgControlProcessUtils;
import kd.epm.eb.control.utils.BgControlUtils;
import kd.epm.eb.control.utils.BgRegisterUtils;

public class QueryBalanceImpl
extends AbstractControlImpl {
    private static final Log log = LogFactory.getLog(QueryBalanceImpl.class);

    public QueryBalanceImpl(IControlParameter parameter) {
        super(parameter);
    }

    public Map<String, Map<String, Map<String, String>>> queryOrgNumbers() {
        if (this.getParameter() == null) {
            return null;
        }
        this.getStats().addInfo("begin queryOrgNumber");
        String[] props = BgRegisterUtils.queryRegisterBizUnit(this.getParameter().getEntityNumber());
        if (props == null) {
            ControlException.notDefaultBizProp((String)this.getParameter().getEntityNumber());
        }
        Object[] objProps = BgRegisterUtils.getBizUnit(this.getStats(), this.getParameter(), props);
        BgRegisterUtils.checkDefaultProps(this.getStats(), objProps, props);
        BizOrgUnit bizOrgUnit = (BizOrgUnit)objProps[0];
        Date bizTime = (Date)objProps[1];
        BgControlData controlData = new BgControlData(BgRegisterUtils.isMultiControl(props), bizOrgUnit, bizTime, this.getStats());
        Collection<BizModel> models = this.getParameter().getBizUtils().queryModel(bizTime, true);
        models = this.getParameter().getBizUtils().filterModel(models, controlData);
        if (models != null && !models.isEmpty()) {
            controlData.setBizModels(models);
            CalcBalance calc = new CalcBalance(this.getParameter(), controlData, null);
            return calc.queryOrgMembers();
        }
        return null;
    }

    public Collection<IControlParam> queryDimenMember() {
        this.getStats().addInfo("begin queryBalance");
        if (this.getParameter() == null) {
            return null;
        }
        String[] props = BgRegisterUtils.queryRegisterBizUnit(this.getParameter().getEntityNumber());
        if (props == null) {
            ControlException.notDefaultBizProp((String)this.getParameter().getEntityNumber());
        }
        Object[] objProps = BgRegisterUtils.getBizUnit(this.getStats(), this.getParameter(), props);
        BgRegisterUtils.checkDefaultProps(this.getStats(), objProps, props);
        BizOrgUnit bizOrgUnit = (BizOrgUnit)objProps[0];
        Date bizTime = (Date)objProps[1];
        BgControlData controlData = new BgControlData(BgRegisterUtils.isMultiControl(props), bizOrgUnit, bizTime, this.getStats());
        Collection<BizModel> models = this.getParameter().getBizUtils().queryModel(bizTime, true);
        models = this.getParameter().getBizUtils().filterModel(models, controlData);
        if (models != null && !models.isEmpty()) {
            if (models.size() > 1 && !controlData.isMultiControl()) {
                ControlException.existMoreModel(models);
            }
            controlData.setBizModels(models);
            CalcBalance calc = new CalcBalance(this.getParameter(), controlData, null);
            return calc.queryDimensionMember();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<IBudgetBalance> queryBalance() {
        this.getStats().addInfo("begin queryBalance");
        ArrayList<IBudgetBalance> balances = new ArrayList<IBudgetBalance>();
        try {
            if (this.getParameter() == null) {
                ArrayList<IBudgetBalance> arrayList = balances;
                return arrayList;
            }
            String[] props = BgRegisterUtils.queryRegisterBizUnit(this.getParameter().getEntityNumber());
            if (props == null) {
                ControlException.notDefaultBizProp((String)this.getParameter().getEntityNumber());
            }
            Object[] objProps = BgRegisterUtils.getBizUnit(this.getStats(), this.getParameter(), props);
            this.getStats().add(this.getParameter().getEntityNumber());
            BgRegisterUtils.checkDefaultProps(this.getStats(), objProps, props);
            BizOrgUnit bizOrgUnit = (BizOrgUnit)objProps[0];
            Date bizTime = (Date)objProps[1];
            BgControlData controlData = new BgControlData(BgRegisterUtils.isMultiControl(props), bizOrgUnit, bizTime, this.getStats());
            this.getStats().add("bizOrgUnit(id = " + bizOrgUnit.getId() + "; number = " + bizOrgUnit.getNumber() + ")");
            this.getStats().add("bizTime = " + DateTimeUtils.format((LocalDateTime)DateTimeUtils.parse((Date)bizTime)));
            BgControlProcessUtils.queryProcessSet(this.getParameter(), controlData, this.getParentOrgIds(controlData), this.getStats());
            if (controlData.getProcess() == null || controlData.getProcess().isEmpty()) {
                this.getStats().addInfo("not suit control processes");
                this.getParameter().getResult().setResult(ControlResultEnum.DONTCONTROL);
                this.getParameter().getResult().setCode("dont-control-process-scheme");
                ControlException.notControlProcess();
            }
            Collection<BizModel> models = this.getParameter().getBizUtils().queryModel(bizTime, true);
            models = this.getParameter().getBizUtils().filterModel(models, controlData);
            if (models != null && !models.isEmpty()) {
                if (models.size() > 1 && !controlData.isMultiControl()) {
                    ControlException.existMoreModel(models);
                }
                controlData.setBizModels(models);
                CalcControl calc = CalcControl.getInterface(controlData);
                calc.setParameter(this.getParameter());
                calc.setModels(models);
                calc.handler();
                balances.addAll(calc.getControlParams());
            } else {
                ControlException.notModelOrVersion();
            }
        }
        finally {
            this.getStats().addInfo("end queryBalance.");
            log.info(this.getStats().toString());
            BgControlLogUtils.finishInfo(this.getStats(), log);
        }
        return balances;
    }

    public Collection<IBudgetBalance> queryMemberBalance() {
        this.getStats().addInfo("begin queryMemberBalance");
        ArrayList<IBudgetBalance> balances = new ArrayList<IBudgetBalance>();
        if (this.getParameter() == null || this.getParameter().getCalcParameter() == null || !this.getParameter().getCalcParameter().check()) {
            return balances;
        }
        this.getParameter().setQueryCentralized(false);
        BizModel bizModel = ModelUtils.getBizModel((Long)((CalcMemberParameter)this.getParameter().getCalcParameter()).getModelId());
        Long businessModelId = ((CalcMemberParameter)this.getParameter().getCalcParameter()).getBussinessModelId();
        if (businessModelId != null && businessModelId != 0L) {
            bizModel.setControlBusModelId(businessModelId);
        }
        BgControlUtils.queryControlDimension(bizModel);
        Set controlDims = bizModel.getControlDims();
        if (this.getParameter().isHasAdjustCheck() && !bizModel.isEBByModel() && controlDims == null) {
            return balances;
        }
        log.info("modelid:" + bizModel.getId() + "busmodel:" + bizModel.getControlBusModelId());
        if (controlDims != null) {
            log.info("controlDimIds" + SerializationUtils.toJsonString((Object)controlDims));
        }
        CalcBalance calc = new CalcBalance(this.getParameter(), new BgControlData(bizModel, null, null, this.getStats()), null);
        Collection<IControlParam> controlParams = calc.queryMemberBudget();
        BalanceCheck balanceCheck = BalanceCheck.getInterface(this.getStats()).setParameter(this.getParameter()).setControlParams(controlParams);
        if (this.getParameter().isHasAdjustCheck()) {
            balanceCheck.calc();
        } else {
            balanceCheck.check();
        }
        balances.addAll(calc.getControlParams());
        this.getStats().addInfo("end queryMemberBalance.");
        log.info(this.getStats().toString());
        return balances;
    }
}

