/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.model.BizOrgUnit;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.ModelUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.face.IBatchControlParameter;
import kd.epm.eb.control.face.IBudgetBalance;
import kd.epm.eb.control.face.IControlParam;
import kd.epm.eb.control.impl.AbstractControlImpl;
import kd.epm.eb.control.impl.CalcObjectParameter;
import kd.epm.eb.control.impl.QueryBalanceImpl;
import kd.epm.eb.control.impl.calc.CalcBalance;
import kd.epm.eb.control.impl.model.BgControlData;
import kd.epm.eb.control.impl.model.BgControlScheme;
import kd.epm.eb.control.utils.BgControlProcessUtils;
import kd.epm.eb.control.utils.BgControlSchemeUtils;
import kd.epm.eb.control.utils.BgControlUtils;
import kd.epm.eb.control.utils.BgRegisterUtils;
import kd.epm.eb.control.utils.OQLBuilder;

public class QueryMappingsImpl
extends AbstractControlImpl {
    private static final Log log = LogFactory.getLog(QueryBalanceImpl.class);

    public QueryMappingsImpl(IBatchControlParameter parameter) {
        super(parameter);
    }

    @Override
    protected IBatchControlParameter getParameter() {
        return (IBatchControlParameter)super.getParameter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<IBudgetBalance>> queryMappings() {
        this.getStats().addInfo("begin-queryMappings");
        HashMap<String, List<IBudgetBalance>> balances = new HashMap<String, List<IBudgetBalance>>(10);
        try {
            String[] props;
            if (this.getParameter() == null || this.getParameter().getBizModelId() == null) {
                HashMap<String, List<IBudgetBalance>> hashMap = balances;
                return hashMap;
            }
            BizModel bizModel = ModelUtils.getBizModel((Long)this.getParameter().getBizModelId());
            if (bizModel == null) {
                HashMap<String, List<IBudgetBalance>> hashMap = balances;
                return hashMap;
            }
            if (this.getParameter().getBussModelId() != null) {
                bizModel.setControlBusModelId(this.getParameter().getBussModelId());
            }
            BgControlUtils.queryControlDimension(bizModel);
            this.getParameter().setBizModel(bizModel);
            if (bizModel.getDimensions() == null || bizModel.getDimensions().isEmpty()) {
                List dimensions = BgDimensionServiceHelper.getDimensionByModel((BizModel)bizModel, (boolean)false);
                dimensions = bizModel.filterControlDims(dimensions);
                bizModel.setDimension(dimensions);
            }
            if ((props = BgRegisterUtils.queryRegisterBizUnit(this.getParameter().getEntityNumber())) == null) {
                this.getStats().addInfo("no-RegisterBizUnit");
            }
            BgControlData controlData = new BgControlData(this.getParameter().getBizModel(), null, null, this.getStats());
            controlData.setMultiControl(BgRegisterUtils.isMultiControl(props));
            Map<String, Object[]> objProps = BgRegisterUtils.getBizUnitBatch(this.getParameter(), props);
            if (objProps == null || objProps.isEmpty()) {
                this.getStats().addInfo("no-objProps");
                HashMap<String, List<IBudgetBalance>> hashMap = balances;
                return hashMap;
            }
            Map<String, Collection<BgControlScheme>> schemes = BgControlSchemeUtils.query(controlData, this.getParameter().getEntityNumber(), true, false);
            if (schemes == null || schemes.isEmpty()) {
                this.getStats().addInfo("no-schemes");
                HashMap<String, List<IBudgetBalance>> hashMap = balances;
                return hashMap;
            }
            HashMap<String, Map> billSchemes = new HashMap<String, Map>(objProps.size());
            HashSet<Long> billIds = new HashSet<Long>();
            HashSet<BgControlScheme> hasSchemes = new HashSet<BgControlScheme>(schemes.size());
            Long billId = null;
            for (Map.Entry<String, Object[]> entry : objProps.entrySet()) {
                Object bizTime;
                if (entry.getValue() == null || entry.getValue()[0] == null || (bizTime = (Date)entry.getValue()[1]) == null) continue;
                try {
                    billId = Long.parseLong(entry.getKey());
                }
                catch (Throwable throwable) {
                    log.info("queryMappings-no-Long-Key:" + entry.getKey());
                    continue;
                }
                for (Map.Entry<String, Collection<BgControlScheme>> entryScheme : schemes.entrySet()) {
                    for (BgControlScheme bgControlScheme : entryScheme.getValue()) {
                        if (bgControlScheme.getEffectivetime() != null && bgControlScheme.getEffectivetime().compareTo((Date)bizTime) > 0 || bgControlScheme.getInvalidtime() != null && bgControlScheme.getInvalidtime().compareTo((Date)bizTime) < 0) continue;
                        billSchemes.computeIfAbsent(entry.getKey(), f -> new HashMap(10)).computeIfAbsent(bgControlScheme.getNumber(), f -> new ArrayList(10)).add(bgControlScheme);
                        billIds.add(billId);
                        hasSchemes.add(bgControlScheme);
                    }
                }
            }
            if (hasSchemes.isEmpty()) {
                HashMap<String, List<IBudgetBalance>> hashMap = balances;
                return hashMap;
            }
            HashSet<String> fields = new HashSet<String>(10);
            OQLBuilder oqlBuilder = new OQLBuilder();
            for (BgControlScheme bgControlScheme : hasSchemes) {
                oqlBuilder.builder(this.getParameter(), this.getParameter().getEntityNumber(), controlData, bgControlScheme, true);
                fields.addAll(Arrays.asList(oqlBuilder.getFields().split(",")));
            }
            QFBuilder builder = new QFBuilder();
            builder.add(new QFilter("entryentity.bill.fieldtable", "=", (Object)this.getParameter().getEntityNumber()));
            builder.add(new QFilter("enable", "=", (Object)Character.valueOf('1')));
            String string = "entryentity.bill.fieldtable, entryentity.runvalue,entryentity.takevalue";
            List processes = null;
            Throwable throwable = null;
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryProcessFields", (String)"eb_bgcontrolprocess", (String)string, (QFilter[])builder.toArrays(), null);){
                processes = CommonServiceHelper.transDataSet((DataSet)ds);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            if (processes != null) {
                for (Map map : processes) {
                    String field;
                    if (!this.getParameter().getEntityNumber().equals(map.get("entryentity.bill.fieldtable"))) continue;
                    String string2 = field = map.get("entryentity.runvalue") == null ? "" : String.valueOf(map.get("entryentity.runvalue"));
                    if (StringUtils.isNotEmpty((String)field)) {
                        fields.add(field);
                    }
                    if (!StringUtils.isNotEmpty((String)(field = map.get("entryentity.takevalue") == null ? "" : String.valueOf(map.get("entryentity.takevalue"))))) continue;
                    fields.add(field);
                }
            }
            OQLBuilder.addParentField(fields);
            log.info("queryMappings-fields=" + JSONUtils.toString(fields));
            QFilter filter = new QFilter("id", "in", billIds);
            Map map = BusinessDataServiceHelper.loadFromCache((String)this.getParameter().getEntityNumber(), (String)StringUtils.join(fields, (String)","), (QFilter[])filter.toArray());
            if (map == null || map.isEmpty()) {
                HashMap<String, List<IBudgetBalance>> hashMap = balances;
                return hashMap;
            }
            for (DynamicObject bill : map.values()) {
                Object[] objProp = objProps.get(String.valueOf(bill.getPkValue()));
                this.getParameter().setCalcParameter(new CalcObjectParameter(bill, null));
                this.getParameter().setSchemes((Map)billSchemes.get(String.valueOf(bill.getPkValue())));
                controlData = new BgControlData(this.getParameter().getBizModel(), (BizOrgUnit)objProp[0], (Date)objProp[1], this.getStats());
                this.getParameter().getDataManager().getApplyFields().clear();
                this.getParameter().getDataManager().getOccApplyFields().clear();
                BgControlProcessUtils.queryProcessSet(this.getParameter(), controlData, this.getParentOrgIds(controlData), this.getStats());
                this.getParameter().getDataManager().setWriteOff(null);
                CalcBalance calc = new CalcBalance(this.getParameter(), controlData, null);
                calc.beforeCalc();
                if (calc.getControlParams() == null || calc.getControlParams().isEmpty()) continue;
                balances.put(String.valueOf(bill.getPkValue()), new ArrayList<IControlParam>(calc.getControlParams()));
            }
        }
        finally {
            this.getStats().addInfo("end-queryMappings.");
            log.info(this.getStats().toString());
        }
        return balances;
    }
}

